/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpc.clientcore;

import com.ibm.bpc.clientcore.BPCQueryAttributes;
import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.exception.InvalidAttributeForQueryException;
import com.ibm.bpc.clientcore.exception.InvalidAttributeTypeForQueryException;
import com.ibm.bpc.clientcore.util.QueryUtils;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.util.Assert;
import com.ibm.bpe.util.MessageLogger;
import com.ibm.bpe.util.TraceLogger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BPCQueryFilterAttributes {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2007, 2009.\n\n";
    private String type = null;
    private Map<String, Object> validAttributes = new HashMap<String, Object>();
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private BPCQueryAttributes queryAttributes = null;
    protected static final int DATE_TIME_CONDITION_BOTH = 0;
    protected static final int DATE_TIME_CONDITION_FUTURE = 1;
    protected static final int DATE_TIME_CONDITION_PAST = 2;

    public BPCQueryFilterAttributes(String string, Map<String, Object> map) {
        this.type = string;
        this.validAttributes = map;
    }

    public abstract BPCQueryFilterAttributes getNewInstance();

    public BPCQueryFilterAttributes getCopy() {
        BPCQueryFilterAttributes bPCQueryFilterAttributes = this.getNewInstance();
        bPCQueryFilterAttributes.setAttributes(BPCQueryFilterAttributes.copyAttributeMap(this.getAttributes()));
        return bPCQueryFilterAttributes;
    }

    public BPCQueryAttributes getQueryAttributes() {
        return this.queryAttributes;
    }

    public void setQueryAttributes(BPCQueryAttributes bPCQueryAttributes) {
        this.queryAttributes = bPCQueryAttributes;
    }

    public String getWhereCondition() {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry("Filter type " + this.type);
        }
        StringBuffer stringBuffer = this.getWhereFilterCondition();
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit("Filter type " + this.type + ": where " + stringBuffer);
        }
        return stringBuffer.toString();
    }

    protected abstract StringBuffer getWhereFilterCondition();

    public String getType() {
        return this.type;
    }

    public static void addValidAttribute(String string, Map<String, Object> map, String string2, Object object) {
        if (object != null) {
            if (object instanceof String || object instanceof String[]) {
                map.put(string2, object);
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "Filter type " + string + ":" + " Attribute has been added name=" + string2 + ", defaultValue=" + BPCQueryFilterAttributes.valueToString(object) + ", valueType=" + object.getClass());
                }
            } else if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace(TraceLogger.TYPE_EVENT, "Filter type " + string + ":" + " Attribute is ignored!" + " Attribute type '" + object.getClass().getName() + " for name '" + string2 + "' is not valid. Expected types are " + String.class.getName() + " or " + String[].class.getName());
            }
        } else if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace(TraceLogger.TYPE_EVENT, "Filter type " + string + ":" + " Attribute is ignored!" + " Attribute default value for name '" + string2 + "' is null!");
        }
    }

    public Map<String, Object> getValidAttributes() {
        return this.validAttributes;
    }

    private Set<String> getValidAttributeNames() {
        return this.validAttributes.keySet();
    }

    private boolean isValidAttributeName(String string) throws InvalidAttributeForQueryException {
        boolean bl = true;
        if (!this.getValidAttributeNames().contains(string)) {
            String string2 = QueryUtils.convertToStringList(this.getValidAttributeNames().toArray(new String[0]));
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "Filter type " + this.type + ": Attribute name '" + string + "' is not valid. Valid names are '" + string2);
            }
            bl = false;
            throw new InvalidAttributeForQueryException(new Object[]{string, this.getClass().getName(), string2});
        }
        return bl;
    }

    private Object getDefaultAttributeValue(String string, Object object) throws InvalidAttributeForQueryException, InvalidAttributeTypeForQueryException {
        Class<?> clazz;
        Class<?> clazz2;
        Object object2 = null;
        if (this.isValidAttributeName(string) && object != null && !(clazz2 = (object2 = this.validAttributes.get(string)).getClass()).equals(clazz = object.getClass())) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace(TraceLogger.TYPE_EVENT, "Filter type " + this.type + ":" + " Attribute type '" + clazz.getName() + " for name '" + string + "' is not valid. Expected type is '" + clazz2.getName());
            }
            throw new InvalidAttributeTypeForQueryException(new Object[]{clazz, string, this.getClass().getName(), clazz2});
        }
        return object2;
    }

    public void setAttribute(String string, Object object) {
        Object object2 = null;
        try {
            object2 = this.getDefaultAttributeValue(string, object);
            if (object != null && !object.equals(object2)) {
                this.attributes.put(string, object);
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace(TraceLogger.TYPE_EVENT, "Filter type " + this.type + ":" + " Attribute 'name=" + string + ", value=" + BPCQueryFilterAttributes.valueToString(object) + "' added.");
                }
            } else {
                this.attributes.remove(string);
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace(TraceLogger.TYPE_EVENT, "Filter type " + this.type + ":" + " Attribute 'name=" + string + "' removed.");
                }
            }
            if (this.getQueryAttributes() != null) {
                this.getQueryAttributes().resetWhereClause();
            }
        }
        catch (ClientException clientException) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace(TraceLogger.TYPE_EVENT, (Throwable)((Object)clientException));
            }
            MessageLogger messageLogger = MessageLogger.newMessageLogger((String)BPCClientTrace.class.getName());
            messageLogger.text(MessageLogger.TYPE_WARNING, clientException.getMessage(this.getQueryAttributes().getLocale()));
        }
    }

    public Object getAttribute(String string) {
        return this.attributes.get(string);
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    private void setAttributes(Map<String, Object> map) {
        this.attributes = map;
    }

    public void resetAttributes() {
        this.attributes.clear();
    }

    public void addDateTimeAttributeValue(String string, String string2) {
        if ("".equals(string2)) {
            this.setAttribute(string, "CURRENT_TIMESTAMP");
        } else {
            this.setAttribute(string, string2);
        }
    }

    public void stripAttributes() {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry("Filter type " + this.type + ": Strip attributes for query type " + this.getType());
        }
        Map<String, Object> map = BPCQueryFilterAttributes.stripAttributes(this.type, this.attributes);
        this.setAttributes(map);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    protected boolean isEntityFilter() {
        return this.getType().equals(this.getQueryAttributes().getEntityType());
    }

    private static Map<String, Object> copyAttributeMap(Map<String, Object> map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(map.size());
        Iterator<String> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = new String(iterator.next());
            Object object = BPCQueryFilterAttributes.copyAttributeValue(map.get(string));
            hashMap.put(string, object);
        }
        return hashMap;
    }

    private static Object copyAttributeValue(Object object) {
        String[] stringArray = null;
        if (object instanceof String) {
            stringArray = new String((String)object);
        } else if (object instanceof String[]) {
            String[] stringArray2 = (String[])object;
            String[] stringArray3 = new String[stringArray2.length];
            for (int i = 0; i < stringArray2.length; ++i) {
                stringArray3[i] = new String(stringArray2[i]);
            }
            stringArray = stringArray3;
        } else {
            Assert.assertion((boolean)false, (String)("Unexpected type for copy, type is " + object.getClass().getName() + ", expected types are String and String[]"));
        }
        return stringArray;
    }

    public static Map<String, Object> stripAttributes(String string, Map<String, Object> map) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry("Filter type " + string);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(map);
        if (map.size() > 0) {
            Set<String> set = map.keySet();
            for (String string2 : set) {
                Object object = map.get(string2);
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "Filter type " + string + ":" + " Query attribute " + string2 + "=" + BPCQueryFilterAttributes.valueToString(object));
                }
                if (object == null || object instanceof String && "".equals(((String)object).trim()) || object instanceof String[] && ((String[])object).length == 0 || object instanceof List && ((List)object).size() == 0) {
                    hashMap.remove(string2);
                    if (!BPCClientTrace.isTracing) continue;
                    BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "Filter type " + string + ":" + " Query attribute " + string2 + " stripped.");
                    continue;
                }
                Assert.assertion((set != null ? 1 : 0) != 0, (String)("Filter type " + string + ":" + " No check for object type " + object.getClass().getName()));
            }
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "Filter type " + string + ":" + " Number of attributes is " + hashMap.size());
            BPCClientTrace.exit();
        }
        return hashMap;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        Map<String, Object> map = this.getAttributes();
        Iterator<String> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            if (stringBuffer.length() > 1) {
                stringBuffer.append(", ");
            }
            String string = iterator.next();
            stringBuffer.append(string + "=");
            stringBuffer.append(BPCQueryFilterAttributes.valueToString(map.get(string)));
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private static String valueToString(Object object) {
        String string = null;
        string = object instanceof String[] ? Arrays.asList((String[])object).toString() : (String)object;
        return string;
    }

    protected String getDateTimeCondition(String string, String string2, int n) {
        int n2;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry("attributeName: " + string + ", columnName: " + string2 + ", condition: " + n);
        }
        String string3 = "";
        String string4 = (String)this.getAttribute(string + "Reference");
        String string5 = (String)this.getAttribute(string + "ReferenceOffset");
        String string6 = (String)this.getAttribute(string + "End");
        String string7 = (String)this.getAttribute(string + "EndOffset");
        if (string4 != null && (n2 = string4.indexOf("after")) == 0) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "Migration of old attribute " + string + "After");
            }
            string4 = string4.substring(5);
            if (string6 == null && string7 == null) {
                string7 = "P";
                this.setAttribute(string + "EndOffset", string7);
            }
            this.setAttribute(string + "Reference", string4);
        }
        if (string6 != null && (n2 = string6.indexOf("before")) == 0) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "Migration of old attribute " + string + "Before");
            }
            if (string4 == null && string7 == null) {
                string4 = string6.substring(6);
                string6 = null;
                string7 = "-P";
                this.setAttribute(string + "Reference", string4);
                this.setAttribute(string + "EndOffset", string7);
            } else {
                string6 = string6.substring(6);
            }
            this.setAttribute(string + "End", string6);
        }
        string3 = QueryUtils.getDateTimeCondition(string2, string4, string5, string6, string7);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit(string3);
        }
        return string3;
    }
}

