/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpc.clientcore;

import com.ibm.bpc.clientcore.BPCQueryFilterAttributes;
import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.ColumnInfo;
import com.ibm.bpc.clientcore.CommandInfo;
import com.ibm.bpc.clientcore.OrderInfo;
import com.ibm.bpc.clientcore.XMLSerializable;
import com.ibm.bpc.clientcore.bean.CustomPropertyBean;
import com.ibm.bpc.clientcore.bean.QueryPropertyBean;
import com.ibm.bpc.clientcore.query.BPCQueryCustomPropertyHelper;
import com.ibm.bpc.clientcore.query.BPCQueryPropertyHelper;
import com.ibm.bpc.clientcore.query.BPCQueryQueryPropertyHelper;
import com.ibm.bpc.clientcore.util.QueryUtils;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.clientmodel.query.ActivityInstanceQueryAttributes;
import com.ibm.bpe.clientmodel.query.ProcessInstanceQueryAttributes;
import com.ibm.bpe.clientmodel.query.ProcessTemplateQueryAttributes;
import com.ibm.bpe.util.Assert;
import com.ibm.bpe.util.TraceLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BPCQueryAttributes {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2007, 2009.\n\n";
    private String entityType = null;
    private String tableName = null;
    private String idColumnName = null;
    private Boolean adminAsUser = null;
    private List<ColumnInfo> columnInfoList = null;
    private String listRows = null;
    private Map<String, BPCQueryFilterAttributes> filterAttributes = new HashMap<String, BPCQueryFilterAttributes>();
    private List<CustomPropertyBean> customProperties = null;
    private List<QueryPropertyBean> queryProperties = null;
    private List<OrderInfo> orderInfoList = null;
    private String selectClause = null;
    private String whereClause = null;
    private String orderClause = null;
    private Integer threshold = null;
    private String currentUser = null;
    private boolean isSystemAdmin = false;
    private boolean isSystemMonitor = false;
    private Locale locale = Locale.getDefault();
    private boolean supportsCustomProperties = false;
    private boolean supportsQueryProperties = false;
    private BPCQueryPropertyHelper customPropertyHelper = null;
    private BPCQueryPropertyHelper queryPropertyHelper = null;
    private List<CommandInfo> commandInfoList = new ArrayList<CommandInfo>();
    private boolean defaultCommandSetUsed = true;

    public BPCQueryAttributes(String string, String string2, String string3) {
        this.entityType = string;
        this.tableName = string2;
        this.idColumnName = string3;
    }

    public BPCQueryAttributes(String string, String string2, String string3, boolean bl) {
        this(string, string2, string3);
        this.supportsCustomProperties = bl;
    }

    public BPCQueryAttributes(String string, String string2, String string3, boolean bl, boolean bl2) {
        this(string, string2, string3, bl);
        this.supportsQueryProperties = bl2;
    }

    protected abstract BPCQueryAttributes getNewInstance();

    public BPCQueryAttributes getCopy() {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry("Entity type: " + this.entityType);
        }
        BPCQueryAttributes bPCQueryAttributes = this.getNewInstance();
        bPCQueryAttributes.setAdminAsUser(this.getAdminAsUser());
        if (this.getColumnInfoList() != null) {
            bPCQueryAttributes.setColumnInfoList(new ArrayList<ColumnInfo>(this.getColumnInfoList()));
        }
        if (this.getCommandInfoList() != null) {
            bPCQueryAttributes.setCommandInfoList(new ArrayList<CommandInfo>(this.getCommandInfoList()));
        }
        bPCQueryAttributes.setDefaultCommandSetUsed(this.isDefaultCommandSetUsed());
        if (this.getListRows() != null) {
            bPCQueryAttributes.setListRows(new String(this.getListRows()));
        }
        for (String string : this.getAllFilterAttributes().keySet()) {
            bPCQueryAttributes.setFilterAttributes(this.getFilterAttributes(string).getCopy());
        }
        if (this.getCustomProperties() != null) {
            bPCQueryAttributes.setCustomProperties(new ArrayList<CustomPropertyBean>(this.getCustomProperties()));
        }
        if (this.getQueryProperties() != null) {
            bPCQueryAttributes.setQueryProperties(new ArrayList<QueryPropertyBean>(this.getQueryProperties()));
        }
        if (this.getOrderInfoList() != null) {
            bPCQueryAttributes.setOrderInfoList(new ArrayList<OrderInfo>(this.getOrderInfoList()));
        }
        if (this.selectClause != null) {
            bPCQueryAttributes.selectClause = new String(this.selectClause);
        }
        if (this.whereClause != null) {
            bPCQueryAttributes.whereClause = new String(this.whereClause);
        }
        if (this.orderClause != null) {
            bPCQueryAttributes.orderClause = new String(this.orderClause);
        }
        if (this.getThreshold() != null) {
            bPCQueryAttributes.setThreshold(new Integer(this.getThreshold()));
        }
        bPCQueryAttributes.currentUser = this.currentUser;
        bPCQueryAttributes.isSystemAdmin = this.isSystemAdmin;
        bPCQueryAttributes.isSystemMonitor = this.isSystemMonitor;
        bPCQueryAttributes.locale = this.locale;
        bPCQueryAttributes.supportsCustomProperties = this.supportsCustomProperties;
        bPCQueryAttributes.supportsQueryProperties = this.supportsQueryProperties;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
        return bPCQueryAttributes;
    }

    public String getWhereCondition() {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry("Entity type: " + this.entityType);
        }
        StringBuffer stringBuffer = new StringBuffer(75);
        if (this.getAllFilterAttributes().size() > 0) {
            String string = this.getEntityType();
            stringBuffer.append(this.getFilterAttributes(string).getWhereCondition());
            for (String string2 : this.getAllFilterAttributes().keySet()) {
                if (string.equals(string2)) continue;
                QueryUtils.addConditionToWhereClause(stringBuffer, "AND", this.getFilterAttributes(string2).getWhereCondition());
            }
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit("Entity type: " + this.entityType + " - where " + stringBuffer);
        }
        return stringBuffer.toString();
    }

    public String getEntityType() {
        return this.entityType;
    }

    public String getIdColumnName() {
        return this.idColumnName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean getAdminAsUser() {
        if (this.adminAsUser != null) {
            return this.adminAsUser;
        }
        return false;
    }

    public void setAdminAsUser(boolean bl) {
        this.adminAsUser = bl ? new Boolean(true) : null;
    }

    public void setAdminAsUser(String string) {
        this.adminAsUser = string != null && "true".equalsIgnoreCase(string) ? new Boolean(true) : null;
    }

    public boolean getUseQueryAll() {
        return !this.getAdminAsUser() && (this.isSystemAdmin() || this.isSystemMonitor());
    }

    public List<ColumnInfo> getColumnInfoList() {
        return this.columnInfoList;
    }

    public void setColumnInfoList(List<ColumnInfo> list) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "Setting columnInfo list: " + list);
        }
        this.columnInfoList = list;
        if (list != null) {
            this.selectClause = null;
            this.resetPropertyHelpers();
        }
    }

    public String getListRows() {
        return this.listRows;
    }

    public void setListRows(String string) {
        this.listRows = string;
    }

    public List<CustomPropertyBean> getCustomProperties() {
        return this.customProperties;
    }

    public void setCustomProperties(List<CustomPropertyBean> list) {
        this.customProperties = list;
        if (list != null && list.size() > 0) {
            this.resetCustomPropertyHelper();
        }
    }

    public List<QueryPropertyBean> getQueryProperties() {
        return this.queryProperties;
    }

    public void setQueryProperties(List<QueryPropertyBean> list) {
        this.queryProperties = list;
        if (list != null && list.size() > 0) {
            this.resetQueryPropertyHelper();
        }
    }

    public void setFilterAttributes(BPCQueryFilterAttributes bPCQueryFilterAttributes) {
        if (bPCQueryFilterAttributes != null) {
            if (bPCQueryFilterAttributes.getType() != null) {
                bPCQueryFilterAttributes.setQueryAttributes(this);
                this.filterAttributes.put(bPCQueryFilterAttributes.getType(), bPCQueryFilterAttributes);
            }
            this.resetWhereClause();
        }
    }

    public BPCQueryFilterAttributes getFilterAttributes(String string) {
        return this.filterAttributes.get(string);
    }

    public Map<String, BPCQueryFilterAttributes> getAllFilterAttributes() {
        return this.filterAttributes;
    }

    public void resetFilterAttributes(String string) {
        BPCQueryFilterAttributes bPCQueryFilterAttributes = this.getFilterAttributes(string);
        if (bPCQueryFilterAttributes != null) {
            bPCQueryFilterAttributes.resetAttributes();
        }
    }

    public void resetAllFilterAttributes() {
        Iterator<String> iterator = this.getAllFilterAttributes().keySet().iterator();
        while (iterator.hasNext()) {
            this.resetFilterAttributes(iterator.next());
        }
    }

    public Object getFilterAttribute(String string, String string2) {
        BPCQueryFilterAttributes bPCQueryFilterAttributes = this.getFilterAttributes(string);
        if (bPCQueryFilterAttributes == null) {
            return null;
        }
        return bPCQueryFilterAttributes.getAttribute(string2);
    }

    public void setFilterAttribute(String string, String string2, Object object) {
        BPCQueryFilterAttributes bPCQueryFilterAttributes = this.getFilterAttributes(string);
        Assert.assertion((bPCQueryFilterAttributes != null ? 1 : 0) != 0, (String)("No attributes for type " + string));
        bPCQueryFilterAttributes.setAttribute(string2, object);
    }

    public void stripAttributes() {
        for (String string : this.getAllFilterAttributes().keySet()) {
            this.getFilterAttributes(string).stripAttributes();
        }
    }

    public void setOrderClause(String string) {
        this.orderClause = string;
    }

    public String getOrderClause() {
        if (this.orderClause != null) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace(TraceLogger.LEVEL_FINEST, "Explicit order clause: " + this.orderClause);
            }
            return this.orderClause;
        }
        this.orderClause = this.createOrderClause();
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace(TraceLogger.LEVEL_FINEST, "Generated order clause: " + this.orderClause);
        }
        return this.orderClause;
    }

    public boolean hasOrderClause() {
        return this.orderClause != null;
    }

    private String createOrderClause() {
        StringBuffer stringBuffer = null;
        if (this.orderInfoList != null) {
            int n = this.orderInfoList.size();
            Map<String, String> map = this.getOrderColumnsMap();
            for (int i = 0; i < n; ++i) {
                OrderInfo orderInfo = this.orderInfoList.get(i);
                String string = orderInfo.getPropertyName();
                String string2 = map.get(string);
                List<Object> list = new ArrayList<String>();
                if (string2 != null) {
                    list.add(string2);
                    if (this instanceof ProcessTemplateQueryAttributes && string.contains("displayName")) {
                        list.add(map.get("name"));
                    }
                    if (this instanceof ProcessInstanceQueryAttributes && string.contains("processTemplateDisplayName")) {
                        list.add(map.get("processTemplateName"));
                    }
                    if (this instanceof ActivityInstanceQueryAttributes && string.contains("processTemplateDisplayName")) {
                        list.add(map.get("processTemplateName"));
                    }
                } else {
                    list = this.getCustomPropertyOrderValueColumnNames(orderInfo);
                    if (list == null) {
                        list = this.getQueryPropertyOrderValueColumnNames(orderInfo);
                    }
                    if (list == null) {
                        if (!BPCClientTrace.isTracing) continue;
                        BPCClientTrace.trace(TraceLogger.LEVEL_FINE, "Tried to use: " + orderInfo.getPropertyName() + " as order element, which is not valid for this query!");
                        continue;
                    }
                }
                String string3 = null;
                if (orderInfo.isDescending()) {
                    string3 = orderInfo.getDirection();
                }
                if (list == null) continue;
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace(TraceLogger.LEVEL_FINE, "Order columns for " + string + ": " + list);
                }
                Iterator<Object> iterator = list.iterator();
                while (iterator.hasNext()) {
                    stringBuffer = this.addOrderElement(stringBuffer, ((String)iterator.next()).toString(), string3);
                }
            }
        }
        return stringBuffer != null ? stringBuffer.toString() : null;
    }

    private StringBuffer addOrderElement(StringBuffer stringBuffer, String string, String string2) {
        if (stringBuffer == null) {
            stringBuffer = new StringBuffer(string);
        } else {
            stringBuffer.append(", ").append(string);
        }
        if (string2 != null) {
            stringBuffer.append(" ").append(string2);
        }
        return stringBuffer;
    }

    public void setOrderInfoList(List<OrderInfo> list) {
        this.orderInfoList = list;
        if (list != null) {
            this.selectClause = null;
            this.orderClause = null;
            this.resetPropertyHelpers();
        }
    }

    public List<OrderInfo> getOrderInfoList() {
        return this.orderInfoList;
    }

    public void setWhereClause(String string) {
        this.whereClause = string;
    }

    public String getWhereClause() {
        if (this.whereClause != null) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace(TraceLogger.LEVEL_FINEST, "Explicit where clause: " + this.whereClause);
            }
            return this.whereClause;
        }
        StringBuffer stringBuffer = new StringBuffer(this.getWhereCondition());
        if (this.hasWhereCustomProperties()) {
            QueryUtils.addConditionToWhereClause(stringBuffer, "AND", this.getWhereClauseCustomProperties());
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "Added custom property where clause.");
            }
        }
        if (this.hasWhereQueryProperties()) {
            QueryUtils.addConditionToWhereClause(stringBuffer, "AND", this.getWhereClauseQueryProperties());
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "Added query property where clause.");
            }
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace(TraceLogger.LEVEL_FINEST, "Generated where clause: " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    public boolean hasWhereClause() {
        return this.whereClause != null;
    }

    public void resetWhereClause() {
        this.whereClause = null;
    }

    protected abstract String getSelectClauseDefault();

    public void setSelectClause(String string) {
        this.selectClause = string;
    }

    public String getSelectClause() {
        if (this.selectClause != null) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace(TraceLogger.LEVEL_FINEST, "Explicit select clause: " + this.selectClause);
            }
            return this.selectClause;
        }
        String string = this.getSelectClauseDefault();
        if (string == null) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace(TraceLogger.LEVEL_FINEST, "No explicit and no default select clause!");
            }
        } else if (this.hasSelectCustomProperties() || this.hasSelectQueryProperties()) {
            StringBuffer stringBuffer = new StringBuffer(string);
            if (this.hasSelectCustomProperties()) {
                stringBuffer = this.addSelectCustomProperties(stringBuffer);
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "Added custom property columns.");
                }
            }
            if (this.hasSelectQueryProperties()) {
                stringBuffer = this.addSelectQueryProperties(stringBuffer);
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "Added query property columns.");
                }
            }
            string = stringBuffer.toString();
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace(TraceLogger.LEVEL_FINEST, "Generated select clause: " + string);
        }
        return string;
    }

    public boolean hasSelectClause() {
        return this.selectClause != null;
    }

    public void setThreshold(Integer n) {
        this.threshold = n;
    }

    public Integer getThreshold() {
        return this.threshold;
    }

    public String getCurrentUser() {
        return this.currentUser;
    }

    public boolean isSystemAdmin() {
        return this.isSystemAdmin;
    }

    public boolean isSystemMonitor() {
        return this.isSystemMonitor;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getQueryString() {
        StringBuffer stringBuffer = new StringBuffer("Query attributes - entityType: ");
        stringBuffer.append(this.entityType).append(" tableName: ").append(this.tableName).append(" idColumnName: ").append(this.idColumnName).append(" adminAsUser: ").append(this.adminAsUser).append(" listRows: ").append(this.listRows).append("\nselectClause: ").append(this.selectClause).append(" whereClause: ").append(this.whereClause).append(" orderClause: ").append(this.orderClause).append(" threshold: ").append(this.threshold).append("\ncustomProperties: ").append(this.getQueryString(this.customProperties)).append("\nqueryProperties: ").append(this.getQueryString(this.queryProperties)).append("\ncolumnInfoList: ").append(this.getQueryString(this.getColumnInfoList())).append("\norderInfoList: ").append(this.orderInfoList);
        for (String string : this.getAllFilterAttributes().keySet()) {
            stringBuffer.append("\nFilters for ").append(string).append(": ");
            stringBuffer.append(this.getFilterAttributes(string).toString());
        }
        stringBuffer.append("\nHelper attributes - currentUser: ").append(this.currentUser).append(" isSystemAdmin: ").append(this.isSystemAdmin).append(" isSystemMonitor: ").append(this.isSystemMonitor).append(" locale: ").append(this.locale).append(" supportsCustomProperties: ").append(this.supportsCustomProperties).append(" supportsQueryProperties: ").append(this.supportsQueryProperties);
        return stringBuffer.toString();
    }

    private String getQueryString(List list) {
        StringBuffer stringBuffer = new StringBuffer(75);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                if (i > 0) {
                    stringBuffer.append("\n");
                }
                XMLSerializable xMLSerializable = (XMLSerializable)list.get(i);
                stringBuffer.append(xMLSerializable.toXML(this.getEntityType()));
            }
        }
        return stringBuffer.length() > 0 ? stringBuffer.toString() : null;
    }

    protected abstract Map<String, String> getOrderColumnsMap();

    public void initializeHelpers(String string, boolean bl, boolean bl2, Locale locale) throws ClientException {
        this.currentUser = string;
        this.isSystemAdmin = bl;
        this.isSystemMonitor = bl2;
        this.locale = locale;
        if (this.supportsCustomProperties) {
            this.setCustomPropertyHelper();
            this.customPropertyHelper.initializeProperties(this);
        }
        if (this.supportsQueryProperties) {
            this.setQueryPropertyHelper();
            this.queryPropertyHelper.initializeProperties(this);
        }
    }

    public boolean hasSelectCustomProperties() {
        if (this.supportsCustomProperties) {
            return this.getCustomPropertyHelper().hasSelectProperties();
        }
        return false;
    }

    public boolean hasSelectQueryProperties() {
        if (this.supportsQueryProperties) {
            return this.getQueryPropertyHelper().hasSelectProperties();
        }
        return false;
    }

    public boolean hasWhereCustomProperties() {
        if (this.supportsCustomProperties) {
            return this.getCustomPropertyHelper().hasWhereProperties();
        }
        return false;
    }

    public boolean hasWhereQueryProperties() {
        if (this.supportsQueryProperties) {
            return this.getQueryPropertyHelper().hasWhereProperties();
        }
        return false;
    }

    public String getCustomPropertyKey(String string, int n) {
        if (this.supportsCustomProperties) {
            return this.getCustomPropertyHelper().getPropertyKey(string, n);
        }
        return null;
    }

    public CustomPropertyBean createCustomPropertyBeanFromResult(String string, String string2, Object object) {
        if (this.supportsCustomProperties) {
            return (CustomPropertyBean)this.getCustomPropertyHelper().createPropertyBeanFromResult(string, string2, object);
        }
        return null;
    }

    public QueryPropertyBean createQueryPropertyBeanFromResult(String string, String string2, Object object) {
        if (this.supportsQueryProperties) {
            return (QueryPropertyBean)this.getQueryPropertyHelper().createPropertyBeanFromResult(string, string2, object);
        }
        return null;
    }

    public boolean isCustomPropertyTableName(String string) {
        if (this.supportsCustomProperties) {
            return BPCQueryPropertyHelper.isPropertyTableName(string, CustomPropertyBean.getTableName(this.entityType));
        }
        return false;
    }

    public boolean isQueryPropertyTableName(String string) {
        if (this.supportsQueryProperties) {
            return BPCQueryPropertyHelper.isPropertyTableName(string, "QUERY_PROPERTY");
        }
        return false;
    }

    private void setCustomPropertyHelper() {
        this.customPropertyHelper = new BPCQueryCustomPropertyHelper();
    }

    private void setQueryPropertyHelper() {
        this.queryPropertyHelper = new BPCQueryQueryPropertyHelper();
    }

    private void resetPropertyHelpers() {
        this.resetCustomPropertyHelper();
        this.resetQueryPropertyHelper();
    }

    private void resetCustomPropertyHelper() {
        this.customPropertyHelper = null;
    }

    private void resetQueryPropertyHelper() {
        this.queryPropertyHelper = null;
    }

    private BPCQueryPropertyHelper getCustomPropertyHelper() {
        Assert.assertion((this.supportsCustomProperties && this.customPropertyHelper != null && this.customPropertyHelper.isInitialized() ? 1 : 0) != 0, (String)"customPropertyHelper is not initialized!");
        return this.customPropertyHelper;
    }

    private BPCQueryPropertyHelper getQueryPropertyHelper() {
        Assert.assertion((this.supportsQueryProperties && this.queryPropertyHelper != null && this.queryPropertyHelper.isInitialized() ? 1 : 0) != 0, (String)"queryPropertyHelper is not initialized!");
        return this.queryPropertyHelper;
    }

    private StringBuffer addSelectCustomProperties(StringBuffer stringBuffer) {
        if (this.supportsCustomProperties) {
            return this.getCustomPropertyHelper().addSelectProperties(stringBuffer);
        }
        return null;
    }

    private StringBuffer addSelectQueryProperties(StringBuffer stringBuffer) {
        if (this.supportsQueryProperties) {
            return this.getQueryPropertyHelper().addSelectProperties(stringBuffer);
        }
        return null;
    }

    private String getWhereClauseCustomProperties() {
        if (this.supportsCustomProperties) {
            return this.getCustomPropertyHelper().getWhereClauseProperties();
        }
        return null;
    }

    private String getWhereClauseQueryProperties() {
        if (this.supportsQueryProperties) {
            return this.getQueryPropertyHelper().getWhereClauseProperties();
        }
        return null;
    }

    private List<String> getCustomPropertyOrderValueColumnNames(OrderInfo orderInfo) {
        if (this.supportsCustomProperties) {
            return this.getCustomPropertyHelper().getOrderValueColumnNames(orderInfo);
        }
        return null;
    }

    private List<String> getQueryPropertyOrderValueColumnNames(OrderInfo orderInfo) {
        if (this.supportsQueryProperties) {
            return this.getQueryPropertyHelper().getOrderValueColumnNames(orderInfo);
        }
        return null;
    }

    public List<CommandInfo> getCommandInfoList() {
        return this.commandInfoList;
    }

    public void setCommandInfoList(List<CommandInfo> list) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "Setting commandInfo list: " + list);
        }
        this.commandInfoList = list != null ? list : new ArrayList<CommandInfo>();
    }

    public boolean isDefaultCommandSetUsed() {
        return this.defaultCommandSetUsed;
    }

    public void setDefaultCommandSetUsed(boolean bl) {
        this.defaultCommandSetUsed = bl;
    }
}

