/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpc.clientcore;

import com.ibm.bpc.clientcore.BPCQueryAttributes;
import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.DynamicalCommandQuery;
import com.ibm.bpc.clientcore.SimpleBPCQueryAttributes;
import com.ibm.bpc.clientcore.util.QueryResultSetWrapper;
import com.ibm.bpc.clientcore.util.QueryUtils;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.util.Assert;
import com.ibm.bpe.util.TraceLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public abstract class BPCQuery
implements DynamicalCommandQuery {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2007, 2008.\n\n";
    public static final String BUNDLE_NAME = "com.ibm.bpc.clientcore.resources.bpcclientcorePIINonMessages";
    private String type = null;
    private BPCQueryAttributes queryAttributes = new SimpleBPCQueryAttributes();
    private Map errorMap = null;
    private String currentUser = null;
    private boolean isSystemAdmin = false;
    private boolean isSystemMonitor = false;
    private Locale locale = Locale.getDefault();

    public BPCQuery() {
    }

    public BPCQuery(BPCQueryAttributes bPCQueryAttributes) {
        Assert.assertion((bPCQueryAttributes != null ? 1 : 0) != 0, (String)"QueryAttributes may not be null!");
        this.queryAttributes = bPCQueryAttributes;
    }

    public boolean isSystemAdmin() {
        return this.isSystemAdmin;
    }

    protected void setSystemAdmin(boolean bl) {
        this.isSystemAdmin = bl;
    }

    public boolean isSystemMonitor() {
        return this.isSystemMonitor;
    }

    protected void setSystemMonitor(boolean bl) {
        this.isSystemMonitor = bl;
    }

    public List execute() throws ClientException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        this.getQueryAttributes().initializeHelpers(this.getCurrentUser(), this.isSystemAdmin(), this.isSystemMonitor(), this.getLocale());
        List list = this.executeBPCQuery();
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit("Returning " + list.size() + " items");
        }
        return list;
    }

    public abstract List executeBPCQuery() throws ClientException;

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public boolean hasOrderClause() {
        return this.getQueryAttributes().hasOrderClause();
    }

    public boolean hasSelectClause() {
        return this.getQueryAttributes().hasSelectClause();
    }

    public boolean hasWhereClause() {
        return this.getQueryAttributes().hasWhereClause();
    }

    public String getOrderClause() {
        return this.getQueryAttributes().getOrderClause();
    }

    public String getSelectClause() {
        return this.getQueryAttributes().getSelectClause();
    }

    public Integer getThreshold() {
        return this.getQueryAttributes().getThreshold();
    }

    public String getWhereClause() {
        return this.getQueryAttributes().getWhereClause();
    }

    public void setOrderClause(String string) {
        this.getQueryAttributes().setOrderClause(string);
    }

    public void setSelectClause(String string) {
        this.getQueryAttributes().setSelectClause(string);
    }

    public void setThreshold(Integer n) {
        this.getQueryAttributes().setThreshold(n);
    }

    public void setWhereClause(String string) {
        this.getQueryAttributes().setWhereClause(string);
    }

    public void resetWhereClause() {
        this.getQueryAttributes().resetWhereClause();
    }

    public boolean getUseQueryAll() {
        return this.getQueryAttributes().getUseQueryAll();
    }

    public String getCurrentUser() {
        return this.currentUser;
    }

    public void setCurrentUser(String string) {
        this.currentUser = string;
    }

    public BPCQueryAttributes getQueryAttributes() {
        return this.queryAttributes;
    }

    public void setQueryAttributes(BPCQueryAttributes bPCQueryAttributes) {
        this.queryAttributes = bPCQueryAttributes;
    }

    public List getColumnInfoList() {
        return this.queryAttributes.getColumnInfoList();
    }

    public List getCommandInfoList() {
        return this.queryAttributes.getCommandInfoList();
    }

    public boolean isDefaultCommandSetUsed() {
        return this.queryAttributes.isDefaultCommandSetUsed();
    }

    public void setColumnInfoList(List list) {
        this.queryAttributes.setColumnInfoList(list);
    }

    public void reset() {
        this.queryAttributes.resetAllFilterAttributes();
    }

    protected String getTableName() {
        return this.getQueryAttributes().getTableName();
    }

    protected String getIdColumnName() {
        return this.getQueryAttributes().getIdColumnName();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Map getErrors() {
        return this.errorMap;
    }

    public void setErrors(Map map) {
        this.errorMap = map;
    }

    protected String getQueryString() {
        return this.getQueryString(this.getSelectClause(), this.getWhereClause(), this.getOrderClause(), this.getThreshold());
    }

    protected String getQueryString(String string, String string2, String string3, Integer n) {
        StringBuffer stringBuffer = new StringBuffer("\nSelect clause: ");
        stringBuffer.append(string).append("\nWhere clause: ").append(string2).append("\nOrderBy clause: ").append(string3).append("\nThreshold: ").append(n).append(", useQueryAll: ").append(this.getUseQueryAll()).append(", currentUser: ").append(this.getCurrentUser()).append(", isSystemAdmin: ").append(this.isSystemAdmin()).append(", isSystemMonitor: ").append(this.isSystemMonitor()).append(", locale: ").append(this.getLocale()).append("\n").append(this.getQueryAttributes().getQueryString());
        return stringBuffer.toString();
    }

    protected String updateWhereClause(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        QueryUtils.addConditionToWhereClause(stringBuffer, "AND", QueryUtils.getAdminAsUserWorkItemCondition(this.getQueryAttributes()));
        return this.replacePseudoSQLFunctions(stringBuffer.toString());
    }

    protected String updateWhereClauseForTemplates(String string) {
        return this.replacePseudoSQLFunctions(string);
    }

    private String replacePseudoSQLFunctions(String string) {
        String string2 = QueryUtils.replaceCurrentUser(string, this.getQueryAttributes().getCurrentUser());
        string2 = QueryUtils.replaceCurrentTimestamp(string2);
        string2 = QueryUtils.replaceTsAdd(string2);
        string2 = QueryUtils.replaceTsSpan(string2);
        return string2;
    }

    protected List transformToBeans(QueryResultSetWrapper queryResultSetWrapper) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "Result rows " + (queryResultSetWrapper != null ? queryResultSetWrapper.size() : 0));
        }
        ArrayList<Object> arrayList = null;
        if (queryResultSetWrapper != null && queryResultSetWrapper.size() > 0) {
            arrayList = new ArrayList(queryResultSetWrapper.size());
            for (int i = 0; i < queryResultSetWrapper.size(); ++i) {
                queryResultSetWrapper.next();
                Object object = this.createBean(queryResultSetWrapper);
                arrayList.add(object);
            }
        } else {
            arrayList = new ArrayList<Object>(0);
        }
        return arrayList;
    }

    protected Object createBean(QueryResultSetWrapper queryResultSetWrapper) {
        Assert.assertion((boolean)false, (String)"Method must be overwritten if transformToBeans is called!");
        return new Object();
    }

    public String getBundleName() {
        return BUNDLE_NAME;
    }
}

