/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.jsf.util;

import com.ibm.bpc.clientcore.converter.SimpleConverter;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.jsf.converter.FacesSimpleConverter;
import com.ibm.bpe.jsf.exception.ConfigurationException;
import com.ibm.bpe.jsf.exception.ConverterNotAvailableException;
import com.ibm.bpe.jsf.util.LocaleUtils;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import javax.faces.convert.Converter;

public class MetaInformation {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2007.\n\n";
    private Method _isValidMethod = null;
    private Method _converterMethod = null;
    private Method _labelMethod = null;
    private String _className = null;
    private static final String IS_VALID = "isValid";
    private static final String GET_CONVERTER = "getConverter";
    private static final String GET_LABEL = "getLabel";

    public MetaInformation(Class clazz) throws ConfigurationException, SecurityException, NoSuchMethodException {
        this._className = clazz.getName();
        this._isValidMethod = null;
        this._converterMethod = clazz.getMethod(GET_CONVERTER, String.class);
        this._labelMethod = clazz.getMethod(GET_LABEL, String.class, Locale.class);
    }

    public boolean isPropertyValid(String string) {
        Boolean bl;
        try {
            bl = this._isValidMethod != null ? (Boolean)this._isValidMethod.invoke(null, string) : Boolean.TRUE;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return true;
        }
        catch (InvocationTargetException invocationTargetException) {
            return true;
        }
        return bl;
    }

    public SimpleConverter getSimpleConverter(String string) {
        SimpleConverter simpleConverter;
        try {
            simpleConverter = this._converterMethod != null ? (SimpleConverter)this._converterMethod.invoke(null, string) : null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
        return simpleConverter;
    }

    public Converter getFacesConverter(String string) throws ConverterNotAvailableException {
        SimpleConverter simpleConverter = null;
        FacesSimpleConverter facesSimpleConverter = null;
        try {
            SimpleConverter simpleConverter2 = simpleConverter = this._converterMethod != null ? (SimpleConverter)this._converterMethod.invoke(null, string) : null;
            if (simpleConverter != null) {
                facesSimpleConverter = new FacesSimpleConverter();
                facesSimpleConverter.setSimpleConverter(simpleConverter);
            } else if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Could not find a SimpleConverter for property " + string + " of class " + this._className));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ConverterNotAvailableException(new Object[]{string, this._className}, illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ConverterNotAvailableException(new Object[]{string, this._className}, illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ConverterNotAvailableException(new Object[]{string, this._className}, invocationTargetException);
        }
        if (facesSimpleConverter == null) {
            return null;
        }
        return facesSimpleConverter;
    }

    public String getLabel(String string) {
        String string2;
        try {
            string2 = this._labelMethod != null ? (String)this._labelMethod.invoke(null, string, LocaleUtils.getLocale()) : null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
        return string2;
    }

    public static SimpleConverter lookupSimpleConverter(Class clazz, String string) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method method = clazz.getMethod(GET_CONVERTER, String.class);
        SimpleConverter simpleConverter = method != null ? (SimpleConverter)method.invoke(null, string) : null;
        return simpleConverter;
    }

    public static String lookupLabel(Class clazz, String string) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method method = clazz.getMethod(GET_LABEL, String.class, Locale.class);
        String string2 = method != null ? (String)method.invoke(null, string, LocaleUtils.getLocale()) : null;
        return string2;
    }

    public static boolean lookupIsPropertyValid(Class clazz, String string) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method method = clazz.getMethod(IS_VALID, String.class);
        Boolean bl = method != null ? (Boolean)method.invoke(null, string) : Boolean.TRUE;
        return bl;
    }
}

