/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.jsf.util;

import com.ibm.bpc.clientcore.util.User;
import com.ibm.bpe.api.ProcessError;
import com.ibm.bpe.api.ProcessException;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.util.Assert;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.task.api.TaskError;
import com.ibm.task.api.TaskException;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.servlet.http.HttpServletRequest;

public class LocaleUtils {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";
    static ValueBinding userBinding = null;
    static com.ibm.icu.util.TimeZone UTC = com.ibm.icu.util.TimeZone.getTimeZone((String)"UTC");
    static DateFormat serverDateFormatter = new SimpleDateFormat("HH:mm:ss");
    static ResourceBundle applicationMessages;

    public static Locale getLocale() {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        return LocaleUtils.getLocale(FacesContext.getCurrentInstance());
    }

    public static Locale getLocale(FacesContext facesContext) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        Locale locale = facesContext.getApplication().getDefaultLocale();
        Object object = facesContext.getExternalContext().getRequest();
        if (object instanceof HttpServletRequest) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)object;
            locale = httpServletRequest.getLocale();
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)locale.getDisplayName());
        }
        return locale;
    }

    public static TimeZone getClientTimeZone(FacesContext facesContext) {
        Application application;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        if (userBinding == null) {
            application = facesContext.getApplication();
            userBinding = application.createValueBinding("#{user}");
        }
        Assert.assertion((userBinding != null ? 1 : 0) != 0, (String)"application.createValueBinding(\"#{user}\") != null");
        application = (User)userBinding.getValue(facesContext);
        TimeZone timeZone = null;
        timeZone = application != null ? application.getTimeZone() : TimeZone.getDefault();
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)timeZone);
        }
        return timeZone;
    }

    private static com.ibm.icu.util.TimeZone convertJava2ICUTZ(TimeZone timeZone) {
        com.ibm.icu.util.TimeZone timeZone2 = com.ibm.icu.util.TimeZone.getTimeZone((String)timeZone.getID());
        timeZone2.setRawOffset(timeZone.getRawOffset());
        return timeZone2;
    }

    public static Locale getFacesLocale(FacesContext facesContext) {
        if (facesContext != null && facesContext.getViewRoot() != null) {
            return facesContext.getViewRoot().getLocale();
        }
        return Locale.getDefault();
    }

    public static Locale getFacesLocale() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return LocaleUtils.getFacesLocale(facesContext);
    }

    public static String getMessage(Locale locale, Throwable throwable) {
        if (throwable instanceof ProcessException) {
            return ((ProcessException)throwable).getMessage(locale);
        }
        if (throwable instanceof TaskException) {
            return ((TaskException)throwable).getMessage(locale);
        }
        if (throwable instanceof ProcessError) {
            return ((ProcessError)throwable).getMessage(locale);
        }
        if (throwable instanceof TaskError) {
            return ((TaskError)throwable).getMessage(locale);
        }
        return throwable.getMessage();
    }

    public static com.ibm.icu.util.TimeZone getClientICUTimeZone(FacesContext facesContext) {
        Application application;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        if (userBinding == null) {
            application = facesContext.getApplication();
            userBinding = application.createValueBinding("#{user}");
        }
        Assert.assertion((userBinding != null ? 1 : 0) != 0, (String)"application.createValueBinding(\"#{user}\") != null");
        application = (User)userBinding.getValue(facesContext);
        com.ibm.icu.util.TimeZone timeZone = null;
        timeZone = application != null ? LocaleUtils.convertJava2ICUTZ(application.getTimeZone()) : com.ibm.icu.util.TimeZone.getDefault();
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)timeZone);
        }
        return timeZone;
    }

    public static String showClientDateTime(Date date) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Locale locale = LocaleUtils.getFacesLocale(facesContext);
        DateFormat dateFormat = DateFormat.getDateTimeInstance((int)3, (int)1, (Locale)locale);
        dateFormat.setLenient(false);
        dateFormat.setTimeZone(LocaleUtils.getClientICUTimeZone(facesContext));
        ((SimpleDateFormat)dateFormat).applyPattern(com.ibm.bpc.clientcore.util.LocaleUtils.getAdjustedYearPattern((Integer)3, (Integer)1, (Locale)locale));
        String string = dateFormat.format(date);
        if ("ar".equals(locale.getLanguage())) {
            string = "&lrm; ".concat(string).concat(" &#x202C; ");
        }
        return string;
    }

    public static String createServerTimeObject(Date date) {
        return serverDateFormatter.format(date);
    }

    public static String getLocalizedApplicationString(String string) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)string);
        }
        String string2 = null;
        try {
            if (applicationMessages != null) {
                string2 = applicationMessages.getString(string);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (BPCClientTrace.isTracing && string2 == null) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_EVENT, (String)("No localized string found for key " + string));
        }
        return string2 != null ? string2 : string;
    }

    public static String getLocalizedString(String string, String string2) {
        return LocaleUtils.getLocalizedString(string, LocaleUtils.getLocale(), string2);
    }

    public static String getLocalizedString(String string, Locale locale, String string2) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(string2, locale);
        String string3 = string;
        try {
            string3 = resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("No matching string found for key " + string + ". Using " + string));
            }
            string3 = string;
        }
        return string3;
    }

    static {
        serverDateFormatter.setTimeZone(UTC);
        applicationMessages = null;
    }
}

