/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.jsf.util;

import com.ibm.bpc.clientcore.converter.SimpleConverter;
import com.ibm.bpc.clientcore.converter.TimezoneConverter;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.jsf.util.LocaleUtils;
import com.ibm.bpe.jsf.util.MetaInformation;
import com.ibm.bpe.jsf.util.SelectionWrapper;
import com.ibm.bpe.util.Assert;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.icu.text.Collator;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Locale;
import javax.faces.context.FacesContext;

public class ListComparator
implements Comparator {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2008.\n\n";
    private TimezoneConverter timeZoneConverter = null;
    private SimpleConverter simpleconverter = null;
    private String property = null;
    private String getter = null;
    private String booleanGetter = null;
    private Method method = null;
    private int order = 1;
    private boolean initialised = false;
    public static final Integer ASCENDING = new Integer(1);
    public static final Integer DESCENDING = new Integer(-1);
    public static final Integer NOSORTED = new Integer(0);

    public ListComparator(String string, SimpleConverter simpleConverter, Integer n) {
        this.property = string;
        this.order = n != null ? n : 1;
        this.getter = string != null ? "get" + string.substring(0, 1).toUpperCase() + string.substring(1) : null;
        this.booleanGetter = string != null ? "is" + string.substring(0, 1).toUpperCase() + string.substring(1) : null;
        this.setSimpleConverter(simpleConverter);
        Assert.assertion((string != null ? 1 : 0) != 0, (String)"Property used in ListComparator must not be null");
    }

    private Class getClazz(SelectionWrapper selectionWrapper) {
        return selectionWrapper.getObject().getClass();
    }

    public int compare(Object object, Object object2) {
        try {
            if (!this.initialised) {
                this.init(object);
            }
            Object object3 = this.method.invoke(((SelectionWrapper)object).getObject(), new Object[0]);
            Object object4 = this.method.invoke(((SelectionWrapper)object2).getObject(), new Object[0]);
            if (object3 instanceof Number && object4 instanceof Number) {
                boolean bl;
                boolean bl2 = ((Number)object3).doubleValue() < ((Number)object4).doubleValue();
                boolean bl3 = bl = ((Number)object3).doubleValue() > ((Number)object4).doubleValue();
                if (bl2) {
                    return -1 * this.order;
                }
                if (bl) {
                    return this.order;
                }
                return 0;
            }
            if (object3 instanceof Calendar && object4 instanceof Calendar) {
                int n = 0;
                if (((Calendar)object3).before((Calendar)object4)) {
                    n = -1;
                } else if (((Calendar)object3).after((Calendar)object4)) {
                    n = 1;
                }
                return n * this.order;
            }
            String string = null;
            String string2 = null;
            Locale locale = LocaleUtils.getFacesLocale();
            if (object3 != null) {
                string = this.getConvertedValue(locale, object3);
            }
            if (object4 != null) {
                string2 = this.getConvertedValue(locale, object4);
            }
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)(string + " <=> " + string2));
            }
            if (string == null) {
                string = "";
            }
            if (string2 == null) {
                string2 = "";
            }
            return Collator.getInstance((Locale)LocaleUtils.getLocale()).compare(string, string2) * this.order;
        }
        catch (Exception exception) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_EVENT, (Throwable)exception);
            }
            return 0;
        }
    }

    private void init(Object object) throws NoSuchMethodException, SecurityException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        block4: {
            Class clazz = this.getClazz((SelectionWrapper)object);
            try {
                this.method = clazz.getMethod(this.getter, new Class[]{null});
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.method = clazz.getMethod(this.booleanGetter, new Class[0]);
            }
            Assert.assertion((this.method != null ? 1 : 0) != 0, (String)("Class  (" + clazz.getClass().getName() + ") must have a method (" + this.getter + ") or (" + this.booleanGetter + ")"));
            try {
                SimpleConverter simpleConverter = MetaInformation.lookupSimpleConverter(clazz, this.property);
                this.setSimpleConverter(simpleConverter);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (!BPCClientTrace.isTracing) break block4;
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"No getConverter method found on object, going to use 'toString' to sort entries");
            }
        }
        this.initialised = true;
    }

    private void setSimpleConverter(SimpleConverter simpleConverter) {
        if (simpleConverter != null) {
            if (simpleConverter instanceof TimezoneConverter) {
                this.timeZoneConverter = (TimezoneConverter)simpleConverter;
            } else {
                this.simpleconverter = simpleConverter;
            }
        }
    }

    private String getConvertedValue(Locale locale, Object object) {
        if (this.timeZoneConverter != null) {
            return this.timeZoneConverter.getAsString(object, locale, LocaleUtils.getClientTimeZone(FacesContext.getCurrentInstance()));
        }
        if (this.simpleconverter != null) {
            return this.simpleconverter.getAsString(object, locale);
        }
        return object.toString();
    }
}

