/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.jsf.util;

import com.ibm.bpc.clientcore.util.ErrorBean;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.jsf.component.CommandTracer;
import com.ibm.bpe.jsf.util.LocaleUtils;
import com.ibm.bpe.jsf.util.SelectionWrapper;
import com.ibm.bpe.util.Assert;
import com.ibm.bpe.util.Catalog;
import com.ibm.bpe.util.Environment;
import com.ibm.bpe.util.MessageLogger;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.wsspi.al.ALContext;
import com.ibm.wsspi.al.InvalidConfigException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.application.NavigationHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;

public class FacesUtils {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";
    private static final String PII_MESSAGE_FILE = "com.ibm.bpe.jsf.catalog.bpcjsfcomponentsPIIMessages";
    private static final String NON_PII_MESSAGE_FILE = "com.ibm.bpe.jsf.catalog.BpcjsfcomponentsPIINonMessages";
    private static final String ERROR_PAGE_TARGET = "error";
    private static final String ERROR_PAGE_BINDING = "#{BPCError}";
    public static final String BPCCALLEDRENDERRESPONSE = "bpcCalledRenderResponse";
    private static Map CATALOG_CACHE = new HashMap();
    private static String _RALTemplateNameDefault = "BPC_CLIENT";

    public static Class getApplicationClazz(String string) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = FacesUtils.class.getClassLoader();
        }
        Class<?> clazz = null;
        clazz = classLoader.loadClass(string);
        return clazz;
    }

    public static Object getApplicationClazzInstance(String string) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Class clazz = FacesUtils.getApplicationClazz(string);
        Object var2_2 = null;
        var2_2 = clazz.newInstance();
        return var2_2;
    }

    public static List wrapInSelectionHandler(List list) {
        if (list == null) {
            return null;
        }
        ArrayList<SelectionWrapper> arrayList = new ArrayList<SelectionWrapper>();
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            arrayList.add(new SelectionWrapper(e));
            ++n;
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Wrapping " + n + " items"));
        }
        return arrayList;
    }

    public static List unwrapSelectionHandler(List list) {
        if (list == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        for (Object object : list) {
            if (object instanceof SelectionWrapper) {
                object = ((SelectionWrapper)object).getObject();
            }
            arrayList.add(object);
        }
        return arrayList;
    }

    public static void queueValidationMessage(String string, FacesMessage facesMessage) {
        FacesContext facesContext;
        Map map;
        ArrayList<FacesMessage> arrayList;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Queueing validation message for clientId " + string));
        }
        if ((arrayList = (ArrayList<FacesMessage>)(map = (facesContext = FacesContext.getCurrentInstance()).getExternalContext().getRequestMap()).get("validation/" + string)) == null) {
            arrayList = new ArrayList<FacesMessage>();
        }
        arrayList.add(facesMessage);
        map.put("validation/" + string, arrayList);
    }

    public static List getValidationMessage(String string) {
        FacesContext facesContext;
        Map map;
        List list;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Retrieving validation message for clientId " + string));
        }
        return (list = (List)(map = (facesContext = FacesContext.getCurrentInstance()).getExternalContext().getRequestMap()).get("validation/" + string)) != null ? list : new ArrayList();
    }

    public static boolean hasValidationMessages(String string) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Checking validation messages for clientId " + string));
        }
        boolean bl = false;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Map map = facesContext.getExternalContext().getRequestMap();
        for (String string2 : map.keySet()) {
            if (string2 == null || !string2.startsWith("validation/" + string)) continue;
            bl = true;
            break;
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)Boolean.toString(bl));
        }
        return bl;
    }

    public static String lookupPIIMessage(String string, Object[] objectArray) {
        Catalog catalog = FacesUtils.lookupCatalog(PII_MESSAGE_FILE, LocaleUtils.getFacesLocale());
        return catalog.get(string, objectArray);
    }

    public static String lookupNonPIIMessage(String string) {
        Catalog catalog = FacesUtils.lookupCatalog(NON_PII_MESSAGE_FILE, LocaleUtils.getFacesLocale());
        return catalog.get(string);
    }

    public static String lookupNonPIIMessage(String string, Object[] objectArray) {
        Catalog catalog = FacesUtils.lookupCatalog(NON_PII_MESSAGE_FILE, LocaleUtils.getFacesLocale());
        String string2 = catalog.get(string);
        return MessageFormat.format(string2, objectArray);
    }

    public static void showErrorPage(FacesContext facesContext, Exception exception, boolean bl) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        String string = null;
        if (bl) {
            string = ERROR_PAGE_TARGET;
        }
        FacesUtils.showErrorPage(facesContext, exception, string);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void showErrorPage(FacesContext facesContext, Exception exception, String string) {
        Map map;
        ValueBinding valueBinding;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        if ((valueBinding = (ValueBinding)(map = facesContext.getExternalContext().getApplicationMap()).get("errorBeanValueBinding")) == null) {
            valueBinding = facesContext.getApplication().createValueBinding(ERROR_PAGE_BINDING);
            map.put("errorBeanValueBinding", valueBinding);
        }
        Assert.assertion((valueBinding != null ? 1 : 0) != 0, (String)"The errorBeanBinding must not be null");
        ErrorBean errorBean = (ErrorBean)valueBinding.getValue(facesContext);
        if (errorBean == null) {
            MessageLogger messageLogger = MessageLogger.newMessageLogger((String)BPCClientTrace.class.getName());
            messageLogger.exception(MessageLogger.TYPE_ERROR, (Throwable)exception);
            return;
        }
        errorBean.setException(exception, LocaleUtils.getFacesLocale());
        if (string != null && !facesContext.getRenderResponse()) {
            String string2;
            UIViewRoot uIViewRoot = facesContext.getViewRoot();
            String string3 = string2 = uIViewRoot != null ? uIViewRoot.getViewId() : "";
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Following navigation rule: " + string + " from page " + string2));
            }
            FacesUtils.navigate(facesContext, string);
            if (!BPCClientTrace.isTracing) return;
            BPCClientTrace.exit();
            return;
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Processing is already in RenderResponse.. re-throwing Exception to trigger default error page");
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
        IllegalStateException illegalStateException = new IllegalStateException("Faces Phase is already RenderedResponse - Can't display faces error page");
        illegalStateException.initCause(exception);
        throw illegalStateException;
    }

    public static void addCommandTrace(String string, List list) {
        block3: {
            try {
                FacesContext facesContext = FacesContext.getCurrentInstance();
                Application application = facesContext.getApplication();
                ValueBinding valueBinding = application.createValueBinding("#{bspace}");
                CommandTracer commandTracer = (CommandTracer)valueBinding.getValue(facesContext);
                if (commandTracer != null) {
                    commandTracer.addCommandTrace(string, list);
                }
            }
            catch (Exception exception) {
                if (!BPCClientTrace.isTracing) break block3;
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_EVENT, (Throwable)exception);
            }
        }
    }

    public static void navigate(FacesContext facesContext, String string) {
        Map map = facesContext.getExternalContext().getRequestMap();
        if (map.get(BPCCALLEDRENDERRESPONSE) != null) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Call to FacesUtils.navigate with target " + string + ". However renderResponse was already called for the current request!"));
            }
        } else {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Call to FacesUtils.navigate: Navigating to " + string));
            }
            Application application = facesContext.getApplication();
            NavigationHandler navigationHandler = application.getNavigationHandler();
            navigationHandler.handleNavigation(facesContext, null, string);
            facesContext.renderResponse();
            map.put(BPCCALLEDRENDERRESPONSE, "true");
        }
    }

    public static String getImageUrl(String string) {
        ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
        String string2 = externalContext.encodeResourceURL(externalContext.getRequestContextPath() + "/images/" + string);
        return string2;
    }

    public static String getRALTemplateName() {
        String string = Environment.getProperty((String)"RALTemplateName");
        if (string == null) {
            string = _RALTemplateNameDefault;
        }
        return string;
    }

    public static void setRALContext(String string) throws InvalidConfigException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)string);
        }
        if (string != null) {
            ALContext.setContext((String)FacesUtils.getRALTemplateName(), (String)string);
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    public static void unsetRALContext(String string) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)string);
        }
        if (string != null) {
            ALContext.unset();
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    static Catalog lookupCatalog(String string, Locale locale) {
        String string2 = locale.toString() + "#" + string;
        Catalog catalog = (Catalog)CATALOG_CACHE.get(string2);
        if (catalog == null) {
            catalog = new Catalog(string, locale);
            CATALOG_CACHE.put(string2, catalog);
        }
        return catalog;
    }

    public static UIComponent findComponent(String string) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)string);
        }
        if (string == null) {
            return null;
        }
        UIViewRoot uIViewRoot = FacesContext.getCurrentInstance().getViewRoot();
        ArrayList arrayList = new ArrayList();
        Object var3_3 = null;
        UIViewRoot uIViewRoot2 = uIViewRoot;
        while (uIViewRoot2 != null) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Processing ComponentID: " + uIViewRoot2.getId()));
            }
            if (string.equals(uIViewRoot2.getId())) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Found matching ComponentID: " + string));
                }
                return uIViewRoot2;
            }
            if (!uIViewRoot2.getChildren().isEmpty()) {
                arrayList.addAll(uIViewRoot2.getChildren());
            }
            if (arrayList.isEmpty()) {
                uIViewRoot2 = null;
                continue;
            }
            uIViewRoot2 = (UIComponent)arrayList.get(0);
            arrayList.remove(0);
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Did not find ComponentID: " + string));
        }
        return uIViewRoot2;
    }
}

