/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.jsf.util;

import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import java.io.IOException;
import javax.faces.FactoryFinder;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;

public class FacesIntrospector {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2008.\n\n";
    private static FacesIntrospector SINGLETON = null;
    static final String CLIENT_ID = "bpc_view_id";
    static final String LAST_CLIENT_ID = "bpc_last_view_id";
    static final String CURRENT_PHASE = "bpc_faces_phase";
    static final String NAVIGATOR = "bpc_Navigator";

    public static FacesIntrospector getFacesIntrospector() {
        if (SINGLETON == null) {
            SINGLETON = new FacesIntrospector();
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ExternalContext externalContext = facesContext.getExternalContext();
            externalContext.getApplicationMap().put(NAVIGATOR, SINGLETON);
        }
        return SINGLETON;
    }

    public FacesIntrospector() {
        this.init();
    }

    private void init() {
        LifecycleFactory lifecycleFactory;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        if ((lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory")) == null) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Could not access a LifecycleFactor");
            }
            return;
        }
        Lifecycle lifecycle = lifecycleFactory.getLifecycle("DEFAULT");
        if (lifecycle == null) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Could not access a Lifecycle Instance");
            }
            return;
        }
        Listener listener = new Listener();
        lifecycle.addPhaseListener((PhaseListener)listener);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Registering phase listener");
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    public String getCurrentPhase() {
        String string = (String)this.getValue(CURRENT_PHASE);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)("returning currentPhase = " + string));
        }
        return string;
    }

    public String getCurrentClientId() {
        String string = (String)this.getValue(CLIENT_ID);
        return string;
    }

    public String getLastClientId() {
        String string = (String)this.getValue(LAST_CLIENT_ID);
        return string;
    }

    public void back(ActionEvent actionEvent) {
        String string = (String)this.getValue(LAST_CLIENT_ID);
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
        UIViewRoot uIViewRoot = viewHandler.createView(facesContext, string);
        facesContext.setViewRoot(uIViewRoot);
        facesContext.renderResponse();
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)("returning to lastClientId = " + string));
        }
    }

    public void redirectBack(ActionEvent actionEvent) {
        block3: {
            String string = (String)this.getValue(LAST_CLIENT_ID);
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
            String string2 = viewHandler.getActionURL(facesContext, string);
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Redirecting to " + string2));
            }
            try {
                facesContext.getExternalContext().redirect(string2);
                facesContext.responseComplete();
            }
            catch (IOException iOException) {
                if (!BPCClientTrace.isTracing) break block3;
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_EVENT, (Throwable)iOException);
            }
        }
    }

    private Object getValue(String string) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        return externalContext.getSessionMap().get(string);
    }

    private static void logPhase(PhaseId phaseId, boolean bl) {
        if (BPCClientTrace.isTracing) {
            if (bl) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("BEFORE PHASE " + phaseId.toString()));
            } else {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("AFTER PHASE " + phaseId.toString()));
            }
        }
    }

    private static void setClientIDHistory() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        UIViewRoot uIViewRoot = facesContext.getViewRoot();
        String string = uIViewRoot.getViewId();
        ExternalContext externalContext = facesContext.getExternalContext();
        String string2 = (String)externalContext.getSessionMap().get(CLIENT_ID);
        externalContext.getSessionMap().put(LAST_CLIENT_ID, string2);
        externalContext.getSessionMap().put(CLIENT_ID, string);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("VIEW: " + string));
        }
    }

    public static class Listener
    implements PhaseListener {
        public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005.\n\n";
        private static final long serialVersionUID = 1L;

        public void afterPhase(PhaseEvent phaseEvent) {
            FacesIntrospector.logPhase(phaseEvent.getPhaseId(), false);
        }

        public void beforePhase(PhaseEvent phaseEvent) {
            if (phaseEvent.getPhaseId() == PhaseId.RENDER_RESPONSE) {
                FacesIntrospector.setClientIDHistory();
                this.refreshTraceSettings();
            }
            FacesIntrospector.logPhase(phaseEvent.getPhaseId(), true);
            this.setPhaseId(phaseEvent.getPhaseId());
        }

        public PhaseId getPhaseId() {
            return PhaseId.ANY_PHASE;
        }

        private void refreshTraceSettings() {
            BPCClientTrace.refreshCachedSettings();
        }

        private void setPhaseId(PhaseId phaseId) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            if (facesContext == null) {
                return;
            }
            ExternalContext externalContext = facesContext.getExternalContext();
            externalContext.getSessionMap().put(FacesIntrospector.CURRENT_PHASE, phaseId.toString());
        }
    }
}

