/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.jsf.util;

import com.ibm.bpc.clientcore.ColumnInfo;
import com.ibm.bpc.clientcore.converter.SimpleConverter;
import com.ibm.bpc.clientcore.converter.TimezoneConverter;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.jsf.converter.StateConverter;
import com.ibm.bpe.jsf.util.LocaleUtils;
import com.ibm.bpe.jsf.util.SelectionWrapper;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.faces.context.FacesContext;
import javax.faces.el.PropertyResolver;

public class DynamicListComparator
implements Comparator {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2006, 2008.\n\n";
    static final String OBSERVER_RESOURCE = new String("com.ibm.bpe.observer.resources.ObserverUI");
    private PropertyResolver resolver = null;
    private String[] getter = null;
    private SimpleConverter simpleConverter = null;
    private TimezoneConverter timeZoneConverter = null;
    private StateConverter stateConverter = null;
    private Locale locale = null;
    private TimeZone timeZone = null;
    private int order = 0;

    public DynamicListComparator(ColumnInfo columnInfo, Integer n) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        this.order = n;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        this.getter = this.parsePropertyExpression(columnInfo.getPropertyName());
        this.resolver = facesContext.getApplication().getPropertyResolver();
        Object object = columnInfo.getPropertyConverter();
        if (object instanceof TimezoneConverter) {
            this.timeZoneConverter = (TimezoneConverter)object;
        } else if (object instanceof SimpleConverter) {
            this.simpleConverter = (SimpleConverter)object;
        } else if (object instanceof StateConverter) {
            this.stateConverter = (StateConverter)object;
        }
        this.locale = LocaleUtils.getFacesLocale(facesContext);
        this.timeZone = LocaleUtils.getClientTimeZone(facesContext);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    private String[] parsePropertyExpression(String string) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Parsing property expression \"" + string + "\""));
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".'[]");
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2 == null || string2.length() <= 0) continue;
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Property: " + string2));
            }
            ++n;
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[n]);
    }

    public int compare(Object object, Object object2) {
        Object object3 = this.resolve(object instanceof SelectionWrapper ? ((SelectionWrapper)object).getObject() : object, this.resolver, this.getter);
        Object object4 = this.resolve(object2 instanceof SelectionWrapper ? ((SelectionWrapper)object2).getObject() : object2, this.resolver, this.getter);
        if (this.stateConverter == null && this.simpleConverter == null && object3 instanceof Number && object4 instanceof Number) {
            boolean bl;
            boolean bl2 = ((Number)object3).doubleValue() < ((Number)object4).doubleValue();
            boolean bl3 = bl = ((Number)object3).doubleValue() > ((Number)object4).doubleValue();
            if (bl2) {
                return -1 * this.order;
            }
            if (bl) {
                return this.order;
            }
            return 0;
        }
        if (object3 instanceof Calendar && object4 instanceof Calendar) {
            int n = 0;
            if (((Calendar)object3).before((Calendar)object4)) {
                n = -1;
            } else if (((Calendar)object3).after((Calendar)object4)) {
                n = 1;
            }
            return n * this.order;
        }
        String string = null;
        String string2 = null;
        if (object3 != null) {
            string = this.timeZoneConverter != null ? this.timeZoneConverter.getAsString(object3, this.locale, this.timeZone) : (this.stateConverter != null ? this.stateConverter.getAsString(object3, this.locale, OBSERVER_RESOURCE) : (this.simpleConverter != null ? this.simpleConverter.getAsString(object3, this.locale) : object3.toString()));
        }
        if (object4 != null) {
            string2 = this.timeZoneConverter != null ? this.timeZoneConverter.getAsString(object4, this.locale, this.timeZone) : (this.stateConverter != null ? this.stateConverter.getAsString(object4, this.locale, OBSERVER_RESOURCE) : (this.simpleConverter != null ? this.simpleConverter.getAsString(object4, this.locale) : object4.toString()));
        }
        string = string != null ? string : "";
        string2 = string2 != null ? string2 : "";
        return Collator.getInstance((Locale)LocaleUtils.getLocale()).compare(string, string2) * this.order;
    }

    private Object resolve(Object object, PropertyResolver propertyResolver, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length && object != null) {
            object = propertyResolver.getValue(object, (Object)stringArray[n++]);
        }
        return object;
    }
}

