/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.jsf.message.sdo;

import com.ibm.bpc.clientcore.MessageWrapper;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.jsf.message.sdo.MessageNodeUtils;
import com.ibm.bpe.message.sdo.SDOImplHelper;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Sequence;
import commonj.sdo.Type;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import javax.xml.namespace.QName;

public class SDOViewer {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";

    private static void showDataObject(Writer writer, DataObject dataObject, Type type) {
        writer.increment();
        if (dataObject != null) {
            type = dataObject.getType();
        }
        boolean bl = writer.isTypeAlreadyHandled(type);
        if (dataObject != null && writer.pushAndCheckForCircularCycles(dataObject)) {
            writer.write("ATTENTION: CIRCULAR REFERENCE ENCOUNTERED");
        } else {
            SDOImplHelper sDOImplHelper = writer.getSdoHelper();
            writer.write("Type name=" + type.getName());
            writer.write("uri=" + type.getURI());
            writer.write("instanceClass=" + type.getInstanceClass());
            String string = dataObject != null ? "true" : "false";
            writer.write("populated: " + string);
            if (dataObject == null && bl) {
                writer.write("Type has already been handled ...");
            } else {
                List list = null;
                if (dataObject != null) {
                    if (dataObject.getType().isSequenced()) {
                        writer.write("isSequenced=true");
                        Sequence sequence = dataObject.getSequence();
                        for (int i = 0; i < sequence.size(); ++i) {
                            Property property = sequence.getProperty(i);
                            Object object = sequence.getValue(i);
                            SDOViewer.showSequence(sDOImplHelper, writer, property, i, object);
                        }
                    } else {
                        if (dataObject != null) {
                            list = dataObject.getInstanceProperties();
                            if (MessageNodeUtils.isWrapperType(dataObject)) {
                                writer.write("Is DataObject Wrapper");
                            }
                            writer.write("using instance properties");
                        }
                        for (Property property : list) {
                            SDOViewer.showProperty(sDOImplHelper, writer, dataObject, property);
                        }
                    }
                } else {
                    list = type.getProperties();
                    for (Property property : list) {
                        SDOViewer.showProperty(sDOImplHelper, writer, dataObject, property);
                    }
                }
            }
            if (dataObject != null) {
                writer.pop();
            }
        }
        writer.decrement();
    }

    private static void showSequence(SDOImplHelper sDOImplHelper, Writer writer, Property property, int n, Object object) {
        writer.increment();
        writer.write(n + ".Item");
        if (property != null) {
            QName qName;
            String string = property.getType().getURI();
            String string2 = property.getType().getName();
            writer.write("Property name=" + property.getName());
            writer.write("propertyType=" + string2);
            writer.write("propertyUri=" + string);
            if ("commonj.sdo".equals(string) && (qName = sDOImplHelper.getSchemaType(property)) != null) {
                writer.write("qName=(" + qName.getNamespaceURI() + "," + qName.getLocalPart() + ")");
            }
            if (property.isContainment()) {
                writer.write("containment=true");
            } else {
                writer.write("containment=false");
            }
            if (object != null) {
                if (object instanceof DataObject) {
                    SDOViewer.showDataObject(writer, (DataObject)object, null);
                } else {
                    writer.write("dataType=true");
                }
            }
        } else {
            writer.write("dataType=text?");
            writer.write("value=" + object);
        }
        writer.write("isSet=" + (object != null));
        writer.decrement();
    }

    private static void showProperty(SDOImplHelper sDOImplHelper, Writer writer, DataObject dataObject, Property property) {
        Object object;
        writer.increment();
        writer.write("Property name=" + property.getName());
        boolean bl = dataObject != null ? dataObject.isSet(property) : false;
        String string = property.getType().getURI();
        String string2 = property.getType().getName();
        writer.write("propertyType=" + string2);
        writer.write("propertyUri=" + string);
        if ("commonj.sdo".equals(string) && (object = sDOImplHelper.getSchemaType(property)) != null) {
            writer.write("qName=(" + ((QName)object).getNamespaceURI() + "," + ((QName)object).getLocalPart() + ")");
        }
        if (MessageNodeUtils.isAttribute(property)) {
            writer.write("attribute=true");
        }
        if (property.isContainment()) {
            writer.write("containment=true");
        } else {
            writer.write("containment=false");
        }
        writer.write("isSet=" + bl);
        if (property.isMany()) {
            writer.write("many=true");
        } else {
            writer.write("many=false");
        }
        writer.write("minOccurs=" + sDOImplHelper.getLowerBound(MessageNodeUtils.boHelper, property));
        writer.write("maxOccurs=" + sDOImplHelper.getUpperBound(MessageNodeUtils.boHelper, property));
        if (bl) {
            object = dataObject.get(property);
            if (object instanceof List) {
                writer.write("list=true");
                List list = (List)object;
                Iterator iterator = list.iterator();
                int n = 1;
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    SDOViewer.showListItem(writer, e, n);
                    ++n;
                }
            } else if (object instanceof DataObject) {
                SDOViewer.showDataObject(writer, (DataObject)object, null);
            } else if (object instanceof Sequence) {
                writer.write("sequence=true");
                Sequence sequence = (Sequence)object;
                int n = sequence.size();
                for (int i = 0; i < n; ++i) {
                    SDOViewer.showSequenceItem(sDOImplHelper, writer, sequence, i + 1);
                }
            } else {
                writer.write("dataType=true");
            }
        } else {
            SDOViewer.showDataObject(writer, null, property.getType());
        }
        writer.write("\n");
        writer.decrement();
    }

    private static void showListItem(Writer writer, Object object, int n) {
        if (object instanceof DataObject) {
            writer.write(n + ".List Item");
            SDOViewer.showDataObject(writer, (DataObject)object, null);
        } else {
            writer.write(n + ".List Item (" + object.getClass().getName() + ")");
        }
    }

    private static void showSequenceItem(SDOImplHelper sDOImplHelper, Writer writer, Sequence sequence, int n) {
        writer.write(n + ".Sequence Item");
        Property property = sequence.getProperty(n - 1);
        Object object = sequence.getValue(n - 1);
        if (property != null) {
            writer.write("property name=" + property.getName());
            writer.write("propertyType=" + property.getType().getName());
            writer.write("propertyUri=" + property.getType().getURI());
            writer.write("minOccurs=" + sDOImplHelper.getLowerBound(MessageNodeUtils.boHelper, property));
            writer.write("maxOccurs=" + sDOImplHelper.getUpperBound(MessageNodeUtils.boHelper, property));
        } else {
            writer.write("property is null");
        }
        if (object instanceof DataObject) {
            SDOViewer.showDataObject(writer, (DataObject)object, null);
        } else {
            writer.write("dataType=true");
        }
    }

    private static String displayMessage(DataObject dataObject) {
        Writer writer = new Writer();
        SDOImplHelper sDOImplHelper = MessageNodeUtils.getSDOImplHelper(dataObject);
        writer.write("BOVersion=" + sDOImplHelper.getBOVersion());
        writer.setSdoHelper(sDOImplHelper);
        SDOViewer.showDataObject(writer, dataObject, null);
        return writer.dump();
    }

    public static void displayMessage(Object object) {
        block7: {
            try {
                if (BPCClientTrace.isTracing) {
                    if (object instanceof DataObject) {
                        BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("\n" + SDOViewer.displayMessage((DataObject)object)));
                    } else if (object instanceof MessageWrapper) {
                        BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("MessageWrapper(" + ((MessageWrapper)object).getMessage() + ")"));
                    } else {
                        BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Cached Model: " + object));
                    }
                }
            }
            catch (Throwable throwable) {
                if (!BPCClientTrace.isTracing) break block7;
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_EVENT, (String)"Could not trace message");
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_EVENT, (Throwable)throwable);
            }
        }
    }

    public static class Writer {
        public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005.\n\n";
        private SDOImplHelper sdoHelper = null;
        private StringBuffer _buffer = new StringBuffer("\n");
        private Stack _dataObjectStack = new Stack();
        private Set _typeSet = new HashSet();
        private int _indent = 0;
        private int _increment = 10;

        public void increment() {
            this._indent += this._increment;
        }

        public void decrement() {
            this._indent -= this._increment;
        }

        public void write(String string) {
            for (int i = 0; i < this._indent; ++i) {
                this._buffer.append(" ");
            }
            this._buffer.append(string);
            this._buffer.append("\n");
        }

        public String dump() {
            return this._buffer.toString();
        }

        public boolean pushAndCheckForCircularCycles(DataObject dataObject) {
            for (Object e : this._dataObjectStack) {
                if (dataObject != e) continue;
                return true;
            }
            this._dataObjectStack.push(dataObject);
            return false;
        }

        public boolean isTypeAlreadyHandled(Type type) {
            String string = type.getURI() + ":" + type.getName();
            if (this._typeSet.contains(string)) {
                return true;
            }
            this._typeSet.add(string);
            return false;
        }

        public void pop() {
            this._dataObjectStack.pop();
        }

        public SDOImplHelper getSdoHelper() {
            return this.sdoHelper;
        }

        public void setSdoHelper(SDOImplHelper sDOImplHelper) {
            this.sdoHelper = sDOImplHelper;
        }
    }
}

