/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.jsf.message.sdo;

import com.ibm.bpc.clientcore.converter.DateTimeUtils;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.jsf.util.LocaleUtils;
import com.ibm.bpe.message.sdo.SDOImplHelper;
import com.ibm.bpe.util.Assert;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.websphere.bo.BOFactory;
import com.ibm.websphere.bo.BOType;
import com.ibm.websphere.sca.ServiceManager;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Sequence;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDOUtils {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";
    private static final QName DATETIME = new QName("http://www.w3.org/2001/XMLSchema", "dateTime");
    private static final QName TIME = new QName("http://www.w3.org/2001/XMLSchema", "time");
    private static final QName DATE = new QName("http://www.w3.org/2001/XMLSchema", "date");

    private static Object createInitialValue(SDOImplHelper sDOImplHelper, DataObject dataObject, Property property) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("creating intial property for property \"" + property.getName() + "\""));
        }
        Object object = null;
        if (property.getType().isDataType()) {
            object = SDOUtils.createPrimitive(sDOImplHelper, property);
        } else if ("Object".equals(property.getType().getName())) {
            object = SDOUtils.createDataTypeWrapper(null);
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("creating a dataObject of type (" + property.getType().getURI() + "," + property.getType().getName() + ")"));
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"DataTypeWrapper added the DataObject to the property");
            }
        } else {
            object = dataObject.createDataObject(property);
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("creating a dataObject of type (" + property.getType().getURI() + "," + property.getType().getName() + ")"));
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"DataObject.createDataObject added the DataObject to the property");
            }
        }
        return object;
    }

    public static Object createPrimitive(SDOImplHelper sDOImplHelper, Property property) {
        return SDOUtils.createInitialDataValue(sDOImplHelper, property);
    }

    public static boolean isExtensible(Property property) {
        boolean bl = !property.isContainment() && !property.getType().isDataType();
        return !bl;
    }

    public static void insert(SDOImplHelper sDOImplHelper, DataObject dataObject, Property property, int n) {
        if (property.isMany()) {
            List list = dataObject.getList(property);
            int n2 = list.size();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Iterator iterator = list.iterator();
            for (int i = 0; i < n2; ++i) {
                Object e = list.get(i);
                if (n == i) {
                    arrayList.add(SDOUtils.createInitialValue(sDOImplHelper, dataObject, property));
                }
                arrayList.add(e);
            }
            SDOUtils.replaceListEntries(list, arrayList);
        } else {
            Object object = SDOUtils.createInitialValue(sDOImplHelper, dataObject, property);
            if (object instanceof DataObject) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"createDataObject already added the item");
                }
            } else {
                dataObject.set(property, object);
            }
        }
    }

    public static Object appendEmptyElement(SDOImplHelper sDOImplHelper, DataObject dataObject, Property property, int n) {
        if (property.isMany()) {
            List list = dataObject.getList(property);
            if (SDOUtils.isExtensible(property)) {
                for (int i = 0; i < n; ++i) {
                    Object object = SDOUtils.createInitialValue(sDOImplHelper, dataObject, property);
                    if (object instanceof DataObject) {
                        if (!BPCClientTrace.isTracing) continue;
                        BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"createDataObject already added the item");
                        continue;
                    }
                    list.add(object);
                }
            } else if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Property " + property.getName() + " is not extensible -- cannot add any elements"));
            }
            return list;
        }
        Object object = SDOUtils.createInitialValue(sDOImplHelper, dataObject, property);
        if (object instanceof DataObject) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"createDataObject already added the item");
            }
        } else {
            dataObject.set(property, object);
        }
        return object;
    }

    public static void remove(DataObject dataObject, Property property, int n) {
        if (property.isMany()) {
            List list = (List)dataObject.get(property);
            list.remove(n);
        } else {
            dataObject.unset(property);
        }
    }

    private static void replaceListEntries(List<Object> list, List<Object> list2) {
        list.clear();
        for (Object object : list2) {
            list.add(object);
        }
    }

    public static void setArrayAtPosition(SDOImplHelper sDOImplHelper, DataObject dataObject, Property property, int n) {
        Object object = SDOUtils.createInitialValue(sDOImplHelper, dataObject, property);
        if (object instanceof DataObject) {
            SDOUtils.removeArrayItemAtPosition(dataObject, property, n);
            SDOUtils.moveArrayItem(dataObject, dataObject.getSequence().size() - 1, n);
        } else {
            SDOUtils.setArrayAtPosition(dataObject, property, n, object);
        }
    }

    public static void setArrayAtPosition(DataObject dataObject, Property property, int n, Object object) {
        Sequence sequence = dataObject.getSequence();
        if (n < sequence.size()) {
            sequence.setValue(n, object);
        } else {
            int n2 = n - sequence.size() + 1;
            for (int i = 0; i < n2 - 1; ++i) {
                sequence.add(property, null);
            }
            sequence.add(property, object);
        }
    }

    public static void unsetArrayAtPosition(DataObject dataObject, Property property, int n) {
        Sequence sequence = dataObject.getSequence();
        sequence.remove(n);
        sequence.add(property, null);
        SDOUtils.moveArrayItem(dataObject, sequence.size() - 1, n);
    }

    public static void removeArrayItemAtPosition(DataObject dataObject, Property property, int n) {
        Sequence sequence = dataObject.getSequence();
        sequence.remove(n);
    }

    public static void insertEmptyArrayItemAtPosition(DataObject dataObject, Property property, int n) {
        Sequence sequence = dataObject.getSequence();
        int n2 = sequence.size();
        if (n < n2) {
            sequence.add(n, property, null);
        }
    }

    public static DataObject createDataTypeWrapper(Object object) {
        ServiceManager serviceManager = new ServiceManager();
        BOFactory bOFactory = (BOFactory)serviceManager.locateService("com/ibm/websphere/bo/BOFactory");
        BOType bOType = (BOType)new ServiceManager().locateService("com/ibm/websphere/bo/BOType");
        String string = null;
        if (object != null) {
            string = object.toString();
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("createDataTypeWrapper with value: " + string));
        }
        DataObject dataObject = bOFactory.createDataTypeWrapper(bOType.getType("http://www.w3.org/2001/XMLSchema", "string"), (Object)string);
        return dataObject;
    }

    private static void moveArrayItem(DataObject dataObject, int n, int n2) {
        Sequence sequence = dataObject.getSequence();
        sequence.move(n, n2);
    }

    static void appendEmptyArrayItem(DataObject dataObject, Property property) {
        Sequence sequence = dataObject.getSequence();
        sequence.add(property, null);
    }

    private static Object createInitialDataValue(SDOImplHelper sDOImplHelper, Property property) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        Assert.assertion((property != null ? 1 : 0) != 0, (String)"The property must not be null");
        String string = property.getType().getInstanceClass().getName();
        QName qName = sDOImplHelper.getBaseStandardType(property);
        String string2 = property.getType().getURI();
        String string3 = property.getType().getName();
        if (qName != null) {
            string3 = qName.getLocalPart();
            string2 = qName.getNamespaceURI();
        } else if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"getBaseStandardType() == null");
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("creating a " + string + " for type (" + string2 + "," + string3 + ")"));
        }
        Object object = null;
        if (qName != null && "base64Binary".equals(qName.getLocalPart())) {
            object = new byte[]{};
        } else if (qName != null && "hexBinary".equals(qName.getLocalPart())) {
            object = new byte[]{};
        } else if (qName != null && "time".equals(qName.getLocalPart())) {
            object = LocaleUtils.createServerTimeObject(new Date());
        } else if (qName != null && "duration".equals(qName.getLocalPart())) {
            object = "P0D";
        } else if (qName != null && "gDay".equals(qName.getLocalPart())) {
            object = DateTimeUtils.createGDaySample((Date)new Date());
        } else if (qName != null && "gMonth".equals(qName.getLocalPart())) {
            object = DateTimeUtils.createGMonthSample((Date)new Date());
        } else if (qName != null && "gMonthDay".equals(qName.getLocalPart())) {
            object = DateTimeUtils.createGMonthDaySample((Date)new Date());
        } else if ("java.math.BigDecimal".equals(string)) {
            object = new BigDecimal(0);
        } else if ("java.math.BigInteger".equals(string)) {
            object = new BigInteger("0");
        } else if ("java.math.BigDecimal".equals(string)) {
            object = new BigDecimal("0");
        } else if ("java.lang.Boolean".equals(string) || "boolean".equals(string)) {
            object = Boolean.TRUE;
        } else if ("java.lang.Byte".equals(string) || "byte".equals(string)) {
            object = new Byte("0");
        } else if ("java.lang.Character".equals(string)) {
            char c = 'A';
            object = new Character(c);
        } else if ("java.util.Date".equals(string)) {
            object = new Date();
        } else if ("java.lang.Double".equals(string) || "double".equals(string)) {
            object = new Double(0.0);
        } else if ("java.lang.Float".equals(string) || "float".equals(string)) {
            object = new Float(0.0f);
        } else if ("java.lang.Integer".equals(string) || "int".equals(string)) {
            object = new Integer(0);
        } else if ("java.lang.Long".equals(string) || "long".equals(string)) {
            object = new Long(0L);
        } else if ("java.lang.Short".equals(string) || "short".equals(string)) {
            short s = 0;
            object = new Short(s);
        } else if ("java.lang.String".equals(string)) {
            object = "";
        } else if ("java.lang.Object".equals(string)) {
            object = "";
        } else if ("java.util.List".equals(string)) {
            object = new ArrayList();
        } else {
            Assert.assertion((boolean)false, (String)(string + " must belong the set of supported primitive types"));
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)object);
        }
        return object;
    }
}

