/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.jsf.message.sdo;

import com.ibm.bpc.clientcore.converter.ConverterUtils;
import com.ibm.bpc.clientcore.converter.NumberOutOfBoundsException;
import com.ibm.bpc.clientcore.converter.XConverter;
import com.ibm.bpe.api.ProcessException;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.jsf.exception.InvalidInputException;
import com.ibm.bpe.jsf.message.sdo.MessageItem;
import com.ibm.bpe.jsf.message.sdo.MessageItemContext;
import com.ibm.bpe.jsf.message.sdo.MessageNodeUtils;
import com.ibm.bpe.jsf.message.sdo.MessageProperty;
import com.ibm.bpe.jsf.util.FacesUtils;
import com.ibm.bpe.jsf.util.InvalidPropertyMessage;
import com.ibm.bpe.jsf.util.LocaleUtils;
import com.ibm.bpe.message.sdo.SDOImplHelper;
import com.ibm.bpe.util.Assert;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.bpe.util.XSDJavaConverter;
import commonj.sdo.Property;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.el.ValueBinding;
import javax.xml.namespace.QName;

public class SDO110Converter
implements Converter,
Serializable {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";
    private static final long serialVersionUID = 1L;
    private ValueBinding contextBinding = null;
    private String to = null;
    private static final QName DATETIME = new QName("http://www.w3.org/2001/XMLSchema", "dateTime");
    private static final QName TIME = new QName("http://www.w3.org/2001/XMLSchema", "time");
    private static final QName DATE = new QName("http://www.w3.org/2001/XMLSchema", "date");

    private MessageItemContext getNodeContext(FacesContext facesContext) {
        Assert.assertion((this.contextBinding != null ? 1 : 0) != 0, (String)"A Binding to a NodeContext must be specified");
        return (MessageItemContext)this.contextBinding.getValue(facesContext);
    }

    public Object getAsObject(FacesContext facesContext, UIComponent uIComponent, String string) {
        Object object;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)string);
        }
        Locale locale = LocaleUtils.getFacesLocale(facesContext);
        MessageItemContext messageItemContext = this.getNodeContext(facesContext);
        MessageItem messageItem = messageItemContext.getMessageItem();
        MessageProperty messageProperty = (MessageProperty)messageItem.getParent();
        SDOImplHelper sDOImplHelper = messageItem.getSDOImplHelper();
        Object object2 = null;
        ProcessException processException = null;
        try {
            if (messageItem.isTextElement()) {
                object2 = string;
            } else if (messageProperty != null && !messageProperty.isAny() && !messageItem.isWrapperDataObject()) {
                String string2;
                object2 = (messageItem.isArtifical() || messageItem.isNil()) && "".equals(string) ? null : SDO110Converter.getAsObject(sDOImplHelper, locale, messageProperty.getProperty(), string);
                if (object2 instanceof String && "".equals(object2) && sDOImplHelper.getBOVersion().startsWith("SDOX") && (object = sDOImplHelper.getSchemaType(messageProperty.getProperty())) != null && "http://www.w3.org/2001/XMLSchema".equals(((QName)object).getNamespaceURI()) && ("gDay".equals(string2 = ((QName)object).getLocalPart()) || "gMonth".equals(string2) || "gMonthDay".equals(string2) || "duration".equals(string2))) {
                    throw new InvalidInputException(new Object[]{string, string2});
                }
            } else {
                object = messageItem.getPrimitive();
                object2 = SDO110Converter.getAsObject(locale, object.getClass(), string);
            }
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Returning " + object2));
                BPCClientTrace.exit();
            }
        }
        catch (ProcessException processException2) {
            processException = processException2;
        }
        if (processException != null) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Input for " + messageItem.getIdentifier() + " not valid"));
            }
            if (processException instanceof NumberOutOfBoundsException) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Input " + string + " was not accepted"));
                }
                object = ((NumberOutOfBoundsException)processException).getSuggestedValue();
                if (uIComponent instanceof EditableValueHolder) {
                    ((EditableValueHolder)uIComponent).setSubmittedValue(object);
                }
            }
            object = new InvalidPropertyMessage(uIComponent.getClientId(facesContext), processException);
            this.queueMessage(facesContext, messageItemContext.getValidationId(), (FacesMessage)object);
            throw new ConverterException((FacesMessage)object);
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
        return object2;
    }

    public String getAsString(FacesContext facesContext, UIComponent uIComponent, Object object) {
        Object object2;
        Object object3;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        Locale locale = LocaleUtils.getFacesLocale(facesContext);
        if (uIComponent instanceof EditableValueHolder && !(object3 = (EditableValueHolder)uIComponent).isValid()) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.exit((Object)("Invalid input. Existing value --> " + object));
            }
            object2 = object3.getSubmittedValue();
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.exit((Object)("Submitted value --> " + object2));
            }
            if (object3.getSubmittedValue() != null) {
                return object2.toString();
            }
        }
        object3 = this.getNodeContext(facesContext);
        object2 = ((MessageItemContext)object3).getMessageItem();
        MessageProperty messageProperty = (MessageProperty)((MessageItem)object2).getParent();
        SDOImplHelper sDOImplHelper = ((MessageItem)object2).getSDOImplHelper();
        String string = null;
        if (((MessageItem)object2).isTextElement() && object instanceof String) {
            string = (String)object;
        } else if (messageProperty != null && !messageProperty.isAny() && !((MessageItem)object2).isWrapperDataObject()) {
            if ((((MessageItem)object2).isArtifical() || ((MessageItem)object2).isNil()) && object == null) {
                return "";
            }
            string = SDO110Converter.getAsString(sDOImplHelper, locale, messageProperty.getProperty(), object);
        } else {
            Object object4 = ((MessageItem)object2).getPrimitive();
            string = SDO110Converter.getAsString(locale, object4.getClass(), object);
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Returning " + string));
            BPCClientTrace.exit();
        }
        return string;
    }

    static Object getAsObject(SDOImplHelper sDOImplHelper, Locale locale, Property property, String string) throws ProcessException {
        Object object = null;
        QName qName = sDOImplHelper.getBaseStandardType(property);
        if (qName != null) {
            XConverter xConverter = ConverterUtils.getInstance();
            object = xConverter.isSupported(qName) ? xConverter.createFrom(locale, qName, string) : XSDJavaConverter.convertXSD2JavaType((QName)qName, (XSDJavaConverter.MapRule)XSDJavaConverter.SDO11_8B, (String)string, (Locale)locale, null);
        } else {
            try {
                object = sDOImplHelper.createFromString(MessageNodeUtils.boType, property.getType(), string);
            }
            catch (Throwable throwable) {
                if (throwable instanceof ProcessException) {
                    throw (ProcessException)throwable;
                }
                throw new InvalidInputException(new Object[]{string, property.getType().getName()}, throwable);
            }
        }
        return object;
    }

    static String getAsString(SDOImplHelper sDOImplHelper, Locale locale, Property property, Object object) {
        XConverter xConverter;
        String string = null;
        QName qName = sDOImplHelper.getBaseStandardType(property);
        string = qName != null ? ((xConverter = ConverterUtils.getInstance()).isSupported(qName) ? xConverter.convertTo(locale, qName, object) : XSDJavaConverter.convertJavaType2Literal((QName)qName, (XSDJavaConverter.MapRule)XSDJavaConverter.SDO11_8B, (Object)object, (Locale)locale, null)) : sDOImplHelper.convertToString(MessageNodeUtils.boType, property.getType(), object);
        return string;
    }

    static Object getAsObject(Locale locale, Class clazz, String string) throws ProcessException {
        Object object = null;
        Assert.assertion((clazz != null ? 1 : 0) != 0, (String)"The Object Class must be specified for a Boxed Primitive Value");
        XConverter xConverter = ConverterUtils.getInstance();
        QName qName = ConverterUtils.getXSDTypeForClazz((Class)clazz);
        if (qName != null) {
            object = xConverter.isSupported(qName) ? xConverter.createFrom(locale, qName, string) : XSDJavaConverter.convertXSD2JavaType((QName)qName, (XSDJavaConverter.MapRule)XSDJavaConverter.SDO11_8B, (String)string, (Locale)locale, null);
        } else {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_EVENT, (String)("The corresponding xsd-type for " + clazz.getName() + " could not be determined"));
            }
            Exception exception = null;
            try {
                Constructor constructor = clazz.getConstructor(String.class);
                object = constructor.newInstance(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                exception = illegalArgumentException;
            }
            catch (InstantiationException instantiationException) {
                exception = instantiationException;
            }
            catch (IllegalAccessException illegalAccessException) {
                exception = illegalAccessException;
            }
            catch (InvocationTargetException invocationTargetException) {
                exception = invocationTargetException;
            }
            catch (SecurityException securityException) {
                exception = securityException;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                exception = noSuchMethodException;
            }
            if (exception != null) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_EVENT, (Throwable)exception);
                }
                object = string;
            }
        }
        return object;
    }

    static String getAsString(Locale locale, Class clazz, Object object) {
        String string = null;
        Assert.assertion((clazz != null ? 1 : 0) != 0, (String)"The Object Class must be specified for a Boxed Primitive Value");
        XConverter xConverter = ConverterUtils.getInstance();
        QName qName = ConverterUtils.getXSDTypeForClazz((Class)clazz);
        if (qName != null) {
            string = xConverter.isSupported(qName) ? xConverter.convertTo(locale, qName, object) : XSDJavaConverter.convertJavaType2Literal((QName)qName, (XSDJavaConverter.MapRule)XSDJavaConverter.SDO11_8B, (Object)object, (Locale)locale, null);
        } else {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_EVENT, (String)("The corresponding xsd-type for " + clazz.getName() + " could not be determined"));
            }
            string = object.toString();
        }
        return string;
    }

    private void queueMessage(FacesContext facesContext, String string, FacesMessage facesMessage) {
        if (this.to != null) {
            string = string + ':' + this.to;
        }
        FacesUtils.queueValidationMessage(string, facesMessage);
    }

    public void queueMessage(FacesContext facesContext, UIInput uIInput) {
        Object object;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        String string = this.getAsString(facesContext, (UIComponent)uIInput, uIInput.getValue());
        MessageItemContext messageItemContext = this.getNodeContext(facesContext);
        MessageItem messageItem = messageItemContext.getMessageItem();
        MessageProperty messageProperty = (MessageProperty)messageItem.getParent();
        String string2 = null;
        string2 = messageProperty != null ? messageProperty.getXMLTypeName() : (uIInput.getValue() != null ? ((object = ConverterUtils.getXSDTypeForClazz(uIInput.getValue().getClass())) != null ? object.getLocalPart() : "unkown") : "unkown");
        object = new InvalidInputException(new Object[]{string, string2});
        InvalidPropertyMessage invalidPropertyMessage = new InvalidPropertyMessage(uIInput.getClientId(facesContext), (ProcessException)((Object)object));
        this.queueMessage(facesContext, messageItemContext.getValidationId(), invalidPropertyMessage);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    public ValueBinding getContextBinding() {
        return this.contextBinding;
    }

    public void setContextBinding(ValueBinding valueBinding) {
        this.contextBinding = valueBinding;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String string) {
        this.to = string;
    }
}

