/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.jsf.message.sdo;

import com.ibm.bpc.clientcore.MessageWrapper;
import com.ibm.bpe.api.ProcessException;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.jsf.exception.PropertyNotFoundException;
import com.ibm.bpe.jsf.exception.PropertyPopulationException;
import com.ibm.bpe.jsf.message.sdo.MessageItem;
import com.ibm.bpe.jsf.message.sdo.MessageNode;
import com.ibm.bpe.jsf.message.sdo.MessageNodeUtils;
import com.ibm.bpe.jsf.message.sdo.SDO110Converter;
import com.ibm.bpe.jsf.message.sdo.SDOUtils;
import com.ibm.bpe.message.sdo.SDOImplHelper;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PopulationHelper {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";

    public static void populateBoxedPrimitive(MessageWrapper messageWrapper, Class clazz, Map<String, Object> map, List list, List list2, Locale locale, String string) {
        Set<Map.Entry<String, Object>> set = map.entrySet();
        for (Map.Entry entry : set) {
            String string2 = (String)entry.getKey();
            String string3 = (String)entry.getValue();
            if (string2 == null || !string2.startsWith(string)) continue;
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Setting \"" + string3 + "\""));
            }
            Object object = string3;
            ProcessException processException = null;
            try {
                object = SDO110Converter.getAsObject(locale, clazz, string3);
            }
            catch (ProcessException processException2) {
                processException = processException2;
            }
            if (processException != null) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Adding ValidationExeption: " + processException.getMessage()));
                }
                list.add(processException);
                list2.add(object);
            }
            messageWrapper.setMessage(object);
            break;
        }
    }

    public static void populateMessageWithLiterals(DataObject dataObject, Map<String, Object> map, Map<String, Exception> map2, Map<String, String> map3, Locale locale, String string) throws PropertyNotFoundException, PropertyPopulationException, IllegalArgumentException {
        Node node = new Node();
        Set<Map.Entry<String, Object>> set = map.entrySet();
        for (Map.Entry entry : set) {
            String string2 = (String)entry.getKey();
            String string3 = (String)entry.getValue();
            if (string2 == null || !string2.startsWith(string)) continue;
            String string4 = string2.substring(string.length());
            PopulationHelper.addValue2Tree(node, string4, string3, null);
        }
        PopulationHelper.processNodeTree(node, dataObject, locale, map2, map3, true);
    }

    public static void populateMessage(DataObject dataObject, Map<String, Object> map, Set<String> set) throws PropertyNotFoundException, PropertyPopulationException {
        Node node = new Node();
        for (String object2 : set) {
            PopulationHelper.addRemoval2Tree(node, object2);
        }
        Set<Map.Entry<String, Object>> set2 = map.entrySet();
        for (Map.Entry entry : set2) {
            String string = (String)entry.getKey();
            Object v = entry.getValue();
            if (v == null) continue;
            PopulationHelper.addValue2Tree(node, string, null, v);
        }
        PopulationHelper.processNodeTree(node, dataObject, null, null, null, false);
    }

    private static void addRemoval2Tree(Node node, String string) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Processing removal for \"" + string + "\""));
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        Node node2 = node;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if ("".equals(string2)) continue;
            Node node3 = node2.getChild(string2);
            if (node3 != null) {
                node2 = node3;
                continue;
            }
            node2 = node2.addChild(string2);
        }
        node2.setRemoved(true);
    }

    private static void addValue2Tree(Node node, String string, String string2, Object object) throws IllegalArgumentException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Processing addition for \"" + string + "\""));
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        Node node2 = node;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if ("".equals(string3)) continue;
            Node node3 = node2.getChild(string3);
            if (node3 != null) {
                node2 = node3;
                continue;
            }
            node2 = node2.addChild(string3);
        }
        node2.setLiteral(string2);
        node2.setValue(object);
    }

    private static void processNodeTree(Node node, DataObject dataObject, Locale locale, Map<String, Exception> map, Map<String, String> map2, boolean bl) throws PropertyNotFoundException, PropertyPopulationException {
        Collection<Node> collection;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)node.getXPath());
        }
        if ((collection = node.getChildren()).isEmpty()) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.exit((Object)node.getXPath());
            }
            return;
        }
        for (Node node2 : collection) {
            DataObject dataObject2 = PopulationHelper.handle(dataObject, node2, locale, map, map2, bl);
            if (dataObject2 == null) continue;
            PopulationHelper.processNodeTree(node2, dataObject2, locale, map, map2, bl);
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)node.getXPath());
        }
    }

    private static DataObject handle(DataObject dataObject, Node node, Locale locale, Map<String, Exception> map, Map<String, String> map2, boolean bl) throws PropertyNotFoundException, PropertyPopulationException {
        Object object;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)node.getXPath());
        }
        SDOImplHelper sDOImplHelper = MessageNodeUtils.getSDOImplHelper(dataObject);
        Property property = MessageNodeUtils.getProperty(dataObject.getType(), node.getProperty());
        String string = node.getLiteral();
        Object object2 = node.getValue();
        if (property == null) {
            throw new PropertyNotFoundException(new Object[]{node.getXPath(), node.getXPath()});
        }
        if (bl && string != null) {
            object = null;
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)(node.getXPath() + " --> " + string));
            }
            try {
                object2 = SDO110Converter.getAsObject(sDOImplHelper, locale, property, string);
            }
            catch (ProcessException processException) {
                object = processException;
            }
            if (object != null) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Adding ValidationExeption: " + ((Throwable)object).getMessage()));
                }
                String string2 = node.getXPath();
                map.put(string2, (Exception)object);
                map2.put(string2, string);
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.exit();
                }
                return null;
            }
        }
        if (node.isRemoved()) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Removing element " + node.getXPath()));
            }
            if (node.isMany()) {
                object = dataObject.getList(property);
                int n = object.size();
                object.remove(n - 1);
            } else {
                dataObject.set(property, null);
            }
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.exit();
            }
            return null;
        }
        object = null;
        if (node.isMany()) {
            if (node.isMany() && !property.isMany()) {
                String string3 = node.getXPath();
                String string4 = Node.removeBrackets(node);
                throw new PropertyPopulationException(new Object[]{string3, string4});
            }
            int n = node.getNumber();
            List list = dataObject.getList(property);
            int n2 = list.size();
            if (n2 <= n) {
                if (SDOUtils.isExtensible(property)) {
                    list = (List)SDOUtils.appendEmptyElement(sDOImplHelper, dataObject, property, n + 1 - n2);
                } else {
                    if (BPCClientTrace.isTracing) {
                        BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Property " + property.getName() + " is not extensible -- cannot add new elements"));
                    }
                    if (BPCClientTrace.isTracing) {
                        BPCClientTrace.exit();
                    }
                    return null;
                }
            }
            if (object2 != null) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)(node.getXPath() + " is set to " + object2));
                }
                list.set(n, object2);
                object = null;
            } else if (!property.getType().isDataType()) {
                object = (DataObject)list.get(n);
            } else {
                list.set(n, null);
                object = null;
            }
        } else {
            if (!node.isMany() && property.isMany()) {
                String string5 = node.getXPath();
                String string6 = node.getXPath() + "[1]";
                throw new PropertyPopulationException(new Object[]{string5, string6});
            }
            if (object2 != null) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Property: Name= " + property.getName() + " Type = " + property.getType().getName()));
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Element: Class= " + object2.getClass().getName() + " Value = " + object2.toString()));
                }
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)(node.getXPath() + " is set to " + object2));
                }
                if ("Object".equals(property.getType().getName())) {
                    dataObject.set(property, (Object)SDOUtils.createDataTypeWrapper(object2));
                } else {
                    dataObject.set(property, object2);
                }
                object = null;
            } else if (!property.getType().isDataType()) {
                DataObject dataObject2 = (DataObject)dataObject.get(property);
                if (dataObject2 == null) {
                    dataObject2 = (DataObject)SDOUtils.appendEmptyElement(sDOImplHelper, dataObject, property, 1);
                }
                object = dataObject2;
            } else {
                dataObject.set(property, null);
                object = null;
            }
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)(object != null ? 1 : 0));
        }
        return object;
    }

    public static Map<String, Object> createMessageMap(DataObject dataObject, Locale locale) {
        MessageItem messageItem = MessageNodeUtils.createMessageItem(dataObject, false);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        PopulationHelper.createMessageMap(messageItem, hashMap, false, locale);
        return hashMap;
    }

    public static Map<String, Object> createMessageMapWithLiterals(Object object, Locale locale) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (object instanceof DataObject) {
            MessageItem messageItem = MessageNodeUtils.createMessageItem((DataObject)object, false);
            PopulationHelper.createMessageMap(messageItem, hashMap, true, locale);
        } else {
            String string = "";
            if (object != null) {
                string = SDO110Converter.getAsString(locale, object.getClass(), object);
            }
            hashMap.put("this", string);
        }
        return hashMap;
    }

    private static void createMessageMap(MessageNode messageNode, Map<String, Object> map, boolean bl, Locale locale) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)messageNode.getIdentifier());
        }
        if (messageNode instanceof MessageItem && messageNode.isLeaf()) {
            String string = messageNode.getXPath();
            MessageItem messageItem = (MessageItem)messageNode;
            Object object = messageItem.getDataObject();
            if (object == null) {
                object = messageItem.getPrimitive();
            }
            if (bl) {
                Property property = messageItem.getContainingProperty();
                String string2 = SDO110Converter.getAsString(messageNode.getSDOImplHelper(), locale, property, object);
                if (BPCClientTrace.isTracing && string2 != null) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Adding " + string + " -> " + string2));
                }
                map.put(string, string2);
            } else {
                if (BPCClientTrace.isTracing && object != null) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Adding " + string + " -> " + object));
                }
                map.put(string, object);
            }
        } else {
            for (MessageNode messageNode2 = messageNode.getFirstChild(); messageNode2 != null; messageNode2 = messageNode2.getNextSibling()) {
                PopulationHelper.createMessageMap(messageNode2, map, bl, locale);
            }
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)messageNode.getIdentifier());
        }
    }

    public static void populateDataObject(DataObject dataObject, Map<String, Object> map, Map<String, Exception> map2, Map<String, String> map3, Locale locale, String string) throws PropertyNotFoundException, PropertyPopulationException, IllegalArgumentException {
        PopulationHelper.populateMessageWithLiterals(dataObject, map, map2, map3, locale, string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Node {
        public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005.\n\n";
        static final int NOT_SET = -1;
        private String literal = null;
        private Object value = null;
        private String property = "";
        private String xPath = "";
        private boolean many;
        private int number = -1;
        private SortedMap<String, Node> childrenMap = new TreeMap<String, Node>();
        private boolean removed = false;

        public Node() {
            this("", "root");
        }

        private Node(String string, String string2) throws IllegalArgumentException {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.entry((Object)string);
            }
            this.xPath = string;
            int n = string2.indexOf("[");
            if (n != -1) {
                int n2 = string2.indexOf("]");
                this.many = true;
                this.property = string2.substring(0, n);
                if (this.property.startsWith("@")) {
                    this.property = this.property.substring(1);
                }
                this.number = Integer.parseInt(string2.substring(n + 1, n2));
                --this.number;
                if (this.number < 0) {
                    throw new IllegalArgumentException(string2 + " is not valid XPath statement. Array indexes must start with 1 not 0 in a XPath statement.");
                }
            } else {
                this.many = false;
                this.number = -1;
                this.property = string2;
            }
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.exit();
            }
        }

        public Node getChild(String string) {
            return (Node)this.childrenMap.get(string);
        }

        public Node addChild(String string) throws IllegalArgumentException {
            Node node = new Node(this.xPath + "/" + string, string);
            this.childrenMap.put(string, node);
            return node;
        }

        public Collection<Node> getChildren() {
            return this.childrenMap.values();
        }

        public boolean isMany() {
            return this.many;
        }

        public int getNumber() {
            return this.number;
        }

        public String getProperty() {
            return this.property;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object object) {
            this.value = object;
            if (object != null && BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("value = \"" + this.value + "\""));
            }
        }

        public String getLiteral() {
            return this.literal;
        }

        public void setLiteral(String string) {
            this.literal = string;
            if (string != null && BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Literal = \"" + this.literal + "\""));
            }
        }

        public String getXPath() {
            return this.xPath;
        }

        public static String removeBrackets(Node node) {
            String string = node.getXPath();
            int n = string.lastIndexOf("[");
            if (n != -1) {
                return string.substring(0, n);
            }
            return string;
        }

        public boolean isRemoved() {
            return this.removed;
        }

        public void setRemoved(boolean bl) {
            this.removed = bl;
        }
    }
}

