/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.jsf.message.sdo;

import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.jsf.message.sdo.MessageContext;
import com.ibm.bpe.jsf.message.sdo.MessageItem;
import com.ibm.bpe.jsf.message.sdo.MessageNode;
import com.ibm.bpe.jsf.message.sdo.MessageProperty;
import com.ibm.bpe.jsf.message.sdo.MessageRendererContext;
import com.ibm.bpe.jsf.util.FacesUtils;
import com.ibm.icu.text.NumberFormat;
import java.io.IOException;

public class MessageRendererHelper {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";
    private static final String ACTIONS = "MESSAGE_COMPONENT.RENDERING.ACTIONS";
    public static final String DEFAULT_FACET_NAME = "default";
    public static final String VALIDATION_FACET_NAME = "validation";
    public static final String ACTIONS_FACET_NAME = "actions";

    public static void processMessage(MessageRendererContext messageRendererContext, MessageItem messageItem) throws IOException {
        MessageProperty messageProperty;
        String string;
        String string2 = string = messageItem != null ? messageItem.getIdentifier() : "Empty Message";
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)string);
        }
        if ((messageProperty = (MessageProperty)messageItem.getFirstChild()) != null) {
            messageRendererContext.startTag("div");
            messageRendererContext.startTag("table");
            MessageRendererHelper.addTableStyle(messageRendererContext);
            messageRendererContext.addAttribute("border", "1");
            for (MessageProperty messageProperty2 = messageProperty; messageProperty2 != null; messageProperty2 = (MessageProperty)messageProperty2.getNextSibling()) {
                messageRendererContext.startTag("tr");
                messageRendererContext.startTag("td");
                if (messageProperty2.isWildCard()) {
                    messageRendererContext.addSourceViewRecommendation();
                } else {
                    messageRendererContext.addTypeTitle(messageProperty2.getXMLTypeName());
                }
                messageRendererContext.addLabel(messageProperty2, MessageRendererHelper.getPropertyLabel(messageProperty2));
                messageRendererContext.endTag("td");
                messageRendererContext.startTag("td");
                if (messageProperty2.isWildCard()) {
                    MessageRendererHelper.processProperty(messageRendererContext, messageProperty2);
                } else {
                    MessageRendererHelper.processProperty(messageRendererContext, messageProperty2);
                }
                messageRendererContext.endTag("td");
                if (!messageRendererContext.isReadOnlyMode()) {
                    messageRendererContext.startTag("td");
                    messageRendererContext.setMessageNode(messageProperty2);
                    messageRendererContext.renderValidationFacet();
                    messageRendererContext.endTag("td");
                }
                messageRendererContext.endTag("tr");
            }
            messageRendererContext.endTag("table");
            messageRendererContext.endTag("div");
        } else {
            messageRendererContext.startTag("div");
            messageRendererContext.startTag("table");
            messageRendererContext.addAttribute("border", "1");
            messageRendererContext.startTag("tr");
            messageRendererContext.startTag("td");
            messageRendererContext.setMessageNode(messageItem);
            messageRendererContext.renderItemFacet();
            if (messageRendererContext.isNotValid()) {
                messageRendererContext.renderAttentionMarker();
            }
            messageRendererContext.endTag("td");
            if (!messageRendererContext.isReadOnlyMode()) {
                messageRendererContext.startTag("td");
                messageRendererContext.renderValidationFacet();
                messageRendererContext.endTag("td");
            }
            messageRendererContext.endTag("tr");
            messageRendererContext.endTag("table");
            messageRendererContext.endTag("div");
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)string);
        }
    }

    public static void processProperty(MessageRendererContext messageRendererContext, MessageProperty messageProperty) throws IOException {
        MessageItem messageItem;
        boolean bl;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)messageProperty.getIdentifier());
        }
        boolean bl2 = bl = (messageItem = (MessageItem)messageProperty.getFirstChild()) != null;
        if (bl) {
            if (messageItem.isArray()) {
                MessageRendererHelper.processTrueArray(messageRendererContext, messageProperty);
            } else if (messageProperty.isArrayProperty() || messageProperty.isArray()) {
                MessageRendererHelper.processArray(messageRendererContext, messageProperty, false);
            } else if (messageProperty.isSequencePropery()) {
                MessageRendererHelper.processSequenceProperty(messageRendererContext, messageProperty);
            } else {
                MessageRendererHelper.processOrdinaryProperty(messageRendererContext, messageProperty);
            }
        } else {
            MessageRendererHelper.processEmptyProperty(messageRendererContext, messageProperty);
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)messageProperty.getIdentifier());
        }
    }

    public static void processEmptyProperty(MessageRendererContext messageRendererContext, MessageProperty messageProperty) throws IOException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)messageProperty.getIdentifier());
        }
        if (!messageRendererContext.isReadOnlyMode()) {
            MessageContext messageContext = messageRendererContext.setMessageNode(messageProperty);
            messageRendererContext.addElementIsUnSet();
            messageRendererContext.getWriter().write("-");
            if (messageContext.isAppendPossible() || messageContext.isInsertPossible() || messageContext.isRemovePossible()) {
                messageRendererContext.renderActionFacet();
            }
        } else {
            messageRendererContext.addElementIsUnSet();
            messageRendererContext.getWriter().write("-");
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)messageProperty.getIdentifier());
        }
    }

    public static void processTrueArray(MessageRendererContext messageRendererContext, MessageProperty messageProperty) throws IOException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)messageProperty.getIdentifier());
        }
        MessageItem messageItem = (MessageItem)messageProperty.getFirstChild();
        if (messageProperty.isArrayProperty()) {
            messageRendererContext.startTag("table");
            MessageRendererHelper.addTableStyle(messageRendererContext);
            for (MessageItem messageItem2 = messageItem; messageItem2 != null; messageItem2 = (MessageItem)messageItem2.getNextSibling()) {
                messageRendererContext.startTag("tr");
                messageRendererContext.startTag("td");
                MessageProperty messageProperty2 = (MessageProperty)messageItem2.getFirstChild();
                if (messageProperty2.getFirstChild() != null) {
                    MessageRendererHelper.processArray(messageRendererContext, messageProperty2, true);
                } else {
                    messageRendererContext.startTag("table");
                    MessageRendererHelper.addTableStyle(messageRendererContext);
                    messageRendererContext.startTag("tr");
                    messageRendererContext.startTag("td");
                    messageRendererContext.write(MessageRendererHelper.getPropertyLabel(messageProperty2));
                    messageRendererContext.endTag("td");
                    messageRendererContext.startTag("td");
                    MessageRendererHelper.processEmptyProperty(messageRendererContext, messageProperty2);
                    messageRendererContext.endTag("td");
                    messageRendererContext.endTag("tr");
                    messageRendererContext.endTag("table");
                }
                messageRendererContext.endTag("td");
                messageRendererContext.endTag("tr");
            }
            messageRendererContext.endTag("table");
        } else {
            MessageItem messageItem3 = messageItem;
            MessageProperty messageProperty3 = (MessageProperty)messageItem3.getFirstChild();
            if (messageProperty3.getFirstChild() != null) {
                MessageRendererHelper.processArray(messageRendererContext, messageProperty3, true);
            } else {
                messageRendererContext.startTag("table");
                MessageRendererHelper.addTableStyle(messageRendererContext);
                messageRendererContext.startTag("tr");
                messageRendererContext.startTag("td");
                messageRendererContext.write(MessageRendererHelper.getPropertyLabel(messageProperty3));
                messageRendererContext.endTag("td");
                messageRendererContext.startTag("td");
                MessageRendererHelper.processEmptyProperty(messageRendererContext, messageProperty3);
                messageRendererContext.endTag("td");
                messageRendererContext.endTag("tr");
                messageRendererContext.endTag("table");
            }
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)messageProperty.getIdentifier());
        }
    }

    public static void processArray(MessageRendererContext messageRendererContext, MessageProperty messageProperty, boolean bl) throws IOException {
        MessageItem messageItem;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)messageProperty.getIdentifier());
        }
        MessageItem messageItem2 = messageItem = (MessageItem)messageProperty.getFirstChild();
        while (messageItem2.isEmpty() && messageItem2.getNextSibling() != null) {
            messageItem2 = (MessageItem)messageItem2.getNextSibling();
        }
        int n = 0;
        int n2 = 0;
        MessageProperty messageProperty2 = (MessageProperty)messageItem2.getFirstChild();
        if (messageProperty2 != null) {
            Object object;
            messageRendererContext.startTag("table");
            MessageRendererHelper.addTableStyle(messageRendererContext);
            messageRendererContext.addAttribute("border", "1");
            messageRendererContext.startTag("tr");
            if (bl) {
                ++n;
                messageRendererContext.startTag("th");
                messageRendererContext.endTag("th");
            }
            for (MessageProperty messageProperty3 = messageProperty2; messageProperty3 != null; messageProperty3 = (MessageProperty)messageProperty3.getNextSibling()) {
                ++n;
                ++n2;
                messageRendererContext.startTag("th");
                if (messageProperty3.isWildCard()) {
                    messageRendererContext.addSourceViewRecommendation();
                } else {
                    messageRendererContext.addTypeTitle(messageProperty3.getXMLTypeName());
                }
                messageRendererContext.addLabel(messageProperty3, MessageRendererHelper.getPropertyLabel(messageProperty3));
                messageRendererContext.endTag("th");
            }
            if (!messageRendererContext.isReadOnlyMode()) {
                ++n;
                messageRendererContext.startTag("th");
                messageRendererContext.write(FacesUtils.lookupNonPIIMessage(ACTIONS));
                messageRendererContext.endTag("th");
            }
            messageRendererContext.endTag("tr");
            int n3 = 1;
            for (object = messageItem; object != null; object = (MessageItem)((MessageItem)object).getNextSibling()) {
                messageRendererContext.startTag("tr");
                if (bl) {
                    messageRendererContext.startTag("td");
                    messageRendererContext.write(MessageRendererHelper.getTrueArrayPropertyLabel(messageProperty, n3++));
                    messageRendererContext.endTag("td");
                }
                if (((MessageItem)object).isEmpty()) {
                    messageRendererContext.startTag("td");
                    messageRendererContext.addAttribute("colspan", Integer.toString(n2));
                    messageRendererContext.write("-");
                    messageRendererContext.endTag("td");
                } else {
                    for (MessageProperty messageProperty4 = (MessageProperty)((MessageItem)object).getFirstChild(); messageProperty4 != null; messageProperty4 = (MessageProperty)messageProperty4.getNextSibling()) {
                        messageRendererContext.startTag("td");
                        if (messageProperty4.isWildCard()) {
                            MessageRendererHelper.processProperty(messageRendererContext, messageProperty4);
                        } else {
                            MessageRendererHelper.processProperty(messageRendererContext, messageProperty4);
                        }
                        messageRendererContext.endTag("td");
                    }
                }
                if (!messageRendererContext.isReadOnlyMode()) {
                    messageRendererContext.startTag("td");
                    messageRendererContext.setMessageNode((MessageNode)object);
                    messageRendererContext.renderActionFacet();
                    messageRendererContext.endTag("td");
                }
                messageRendererContext.endTag("tr");
            }
            if (!messageRendererContext.isReadOnlyMode() && (((MessageContext)(object = messageRendererContext.setMessageNode(messageProperty))).isAppendPossible() || ((MessageContext)object).isInsertPossible() || ((MessageContext)object).isRemovePossible())) {
                messageRendererContext.startTag("tr");
                messageRendererContext.startTag("td");
                messageRendererContext.addAttribute("colspan", new Integer(n));
                messageRendererContext.renderActionFacet();
                messageRendererContext.endTag("td");
                messageRendererContext.endTag("tr");
            }
            messageRendererContext.endTag("table");
        } else {
            Object object;
            n = messageRendererContext.isReadOnlyMode() ? 1 : 2;
            if (bl) {
                ++n;
            }
            messageRendererContext.startTag("table");
            MessageRendererHelper.addTableStyle(messageRendererContext);
            messageRendererContext.addAttribute("border", "1");
            int n4 = 1;
            for (object = messageItem; object != null; object = (MessageItem)((MessageItem)object).getNextSibling()) {
                messageRendererContext.startTag("tr");
                messageRendererContext.setMessageNode((MessageNode)object);
                if (bl) {
                    messageRendererContext.startTag("td");
                    messageRendererContext.write(MessageRendererHelper.getTrueArrayPropertyLabel(messageProperty, n4++));
                    messageRendererContext.endTag("td");
                }
                messageRendererContext.startTag("td");
                if (((MessageItem)object).isEmpty()) {
                    messageRendererContext.write("-");
                } else {
                    messageRendererContext.renderItemFacet();
                    if (messageRendererContext.isNotValid()) {
                        messageRendererContext.renderAttentionMarker();
                    }
                }
                messageRendererContext.endTag("td");
                if (!messageRendererContext.isReadOnlyMode()) {
                    messageRendererContext.startTag("td");
                    messageRendererContext.renderActionFacet();
                    messageRendererContext.endTag("td");
                }
                messageRendererContext.endTag("tr");
            }
            if (!messageRendererContext.isReadOnlyMode() && (((MessageContext)(object = messageRendererContext.setMessageNode(messageProperty))).isAppendPossible() || ((MessageContext)object).isInsertPossible() || ((MessageContext)object).isRemovePossible())) {
                messageRendererContext.startTag("tr");
                messageRendererContext.startTag("td");
                messageRendererContext.addAttribute("colspan", new Integer(n));
                messageRendererContext.renderActionFacet();
                messageRendererContext.endTag("td");
                messageRendererContext.endTag("tr");
            }
            messageRendererContext.endTag("table");
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)messageProperty.getIdentifier());
        }
    }

    public static void processOrdinaryProperty(MessageRendererContext messageRendererContext, MessageProperty messageProperty) throws IOException {
        MessageItem messageItem;
        MessageProperty messageProperty2;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)messageProperty.getIdentifier());
        }
        if ((messageProperty2 = (MessageProperty)(messageItem = (MessageItem)messageProperty.getFirstChild()).getFirstChild()) == null) {
            if (messageProperty.isDataType() || messageItem.isWrapperDataObject()) {
                if (messageProperty.isWildCard()) {
                    messageRendererContext.addSourceViewRecommendation();
                }
                messageRendererContext.setMessageNode(messageItem);
                messageRendererContext.renderItemFacet();
                if (messageRendererContext.isNotValid()) {
                    messageRendererContext.renderAttentionMarker();
                }
            } else if (messageItem.isTextElement()) {
                messageRendererContext.setMessageNode(messageItem);
                messageRendererContext.renderItemFacet();
            } else {
                messageRendererContext.addElementIsSet();
                messageRendererContext.getWriter().write("+");
            }
        } else {
            Object object;
            messageRendererContext.startTag("table");
            MessageRendererHelper.addTableStyle(messageRendererContext);
            messageRendererContext.addAttribute("border", "1");
            for (object = messageProperty2; object != null; object = (MessageProperty)((MessageProperty)object).getNextSibling()) {
                messageRendererContext.startTag("tr");
                String string = MessageRendererHelper.getPropertyLabel((MessageProperty)object);
                if ("".equals(string)) {
                    messageRendererContext.startTag("td");
                    messageRendererContext.addAttribute("colspan", "2");
                } else {
                    messageRendererContext.startTag("td");
                    if (((MessageProperty)object).isWildCard()) {
                        messageRendererContext.addSourceViewRecommendation();
                    } else {
                        messageRendererContext.addTypeTitle(((MessageProperty)object).getXMLTypeName());
                    }
                    messageRendererContext.addLabel((MessageProperty)object, string);
                    messageRendererContext.endTag("td");
                    messageRendererContext.startTag("td");
                }
                if (((MessageProperty)object).isWildCard()) {
                    MessageRendererHelper.processProperty(messageRendererContext, (MessageProperty)object);
                } else {
                    MessageRendererHelper.processProperty(messageRendererContext, (MessageProperty)object);
                }
                messageRendererContext.endTag("td");
                messageRendererContext.endTag("tr");
            }
            messageRendererContext.endTag("table");
            if (!messageRendererContext.isReadOnlyMode()) {
                object = messageRendererContext.setMessageNode(messageItem);
                if (((MessageContext)object).isAppendPossible() || ((MessageContext)object).isInsertPossible() || ((MessageContext)object).isRemovePossible()) {
                    messageRendererContext.renderActionFacet();
                }
                if (((MessageContext)object).getDialogFacet() != null) {
                    messageRendererContext.renderFacet(((MessageContext)object).getDialogFacet());
                }
            }
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)messageProperty.getIdentifier());
        }
    }

    public static void processSequenceProperty(MessageRendererContext messageRendererContext, MessageProperty messageProperty) throws IOException {
        MessageItem messageItem;
        MessageProperty messageProperty2;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)messageProperty.getIdentifier());
        }
        if ((messageProperty2 = (MessageProperty)(messageItem = (MessageItem)messageProperty.getFirstChild()).getFirstChild()) == null) {
            messageRendererContext.setMessageNode(messageItem);
            messageRendererContext.renderItemFacet();
            if (messageRendererContext.isNotValid()) {
                messageRendererContext.renderAttentionMarker();
            }
        } else {
            Object object;
            messageRendererContext.startTag("table");
            MessageRendererHelper.addTableStyle(messageRendererContext);
            messageRendererContext.addAttribute("border", "1");
            for (object = messageProperty2; object != null; object = (MessageProperty)((MessageProperty)object).getNextSibling()) {
                MessageContext messageContext = messageRendererContext.setMessageNode((MessageNode)object);
                String string = messageContext.getDialogFacet();
                if (string != null) {
                    messageRendererContext.startTag("tr");
                    messageRendererContext.startTag("td");
                    messageRendererContext.addAttribute("colspan", "2");
                    messageRendererContext.renderFacet(string);
                    messageRendererContext.endTag("td");
                    messageRendererContext.endTag("tr");
                }
                messageRendererContext.startTag("tr");
                String string2 = MessageRendererHelper.getPropertyLabel((MessageProperty)object);
                if ("".equals(string2)) {
                    messageRendererContext.startTag("td");
                    messageRendererContext.addAttribute("colspan", "2");
                } else {
                    messageRendererContext.startTag("td");
                    if (((MessageProperty)object).isWildCard()) {
                        messageRendererContext.addSourceViewRecommendation();
                    } else {
                        messageRendererContext.addTypeTitle(((MessageProperty)object).getXMLTypeName());
                    }
                    messageRendererContext.addLabel((MessageProperty)object, string2);
                    messageRendererContext.endTag("td");
                    messageRendererContext.startTag("td");
                }
                if (((MessageProperty)object).isWildCard()) {
                    MessageRendererHelper.processProperty(messageRendererContext, (MessageProperty)object);
                } else {
                    MessageRendererHelper.processProperty(messageRendererContext, (MessageProperty)object);
                }
                messageRendererContext.endTag("td");
                if (!messageRendererContext.isReadOnlyMode()) {
                    messageRendererContext.startTag("td");
                    messageContext = messageRendererContext.setMessageNode((MessageNode)object);
                    if (messageContext.isAppendPossible() || messageContext.isInsertPossible() || messageContext.isRemovePossible()) {
                        messageRendererContext.renderActionFacet();
                    }
                    messageRendererContext.endTag("td");
                }
                messageRendererContext.endTag("tr");
            }
            object = messageRendererContext.setMessageNode(messageItem);
            if (((MessageContext)object).isAppendPossible() || ((MessageContext)object).isInsertPossible() || ((MessageContext)object).isRemovePossible()) {
                messageRendererContext.startTag("tr");
                messageRendererContext.startTag("td");
                messageRendererContext.addAttribute("colspan", "2");
                messageRendererContext.renderActionFacet();
                messageRendererContext.endTag("td");
                messageRendererContext.endTag("tr");
            }
            if (((MessageContext)object).getDialogFacet() != null) {
                messageRendererContext.startTag("tr");
                messageRendererContext.startTag("td");
                messageRendererContext.addAttribute("colspan", "2");
                messageRendererContext.renderFacet(((MessageContext)object).getDialogFacet());
                messageRendererContext.endTag("td");
                messageRendererContext.endTag("tr");
            }
            messageRendererContext.endTag("table");
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)messageProperty.getIdentifier());
        }
    }

    static String getPropertyLabel(MessageProperty messageProperty) {
        if (messageProperty.isSequencePropery() && !messageProperty.isAny()) {
            return "";
        }
        return messageProperty.getLabel();
    }

    static String getTrueArrayPropertyLabel(MessageProperty messageProperty, int n) {
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        return MessageRendererHelper.getPropertyLabel(messageProperty) + "[" + numberFormat.format((long)n++) + "]";
    }

    static void addTableStyle(MessageRendererContext messageRendererContext) throws IOException {
        if (messageRendererContext.getTableStyleClass() != null) {
            messageRendererContext.addAttribute("class", messageRendererContext.getTableStyleClass());
        } else {
            messageRendererContext.addAttribute("border", "1");
        }
    }
}

