/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.jsf.message.sdo;

import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.jsf.component.MessageComponent;
import com.ibm.bpe.jsf.message.sdo.MessageContext;
import com.ibm.bpe.jsf.message.sdo.MessageItem;
import com.ibm.bpe.jsf.message.sdo.MessageNode;
import com.ibm.bpe.jsf.message.sdo.MessageProperty;
import com.ibm.bpe.jsf.util.FacesUtils;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class MessageRendererContext {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";
    private FacesContext facesContext = null;
    private ResponseWriter writer = null;
    private MessageComponent component = null;
    private Map facetMap = null;
    private boolean readOnlyMode = false;
    private boolean readOnlyModeChanged = false;
    private boolean simplificationMode = false;
    private String tableStyleClass = null;
    private MessageNode currentNode = null;
    private MessageContext currentContext = null;
    private Set ajaxButtonSet = new HashSet();
    private MessageFormat typeMessageFormatter = null;
    private String sourceViewRecommendation = null;
    private String elementIsSetMessage = null;
    private String elementIsUnSetMessage = null;
    private String styleForInvalidInput = null;
    private static final String DEFAULT_FACET_NAME = "default";
    private static final String BOOLEAN_FACET_NAME = "boolean";
    private static final String VALIDATION_FACET_NAME = "validation";
    private static final String ACTIONS_FACET_NAME = "actions";

    public MessageRendererContext(FacesContext facesContext, ResponseWriter responseWriter, MessageComponent messageComponent) {
        this(facesContext, responseWriter, messageComponent, messageComponent != null ? messageComponent.getBooleanAttribute("readOnly") : false, messageComponent.getFacets());
    }

    private MessageRendererContext(FacesContext facesContext, ResponseWriter responseWriter, MessageComponent messageComponent, boolean bl, Map map) {
        this.facesContext = facesContext;
        this.writer = responseWriter;
        this.component = messageComponent;
        this.facetMap = map;
        this.readOnlyMode = bl || !((Map)messageComponent.getAttribute("dialogFacetMap")).isEmpty();
        this.simplificationMode = messageComponent != null ? messageComponent.getBooleanAttribute("simplificationMode") : false;
        this.tableStyleClass = messageComponent != null ? (String)messageComponent.getAttributes().get("tableStyleClass") : null;
        String string = FacesUtils.lookupNonPIIMessage("MESSAGE_COMPONENT.TYPE_HINT");
        if (string != null) {
            this.typeMessageFormatter = new MessageFormat(string);
        }
        this.styleForInvalidInput = (String)messageComponent.getAttribute("styleClass4invalidInput");
        this.sourceViewRecommendation = FacesUtils.lookupNonPIIMessage("MESSAGE_COMPONENT.SOURCE_VIEW_RECOMMENDATION");
        this.elementIsSetMessage = FacesUtils.lookupNonPIIMessage("MESSAGE_COMPONENT.ELEMENT_SET");
        this.elementIsUnSetMessage = FacesUtils.lookupNonPIIMessage("MESSAGE_COMPONENT.ELEMENT_UNSET");
    }

    public FacesContext getFacesContext() {
        return this.facesContext;
    }

    public Map getFacetMap() {
        return this.facetMap;
    }

    public boolean isReadOnlyMode() {
        return this.readOnlyMode;
    }

    public boolean isSimplificationMode() {
        return this.simplificationMode;
    }

    public ResponseWriter getWriter() {
        return this.writer;
    }

    public String getTableStyleClass() {
        return this.tableStyleClass;
    }

    public MessageContext setMessageNode(MessageNode messageNode) {
        if (this.currentNode == null || messageNode == null || this.currentNode.getIdentifier() != messageNode.getIdentifier()) {
            this.currentNode = messageNode;
            this.currentContext = this.component.setMessageNode(messageNode);
            this.currentContext.setReadOnly(this.readOnlyMode);
            if (messageNode instanceof MessageProperty) {
                if (((MessageProperty)messageNode).isWildCard()) {
                    this.currentContext.setReadOnly(true);
                }
            } else if (messageNode.getParent() != null && ((MessageProperty)messageNode.getParent()).isWildCard()) {
                this.currentContext.setReadOnly(true);
            }
        }
        return this.currentContext;
    }

    public void startTag(String string) throws IOException {
        this.writer.startElement(string, (UIComponent)this.component);
    }

    public void endTag(String string) throws IOException {
        this.writer.endElement(string);
    }

    public void addAttribute(String string, Object object) throws IOException {
        this.writer.writeAttribute(string, object, string);
    }

    public void write(String string) throws IOException {
        this.writer.writeText((Object)(string != null ? string : ""), null);
    }

    public void renderFacet(String string) throws IOException {
        String string2 = this.currentNode != null ? this.currentNode.getIdentifier() : "";
        MessageRendererContext.encodeFacet(this.facesContext, this.facetMap, string, string2);
    }

    public void renderValidationFacet() throws IOException {
        this.renderFacet(VALIDATION_FACET_NAME);
    }

    public void renderItemFacet() throws IOException {
        if (this.currentNode != null && this.currentNode.isBooleanField()) {
            this.renderFacet(BOOLEAN_FACET_NAME);
        } else {
            this.renderFacet(DEFAULT_FACET_NAME);
        }
    }

    public void renderActionFacet() throws IOException {
        this.renderFacet(ACTIONS_FACET_NAME);
    }

    public boolean isNotValid() {
        UIInput uIInput = (UIInput)this.component.findComponent("IDS");
        return uIInput != null && !uIInput.isValid();
    }

    public void renderAttentionMarker() throws IOException {
    }

    public void addLabel(MessageProperty messageProperty, String string) throws IOException {
        MessageItem messageItem = (MessageItem)messageProperty.getFirstChild();
        if (messageItem != null && messageItem.isLeaf()) {
            this.startTag("label");
            this.addAttribute("for", this.component.getUniqueId(FacesContext.getCurrentInstance(), this.component, messageItem.getIdentifier() + ":IDS"));
            this.write(string);
            this.endTag("label");
        } else {
            this.write(string);
        }
    }

    public void addTypeTitle(String string) throws IOException {
        String string2;
        if (string != null && this.typeMessageFormatter != null && (string2 = this.typeMessageFormatter.format(new Object[]{string})) != null) {
            this.addAttribute("title", string2);
        }
    }

    public void addSourceViewRecommendation() throws IOException {
        if (!this.isReadOnlyMode()) {
            this.addAttribute("title", this.sourceViewRecommendation);
        }
    }

    public void addElementIsSet() throws IOException {
        this.addAttribute("title", this.elementIsSetMessage);
    }

    public void addElementIsUnSet() throws IOException {
        this.addAttribute("title", this.elementIsUnSetMessage);
    }

    static void encodeRecursiv(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        if (!uIComponent.isRendered()) {
            return;
        }
        uIComponent.encodeBegin(facesContext);
        if (uIComponent.getRendersChildren()) {
            uIComponent.encodeChildren(facesContext);
        } else {
            for (UIComponent uIComponent2 : uIComponent.getChildren()) {
                MessageRendererContext.encodeRecursiv(facesContext, uIComponent2);
            }
        }
        uIComponent.encodeEnd(facesContext);
    }

    public static void encodeFacet(FacesContext facesContext, Map map, String string, String string2) throws IOException {
        UIComponent uIComponent;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)(string + " for " + string2));
        }
        if ((uIComponent = (UIComponent)map.get(string)) == null) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("MessageComponent does not feature a facet with name " + string));
            }
            return;
        }
        MessageRendererContext.encodeRecursiv(facesContext, uIComponent);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)(string + " for " + string2));
        }
    }
}

