/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.jsf.message.sdo;

import com.ibm.bpc.clientcore.converter.ConverterUtils;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.jsf.message.sdo.MessageItem;
import com.ibm.bpe.jsf.message.sdo.MessageNode;
import com.ibm.bpe.jsf.message.sdo.MessageNodeUtils;
import com.ibm.bpe.jsf.message.sdo.SDOUtils;
import com.ibm.bpe.message.sdo.SDOImplHelper;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Sequence;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageProperty
implements MessageNode {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2007, 2009.\n\n";
    private SDOImplHelper sdoHelper = null;
    private MessageItem parent = null;
    private MessageItem firstChildCache = null;
    boolean firstChildSet = false;
    private int level = 0;
    private static final int EXPANSION_LEVEL_LIMIT = 16;
    private List properties = null;
    private Map<Integer, Integer> indexMap = null;
    private int indexInPropertiesMap = 0;
    private Map<Integer, Integer> xPathIndexMap = null;
    private boolean simplified = false;
    String identifier = "";
    String xPath = "";
    private Property property = null;
    private Sequence sequence = null;
    private boolean insertPossible = false;
    private boolean appendPossible = false;
    private boolean removePossible = false;
    private boolean arrayProperty = false;
    private boolean sequenceProperty = false;
    private boolean attribute = false;
    private boolean array = false;
    private boolean wildcard = false;
    private boolean booleanField = false;
    private boolean dataType = false;
    private boolean any = false;
    private QName type = null;
    private QName wrappedSimpleType = null;

    MessageProperty(SDOImplHelper sDOImplHelper, MessageItem messageItem, List list, int n, Map<Integer, Integer> map, Map<Integer, Integer> map2) {
        Object object;
        this.sdoHelper = sDOImplHelper;
        this.parent = messageItem;
        this.properties = list;
        this.indexInPropertiesMap = n;
        this.indexMap = map;
        this.xPathIndexMap = map2;
        this.property = (Property)list.get(n);
        this.dataType = this.property != null ? this.property.getType().isDataType() : false;
        this.attribute = MessageNodeUtils.isAttribute(this.property);
        this.sequence = messageItem.getSequence();
        if (this.parent != null) {
            this.array = this.parent.isArray();
        }
        if (this.parent != null) {
            this.level = this.parent.getLevel() + 1;
        }
        this.calculateIdentifiers();
        if (this.sequence != null && BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)(this.identifier + "contains Sequence with size " + this.sequence.size()));
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)map.toString());
        }
        if (this.isSet()) {
            if (this.property.isMany()) {
                object = this.getValue();
                if (object instanceof List) {
                    this.arrayProperty = true;
                    int n2 = ((List)object).size();
                    int n3 = this.sdoHelper.getUpperBound(MessageNodeUtils.boHelper, this.property);
                    if (n3 < 0) {
                        this.appendPossible = true;
                    } else if (n2 < n3) {
                        this.appendPossible = true;
                    }
                } else if (object instanceof Sequence) {
                    this.sequenceProperty = true;
                }
            }
        } else {
            object = this.property.getType();
            if ("EFeatureMapEntry".equals(object.getName()) && "http://www.eclipse.org/emf/2002/Ecore".equals(object.getURI())) {
                this.appendPossible = false;
                this.sequenceProperty = true;
            } else {
                if (this.property.isMany()) {
                    this.arrayProperty = true;
                }
                this.appendPossible = true;
            }
        }
        if (this.sequence != null) {
            this.appendPossible = false;
            this.removePossible = false;
        }
        if (this.parent != null) {
            this.simplified = this.parent.isSimplified();
        }
        if (this.sdoHelper.isWildcardContent(MessageNodeUtils.boHelper, this.property)) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)(this.getIdentifier() + " is wildcard property"));
            }
            this.wildcard = true;
            this.appendPossible = false;
            this.insertPossible = false;
        }
        if (this.property.getType() != null && !this.property.getType().isDataType() && this.property.getType().getProperties().size() == 0) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Property with complex type without properties. I.e. element without content.");
            }
            this.wildcard = true;
            this.insertPossible = false;
            this.appendPossible = !this.isSet();
        }
        if (this.property != null) {
            object = this.property.getType().getURI();
            String string = this.property.getType().getName();
            if ("commonj.sdo".equals(object) && "Boolean".equals(string)) {
                this.booleanField = true;
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)(this.getIdentifier() + " is a boolean field"));
                }
            } else if ("commonj.sdo".equals(object) && "Object".equals(string)) {
                Object object2;
                this.any = true;
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)(this.getIdentifier() + " is a any field"));
                }
                if ((object2 = this.getValue()) != null && object2 instanceof DataObject) {
                    Object object3;
                    DataObject dataObject = (DataObject)object2;
                    if (MessageNodeUtils.isWrapperType(dataObject) && (object3 = dataObject.get("value")) != null) {
                        this.wrappedSimpleType = ConverterUtils.getXSDTypeForClazz(object3.getClass());
                        this.wildcard = false;
                    }
                } else if (this.property.getType().isDataType() && object2 != null) {
                    this.wrappedSimpleType = ConverterUtils.getXSDTypeForClazz(object2.getClass());
                    this.wildcard = false;
                }
            }
        }
    }

    private void calculateIdentifiers() {
        if (this.parent != null) {
            String string = this.property.getName();
            if (this.attribute) {
                string = "@" + string;
            }
            string = string != null ? string.replaceAll("\\.", "..") : null;
            this.identifier = this.parent.identifier == null ? string : this.parent.identifier + "." + string;
            if (this.sequence != null && this.property.isMany()) {
                this.identifier = this.identifier + "[" + (this.xPathIndexMap.get(this.indexInPropertiesMap) - 1) + "]";
            }
            this.xPath = this.attribute ? this.parent.xPath + "/@" + this.property.getName() : this.parent.xPath + "/" + this.property.getName();
        }
    }

    private int getIndex(int n) {
        if (this.indexMap != null) {
            return this.indexMap.get(n);
        }
        return n;
    }

    @Override
    public MessageNode getParent() {
        return this.parent;
    }

    @Override
    public MessageNode getNextSibling() {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        MessageProperty messageProperty = null;
        messageProperty = this.indexInPropertiesMap + 1 < this.properties.size() ? new MessageProperty(this.sdoHelper, this.parent, this.properties, this.indexInPropertiesMap + 1, this.indexMap, this.xPathIndexMap) : null;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)(messageProperty != null ? messageProperty.getIdentifier() : "-"));
        }
        return messageProperty;
    }

    @Override
    public MessageNode getFirstChild() {
        Object object;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        MessageItem messageItem = null;
        if (this.firstChildSet) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.exit((Object)"Returning cached Item");
            }
            return this.firstChildCache;
        }
        List<DataObject> list = new ArrayList<Object>();
        if (this.isArray()) {
            object = this.parent.getDataObject();
            Sequence sequence = object.getSequence();
            for (int i = 0; i < sequence.size(); ++i) {
                Object object2 = sequence.getValue(i);
                if (object2 == null) {
                    list.add((DataObject)new MessageItem.EmptyItem());
                    continue;
                }
                list.add((DataObject)object2);
            }
        } else if (this.sequence != null) {
            list.add((DataObject)this.sequence.getValue(this.getIndex(this.indexInPropertiesMap)));
        } else {
            object = this.parent.getDataObject();
            if (object.isSet(this.property)) {
                Object object3 = object.get(this.property);
                if (object3 instanceof List && this.property.isMany()) {
                    list = (List)object3;
                } else {
                    list.add((DataObject)object3);
                }
            } else if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)(this.identifier + " is not set"));
            }
            if (this.appendPossible && this.level < 16) {
                list = MessageNodeUtils.addManadatoryItems(this.sdoHelper, list, object, this.property, this.xPath);
            }
        }
        if (list.size() != 0) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("#Children: " + list.size()));
            }
            messageItem = new MessageItem(this.sdoHelper, this, list, 0);
        } else {
            messageItem = null;
            if (this.isSimplified() && !this.arrayProperty && !this.sequenceProperty && this.level < 16 && SDOUtils.isExtensible(this.property) && this.property.getType().isDataType() && !this.booleanField && !this.wildcard) {
                object = SDOUtils.createPrimitive(this.sdoHelper, this.property);
                list.add((DataObject)object);
                messageItem = new MessageItem(this.sdoHelper, this, list, 0);
                messageItem.setArtifical(true);
            }
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)(messageItem != null ? messageItem.getIdentifier() : "-"));
        }
        this.firstChildSet = true;
        this.firstChildCache = messageItem;
        return messageItem;
    }

    @Override
    public int getNumberBrotherAndSister() {
        return this.properties.size();
    }

    @Override
    public String getIdentifier() {
        if (this.identifier != null) {
            return "P." + this.identifier;
        }
        return "P";
    }

    @Override
    public String getXPath() {
        return this.xPath;
    }

    @Override
    public boolean isLeaf() {
        return this.getFirstChild() == null;
    }

    @Override
    public boolean isInsertPossible() {
        return this.insertPossible;
    }

    @Override
    public boolean isAppendPossible() {
        return this.appendPossible;
    }

    @Override
    public boolean isRemovePossible() {
        return this.removePossible;
    }

    @Override
    public boolean isSimplified() {
        return this.simplified;
    }

    public boolean isArrayProperty() {
        return this.arrayProperty;
    }

    public boolean isSequencePropery() {
        return this.sequenceProperty;
    }

    public String getLabel() {
        if (this.property != null) {
            String string = this.property.getName();
            if (string.startsWith(":")) {
                return "";
            }
            String string2 = null;
            String string3 = null;
            string3 = this.level == 1 ? string : MessageNodeUtils.getDeclaredName(this.sdoHelper, this.property);
            string2 = string3 == null || string3.startsWith(":") ? string : string3;
            if (this.attribute) {
                string2 = "@" + string2;
            }
            return string2;
        }
        return "";
    }

    Property getProperty() {
        return this.property;
    }

    void setProperty(Property property) {
        this.property = property;
    }

    Object getValue() {
        if (this.sequence != null) {
            return this.sequence.getValue(this.getIndex(this.indexInPropertiesMap));
        }
        return this.parent.getDataObject().get(this.property);
    }

    public void setValue(int n, Object object) {
        if (this.sequence != null) {
            if (this.property.isMany()) {
                List list = this.parent.getSequencedDataObject().getList(this.property);
                int n2 = list.size();
                int n3 = this.xPathIndexMap.get(this.indexInPropertiesMap) - 1;
                if (n3 >= n2 && BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("[" + this.identifier + "] index " + n3 + " is not smaller than size of list: " + n2));
                }
                list.set(n3, object);
            } else {
                this.sequence.setValue(this.getIndex(this.indexInPropertiesMap), object);
            }
        } else if (this.property.isMany()) {
            List list = (List)this.getValue();
            list.set(n, object);
        } else if (this.isArray()) {
            DataObject dataObject = this.parent.getDataObject();
            SDOUtils.setArrayAtPosition(dataObject, this.property, this.getIndex(this.indexInPropertiesMap), object);
        } else if (this.sequence != null) {
            this.sequence.setValue(this.getIndex(this.indexInPropertiesMap), object);
        } else {
            this.parent.getDataObject().set(this.property, object);
        }
    }

    boolean isSet() {
        if (this.sequence != null) {
            return true;
        }
        return this.parent.getDataObject().isSet(this.property);
    }

    public boolean inSequence() {
        return this.sequence != null;
    }

    public String getXMLTypeName() {
        QName qName = null;
        if (this.wrappedSimpleType != null) {
            qName = this.wrappedSimpleType;
        } else if (this.property != null) {
            qName = this.sdoHelper.getSchemaType(this.property);
        }
        return qName != null ? qName.getLocalPart() : null;
    }

    public QName getType() {
        return this.type;
    }

    public boolean isWildCard() {
        return this.wildcard;
    }

    public boolean isAny() {
        return this.any;
    }

    public boolean isAttribute() {
        return this.attribute;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean isArray() {
        return this.array;
    }

    @Override
    public boolean isBooleanField() {
        return this.booleanField;
    }

    public boolean isDataType() {
        return this.dataType;
    }

    public int getXPathArrayIndex() {
        if (this.xPathIndexMap != null) {
            return this.xPathIndexMap.get(this.indexInPropertiesMap);
        }
        return 1;
    }

    @Override
    public SDOImplHelper getSDOImplHelper() {
        return this.sdoHelper;
    }
}

