/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.jsf.message.sdo;

import com.ibm.bpc.clientcore.MessageWrapper;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.jsf.component.MessageComponent;
import com.ibm.bpe.jsf.message.sdo.MessageContext;
import com.ibm.bpe.jsf.message.sdo.MessageIdTokenizer;
import com.ibm.bpe.jsf.message.sdo.MessageItem;
import com.ibm.bpe.jsf.message.sdo.MessageItemContext;
import com.ibm.bpe.jsf.message.sdo.MessageNode;
import com.ibm.bpe.jsf.message.sdo.MessageProperty;
import com.ibm.bpe.jsf.message.sdo.MessagePropertyContext;
import com.ibm.bpe.jsf.message.sdo.SDOUtils;
import com.ibm.bpe.message.sdo.SDOImplHelper;
import com.ibm.bpe.util.Assert;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.websphere.bo.BOType;
import com.ibm.websphere.bo.BOXSDHelper;
import com.ibm.websphere.sca.ServiceManager;
import com.ibm.wsspi.bo.BOSPI;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Sequence;
import commonj.sdo.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MessageNodeUtils {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";
    static BOXSDHelper boHelper = null;
    static BOType boType = null;

    public static List addManadatoryItems(SDOImplHelper sDOImplHelper, List arrayList, DataObject dataObject, Property property, String string) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        int n = 0;
        int n2 = sDOImplHelper.getLowerBound(boHelper, property);
        int n3 = sDOImplHelper.getUpperBound(boHelper, property);
        int n4 = n2 = n2 < 0 ? 0 : n2;
        if (n2 > arrayList.size()) {
            if (SDOUtils.isExtensible(property)) {
                n = n2 - arrayList.size();
                Object object = SDOUtils.appendEmptyElement(sDOImplHelper, dataObject, property, n);
                if (object instanceof List) {
                    arrayList = (List)object;
                } else {
                    arrayList = new ArrayList<Object>();
                    arrayList.add(object);
                }
            } else if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Property " + string + " is not extensible -- cannot add any elements"));
            }
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)("" + n));
        }
        return arrayList;
    }

    public static MessageItem createMessageItem(Object object, boolean bl) {
        Object object2;
        if (object instanceof MessageWrapper) {
            object2 = ((MessageWrapper)object).getMessage();
            if (object2 instanceof DataObject) {
                object = object2;
            } else if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Boxed Primitive encountered");
            }
        }
        if (object != null) {
            Object object3;
            object2 = null;
            if (object instanceof DataObject) {
                object3 = (DataObject)object;
                if (!object3.getType().isOpen() && object3.getType().getProperties() != null && object3.getType().getProperties().size() == 0) {
                    return null;
                }
                object2 = MessageNodeUtils.getSDOImplHelper((DataObject)object3);
            }
            object3 = new ArrayList();
            object3.add(object);
            MessageItem messageItem = new MessageItem((SDOImplHelper)object2, null, (List)object3, 0);
            messageItem.setSimplified(bl);
            return messageItem;
        }
        return null;
    }

    public static String getValidationClientId(String string, String string2) {
        int n;
        MessageIdTokenizer messageIdTokenizer = new MessageIdTokenizer(string2);
        messageIdTokenizer.nextOriginalToken();
        String string3 = null;
        if (messageIdTokenizer.hasMoreTokens() && (n = (string3 = messageIdTokenizer.nextOriginalToken()).indexOf("[")) != -1) {
            string3 = string3.substring(0, n);
        }
        if (string3 != null) {
            return string + ':' + "P." + string3;
        }
        return string + ':' + "T";
    }

    public static MessageNode getMessageNode(DataObject dataObject, String string, boolean bl) {
        if (string == null) {
            return null;
        }
        MessageIdTokenizer messageIdTokenizer = new MessageIdTokenizer(string);
        if (!messageIdTokenizer.hasMoreTokens()) {
            return null;
        }
        String string2 = messageIdTokenizer.nextToken();
        boolean bl2 = false;
        if ("P".equals(string2)) {
            bl2 = true;
        }
        MessageItem messageItem = MessageNodeUtils.createMessageItem(dataObject, bl);
        MessageProperty messageProperty = null;
        while (messageItem != null && messageIdTokenizer.hasMoreTokens()) {
            String string3 = messageIdTokenizer.nextToken();
            if (messageIdTokenizer.hasMoreTokens()) {
                messageItem = MessageNodeUtils.getNextMessageItem(messageItem, string3);
                continue;
            }
            if (bl2) {
                messageProperty = MessageNodeUtils.getNextMessageProperty(messageItem, string3);
                continue;
            }
            messageItem = MessageNodeUtils.getNextMessageItem(messageItem, string3);
        }
        if (messageItem == null) {
            return null;
        }
        if (bl2) {
            return messageProperty;
        }
        return messageItem;
    }

    private static MessageItem getNextMessageItem(MessageItem messageItem, String string) {
        Object object;
        Object object2;
        int n = 0;
        String string2 = string;
        int n2 = string.indexOf("[");
        if (n2 != -1) {
            object2 = string.substring(n2 + 1, string.length() - 1);
            string2 = string.substring(0, n2);
            n = Integer.parseInt((String)object2);
        }
        if (messageItem.getSequence() != null) {
            object2 = (MessageProperty)messageItem.getFirstChild();
            int n3 = 0;
            while (true) {
                if (object2 == null) {
                    return null;
                }
                String string3 = ((MessageProperty)object2).getProperty().getName();
                if (string2.equals(string3) && n3++ == n) break;
                object2 = (MessageProperty)((MessageProperty)object2).getNextSibling();
            }
            return (MessageItem)((MessageProperty)object2).getFirstChild();
        }
        object2 = (MessageProperty)messageItem.getFirstChild();
        while (true) {
            if (object2 == null) {
                return null;
            }
            object = ((MessageProperty)object2).getProperty().getName();
            if (string2.equals(object)) break;
            object2 = (MessageProperty)((MessageProperty)object2).getNextSibling();
        }
        Assert.assertion((object2 != null ? 1 : 0) != 0, (String)"Property must not be null");
        object = (MessageItem)((MessageProperty)object2).getFirstChild();
        for (int i = 0; i < n; ++i) {
            object = (MessageItem)((MessageItem)object).getNextSibling();
        }
        return object;
    }

    private static MessageProperty getNextMessageProperty(MessageItem messageItem, String string) {
        if (messageItem.getSequence() != null) {
            int n = 0;
            String string2 = string;
            int n2 = string.indexOf("[");
            if (n2 != -1) {
                String string3 = string.substring(n2 + 1, string.length() - 1);
                string2 = string.substring(0, n2);
                n = Integer.parseInt(string3);
            }
            int n3 = 0;
            MessageProperty messageProperty = (MessageProperty)messageItem.getFirstChild();
            while (true) {
                if (string2 == null) {
                    return null;
                }
                String string4 = messageProperty.getProperty().getName();
                if (string2.equals(string4) && n3++ == n) break;
                messageProperty = (MessageProperty)messageProperty.getNextSibling();
            }
            return messageProperty;
        }
        String string5 = string;
        boolean bl = false;
        if (string5 != null && string5.startsWith("@")) {
            bl = true;
            string5 = string5.substring(1);
        }
        MessageProperty messageProperty = (MessageProperty)messageItem.getFirstChild();
        while (true) {
            if (messageProperty == null) {
                return null;
            }
            String string6 = messageProperty.getProperty().getName();
            if (string5.equals(string6) && (!bl || messageProperty.isAttribute())) break;
            messageProperty = (MessageProperty)messageProperty.getNextSibling();
        }
        return messageProperty;
    }

    public static MessageContext createContext(MessageComponent messageComponent, MessageNode messageNode, String string, String string2, boolean bl) {
        if (messageNode instanceof MessageProperty) {
            return new MessagePropertyContext(messageComponent, (MessageProperty)messageNode, bl, string2);
        }
        return new MessageItemContext(messageComponent, (MessageItem)messageNode, bl, string2);
    }

    public static List removeDublicateProperties(DataObject dataObject, List list) {
        Property property;
        int n;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        if (dataObject == null) {
            return list;
        }
        List<Property> list2 = new ArrayList();
        HashSet<String> hashSet = new HashSet<String>();
        int n2 = list.size();
        for (n = 0; n < n2; ++n) {
            property = (Property)list.get(n);
            if (!"EFeatureMapEntry".equals(property.getType().getName())) continue;
            Sequence sequence = dataObject.getSequence(property);
            int n3 = sequence.size();
            for (int i = 0; i < n3; ++i) {
                Property property2 = sequence.getProperty(i);
                if (hashSet == null || property2 == null) continue;
                hashSet.add(property2.getName());
            }
        }
        if (hashSet.size() > 0) {
            for (n = 0; n < n2; ++n) {
                property = (Property)list.get(n);
                if ("EFeatureMapEntry".equals(property.getType().getName())) {
                    list2.add(property);
                    continue;
                }
                if (!hashSet.contains(property.getName())) {
                    list2.add(property);
                    continue;
                }
                if (!BPCClientTrace.isTracing) continue;
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Ignoring property " + property.getName() + " which is also contained in sequence"));
            }
        } else {
            list2 = list;
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
        return list2;
    }

    public static List removeUnkownProperties(DataObject dataObject, List list) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        if (dataObject == null) {
            return list;
        }
        SDOImplHelper sDOImplHelper = MessageNodeUtils.getSDOImplHelper(dataObject);
        ArrayList<Property> arrayList = new ArrayList<Property>();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Property property = (Property)list.get(i);
            String string = property.getName();
            if ("EFeatureMapEntry".equals(property.getType().getName())) {
                if (!BPCClientTrace.isTracing) continue;
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Ignoring property \"" + string));
                continue;
            }
            String string2 = sDOImplHelper.getDeclaredName(boHelper, property);
            if (string2 == null || string2.startsWith(":") || "".equals(string2)) {
                if (!BPCClientTrace.isTracing) continue;
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Ignoring property \"" + string + "\" + having display name + \"" + string2));
                continue;
            }
            arrayList.add(property);
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
        return arrayList;
    }

    public static List removeUnSetProperties(DataObject dataObject, List list) {
        String string;
        int n;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        if (dataObject == null) {
            return list;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Property property = null;
        Property property2 = null;
        Property property3 = null;
        for (n = 0; n < list.size(); ++n) {
            Property property4 = (Property)list.get(n);
            string = property4.getName();
            if ("any".equals(string)) {
                property = property4;
                continue;
            }
            if ("mixed".equals(string)) {
                property2 = property4;
                continue;
            }
            if (!"anyAttribute".equals(string)) continue;
            property3 = property4;
        }
        if (property != null && property2 != null && property3 != null) {
            if (dataObject.isSet(property)) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Keep property any - remove other properties");
                }
                arrayList.add(property);
            } else if (dataObject.isSet(property2)) {
                arrayList.add(property2);
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Keep property mixed - remove other properties");
                }
            } else {
                arrayList.add(property3);
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Keep property anyAttribute - remove other properties");
                }
            }
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.exit();
            }
            return arrayList;
        }
        n = list.size();
        for (int i = 0; i < n; ++i) {
            string = (Property)list.get(i);
            if (dataObject.isSet((Property)string)) {
                arrayList.add(string);
                continue;
            }
            if (!BPCClientTrace.isTracing) continue;
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Ignoring property " + string.getName() + " which is not set"));
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
        return arrayList;
    }

    public static String calculateMessageId(String string) {
        String string2;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)string);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            String string3 = string2.replaceAll("\\.", "..");
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(".");
            }
            int n = string3.indexOf("[");
            int n2 = string3.indexOf("]");
            if (n != -1 && n2 != -1 && n < n2) {
                String string4 = string3.substring(n + 1, n2);
                stringBuffer.append(string3.substring(0, n)).append("[");
                stringBuffer.append(Integer.parseInt(string4) - 1).append("]");
                continue;
            }
            stringBuffer.append(string3);
        }
        string2 = stringBuffer.toString();
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)string2);
        }
        return string2;
    }

    public static Property getProperty(Type type, String string) {
        boolean bl = false;
        if (string != null && string.startsWith("@")) {
            bl = true;
            string = string.substring(1);
        }
        Property property = null;
        List list = type.getProperties();
        for (Property property2 : list) {
            if (!string.equals(property2.getName()) || bl && !MessageNodeUtils.isAttribute(property2)) continue;
            property = property2;
            break;
        }
        return property;
    }

    public static boolean isAttribute(Property property) {
        return boHelper.isAttribute(property);
    }

    public static boolean isWrapperType(DataObject dataObject) {
        return boType.isDataTypeWrapper(dataObject);
    }

    public static boolean isArrayType(Type type) {
        Property property;
        List list;
        return type.isSequenced() && !type.isOpen() && (list = type.getProperties()) != null && list.size() == 1 && (property = (Property)list.get(0)).isMany();
    }

    public static String getDeclaredName(SDOImplHelper sDOImplHelper, Property property) {
        return sDOImplHelper.getDeclaredName(boHelper, property);
    }

    public static SDOImplHelper getSDOImplHelper(DataObject dataObject) {
        return SDOImplHelper.newInstance((DataObject)dataObject);
    }

    public static String createCanonicalXPath(String string) {
        String string2;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)string);
        }
        String string3 = "\\*\\[local-name\\(\\)='([^']+)' and namespace-uri\\(\\)='([^']+)'\\]";
        Pattern pattern = Pattern.compile(string3);
        Matcher matcher = pattern.matcher(string);
        String string4 = matcher.replaceAll("$1");
        StringTokenizer stringTokenizer = new StringTokenizer(string4, "/");
        if ("SDOX".equals(BOSPI.INSTANCE.getBOVersion()) && stringTokenizer.hasMoreTokens()) {
            stringTokenizer.nextToken();
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append("/");
            string2 = stringTokenizer.nextToken();
            if (string2.indexOf("[") == -1) {
                stringBuffer.append(string2);
                stringBuffer.append("[1]");
                continue;
            }
            stringBuffer.append(string2);
        }
        string2 = stringBuffer.toString();
        if (string2 != null && !string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)string2);
        }
        return string2;
    }

    static {
        boHelper = (BOXSDHelper)ServiceManager.INSTANCE.locateService("com/ibm/websphere/bo/BOXSDHelper");
        boType = (BOType)new ServiceManager().locateService("com/ibm/websphere/bo/BOType");
    }
}

