/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.jsf.message.sdo;

import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.jsf.component.MessageComponent;
import com.ibm.bpe.jsf.message.sdo.MessageContext;
import com.ibm.bpe.jsf.message.sdo.MessageItem;
import com.ibm.bpe.jsf.message.sdo.MessageNodeUtils;
import com.ibm.bpe.jsf.message.sdo.MessageProperty;
import com.ibm.bpe.jsf.message.sdo.SDOUtils;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import java.util.Map;

public class MessageItemContext
extends MessageContext {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";
    private MessageItem item = null;
    private String dialog = null;

    public MessageItemContext(MessageComponent messageComponent, MessageItem messageItem, boolean bl, String string) {
        super(messageComponent, bl, string);
        this.item = messageItem;
        this.dialog = bl ? null : (String)((Map)this.getMessageComponent().getAttribute("dialogFacetMap")).get(this.item.getIdentifier());
    }

    public boolean isAppendPossible() {
        if (!this.isReadOnly()) {
            if (this.item.getSequence() != null) {
                return false;
            }
            return this.item.isAppendPossible();
        }
        return false;
    }

    public String append() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("append is not supported");
    }

    public boolean isInsertPossible() {
        return !this.isReadOnly() && this.item.isInsertPossible();
    }

    public String insert() throws UnsupportedOperationException {
        MessageProperty messageProperty = (MessageProperty)this.item.getParent();
        Property property = messageProperty.getProperty();
        MessageItem messageItem = (MessageItem)messageProperty.getParent();
        DataObject dataObject = messageItem.getDataObject();
        if (this.item.isInArray()) {
            SDOUtils.insertEmptyArrayItemAtPosition(dataObject, property, this.item.getIndex());
        } else {
            SDOUtils.insert(MessageNodeUtils.getSDOImplHelper(dataObject), dataObject, property, this.item.getIndex());
        }
        return null;
    }

    public boolean isRemovePossible() {
        return !this.isReadOnly() && this.item.isRemovePossible();
    }

    public boolean isRemoveInCellPossible() {
        return !this.isReadOnly() && this.item.isRemoveInCellPossible();
    }

    public String remove() throws UnsupportedOperationException {
        MessageProperty messageProperty = (MessageProperty)this.item.getParent();
        Property property = messageProperty.getProperty();
        MessageItem messageItem = (MessageItem)messageProperty.getParent();
        DataObject dataObject = messageItem.getDataObject();
        if (this.item.isInArray()) {
            SDOUtils.removeArrayItemAtPosition(dataObject, property, this.item.getIndex());
        } else {
            SDOUtils.remove(dataObject, property, this.item.getIndex());
        }
        return null;
    }

    public Object getValue() throws UnsupportedOperationException {
        if (this.item.isEmpty()) {
            return null;
        }
        if (this.item.isArtifical()) {
            return null;
        }
        if (this.item.getPrimitive() != null) {
            return this.item.getPrimitive();
        }
        if (this.item.isTextElement()) {
            return this.item.getSequence().getValue(0);
        }
        return null;
    }

    public void setValue(Object object) throws UnsupportedOperationException {
        if (this.item.isEmpty()) {
            return;
        }
        if (this.item.isArtifical() && object == null) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Ignoring input \"\" since MessageItem is artifical");
            }
            return;
        }
        MessageProperty messageProperty = (MessageProperty)this.item.getParent();
        if (this.item.isTextElement()) {
            this.item.getSequence().setValue(0, object);
        } else if (messageProperty != null && !this.item.isWrapperDataObject()) {
            messageProperty.setValue(this.item.getIndex(), object);
        } else {
            this.item.setPrimitive(object);
        }
    }

    public MessageItem getMessageItem() {
        return this.item;
    }

    public String getDialogFacet() {
        return this.dialog;
    }

    public String addElement() throws UnsupportedOperationException {
        ((Map)this.getMessageComponent().getAttribute("dialogFacetMap")).remove(this.item.getIdentifier());
        return null;
    }

    public boolean isSetPossible() {
        return !this.isReadOnly() && this.item.isSetPossible();
    }

    public boolean isUnsetPossible() {
        return !this.isReadOnly() && this.item.isUnsetPossible();
    }

    public String set() throws UnsupportedOperationException {
        if (this.item.isInArray()) {
            MessageProperty messageProperty = (MessageProperty)this.item.getParent();
            Property property = messageProperty.getProperty();
            MessageItem messageItem = (MessageItem)messageProperty.getParent();
            DataObject dataObject = messageItem.getDataObject();
            SDOUtils.setArrayAtPosition(MessageNodeUtils.getSDOImplHelper(dataObject), dataObject, property, this.item.getIndex());
        }
        return null;
    }

    public String unset() throws UnsupportedOperationException {
        if (this.item.isInArray()) {
            MessageProperty messageProperty = (MessageProperty)this.item.getParent();
            Property property = messageProperty.getProperty();
            MessageItem messageItem = (MessageItem)messageProperty.getParent();
            DataObject dataObject = messageItem.getDataObject();
            SDOUtils.unsetArrayAtPosition(dataObject, property, this.item.getIndex());
        }
        return null;
    }
}

