/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.jsf.message.sdo;

import com.ibm.bpc.clientcore.MessageWrapper;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.jsf.exception.CircularReferenceInMessageException;
import com.ibm.bpe.jsf.exception.NodesLimitExceededException;
import com.ibm.bpe.jsf.message.sdo.BusinessGraphUtils;
import com.ibm.bpe.jsf.message.sdo.MessageNode;
import com.ibm.bpe.jsf.message.sdo.MessageNodeUtils;
import com.ibm.bpe.jsf.message.sdo.MessageProperty;
import com.ibm.bpe.message.sdo.SDOImplHelper;
import com.ibm.bpe.util.MessageLogger;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Sequence;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MessageItem
implements MessageNode {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";
    private SDOImplHelper sdoHelper = null;
    private MessageProperty parent = null;
    private MessageProperty firstChildCache = null;
    boolean firstChildSet = false;
    private int level = 0;
    private static final int LEVEL_LIMIT = 29;
    private List items = null;
    private int index = 0;
    private boolean simplified = false;
    private boolean artifical = false;
    private boolean nil = false;
    String identifier = null;
    String xPath = "";
    private DataObject dataObject = null;
    private Sequence sequence = null;
    private DataObject sequencedDataObject = null;
    private Object primitive = null;
    private boolean insertPossible = false;
    private boolean appendPossible = false;
    private boolean removePossible = false;
    private boolean removeInCellPossible = false;
    private boolean textElement = false;
    private boolean array = false;
    private boolean inArray = false;
    private boolean empty = false;
    private boolean setPossible = false;
    private boolean unsetPossible = false;
    private boolean anyType = false;
    private boolean booleanField = false;
    private boolean wrapperDataObjectType = false;
    private MessageWrapper wrapper = null;
    private DataObject wrapperDataObject = null;

    MessageItem(SDOImplHelper sDOImplHelper, MessageProperty messageProperty, List list, int n) {
        Property property;
        this.sdoHelper = sDOImplHelper;
        this.parent = messageProperty;
        this.items = list;
        this.index = n;
        boolean bl = this.inArray = this.parent != null ? this.parent.isArray() : false;
        if (this.parent != null) {
            this.level = this.parent.getLevel() + 1;
        }
        this.primitive = list.get(n);
        if (this.primitive instanceof EmptyItem) {
            this.empty = true;
        }
        if (this.primitive instanceof MessageWrapper) {
            this.wrapper = (MessageWrapper)this.primitive;
            this.primitive = this.wrapper.getMessage();
            if (this.primitive instanceof Boolean) {
                this.booleanField = true;
            }
        }
        if (this.primitive instanceof DataObject) {
            this.dataObject = (DataObject)this.primitive;
            this.primitive = null;
            if (this.dataObject != null && this.dataObject.getType().isSequenced()) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"isSequenced=true");
                }
                if (this.dataObject.getSequence() != null) {
                    this.sequence = this.dataObject.getSequence();
                    this.sequencedDataObject = this.dataObject;
                    this.dataObject = null;
                    if (this.sequence.size() == 1 && this.sequence.getProperty(0) == null) {
                        this.textElement = true;
                    }
                }
            }
            this.wrapperDataObjectType = MessageNodeUtils.isWrapperType(this.dataObject);
            Property property2 = property = messageProperty != null ? messageProperty.getProperty() : null;
            if (property != null) {
                this.anyType = this.sdoHelper.isWildcardContent(MessageNodeUtils.boHelper, property);
            }
            this.array = false;
        } else if (this.primitive instanceof Sequence) {
            this.sequence = (Sequence)this.primitive;
            this.primitive = null;
        } else {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_EVENT, (String)("primitive=" + this.primitive));
            }
            if (this.primitive == null) {
                this.nil = true;
            }
        }
        if (this.wrapperDataObjectType) {
            this.primitive = this.dataObject.get("value");
            this.wrapperDataObject = this.dataObject;
            this.dataObject = null;
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("WrapperDataObject setting primitive to " + this.primitive));
            }
        }
        if (this.parent != null) {
            this.simplified = this.parent.isSimplified();
        }
        this.calculateIdentifiers();
        if (messageProperty != null && !this.anyType) {
            if (this.isEmpty()) {
                this.setPossible = true;
                this.removePossible = true;
            } else {
                property = messageProperty.getProperty();
                if (messageProperty != null && messageProperty.isBooleanField()) {
                    this.booleanField = true;
                }
                if (!messageProperty.inSequence() && this.sequence == null) {
                    int n2;
                    int n3 = this.sdoHelper.getLowerBound(MessageNodeUtils.boHelper, property);
                    int n4 = this.sdoHelper.getUpperBound(MessageNodeUtils.boHelper, property);
                    if ((n3 = n3 < 0 ? (n3 = 1) : n3) < (n2 = list.size())) {
                        this.removePossible = true;
                    }
                    if (n4 == -1) {
                        this.insertPossible = true;
                    } else if (n2 < n4) {
                        this.insertPossible = true;
                    }
                    this.removeInCellPossible = this.removePossible;
                }
                if (this.primitive != null) {
                    if (property.isMany()) {
                        this.removeInCellPossible = false;
                    } else if (this.booleanField) {
                        this.removePossible = false;
                    } else if (this.simplified) {
                        this.removePossible = false;
                        this.removeInCellPossible = false;
                    }
                }
                if (this.inArray) {
                    this.unsetPossible = true;
                }
            }
        }
        if (this.booleanField && BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)(this.getIdentifier() + " is a boolean field"));
        }
        this.checkCircularReferences();
    }

    private void calculateIdentifiers() {
        if (this.parent != null) {
            Property property = this.parent.getProperty();
            if (this.parent.inSequence()) {
                if (property.isMany()) {
                    this.identifier = this.parent.identifier;
                    this.xPath = this.parent.xPath + "[" + this.parent.getXPathArrayIndex() + "]";
                } else {
                    this.identifier = this.parent.identifier + "[" + (this.parent.getXPathArrayIndex() - 1) + "]";
                    this.xPath = this.parent.xPath;
                }
            } else if (property.isMany()) {
                this.identifier = this.parent.identifier + "[" + this.index + "]";
                this.xPath = this.parent.xPath + "[" + (this.index + 1) + "]";
            } else {
                this.identifier = this.parent.identifier + "[0]";
                this.xPath = this.parent.xPath;
            }
        }
    }

    void checkCircularReferences() {
        if (this.dataObject != null) {
            MessageNode messageNode = this;
            int n = 0;
            while ((messageNode = messageNode.getParent()) != null) {
                ++n;
                if (!(messageNode instanceof MessageItem)) continue;
                MessageNode messageNode2 = messageNode;
                if (n > 29) {
                    throw new NodesLimitExceededException(new Object[]{Integer.toString(14)});
                }
                if (((MessageItem)messageNode2).dataObject == null || this.dataObject != ((MessageItem)messageNode2).dataObject) continue;
                MessageLogger messageLogger = MessageLogger.newMessageLogger((String)BPCClientTrace.class.getName());
                CircularReferenceInMessageException circularReferenceInMessageException = new CircularReferenceInMessageException(new Object[]{this.getXPath(), messageNode.getXPath()});
                messageLogger.text(MessageLogger.TYPE_ERROR, circularReferenceInMessageException.getMessage());
                throw circularReferenceInMessageException;
            }
        }
    }

    public MessageNode getParent() {
        return this.parent;
    }

    public MessageNode getNextSibling() {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        MessageItem messageItem = null;
        messageItem = this.index + 1 < this.items.size() ? new MessageItem(this.sdoHelper, this.parent, this.items, this.index + 1) : null;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)(messageItem != null ? messageItem.getIdentifier() : "-"));
        }
        return messageItem;
    }

    public MessageNode getFirstChild() {
        Object object;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        if (this.firstChildSet) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.exit((Object)"Returning cached Property");
            }
            return this.firstChildCache;
        }
        MessageProperty messageProperty = null;
        List<Property> list = new ArrayList<Property>();
        ArrayList<Property> arrayList = null;
        if (this.isArray()) {
            object = (Property)this.dataObject.getType().getProperties().get(0);
            list.add((Property)object);
        } else if (this.sequence != null) {
            int n = this.sequence.size();
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Number of properties in sequence: " + n));
            }
            arrayList = new ArrayList<Property>();
            for (int i = 0; i < n; ++i) {
                Property property = this.sequence.getProperty(i);
                arrayList.add(property);
                if (property == null) continue;
                list.add(property);
            }
        } else if (this.dataObject != null) {
            Property property = BusinessGraphUtils.getBGProperty(this.dataObject.getType());
            if (property != null) {
                list.add(property);
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Creating Property for Business Object with xpath " + this.getIdentifier()));
                }
            } else {
                List list2 = this.dataObject.getInstanceProperties();
                list.addAll(list2);
            }
        }
        list = MessageNodeUtils.removeDublicateProperties(this.dataObject, list);
        list = this.isAnyType() ? MessageNodeUtils.removeUnSetProperties(this.dataObject, list) : MessageNodeUtils.removeUnkownProperties(this.dataObject, list);
        if (list.size() != 0) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("#Children: " + list.size()));
            }
            object = null;
            HashMap<Integer, Integer> hashMap = null;
            if (arrayList != null) {
                int n = 0;
                object = new HashMap();
                hashMap = new HashMap<Integer, Integer>();
                block1: for (int i = 0; i < list.size(); ++i) {
                    Property property = (Property)list.get(i);
                    int n2 = 0;
                    for (int j = 0; j <= i; ++j) {
                        Property property2 = (Property)list.get(j);
                        if (property2 != property) continue;
                        ++n2;
                    }
                    if (BPCClientTrace.isTracing) {
                        BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("XPathIndex: " + n2));
                    }
                    hashMap.put(i, n2);
                    do {
                        Property property3;
                        if (property != (property3 = (Property)arrayList.get(n))) continue;
                        object.put(i, n);
                        if (BPCClientTrace.isTracing) {
                            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Adding " + i + " -> " + n));
                        }
                        ++n;
                        continue block1;
                    } while (++n <= arrayList.size() - 1);
                }
            }
            messageProperty = new MessageProperty(this.sdoHelper, this, list, 0, (Map<Integer, Integer>)object, hashMap);
        } else {
            messageProperty = null;
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)(messageProperty != null ? messageProperty.getIdentifier() : "-"));
        }
        this.firstChildSet = true;
        this.firstChildCache = messageProperty;
        return messageProperty;
    }

    public int getNumberBrotherAndSister() {
        return this.items.size();
    }

    public String getIdentifier() {
        if (this.identifier != null) {
            return "T." + this.identifier;
        }
        return "T";
    }

    public String getXPath() {
        return this.xPath;
    }

    public boolean isLeaf() {
        return this.getFirstChild() == null;
    }

    public boolean isInsertPossible() {
        return this.insertPossible && !this.artifical;
    }

    public boolean isAppendPossible() {
        return this.appendPossible && !this.artifical;
    }

    public boolean isRemovePossible() {
        return this.removePossible && !this.artifical;
    }

    public boolean isRemoveInCellPossible() {
        return this.removeInCellPossible;
    }

    DataObject getDataObject() {
        return this.dataObject;
    }

    public DataObject getSequencedDataObject() {
        return this.sequencedDataObject;
    }

    boolean isAnyType() {
        return this.anyType;
    }

    Property getContainingProperty() {
        if (this.parent != null) {
            return this.parent.getProperty();
        }
        return null;
    }

    void setDataObject(DataObject dataObject) {
        this.dataObject = dataObject;
    }

    Object getPrimitive() {
        return this.primitive;
    }

    void setPrimitive(Object object) {
        if (this.wrapper != null) {
            this.wrapper.setMessage(object);
        } else if (this.wrapperDataObject != null) {
            this.wrapperDataObject.set("value", object);
        } else {
            this.primitive = object;
        }
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isSimplified() {
        return this.simplified;
    }

    public void setSimplified(boolean bl) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("IsSimplified: " + bl));
        }
        this.simplified = bl;
    }

    public boolean isArtifical() {
        return this.artifical;
    }

    public void setArtifical(boolean bl) {
        this.artifical = bl;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean isArray() {
        return this.array;
    }

    public boolean isInArray() {
        return this.inArray;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public boolean isSetPossible() {
        return this.setPossible;
    }

    public boolean isUnsetPossible() {
        return this.unsetPossible;
    }

    public boolean isBooleanField() {
        return this.booleanField;
    }

    public boolean isTextElement() {
        return this.textElement;
    }

    public boolean isWrapperDataObject() {
        return this.wrapperDataObjectType;
    }

    public boolean isNil() {
        return this.nil;
    }

    public SDOImplHelper getSDOImplHelper() {
        return this.sdoHelper;
    }

    public static class EmptyItem {
    }
}

