/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.jsf.handler;

import com.ibm.bpc.clientcore.ColumnInfo;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.jsf.handler.BPCListHandler;
import com.ibm.bpe.jsf.util.DynamicListComparator;
import com.ibm.bpe.jsf.util.ListComparator;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.faces.event.ActionEvent;

public class BPCListHandlerSortHelper {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2006, 2008.\n\n";
    private final BPCListHandler handler;
    private Map sortStatus = new HashMap();
    private SortToken token = null;

    BPCListHandlerSortHelper(BPCListHandler bPCListHandler) {
        this.handler = bPCListHandler;
    }

    void clear() {
        this.sortStatus.clear();
        this.token = null;
    }

    public void sortedBy(ActionEvent actionEvent) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        String string = (String)actionEvent.getComponent().getAttributes().get("bpcProperty");
        this.sort(string);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    public void sort(String string) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("property = " + string));
        }
        if (string == null) {
            return;
        }
        if (this.handler.items == null) {
            this.handler.refreshList(true);
        }
        if (this.handler.items == null) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"no model available therefore no sorting necessary");
            }
            return;
        }
        Integer n = (Integer)this.sortStatus.get(string);
        Integer n2 = n = n != null && n == ListComparator.DESCENDING ? ListComparator.ASCENDING : ListComparator.DESCENDING;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("sorting in " + (n.equals(ListComparator.DESCENDING) ? "descending " : "ascending ") + " order"));
        }
        Collections.sort(this.handler.items, new ListComparator(string, null, n));
        this.clear();
        this.sortStatus.put(string, n);
        this.token = new SortToken(string, n);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    public void sort(ColumnInfo columnInfo) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        if (columnInfo == null) {
            return;
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("property expression = " + columnInfo.getPropertyName()));
        }
        if (this.handler.items == null) {
            this.handler.refreshList(true);
        }
        if (this.handler.items == null) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"no model available therefore no sorting necessary");
            }
            return;
        }
        Integer n = (Integer)this.sortStatus.get(columnInfo.getPropertyName());
        Integer n2 = n = n != null && n == ListComparator.DESCENDING ? ListComparator.ASCENDING : ListComparator.DESCENDING;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("sorting in " + (n.equals(ListComparator.DESCENDING) ? "descending " : "ascending ") + " order"));
        }
        Collections.sort(this.handler.items, new DynamicListComparator(columnInfo, n));
        this.clear();
        this.sortStatus.put(columnInfo.getPropertyName(), n);
        this.token = new SortToken(columnInfo, n);
        this.handler.getSelectionHelper().clearHiddenSelection();
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    SortToken getSortToken() {
        return this.token;
    }

    void sort(SortToken sortToken) {
        if (sortToken != null) {
            Integer n = sortToken.getOrder();
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Sorting " + sortToken.getProperty() + " in order " + sortToken.getOrder()));
            }
            this.sortStatus.put(sortToken.getProperty(), n == ListComparator.DESCENDING ? ListComparator.ASCENDING : ListComparator.DESCENDING);
            if (sortToken.getColumnInfo() != null) {
                this.sort(sortToken.getColumnInfo());
            } else {
                this.sort(sortToken.getProperty());
            }
        }
    }

    public Integer getSortOrder(String string) {
        Integer n = (Integer)this.sortStatus.get(string);
        if (n == null) {
            n = ListComparator.NOSORTED;
        }
        return n;
    }

    static class SortToken {
        private String property = null;
        private Integer order = null;
        private ColumnInfo columnInfo = null;

        public SortToken(String string, Integer n) {
            this.property = string;
            this.order = n;
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Property: " + string + " Order: " + n));
            }
        }

        public SortToken(ColumnInfo columnInfo, Integer n) {
            this.columnInfo = columnInfo;
            this.order = n;
            String string = this.property = columnInfo != null ? columnInfo.getPropertyName() : null;
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Property (derived form ColumnInfo): " + this.property + " Order: " + n));
            }
        }

        public Integer getOrder() {
            return this.order;
        }

        public String getProperty() {
            return this.property;
        }

        public ColumnInfo getColumnInfo() {
            return this.columnInfo;
        }
    }
}

