/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.jsf.handler;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.jsf.handler.BPCListHandler;
import com.ibm.bpe.jsf.handler.BPCListHandlerPagingHelper;
import com.ibm.bpe.jsf.handler.ItemListener;
import com.ibm.bpe.jsf.util.FacesUtils;
import com.ibm.bpe.jsf.util.SelectionWrapper;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import java.util.Iterator;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UISelectBoolean;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ValueChangeEvent;

public class BPCListHandlerSelectionHelper {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2006, 2007.\n\n";
    private final BPCListHandler handler;
    private BPCListHandlerPagingHelper pagingHelper;
    int numberSelectedItems = 0;
    boolean selectAll = false;
    boolean checkboxEnabled = true;

    BPCListHandlerSelectionHelper(BPCListHandler bPCListHandler) {
        this.handler = bPCListHandler;
        this.pagingHelper = bPCListHandler.getPagingHelper();
    }

    void clear() {
        this.numberSelectedItems = 0;
    }

    public void clearVisibleSelection() {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        if (this.selectAll) {
            return;
        }
        if (this.handler.items != null) {
            int n;
            if (this.pagingHelper == null) {
                this.pagingHelper = this.handler.getPagingHelper();
            }
            if ((n = this.pagingHelper.getNumberDisplayedItems()) > 0) {
                int n2;
                for (int i = n2 = this.pagingHelper.getFirst(); i < n2 + n; ++i) {
                    SelectionWrapper selectionWrapper = (SelectionWrapper)this.handler.items.get(i);
                    if (!selectionWrapper.isSelected()) continue;
                    selectionWrapper.setSelected(false);
                    --this.numberSelectedItems;
                }
            }
        } else {
            this.numberSelectedItems = 0;
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    public void clearHiddenSelection() {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        if (this.selectAll) {
            return;
        }
        if (this.handler.items != null) {
            int n;
            if (this.pagingHelper == null) {
                this.pagingHelper = this.handler.getPagingHelper();
            }
            if ((n = this.pagingHelper.getNumberDisplayedItems()) > 0) {
                SelectionWrapper selectionWrapper;
                int n2;
                int n3 = this.pagingHelper.getFirst();
                int n4 = n3 + n - 1;
                int n5 = this.pagingHelper.getTotalNumberItems();
                for (n2 = 0; n2 < n3; ++n2) {
                    selectionWrapper = (SelectionWrapper)this.handler.items.get(n2);
                    if (!selectionWrapper.isSelected()) continue;
                    selectionWrapper.setSelected(false);
                    --this.numberSelectedItems;
                }
                for (n2 = n4 + 1; n2 < n5; ++n2) {
                    selectionWrapper = (SelectionWrapper)this.handler.items.get(n2);
                    if (!selectionWrapper.isSelected()) continue;
                    selectionWrapper.setSelected(false);
                    --this.numberSelectedItems;
                }
            } else {
                this.numberSelectedItems = 0;
            }
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    public void chooseItem(ActionEvent actionEvent) {
        UIComponent uIComponent;
        Object object;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        if ((object = this.calculateCurrentItem(uIComponent = actionEvent.getComponent())) == null) {
            return;
        }
        this.handler.currentItem = object;
        this.notifyItemListener(this.handler.getItemListener(), object);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    public void selectionChanged(ValueChangeEvent valueChangeEvent) throws AbortProcessingException {
        SelectionWrapper selectionWrapper;
        UISelectBoolean uISelectBoolean;
        UIData uIData;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        if ((uIData = (UIData)(uISelectBoolean = (UISelectBoolean)valueChangeEvent.getComponent()).findComponent("_bpc_table")) != null && (selectionWrapper = (SelectionWrapper)uIData.getRowData()) != null) {
            selectionWrapper.setSelected(uISelectBoolean.isSelected());
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Setting model immedately to " + uISelectBoolean.isSelected()));
            }
        }
        this.numberSelectedItems = uISelectBoolean.isSelected() ? ++this.numberSelectedItems : --this.numberSelectedItems;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    int calculatedSelectionState() {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        int n = 0;
        if (this.handler.items != null) {
            int n2;
            if (this.pagingHelper == null) {
                this.pagingHelper = this.handler.getPagingHelper();
            }
            if ((n2 = this.pagingHelper.getNumberDisplayedItems()) > 0) {
                int n3 = this.pagingHelper.getFirst();
                int n4 = n3 + n2;
                for (int i = n3; i < n4; ++i) {
                    if (!((SelectionWrapper)this.handler.items.get(i)).isSelected()) continue;
                    ++n;
                }
            }
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Number displayed items (" + n2 + "," + this.numberSelectedItems + ")"));
            }
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)Integer.toString(n));
        }
        return n;
    }

    public boolean isDisplayedItemsSelected() {
        int n;
        int n2 = this.calculatedSelectionState();
        if (this.pagingHelper == null) {
            this.pagingHelper = this.handler.getPagingHelper();
        }
        return (n = this.pagingHelper.getNumberDisplayedItems()) != 0 && n == n2;
    }

    public void setDisplayedItemsSelected(boolean bl) {
    }

    public void setSelectAll(boolean bl) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        this.selectAll = bl;
        if (!bl) {
            return;
        }
        this.numberSelectedItems = 0;
        if (this.handler.items != null) {
            int n = this.handler.items.size();
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    SelectionWrapper selectionWrapper = (SelectionWrapper)this.handler.items.get(i);
                    selectionWrapper.setSelected(true);
                    ++this.numberSelectedItems;
                }
            }
        } else {
            this.numberSelectedItems = 0;
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    public void setCheckboxEnabled(boolean bl) {
        this.checkboxEnabled = bl;
    }

    private Object calculateCurrentItem(UIComponent uIComponent) {
        UIData uIData = (UIData)uIComponent.findComponent("_bpc_table");
        if (uIData == null) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"No component with id _bpc_table has been found");
            }
            return null;
        }
        return ((SelectionWrapper)uIData.getRowData()).getObject();
    }

    private void notifyItemListener(List list, Object object) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        Iterator iterator = list.iterator();
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Listeners " + list.size()));
        }
        try {
            while (iterator.hasNext()) {
                ItemListener itemListener = (ItemListener)iterator.next();
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Notifying listener " + itemListener.getClass()));
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Item " + object));
                }
                itemListener.itemChanged(object);
            }
        }
        catch (ClientException clientException) {
            FacesUtils.showErrorPage(FacesContext.getCurrentInstance(), (Exception)((Object)clientException), true);
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }
}

