/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.jsf.handler;

import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.jsf.handler.BPCListHandler;
import com.ibm.bpe.jsf.handler.BPCListHandlerSelectionHelper;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;

public class BPCListHandlerPagingHelper {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2006, 2008.\n\n";
    private final BPCListHandler handler;
    private BPCListHandlerSelectionHelper selectionHelper;
    private int rows = 0;
    private int first = 0;
    private boolean isRowsDefByUser = false;

    BPCListHandlerPagingHelper(BPCListHandler bPCListHandler) {
        this.handler = bPCListHandler;
        this.selectionHelper = bPCListHandler.getSelectionHelper();
    }

    void clear() {
        this.first = 0;
    }

    private boolean showAll() {
        return this.rows == 0;
    }

    public String next() {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        if (!this.showAll() && this.isNextPossible()) {
            if (this.selectionHelper == null) {
                this.selectionHelper = this.handler.getSelectionHelper();
            }
            this.selectionHelper.clearVisibleSelection();
            this.first += this.rows;
            this.selectionHelper.calculatedSelectionState();
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
        return null;
    }

    public boolean isNextPossible() {
        if (this.showAll()) {
            return false;
        }
        if (this.handler.items == null) {
            return false;
        }
        return this.first + this.rows < this.handler.items.size();
    }

    public String previous() {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        if (!this.showAll() && this.isPreviousPossible()) {
            if (this.selectionHelper == null) {
                this.selectionHelper = this.handler.getSelectionHelper();
            }
            this.selectionHelper.clearVisibleSelection();
            this.first -= this.rows;
            if (this.first < 0) {
                this.first = 0;
            }
            this.selectionHelper.calculatedSelectionState();
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
        return null;
    }

    public boolean isPreviousPossible() {
        if (this.showAll()) {
            return false;
        }
        if (this.handler.items == null) {
            return false;
        }
        return this.first > 0;
    }

    public int getFirst() {
        return this.first;
    }

    public int getRows() {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)Integer.toString(this.rows));
        }
        return this.rows;
    }

    public int getTotalNumberItems() {
        return this.handler.items != null ? this.handler.items.size() : 0;
    }

    public int getNumberPages() {
        if (this.showAll()) {
            return 1;
        }
        int n = this.getTotalNumberItems();
        return (n + this.rows - 1) / this.rows;
    }

    public void setPageNumber(int n) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        if (n > this.getNumberPages()) {
            this.setFirst(0);
        } else {
            this.setFirst((n - 1) * this.rows);
        }
        if (this.selectionHelper == null) {
            this.selectionHelper = this.handler.getSelectionHelper();
        }
        this.selectionHelper.clearHiddenSelection();
        this.selectionHelper.calculatedSelectionState();
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    public int getPageNumber() {
        if (this.showAll()) {
            return 1;
        }
        return this.first / this.rows + 1;
    }

    public void setFirst(int n) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)Integer.toString(n));
        }
        this.first = this.showAll() ? n : n / this.rows * this.rows;
        if (this.selectionHelper == null) {
            this.selectionHelper = this.handler.getSelectionHelper();
        }
        this.selectionHelper.clearHiddenSelection();
        this.selectionHelper.calculatedSelectionState();
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    public void setRows(int n) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)Integer.toString(n));
        }
        this.rows = n;
        if (this.rows == 0) {
            this.setFirst(0);
        } else {
            this.setFirst(this.first);
        }
        if (this.selectionHelper == null) {
            this.selectionHelper = this.handler.getSelectionHelper();
        }
        this.selectionHelper.clearHiddenSelection();
        this.selectionHelper.calculatedSelectionState();
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    int getNumberDisplayedItems() {
        int n;
        if (this.showAll()) {
            return this.getTotalNumberItems();
        }
        int n2 = 0;
        int n3 = n = this.handler.items != null ? this.handler.items.size() : 0;
        if (this.first < n) {
            n2 = n - this.first;
            if (n2 > this.rows) {
                n2 = this.rows;
            }
        } else {
            n2 = 0;
        }
        return n2;
    }

    public int getNumberOfSelectedItems() {
        if (this.selectionHelper == null) {
            this.selectionHelper = this.handler.getSelectionHelper();
        }
        return this.selectionHelper.numberSelectedItems;
    }

    public boolean isCheckboxEnabled() {
        if (this.selectionHelper == null) {
            this.selectionHelper = this.handler.getSelectionHelper();
        }
        return this.selectionHelper.checkboxEnabled;
    }

    public boolean isRowsDefByUser() {
        return this.isRowsDefByUser;
    }

    public void setRowsDefByUser(boolean bl) {
        this.isRowsDefByUser = bl;
    }
}

