/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.jsf.handler;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.Localization;
import com.ibm.bpc.clientcore.Query;
import com.ibm.bpe.api.EngineNotAuthorizedException;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.jsf.component.impl.WidgetComponentBase;
import com.ibm.bpe.jsf.exception.QueryNotAvailableException;
import com.ibm.bpe.jsf.handler.BPCListHandlerPagingHelper;
import com.ibm.bpe.jsf.handler.BPCListHandlerSelectionHelper;
import com.ibm.bpe.jsf.handler.BPCListHandlerSortHelper;
import com.ibm.bpe.jsf.handler.ErrorHandler;
import com.ibm.bpe.jsf.handler.ItemListener;
import com.ibm.bpe.jsf.handler.ItemProvider;
import com.ibm.bpe.jsf.util.FacesUtils;
import com.ibm.bpe.jsf.util.LocaleUtils;
import com.ibm.bpe.jsf.util.Message;
import com.ibm.bpe.jsf.util.SelectionWrapper;
import com.ibm.bpe.util.Assert;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.task.api.NotAuthorizedException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;

public class BPCListHandler
implements ItemProvider,
ErrorHandler {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2007.\n\n";
    Query query = null;
    Object currentItem = null;
    List items = null;
    private String type = null;
    private String name = "";
    private List itemListener = new ArrayList();
    private BPCListHandlerPagingHelper pagingHelper = new BPCListHandlerPagingHelper(this);
    private BPCListHandlerSelectionHelper selectionHelper = new BPCListHandlerSelectionHelper(this);
    private BPCListHandlerSortHelper sortHelper = new BPCListHandlerSortHelper(this);
    private Map errorMap = new HashMap();
    private Message queryMessage = null;
    public static final String ATTRIBUTE_FOR_SORTING = "bpcProperty";
    private static final String EMPTY_LIST = "EMPTY_LIST";

    private void clear(boolean bl) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)("ResetErrorMap is: " + bl));
        }
        this.pagingHelper.clear();
        this.selectionHelper.clear();
        this.sortHelper.clear();
        this.items = null;
        this.queryMessage = null;
        if (bl) {
            this.errorMap.clear();
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    public void clearSelection() {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        if (!this.selectionHelper.selectAll) {
            if (this.items != null && this.items.size() > 0) {
                for (int i = 0; i < this.items.size(); ++i) {
                    SelectionWrapper selectionWrapper = (SelectionWrapper)this.items.get(i);
                    selectionWrapper.setSelected(false);
                }
            }
            this.selectionHelper.clear();
        }
        this.selectionHelper.calculatedSelectionState();
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    public List getItems() {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        if (this.items == null) {
            this.clear(true);
            this.executeRefresh();
        } else if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Using cached result");
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
        return this.items;
    }

    public String refreshList(boolean bl) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        BPCListHandlerSortHelper.SortToken sortToken = this.sortHelper.getSortToken();
        this.clear(bl);
        String string = this.executeRefresh();
        if (sortToken != null) {
            this.sortHelper.sort(sortToken);
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)string);
        }
        return string;
    }

    public String refreshList() {
        return this.refreshList(true);
    }

    private String executeRefresh() {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        if (this.queryMessage == null) {
            try {
                if (this.query != null) {
                    if (this.query instanceof Localization) {
                        Locale locale = LocaleUtils.getLocale();
                        ((Localization)this.query).setLocale(locale);
                    }
                    this.items = this.query.execute();
                    this.items = FacesUtils.wrapInSelectionHandler(this.items);
                    if (this.items == null || this.items.size() == 0) {
                        this.queryMessage = new WidgetComponentBase.InternalMessage(0, EMPTY_LIST);
                        this.items = new ArrayList();
                    }
                    this.selectionHelper.setSelectAll(this.selectionHelper.selectAll);
                    this.selectionHelper.calculatedSelectionState();
                } else {
                    if (BPCClientTrace.isTracing) {
                        BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"No Query set, returning empty list");
                    }
                    this.queryMessage = new WidgetComponentBase.ExceptionMessage((Throwable)((Object)new QueryNotAvailableException(new Object[0])));
                    this.items = new ArrayList();
                    this.selectionHelper.calculatedSelectionState();
                }
                return null;
            }
            catch (ClientException clientException) {
                Throwable throwable;
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_EVENT, (Throwable)clientException);
                }
                if ((throwable = clientException.getRootCause()) instanceof NotAuthorizedException || throwable instanceof EngineNotAuthorizedException) {
                    this.queryMessage = new WidgetComponentBase.ExceptionMessage(throwable);
                    return null;
                }
                FacesUtils.showErrorPage(FacesContext.getCurrentInstance(), (Exception)((Object)clientException), true);
                return "error";
            }
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("QueryMessage " + this.queryMessage + " available. Query not executed."));
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
        return null;
    }

    public String executeQuery() throws ClientException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        if (this.queryMessage == null) {
            if (this.query != null) {
                if (this.query instanceof Localization) {
                    Locale locale = LocaleUtils.getLocale();
                    ((Localization)this.query).setLocale(locale);
                }
                this.items = this.query.execute();
                this.items = FacesUtils.wrapInSelectionHandler(this.items);
                if (this.items == null || this.items.size() == 0) {
                    this.queryMessage = new WidgetComponentBase.InternalMessage(0, EMPTY_LIST);
                    this.items = new ArrayList();
                }
                this.selectionHelper.setSelectAll(this.selectionHelper.selectAll);
                this.selectionHelper.calculatedSelectionState();
            } else {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"No Query set, returning empty list");
                }
                this.queryMessage = new WidgetComponentBase.ExceptionMessage((Throwable)((Object)new QueryNotAvailableException(new Object[0])));
                this.items = new ArrayList();
                this.selectionHelper.calculatedSelectionState();
            }
            return null;
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("QueryMessage " + this.queryMessage + " available. Query not executed."));
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
        return null;
    }

    public void setQuery(Query query) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)query);
        }
        String string = query.getType();
        String string2 = this.type;
        Assert.assertion((string == null || string2 == null || string.equals(string2) ? 1 : 0) != 0, (String)("The type of the query \"" + string + "\" must match the type of the handler \"" + string2 + "\" if both are specified"));
        this.query = query;
        this.clear(true);
    }

    public Query getQuery() {
        return this.query;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setType(String string) {
        this.type = string;
        String string2 = this.query != null ? this.query.getType() : null;
        String string3 = this.type;
        Assert.assertion((string2 == null || string3 == null || string2.equals(string3) ? 1 : 0) != 0, (String)("The type of the query \"" + string2 + "\" must match the type of the handler \"" + string3 + "\" if both are specified"));
    }

    public String getType() {
        return this.type;
    }

    public Object getItem() {
        return this.currentItem;
    }

    public List getSelectedItems() {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this.items == null) {
            return new ArrayList();
        }
        int n = 0;
        for (SelectionWrapper selectionWrapper : this.items) {
            if (!selectionWrapper.isSelected() && this.selectionHelper.checkboxEnabled) continue;
            arrayList.add(selectionWrapper.getObject());
            ++n;
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)Integer.toString(n));
        }
        return arrayList;
    }

    public List getItemListener() {
        return this.itemListener;
    }

    public void setItemListener(List list) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)("SelectionListener are set to " + list));
        }
        this.itemListener = list;
        this.itemListener = this.adaptItemListenerList(this.itemListener);
    }

    public void addItemListener(ItemListener itemListener) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)("Adding ItemListener " + itemListener));
        }
        this.itemListener.add(itemListener);
        this.itemListener = this.adaptItemListenerList(this.itemListener);
    }

    public Map getErrors() {
        if (this.errorMap == null) {
            this.errorMap = new HashMap();
        }
        return this.errorMap;
    }

    public void setErrors(Map map) {
        this.errorMap = map;
    }

    public Message getQueryMessage() {
        return this.queryMessage;
    }

    private List adaptItemListenerList(List list) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = list.iterator();
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Application application = facesContext.getApplication();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof ItemListener) {
                arrayList.add(e);
                continue;
            }
            String string = (String)e;
            ValueBinding valueBinding = application.createValueBinding("#{" + string + "}");
            if (valueBinding == null) continue;
            arrayList.add(new ItemListenerProxy(valueBinding));
        }
        return arrayList;
    }

    public BPCListHandlerPagingHelper getPagingHelper() {
        return this.pagingHelper;
    }

    public BPCListHandlerSelectionHelper getSelectionHelper() {
        return this.selectionHelper;
    }

    public BPCListHandlerSortHelper getSortHelper() {
        return this.sortHelper;
    }

    public boolean getNotEmpty() {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("# of items: " + (this.items == null ? 0 : this.items.size())));
        }
        return this.items != null && !this.items.isEmpty();
    }

    static class ItemListenerProxy
    implements ItemListener {
        private ValueBinding binding = null;
        private ItemListener itemListener = null;

        public ItemListenerProxy(ValueBinding valueBinding) {
            Assert.assertion((valueBinding != null ? 1 : 0) != 0, (String)"Binding should not be null");
            this.binding = valueBinding;
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Creating an instance for " + this.binding.getExpressionString()));
            }
        }

        public void itemChanged(Object object) throws ClientException {
            if (this.itemListener == null) {
                this.itemListener = this.createItemListener();
            }
            if (this.itemListener != null) {
                this.itemListener.itemChanged(object);
            } else if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("No ItemListener could not be evaluated using " + this.binding.getExpressionString()));
            }
        }

        private ItemListener createItemListener() {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.entry((Object)("Creating ItemListener for " + this.binding.getExpressionString()));
            }
            ItemListener itemListener = (ItemListener)this.binding.getValue(FacesContext.getCurrentInstance());
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.exit((Object)itemListener);
            }
            return itemListener;
        }
    }
}

