/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.jsf.handler;

import com.ibm.bpc.clientcore.converter.SimpleConverter;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.jsf.handler.ItemListener;
import com.ibm.bpe.jsf.handler.ItemProvider;
import com.ibm.bpe.jsf.util.MetaInformation;
import com.ibm.bpe.jsf.util.PropertyValue;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.List;

public class BPCDetailsHandler
implements ItemListener,
ItemProvider {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005.\n\n";
    private Object _model = null;
    private String _type = null;

    public Object getModel() {
        return this._model;
    }

    public void itemChanged(Object object) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Follow-on item of list related with " + this + " has been changed"));
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("New follow-on item: " + object));
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"model changed");
        }
        this._model = object;
    }

    public String getType() {
        return this._type;
    }

    public void setType(String string) {
        this._type = string;
    }

    public List getPropertyList() {
        if (this._model == null) {
            return new ArrayList();
        }
        Class<?> clazz = this._model.getClass();
        BeanInfo beanInfo = null;
        MetaInformation metaInformation = null;
        try {
            beanInfo = Introspector.getBeanInfo(this._model.getClass());
        }
        catch (IntrospectionException introspectionException) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)(this._model + " does not allow introspection"), (Object)introspectionException);
            }
            return new ArrayList();
        }
        try {
            metaInformation = new MetaInformation(clazz);
        }
        catch (Exception exception) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"MetaInformation for model could not be retrieved", (Object)exception);
            }
            return new ArrayList();
        }
        ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>();
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            if (metaInformation.isPropertyValid(propertyDescriptorArray[i].getName())) {
                String string = metaInformation.getLabel(propertyDescriptorArray[i].getName());
                SimpleConverter simpleConverter = metaInformation.getSimpleConverter(propertyDescriptorArray[i].getName());
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)(simpleConverter + " is the converter for " + propertyDescriptorArray[i].getName()));
                }
                arrayList.add(new PropertyValue(propertyDescriptorArray[i], this._model, string, simpleConverter));
                continue;
            }
            if (!BPCClientTrace.isTracing) continue;
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Ignoring property " + propertyDescriptorArray[i].getName()));
        }
        return arrayList;
    }

    public List getSelectedItems() {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        int n = 0;
        ArrayList<Object> arrayList = new ArrayList<Object>(1);
        if (this._model != null) {
            arrayList.add(this._model);
            ++n;
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)Integer.toString(n));
        }
        return arrayList;
    }
}

