/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.jsf.converter;

import com.ibm.bpc.clientcore.converter.NumberUtils;
import com.ibm.bpc.clientcore.exception.InvalidNumberInputException;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.jsf.util.LocaleUtils;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import java.util.Locale;
import javax.faces.application.FacesMessage;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;

public abstract class NLSNumbersJSFConverter
implements Converter,
StateHolder {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2006, 2009.\n\n";
    private String typeOfNumericValue;
    private boolean optional = false;

    public NLSNumbersJSFConverter() {
    }

    public NLSNumbersJSFConverter(String string) {
        this.typeOfNumericValue = string;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean bl) {
        this.optional = bl;
    }

    public Object getAsObject(FacesContext facesContext, UIComponent uIComponent, String string) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)("UIComponent: " + (uIComponent == null ? "null" : uIComponent.getId()) + " Input: " + string));
        }
        Object object = null;
        if (!this.isOptional() || this.isOptional() && string != null && !"".equals(string)) {
            try {
                object = NumberUtils.getAsObject((String)this.typeOfNumericValue, (String)string, (Locale)facesContext.getExternalContext().getRequestLocale());
            }
            catch (InvalidNumberInputException invalidNumberInputException) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Could not convert input string:" + string + " into an Integer"));
                }
                FacesMessage facesMessage = new FacesMessage(FacesMessage.SEVERITY_ERROR, null, invalidNumberInputException.getMessage(LocaleUtils.getLocale()));
                throw new ConverterException(facesMessage);
            }
        }
        if (BPCClientTrace.isTracing) {
            String string2 = "Returned value: " + object;
            if (object != null) {
                string2 = string2 + " Returned object type: " + object.getClass();
            }
            BPCClientTrace.exit((Object)string2);
        }
        return object;
    }

    public String getAsString(FacesContext facesContext, UIComponent uIComponent, Object object) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)("UIComponent: " + (uIComponent == null ? "null" : uIComponent.getId()) + " Object: " + object));
        }
        String string = null;
        if (object != null) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Object of class " + object.getClass().getName()));
            }
            if (object instanceof String) {
                string = (String)object;
            } else {
                string = NumberUtils.getAsString((String)this.typeOfNumericValue, (Object)object, (Locale)facesContext.getExternalContext().getRequestLocale());
                if (string == null) {
                    string = object.toString();
                }
            }
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit(string);
        }
        return string;
    }

    public void restoreState(FacesContext facesContext, Object object) {
        Object[] objectArray = (Object[])object;
        this.typeOfNumericValue = (String)objectArray[0];
        this.optional = (Boolean)objectArray[1];
    }

    public Object saveState(FacesContext facesContext) {
        Object[] objectArray = new Object[]{this.typeOfNumericValue, new Boolean(this.optional)};
        return objectArray;
    }

    public boolean isTransient() {
        return false;
    }

    public void setTransient(boolean bl) {
        throw new UnsupportedOperationException();
    }
}

