/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.jsf.converter;

import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.util.Assert;
import java.text.StringCharacterIterator;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;

public class HtmlOutputTextConverter
implements Converter {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2008, 2009.\n\n";
    public static char CHAR_CR = (char)13;
    public static char CHAR_LF = (char)10;
    public static char CHAR_TAB = (char)9;
    public static char CHAR_SPACE = (char)32;
    public static char CHAR_LT = (char)60;
    public static char CHAR_GT = (char)62;
    public static String HTML_BR = "<br />";
    public static String HTML_NBSP = "&nbsp;";
    public static String HTML_LT = "&lt;";
    public static String HTML_GT = "&gt;";

    public Object getAsObject(FacesContext facesContext, UIComponent uIComponent, String string) {
        Assert.assertion((boolean)true, (String)"This converter should only be used for <h:outputText> tags!");
        return null;
    }

    public String getAsString(FacesContext facesContext, UIComponent uIComponent, Object object) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)object);
        }
        String string = "";
        if (object instanceof String) {
            string = HtmlOutputTextConverter.convertToHtml((String)object);
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)string);
        }
        return string;
    }

    private static String convertToHtml(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() * 3);
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.current();
        boolean bl = false;
        int n = 0;
        while (c != '\uffff') {
            if (bl) {
                bl = false;
                if (c == CHAR_LF) {
                    c = stringCharacterIterator.next();
                    continue;
                }
            }
            if (c == CHAR_CR) {
                stringBuffer.append(HTML_BR);
                n = 0;
                bl = true;
            } else if (c == CHAR_LF) {
                stringBuffer.append(HTML_BR);
                n = 0;
            } else if (c == CHAR_SPACE) {
                stringBuffer.append(HTML_NBSP);
                ++n;
            } else if (c == CHAR_TAB) {
                for (int i = 4 - n % 4; i > 0; --i) {
                    stringBuffer.append(HTML_NBSP);
                    ++n;
                }
            } else if (c == CHAR_LT) {
                stringBuffer.append(HTML_LT);
                ++n;
            } else if (c == CHAR_GT) {
                stringBuffer.append(HTML_GT);
                ++n;
            } else {
                stringBuffer.append(c);
                ++n;
            }
            c = stringCharacterIterator.next();
        }
        return stringBuffer.toString();
    }
}

