/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.jsf.component.taglib;

import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.jsf.component.CommandBarComponent;
import com.ibm.bpe.jsf.component.impl.WidgetComponentBase;
import com.ibm.bpe.jsf.component.taglib.BaseTag;
import com.ibm.bpe.jsf.component.taglib.CommandTag;
import com.ibm.bpe.jsf.exception.ConfigurationException;
import com.ibm.bpe.util.Assert;
import com.ibm.bpe.util.MessageLogger;
import java.util.ArrayList;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;

public class CommandBarTag
extends BaseTag {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";
    private String _model;
    private String _styleClass;
    private String _buttonStyleClass;
    private ArrayList _actionTags = new ArrayList();

    void addCommand(CommandTag.CommandDefinition commandDefinition) {
        this._actionTags.add(commandDefinition);
    }

    public String getComponentType() {
        return "CommandBarComponent";
    }

    public String getRendererType() {
        return null;
    }

    public String getModel() {
        return this._model;
    }

    public void setModel(String string) {
        this._model = string;
    }

    public String getStyleClass() {
        return this._styleClass;
    }

    public void setStyleClass(String string) {
        this._styleClass = string;
    }

    public String getButtonStyleClass() {
        return this._buttonStyleClass;
    }

    public void setButtonStyleClass(String string) {
        this._buttonStyleClass = string;
    }

    void startPopulation(WidgetComponentBase widgetComponentBase) throws ConfigurationException {
    }

    void finishPopulation(WidgetComponentBase widgetComponentBase) throws ConfigurationException {
        String string;
        String string2 = string = widgetComponentBase != null ? widgetComponentBase.getClientId(FacesContext.getCurrentInstance()) : "-";
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)(this.getComponentType() + " : " + string));
        }
        Assert.assertion((boolean)(widgetComponentBase instanceof CommandBarComponent), (String)(widgetComponentBase.getClass().getName() + " <> com.ibm.bpe.jsf.component.CommandBarComponent"));
        FacesContext facesContext = this.getFacesContext();
        Application application = facesContext.getApplication();
        CommandBarComponent commandBarComponent = (CommandBarComponent)widgetComponentBase;
        CommandBarTag.add(application, widgetComponentBase, "STYLECLASS", this._styleClass);
        CommandBarTag.add(application, widgetComponentBase, "MODEL", this._model);
        try {
            for (CommandTag.CommandDefinition commandDefinition : this._actionTags) {
                String string3 = commandDefinition.getCommandID();
                String string4 = string3 != null ? string3.replaceAll(" ", "_") : null;
                commandBarComponent.addCommandButton(commandDefinition.getCommandClass(), commandDefinition.getCommandID(), commandDefinition.getAction(), commandDefinition.getContext(), string4, commandDefinition.getErrorTarget(), commandDefinition.getActionListener());
                CommandBarTag.add(application, widgetComponentBase, "CURRENT_ACTIONID", commandDefinition.getCommandID());
                CommandBarTag.add(application, widgetComponentBase, "CURRENT_LABEL", commandDefinition.getLabel());
                if (commandDefinition.getRendered() != null) {
                    CommandBarTag.addBooleanValue(application, widgetComponentBase, "CURRENT_RENDERED", commandDefinition.getRendered(), new Boolean(true));
                }
                if (commandDefinition.getImmediate() != null) {
                    CommandBarTag.addBooleanValue(application, widgetComponentBase, "CURRENT_IMMEDIATE", commandDefinition.getImmediate(), new Boolean(true));
                }
                if (commandDefinition.getStyleClass() != null) {
                    CommandBarTag.add(application, widgetComponentBase, "BUTTONSTYLECLASS", commandDefinition.getStyleClass());
                    continue;
                }
                CommandBarTag.add(application, widgetComponentBase, "BUTTONSTYLECLASS", this._buttonStyleClass);
            }
        }
        catch (ConfigurationException configurationException) {
            MessageLogger messageLogger = MessageLogger.newMessageLogger((String)BPCClientTrace.class.getName());
            messageLogger.message(MessageLogger.TYPE_ERROR, configurationException.getLocalizedMessage());
            throw configurationException;
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)(this.getComponentType() + " : " + string));
        }
    }

    public void release() {
        super.release();
        this._model = null;
        this._styleClass = null;
        this._buttonStyleClass = null;
        this._actionTags = null;
    }
}

