/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.jsf.component.taglib;

import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.jsf.component.impl.AssemblyEntity;
import com.ibm.bpe.jsf.component.impl.WidgetComponentBase;
import com.ibm.bpe.jsf.exception.ConfigurationException;
import com.ibm.bpe.util.Assert;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.webapp.UIComponentBodyTag;
import javax.servlet.jsp.JspException;

public abstract class BaseTag
extends UIComponentBodyTag {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2007.\n\n";
    private boolean _ongoingInitialisation = false;
    private WidgetComponentBase _component = null;

    public static void add(Application application, AssemblyEntity assemblyEntity, String string, Object object) {
        if (object != null) {
            if (object instanceof String && BaseTag.isValueReference((String)((String)object))) {
                assemblyEntity.addValueBinding(string, application.createValueBinding((String)object));
            } else if (object instanceof ValueBinding) {
                assemblyEntity.addValueBinding(string, (ValueBinding)object);
            } else if (object instanceof MethodBinding) {
                assemblyEntity.addMethodBinding(string, (MethodBinding)object);
            } else if (object instanceof Converter) {
                assemblyEntity.addConverter(string, (Converter)object);
            } else {
                assemblyEntity.addAttribute(string, object);
            }
        }
    }

    public static void addBooleanValue(Application application, AssemblyEntity assemblyEntity, String string, String string2, Boolean bl) {
        if (string2 != null) {
            if (BaseTag.isValueReference((String)string2)) {
                BaseTag.add(application, assemblyEntity, string, string2);
            } else {
                Boolean bl2 = new Boolean(string2);
                BaseTag.add(application, assemblyEntity, string, bl2);
            }
        } else if (bl != null) {
            BaseTag.add(application, assemblyEntity, string, bl);
        }
    }

    public int doStartTag() throws JspException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)this.getComponentType());
        }
        int n = 0;
        try {
            this._ongoingInitialisation = false;
            n = super.doStartTag();
        }
        catch (Error error) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_EVENT, (String)"Error encountered: ", (Object)error);
            }
            throw error;
        }
        catch (RuntimeException runtimeException) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_EVENT, (String)"RuntimeException encountered: ", (Object)runtimeException);
            }
            throw runtimeException;
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)this.getComponentType());
        }
        return n;
    }

    protected void setProperties(UIComponent uIComponent) {
        String string;
        String string2 = string = uIComponent != null ? uIComponent.getClientId(FacesContext.getCurrentInstance()) : "-";
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)(this.getComponentType() + " : " + string));
        }
        try {
            super.setProperties(uIComponent);
            Assert.assertion((boolean)(uIComponent instanceof WidgetComponentBase), (String)(uIComponent.getClass().getName() + " <> WigdetComponentBase "));
            this._ongoingInitialisation = true;
            this._component = (WidgetComponentBase)uIComponent;
            this._component.createSubTree();
            try {
                this.startPopulation(this._component);
            }
            catch (ConfigurationException configurationException) {
                this._component.setPendingException(configurationException);
            }
        }
        catch (Error error) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_EVENT, (String)"Error: ", (Object)error);
            }
            throw error;
        }
        catch (RuntimeException runtimeException) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_EVENT, (String)"RuntimeException: ", (Object)runtimeException);
            }
            throw runtimeException;
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)(this.getComponentType() + " : " + string));
        }
    }

    public int doEndTag() throws JspException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)this.getComponentType());
        }
        int n = 0;
        try {
            if (this._ongoingInitialisation) {
                if (this._component != null) {
                    try {
                        this.finishPopulation(this._component);
                        this._component.finishComponentTree();
                    }
                    catch (ConfigurationException configurationException) {
                        this._component.setPendingException(configurationException);
                    }
                } else if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"No further population since component == null");
                }
            } else if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"No further population since UIComponentTag.setProperties has not been called");
            }
            this._ongoingInitialisation = false;
            this._component = null;
            n = super.doEndTag();
        }
        catch (Error error) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_EVENT, (String)"Error encountered: ", (Object)error);
            }
            throw error;
        }
        catch (RuntimeException runtimeException) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_EVENT, (String)"RuntimeException encountered: ", (Object)runtimeException);
            }
            throw runtimeException;
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)this.getComponentType());
        }
        return n;
    }

    public void release() {
        this._component = null;
        this._ongoingInitialisation = false;
        super.release();
    }

    abstract void startPopulation(WidgetComponentBase var1) throws ConfigurationException;

    abstract void finishPopulation(WidgetComponentBase var1) throws ConfigurationException;
}

