/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.jsf.component.impl;

import com.ibm.bpe.api.ProcessError;
import com.ibm.bpe.api.ProcessException;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.jsf.component.impl.AssemblyEntity;
import com.ibm.bpe.jsf.component.impl.AssemblyHelper;
import com.ibm.bpe.jsf.component.impl.AssemblyUtils;
import com.ibm.bpe.jsf.component.impl.MessageBoxComponent;
import com.ibm.bpe.jsf.util.FacesIntrospector;
import com.ibm.bpe.jsf.util.FacesUtils;
import com.ibm.bpe.jsf.util.LocaleUtils;
import com.ibm.bpe.jsf.util.Message;
import com.ibm.bpe.util.Assert;
import com.ibm.bpe.util.MessageLogger;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.task.api.TaskError;
import com.ibm.task.api.TaskException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.faces.application.Application;
import javax.faces.component.NamingContainer;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;

public abstract class WidgetComponentBase
extends UIComponentBase
implements AssemblyEntity,
NamingContainer,
StateHolder {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";
    private Map _targetMap = new HashMap();
    private String _family = "javax.faces.Table";
    private Message _pendingMessage = null;
    private Message _lastPendingMessage = null;
    private Boolean _keepMessage = Boolean.FALSE;
    private Boolean _showMessageBoxAndDefaultRendering = Boolean.FALSE;
    protected boolean showMessageBoxAndChild = false;
    static final String MESSAGE_BOX_VAR = "messageInfo";
    static final String MESSAGE_BOX_ID = "messageBox";
    static final String SESSION_PARAM_PENDING_MESSAGE_CLIENT_ID = "PENDING_MESSAGE_CLIENT_ID";
    static final String SESSION_PARAM_PENDING_MESSAGE = "PENDING_MESSAGE";
    protected AssemblyHelper.AssemblyData _assemblyData = null;

    protected abstract UIComponent createComponentTree();

    public void init(Map map) {
        FacesContext facesContext;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        if ((facesContext = FacesContext.getCurrentInstance()) != null) {
            FacesIntrospector.getFacesIntrospector();
            this._targetMap.put("THIS", this);
            this._assemblyData = new AssemblyHelper.AssemblyData(this._targetMap, (UIComponent)this, map);
        } else if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_EVENT, (String)"No Faces Context available. There seems to be no JSF container");
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void createSubTree() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Application application = facesContext.getApplication();
        UIViewRoot uIViewRoot = facesContext.getViewRoot();
        MessageBoxComponent messageBoxComponent = (MessageBoxComponent)AssemblyUtils.createUIComponent(application, uIViewRoot, "impl.MessageBox", MESSAGE_BOX_ID);
        messageBoxComponent.setRendered(false);
        messageBoxComponent.setValueBinding("value", application.createValueBinding("#{messageInfo}"));
        this.getChildren().add(messageBoxComponent);
        UIComponent uIComponent = this.createComponentTree();
        if (uIComponent != null) {
            this.getChildren().add(uIComponent);
        }
    }

    public UIComponent getSubTree() {
        List list = this.getChildren();
        Iterator iterator = list.iterator();
        UIComponent uIComponent = null;
        while (iterator.hasNext() && (uIComponent = (UIComponent)iterator.next()) instanceof MessageBoxComponent) {
        }
        return uIComponent;
    }

    public void addAttribute(String string, Object object) {
        Assert.assertion((this._assemblyData != null ? 1 : 0) != 0, (String)"No AssemblyData object set: Please call init() in the constructor");
        AssemblyHelper.addAttribute(this._assemblyData, string, object);
    }

    public void addValueBinding(String string, ValueBinding valueBinding) {
        Assert.assertion((this._assemblyData != null ? 1 : 0) != 0, (String)"No AssemblyData object set: Please call init() in the constructor");
        AssemblyHelper.addValueBinding(this._assemblyData, string, valueBinding);
    }

    public void addMethodBinding(String string, MethodBinding methodBinding) {
        Assert.assertion((this._assemblyData != null ? 1 : 0) != 0, (String)"No AssemblyData object set: Please call init() in the constructor");
        AssemblyHelper.addMethodBinding(this._assemblyData, string, methodBinding);
    }

    public void addConverter(String string, Converter converter) {
        Assert.assertion((this._assemblyData != null ? 1 : 0) != 0, (String)"No AssemblyData object set: Please call init() in the constructor");
        AssemblyHelper.addConverter(this._assemblyData, string, converter);
    }

    public void finishComponentTree() {
        Assert.assertion((this._assemblyData != null ? 1 : 0) != 0, (String)"No AssemblyData object set: Please call init() in the constructor");
        AssemblyHelper.finishComponentTree(this._assemblyData);
        this._assemblyData = null;
    }

    public UIComponent getRoot() {
        return this;
    }

    public void processDecodes(FacesContext facesContext) {
        if (this._lastPendingMessage != null) {
            this.setMessageInfo(facesContext, this._lastPendingMessage);
        }
        super.processDecodes(facesContext);
        if (this._lastPendingMessage != null) {
            this.removeMessageInfo(facesContext);
        }
    }

    public void processValidators(FacesContext facesContext) {
        if (this._lastPendingMessage != null) {
            this.setMessageInfo(facesContext, this._lastPendingMessage);
        }
        super.processValidators(facesContext);
        if (this._lastPendingMessage != null) {
            this.removeMessageInfo(facesContext);
        }
    }

    public void processUpdates(FacesContext facesContext) {
        if (this._lastPendingMessage != null) {
            this.setMessageInfo(facesContext, this._lastPendingMessage);
        }
        super.processUpdates(facesContext);
        if (this._lastPendingMessage != null) {
            this.removeMessageInfo(facesContext);
        }
    }

    public void restoreState(FacesContext facesContext, Object object) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)(this.getTraceIdentifier() + this));
        }
        Object object2 = ((Object[])object)[0];
        this._lastPendingMessage = (Message)((Object[])object)[1];
        this._showMessageBoxAndDefaultRendering = (Boolean)((Object[])object)[2];
        this._keepMessage = (Boolean)((Object[])object)[3];
        super.restoreState(facesContext, object2);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)this.getTraceIdentifier());
        }
    }

    public Object saveState(FacesContext facesContext) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)(this.getTraceIdentifier() + this));
        }
        Object object = super.saveState(facesContext);
        Object[] objectArray = new Object[]{object, this._pendingMessage, this._showMessageBoxAndDefaultRendering, this._keepMessage};
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)this.getTraceIdentifier());
        }
        return objectArray;
    }

    public void encodeBegin(FacesContext facesContext) throws IOException {
        Map map;
        String string;
        FacesContext facesContext2;
        if (this._pendingMessage == null && (facesContext2 = FacesContext.getCurrentInstance()) != null && (string = (String)(map = facesContext2.getExternalContext().getSessionMap()).get(SESSION_PARAM_PENDING_MESSAGE_CLIENT_ID)) != null && string.equals(this.getClientId(facesContext2))) {
            this._pendingMessage = (Message)map.get(SESSION_PARAM_PENDING_MESSAGE);
            if (this._pendingMessage != null) {
                this._keepMessage = Boolean.TRUE;
                map.remove(SESSION_PARAM_PENDING_MESSAGE_CLIENT_ID);
                map.remove(SESSION_PARAM_PENDING_MESSAGE);
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Retrieved pending message " + string + " from session: " + this._pendingMessage.getMessage()));
                }
            }
        }
        this._lastPendingMessage = this._pendingMessage;
        if (this._keepMessage.booleanValue()) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Keeping message");
            }
            this._keepMessage = Boolean.FALSE;
        } else {
            this._pendingMessage = null;
        }
        if (this._lastPendingMessage != null) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Last pending message: " + this._lastPendingMessage.getMessage()));
            }
            this.setMessageInfo(facesContext, this._lastPendingMessage);
            this.prepare(true);
        } else {
            this.prepare(false);
        }
    }

    public void encodeChildren(FacesContext facesContext) throws IOException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)this.getTraceIdentifier());
        }
        for (UIComponent uIComponent : this.getChildren()) {
            if (!uIComponent.isRendered()) continue;
            this.encodeRecursive(facesContext, uIComponent);
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)this.getTraceIdentifier());
        }
    }

    public void encodeEnd(FacesContext facesContext) throws IOException {
        if (this._lastPendingMessage != null) {
            this.removeMessageInfo(facesContext);
        }
    }

    protected void encodeRecursive(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)this.getTraceIdentifier());
        }
        if (!uIComponent.isRendered()) {
            return;
        }
        uIComponent.encodeBegin(facesContext);
        if (uIComponent.getRendersChildren()) {
            uIComponent.encodeChildren(facesContext);
        } else {
            for (UIComponent uIComponent2 : uIComponent.getChildren()) {
                this.encodeRecursive(facesContext, uIComponent2);
            }
        }
        uIComponent.encodeEnd(facesContext);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)this.getTraceIdentifier());
        }
    }

    public String getFamily() {
        return this._family;
    }

    private void pruneSubTree(UIComponent uIComponent) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)this.getTraceIdentifier());
        }
        List list = uIComponent.getChildren();
        list.clear();
        Map map = uIComponent.getFacets();
        map.clear();
        Assert.assertion((uIComponent.getChildCount() == 0 ? 1 : 0) != 0, (String)("Component (" + uIComponent + ") must not have any children after pruning"));
        Assert.assertion((boolean)uIComponent.getFacets().isEmpty(), (String)("Component (" + uIComponent + ") must not have any facets after pruning"));
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)this.getTraceIdentifier());
        }
    }

    protected void setShowMessageBoxAndDefaultRendering(boolean bl) {
        this._showMessageBoxAndDefaultRendering = new Boolean(bl);
    }

    public void setPendingException(ProcessException processException) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)this.getTraceIdentifier());
        }
        if (processException == null) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.exit((Object)this.getTraceIdentifier());
            }
            return;
        }
        MessageLogger messageLogger = MessageLogger.newMessageLogger((String)BPCClientTrace.class.getName());
        messageLogger.exception(MessageLogger.TYPE_ERROR, (Throwable)processException);
        this.setMessage(new ExceptionMessage((Throwable)processException));
        FacesContext.getCurrentInstance().renderResponse();
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)this.getTraceIdentifier());
        }
    }

    public void setMessage(Message message) {
        block17: {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.entry((Object)(this.getTraceIdentifier() + this));
            }
            if (message == null) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.exit((Object)this.getTraceIdentifier());
                }
                return;
            }
            if (this._pendingMessage == null) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Setting pending message to \"" + message.getMessage() + "\""));
                }
                this._pendingMessage = message;
                try {
                    Object object;
                    Object object2;
                    FacesContext facesContext = FacesContext.getCurrentInstance();
                    if (facesContext != null) {
                        Object v;
                        object2 = facesContext.getExternalContext().getRequestParameterMap();
                        object = object2.get("keepMessageOnce");
                        if (object instanceof String && object.equals("true")) {
                            this._keepMessage = Boolean.TRUE;
                            if (BPCClientTrace.isTracing) {
                                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Activate keepMessageOnce mode");
                            }
                        }
                        if ((v = object2.get("noCommandBarErrors")) instanceof String && v.equals("true")) {
                            this._pendingMessage = null;
                            this._lastPendingMessage = null;
                            if (BPCClientTrace.isTracing) {
                                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Request to not show command bar messages");
                            }
                        }
                    }
                    if (this._keepMessage.booleanValue() && this._pendingMessage != null) {
                        object2 = this.getClientId(facesContext);
                        if (BPCClientTrace.isTracing) {
                            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Store pending message for " + (String)object2 + " in session: " + this._pendingMessage.getMessage()));
                        }
                        object = facesContext.getExternalContext().getSessionMap();
                        object.put((String)SESSION_PARAM_PENDING_MESSAGE_CLIENT_ID, (Object)object2);
                        object.put(SESSION_PARAM_PENDING_MESSAGE, this._pendingMessage);
                    }
                    break block17;
                }
                catch (Throwable throwable) {
                    if (BPCClientTrace.isTracing) {
                        BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_EVENT, (Throwable)throwable);
                    }
                    break block17;
                }
            }
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Ignoring message \"" + message.getMessage() + "\""));
            }
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)this.getTraceIdentifier());
        }
    }

    protected Message getPendingMessage() {
        return this._pendingMessage;
    }

    private void prepare(boolean bl) {
        UIComponent uIComponent;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)this.getTraceIdentifier());
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("shown: " + Boolean.valueOf(bl)));
        }
        if ((uIComponent = this.findComponent(MESSAGE_BOX_ID)) == null && BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Could not find a child component with id messageBox");
        }
        List list = this.getChildren();
        for (UIComponent uIComponent2 : list) {
            if (uIComponent2 == uIComponent) continue;
            if (bl && !this._showMessageBoxAndDefaultRendering.booleanValue()) {
                uIComponent2.setRendered(this.showMessageBoxAndChild);
                continue;
            }
            uIComponent2.setRendered(true);
        }
        if (bl) {
            uIComponent.setRendered(true);
        } else {
            uIComponent.setRendered(false);
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)this.getTraceIdentifier());
        }
    }

    private void setMessageInfo(FacesContext facesContext, Message message) {
        Assert.assertion((message != null ? 1 : 0) != 0, (String)"The message must not be null");
        Map map = facesContext.getExternalContext().getRequestMap();
        map.put(MESSAGE_BOX_VAR, message);
    }

    public static boolean renderMessageBox(UIComponent uIComponent, ProcessException processException) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)processException);
        }
        boolean bl = false;
        while (uIComponent != null && !(uIComponent instanceof WidgetComponentBase)) {
            uIComponent = uIComponent.getParent();
        }
        if (uIComponent != null) {
            ((WidgetComponentBase)uIComponent).setPendingException(processException);
            bl = true;
        } else if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)(processException + " will be ignored since on WigdetComponentBase parent could be found"));
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
        return bl;
    }

    private void removeMessageInfo(FacesContext facesContext) {
        Map map = facesContext.getExternalContext().getRequestMap();
        map.remove(MESSAGE_BOX_VAR);
    }

    public void register(String string, Object object) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)string, (Object)object);
        }
        Assert.assertion((this._assemblyData != null ? 1 : 0) != 0, (String)"No AssemblyData object set: Please call init() in the constructor");
        AssemblyHelper.register(this._assemblyData, string, object);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    public Object getRegisteredObject(String string) {
        Assert.assertion((this._assemblyData != null ? 1 : 0) != 0, (String)"No AssemblyData object set: Please call init() in the constructor");
        return AssemblyHelper.getRegisteredObject(this._assemblyData, string);
    }

    public Object getCurrentRegisteredComponent(String string) {
        return AssemblyHelper.getCurrentRegisteredComponent(this._assemblyData, string);
    }

    public List getAllRegisteredComponents(String string) {
        return AssemblyHelper.getAllRegisteredComponents(this._assemblyData, string);
    }

    private String getTraceIdentifier() {
        return "(" + this.getClass().getName() + "," + this.getId() + ")";
    }

    public static class InternalMessage
    implements Message {
        public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2008.\n\n";
        private static final long serialVersionUID = 1L;
        private String key = null;
        private int type = 0;

        public InternalMessage(int n, String string) {
            this.type = n;
            this.key = string;
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("InternalMessage for " + this.key + " instanciated"));
            }
        }

        public String getMessage() {
            return FacesUtils.lookupNonPIIMessage(this.key);
        }

        public int getType() {
            return this.type;
        }

        public String getKey() {
            return this.key;
        }
    }

    public static class ExceptionMessage
    implements Message {
        public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2008.\n\n";
        private static final long serialVersionUID = 1L;
        boolean isProcessException = false;
        boolean isProcessError = false;
        boolean isTaskException = false;
        boolean isTaskError = false;
        Throwable throwable = null;

        public ExceptionMessage(Throwable throwable) {
            this.throwable = throwable;
            Assert.assertion((throwable != null ? 1 : 0) != 0, (String)"The throwable must not be null");
            if (throwable instanceof ProcessException) {
                this.isProcessException = true;
            } else if (throwable instanceof TaskException) {
                this.isTaskException = true;
            } else if (throwable instanceof ProcessError) {
                this.isProcessError = true;
            } else if (throwable instanceof TaskError) {
                this.isTaskError = true;
            }
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("ExceptionMessage for " + throwable.getClass().getName() + " instanciated"));
            }
        }

        public String getMessage() {
            Locale locale = LocaleUtils.getFacesLocale();
            if (this.isProcessException) {
                return ((ProcessException)this.throwable).getMessage(locale);
            }
            if (this.isTaskException) {
                return ((TaskException)this.throwable).getMessage(locale);
            }
            if (this.isProcessError) {
                return ((ProcessError)this.throwable).getMessage(locale);
            }
            if (this.isTaskError) {
                return ((TaskError)this.throwable).getMessage(locale);
            }
            return this.throwable.getMessage();
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        public int getType() {
            return 2;
        }
    }
}

