/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.jsf.component.impl;

import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import java.io.IOException;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class SectionComponent
extends UIComponentBase {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2009.\n\n";
    private Boolean collapsed = null;
    private String title = null;
    private String toggleExpandedStyleClass = null;
    private String toggleCollapsedStyleClass = null;
    private String styleClass = null;
    private String titleStyleClass = null;
    private String embeddedStyleClass = null;

    public void setCollapsed(Boolean bl) {
        this.collapsed = bl;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getToggleExpandedStyleClass() {
        if (this.toggleExpandedStyleClass == null) {
            return "toggleExpanded";
        }
        return this.toggleExpandedStyleClass;
    }

    public void setToggleExpandedStyleClass(String string) {
        this.toggleExpandedStyleClass = string;
    }

    public String getToggleCollapsedStyleClass() {
        if (this.toggleCollapsedStyleClass == null) {
            return "toggleCollapsed";
        }
        return this.toggleCollapsedStyleClass;
    }

    public void setToggleCollapsedStyleClass(String string) {
        this.toggleCollapsedStyleClass = string;
    }

    public void setStyleClass(String string) {
        this.styleClass = string;
    }

    public void setTitleStyleClass(String string) {
        this.titleStyleClass = string;
    }

    public void setEmbeddedStyleClass(String string) {
        this.embeddedStyleClass = string;
    }

    public void encodeBegin(FacesContext facesContext) throws IOException {
        String string = this.getClientId(facesContext);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)string);
        }
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        responseWriter.startElement("div", (UIComponent)this);
        responseWriter.writeAttribute("id", (Object)string, "clientId");
        if (this.styleClass != null) {
            responseWriter.writeAttribute("class", (Object)this.styleClass, "styleClass");
        }
        boolean bl = this.getCollapsed(facesContext);
        this.encodeTitle(facesContext, bl);
        responseWriter.startElement("div", (UIComponent)this);
        responseWriter.writeAttribute("id", (Object)SectionComponent.getEmbeddedSectionId(string), "id");
        if (this.embeddedStyleClass != null) {
            responseWriter.writeAttribute("class", (Object)this.embeddedStyleClass, "styleClass");
        }
        if (bl) {
            responseWriter.writeAttribute("style", (Object)"display:none;", "style");
        } else {
            responseWriter.writeAttribute("style", (Object)"display:block;", "style");
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    public void encodeChildren(FacesContext facesContext) throws IOException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)this.getClientId(facesContext));
        }
        if (this.getChildCount() == 0) {
            return;
        }
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        for (UIComponent uIComponent : this.getChildren()) {
            if (!uIComponent.isRendered()) continue;
            responseWriter.startElement("div", (UIComponent)this);
            uIComponent.encodeBegin(facesContext);
            if (uIComponent.getRendersChildren()) {
                uIComponent.encodeChildren(facesContext);
            }
            uIComponent.encodeEnd(facesContext);
            responseWriter.endElement("div");
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    public void encodeEnd(FacesContext facesContext) throws IOException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)this.getClientId(facesContext));
        }
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        responseWriter.endElement("div");
        responseWriter.endElement("div");
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void encodeTitle(FacesContext facesContext, boolean bl) throws IOException {
        String string = this.getClientId(facesContext);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)string);
        }
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        responseWriter.startElement("div", (UIComponent)this);
        responseWriter.writeAttribute("id", (Object)SectionComponent.getTitleSectionId(string), "id");
        if (this.titleStyleClass != null) {
            responseWriter.writeAttribute("class", (Object)this.titleStyleClass, "styleClass");
        }
        String string2 = SectionComponent.getCollapsedId(string);
        responseWriter.startElement("input", (UIComponent)this);
        responseWriter.writeAttribute("type", (Object)"hidden", "type");
        responseWriter.writeAttribute("id", (Object)string2, "id");
        responseWriter.writeAttribute("name", (Object)string2, "name");
        responseWriter.writeAttribute("value", (Object)Boolean.toString(bl), "value");
        responseWriter.endElement("input");
        responseWriter.startElement("table", (UIComponent)this);
        responseWriter.writeAttribute("style", (Object)"table-layout:fixed;width:100%;", "style");
        responseWriter.startElement("tr", (UIComponent)this);
        String string3 = this.getToggleExpandedStyleClass();
        if (bl) {
            string3 = this.getToggleCollapsedStyleClass();
        }
        responseWriter.startElement("td", (UIComponent)this);
        responseWriter.writeAttribute("id", (Object)SectionComponent.getToggleSectionId(string), "id");
        responseWriter.writeAttribute("style", (Object)"padding:0px;cursor:pointer", "style");
        responseWriter.writeAttribute("class", (Object)string3, "styleClass");
        String string4 = "var embedded=document.getElementById('" + SectionComponent.getEmbeddedSectionId(string) + "');" + "if(embedded!=null){" + "var hiddenCollapsed=document.getElementById('" + string2 + "');" + "if(hiddenCollapsed!=null){" + "if (hiddenCollapsed.value=='true'){" + "hiddenCollapsed.value='false';" + "this.className='" + this.getToggleExpandedStyleClass() + "';" + "embedded.style.display='block';" + "}else{" + "hiddenCollapsed.value='true';" + "this.className='" + this.getToggleCollapsedStyleClass() + "';" + "embedded.style.display='none';" + "}" + "}" + "}";
        responseWriter.writeAttribute("onClick", (Object)string4, "onClick");
        responseWriter.endElement("td");
        String string5 = this.getTitle(facesContext);
        responseWriter.startElement("td", (UIComponent)this);
        responseWriter.writeAttribute("title", (Object)string5, "title");
        responseWriter.writeAttribute("alt", (Object)string5, "title");
        if (this.titleStyleClass != null) {
            responseWriter.writeAttribute("class", (Object)this.titleStyleClass, "styleClass");
        }
        responseWriter.write(string5);
        responseWriter.endElement("td");
        responseWriter.endElement("tr");
        responseWriter.endElement("table");
        responseWriter.endElement("div");
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    private String getTitle(FacesContext facesContext) {
        ValueExpression valueExpression;
        String string = this.title;
        if (string == null && (valueExpression = this.getValueExpression("title")) != null) {
            ELContext eLContext;
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("title expression: " + valueExpression.getExpressionString()));
            }
            if ((eLContext = facesContext.getELContext()) != null) {
                string = (String)valueExpression.getValue(eLContext);
            } else if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"No ELContext!");
            }
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("title: " + string));
        }
        return string;
    }

    private boolean getCollapsed(FacesContext facesContext) {
        boolean bl = false;
        if (this.collapsed == null) {
            ValueExpression valueExpression = this.getValueExpression("collapsed");
            Boolean bl2 = null;
            if (valueExpression != null) {
                ELContext eLContext;
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("collapsed expression: " + valueExpression.getExpressionString()));
                }
                if ((eLContext = facesContext.getELContext()) != null) {
                    bl2 = (Boolean)valueExpression.getValue(eLContext);
                } else if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"No ELContext!");
                }
            }
            bl = bl2 != null ? bl2 : false;
        } else {
            bl = this.collapsed;
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("collapsed: " + bl));
        }
        return bl;
    }

    private static String getTitleSectionId(String string) {
        return string + ":title";
    }

    private static String getToggleSectionId(String string) {
        return string + ":toggle";
    }

    private static String getCollapsedId(String string) {
        return string + ":collapsed";
    }

    private static String getEmbeddedSectionId(String string) {
        return string + ":embedded";
    }

    public String getFamily() {
        return null;
    }

    public void decode(FacesContext facesContext) {
        String string;
        Map map = facesContext.getExternalContext().getRequestParameterMap();
        String string2 = this.getClientId(facesContext);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)(string2 + " - requestParams: '" + map));
        }
        if ((string = (String)map.get(SectionComponent.getCollapsedId(string2))) != null) {
            this.collapsed = Boolean.valueOf(string);
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)(string2 + " - collapsed: " + this.collapsed));
        }
        super.decode(facesContext);
    }

    public void restoreState(FacesContext facesContext, Object object) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        Object object2 = ((Object[])object)[0];
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("superState: " + (Object[])object2));
        }
        super.restoreState(facesContext, object2);
        this.collapsed = (Boolean)((Object[])object)[1];
        this.title = (String)((Object[])object)[2];
        this.toggleExpandedStyleClass = (String)((Object[])object)[3];
        this.toggleCollapsedStyleClass = (String)((Object[])object)[4];
        this.styleClass = (String)((Object[])object)[5];
        this.titleStyleClass = (String)((Object[])object)[6];
        this.embeddedStyleClass = (String)((Object[])object)[7];
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)this.toString());
        }
    }

    public Object saveState(FacesContext facesContext) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)this.toString());
        }
        Object object = super.saveState(facesContext);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("superState: " + (Object[])object));
        }
        Object[] objectArray = new Object[]{object, this.collapsed, this.title, this.toggleExpandedStyleClass, this.toggleCollapsedStyleClass, this.styleClass, this.titleStyleClass, this.embeddedStyleClass};
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
        return objectArray;
    }

    public String toString() {
        return "collapsed=" + this.collapsed + ", title=" + this.title + ", toggleExpandedStyleClass=" + this.toggleExpandedStyleClass + ", toggleCollapsedStyleClass=" + this.toggleCollapsedStyleClass + ", styleClass=" + this.styleClass + ", titleStyleClass=" + this.titleStyleClass + ", embeddedStyleClass=" + this.embeddedStyleClass;
    }
}

