/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.jsf.component.impl;

import com.ibm.bpc.clientcore.MessageWrapper;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.jsf.component.MessageComponent;
import com.ibm.bpe.jsf.component.impl.WidgetComponentBase;
import com.ibm.bpe.jsf.exception.CouldNotIncludeException;
import com.ibm.bpe.jsf.exception.ModelNotAvailableException;
import com.ibm.bpe.jsf.exception.ModelNotSpecifiedException;
import com.ibm.bpe.jsf.exception.PropertyNotFoundException;
import com.ibm.bpe.jsf.exception.PropertyPopulationException;
import com.ibm.bpe.jsf.message.sdo.PopulationHelper;
import com.ibm.bpe.jsf.util.LocaleUtils;
import com.ibm.bpe.util.MessageLogger;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import commonj.sdo.DataObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class ImportHelperComponent
extends UIComponentBase {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";
    private Map attributes = new HashMap();
    private static final String CONTEXT_ATTRIBUTE = "context";
    private static final String URL_ATTRIBUTE = "url";
    private static final String ERROR_MAP_ATTRIBUTE = "errorMap";
    private static final String VALIDATION_MAP_ATTRIBUTE = "validationMap";

    public ImportHelperComponent() {
        this.setErrorMap(new HashMap());
        this.setValidationMap(new HashMap());
    }

    private Object getAttributeValue(String string) {
        ValueBinding valueBinding;
        Object v = this.attributes.get(string);
        if (v == null && (valueBinding = this.getValueBinding(string)) != null) {
            return valueBinding.getValue(FacesContext.getCurrentInstance());
        }
        return v;
    }

    private void setAttributeValue(String string, Object object) {
        this.attributes.put(string, object);
    }

    public String getContext() {
        return (String)this.getAttributeValue(CONTEXT_ATTRIBUTE);
    }

    public void setContext(String string) {
        this.setAttributeValue(CONTEXT_ATTRIBUTE, string);
    }

    public Map getErrorMap() {
        return (Map)this.getAttributeValue(ERROR_MAP_ATTRIBUTE);
    }

    public void setErrorMap(Map map) {
        this.setAttributeValue(ERROR_MAP_ATTRIBUTE, map);
    }

    public String getUrl() {
        return (String)this.getAttributeValue(URL_ATTRIBUTE);
    }

    public void setUrl(String string) {
        this.setAttributeValue(URL_ATTRIBUTE, string);
    }

    public Map getValidationMap() {
        return (Map)this.getAttributeValue(VALIDATION_MAP_ATTRIBUTE);
    }

    public void setValidationMap(Map map) {
        this.setAttributeValue(VALIDATION_MAP_ATTRIBUTE, map);
    }

    public void restoreState(FacesContext facesContext, Object object) {
        Object[] objectArray = (Object[])object;
        super.restoreState(facesContext, objectArray[0]);
        this.setContext((String)objectArray[1]);
        this.setUrl((String)objectArray[2]);
        this.setErrorMap((Map)objectArray[3]);
        this.setValidationMap((Map)objectArray[4]);
    }

    public Object saveState(FacesContext facesContext) {
        Object[] objectArray = new Object[]{super.saveState(facesContext), this.getContext(), this.getUrl(), this.getErrorMap(), this.getValidationMap()};
        return objectArray;
    }

    public void prepareRendering(FacesContext facesContext, MessageComponent messageComponent, MessageWrapper messageWrapper) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Using Custom Java Server Pages " + messageWrapper.getUrl() + "(" + messageWrapper.getContextRoot() + ")"));
        }
        String string = (String)messageComponent.getAttribute("prefixKey");
        String string2 = (String)messageComponent.getAttribute("messageKey");
        String string3 = (String)messageComponent.getAttribute("faultKey");
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Using prefix " + string + " using destionation " + string2 + " for " + messageWrapper));
        }
        Locale locale = LocaleUtils.getFacesLocale(facesContext);
        Map<String, Object> map = PopulationHelper.createMessageMapWithLiterals(messageWrapper.getMessage(), locale);
        Set set = this.getErrorMap().entrySet();
        for (Map.Entry entry : set) {
            String string4 = (String)entry.getKey();
            String string5 = (String)entry.getValue();
            map.put(string4, string5);
        }
        facesContext.getExternalContext().getRequestMap().put(string2, messageWrapper.getMessage());
        facesContext.getExternalContext().getRequestMap().put(string2 + "Map", map);
        facesContext.getExternalContext().getRequestMap().put(string2 + "ValidationErrors", this.getValidationMap());
        facesContext.getExternalContext().getRequestMap().put(string3, messageWrapper.getFaultName());
        facesContext.getExternalContext().getRequestMap().put(string, this.getClientId(facesContext) + ":M:");
    }

    public void processDecodes(FacesContext facesContext) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        this.setValidationMap(new HashMap());
        this.setErrorMap(new HashMap());
        try {
            this.decodeInput(facesContext);
        }
        catch (ModelNotSpecifiedException modelNotSpecifiedException) {
            WidgetComponentBase.renderMessageBox((UIComponent)this, modelNotSpecifiedException);
        }
        catch (ModelNotAvailableException modelNotAvailableException) {
            WidgetComponentBase.renderMessageBox((UIComponent)this, modelNotAvailableException);
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            WidgetComponentBase.renderMessageBox((UIComponent)this, propertyNotFoundException);
        }
        catch (PropertyPopulationException propertyPopulationException) {
            WidgetComponentBase.renderMessageBox((UIComponent)this, propertyPopulationException);
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    public void decodeInput(FacesContext facesContext) throws ModelNotSpecifiedException, ModelNotAvailableException, PropertyNotFoundException, PropertyPopulationException, IllegalArgumentException {
        MessageComponent messageComponent = (MessageComponent)this.getParent();
        MessageWrapper messageWrapper = (MessageWrapper)messageComponent.getMessage();
        Map map = facesContext.getExternalContext().getRequestParameterMap();
        String string = this.getClientId(facesContext);
        Object object = messageComponent.getCachedMessage();
        String string2 = (String)map.get(messageComponent.getAttribute("faultKey"));
        if (string2 != null && BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Fault Name: " + string2));
        }
        messageWrapper.setFaultName(string2);
        if (object instanceof DataObject) {
            HashMap<String, Exception> hashMap = new HashMap<String, Exception>();
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            PopulationHelper.populateMessageWithLiterals((DataObject)object, map, hashMap, hashMap2, LocaleUtils.getFacesLocale(), string + ":M:");
            if (!hashMap.isEmpty()) {
                Set set = hashMap.entrySet();
                for (Map.Entry entry : set) {
                    String string3 = (String)entry.getKey();
                    Exception exception = (Exception)entry.getValue();
                    if (!BPCClientTrace.isTracing) continue;
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Could not populate property " + (String)entry.getKey()));
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)exception);
                }
                this.saveValidationMessages(hashMap, hashMap2, LocaleUtils.getFacesLocale(facesContext));
                facesContext.renderResponse();
            }
        } else {
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            String string4 = this.getClientId(facesContext);
            Set set = map.entrySet();
            PopulationHelper.populateBoxedPrimitive((MessageWrapper)object, object != null ? object.getClass() : null, map, arrayList, arrayList2, LocaleUtils.getFacesLocale(), string + ":M:");
            if (!arrayList.isEmpty()) {
                Exception exception2 = null;
                for (Exception exception2 : arrayList) {
                    if (!BPCClientTrace.isTracing) continue;
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Could not populate boxed primitive");
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)exception2);
                }
                HashMap hashMap = new HashMap();
                HashMap<String, Exception> hashMap3 = new HashMap<String, Exception>();
                hashMap3.put("this", exception2);
                if (!arrayList2.isEmpty()) {
                    hashMap.put("this", arrayList2.get(0));
                }
                this.saveValidationMessages(hashMap3, hashMap, LocaleUtils.getFacesLocale());
                facesContext.renderResponse();
            }
        }
    }

    private void saveValidationMessages(Map map, Map map2, Locale locale) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Set set = map.entrySet();
        for (Map.Entry entry : set) {
            String string = (String)entry.getKey();
            Throwable throwable = (Throwable)entry.getValue();
            String string2 = LocaleUtils.getMessage(locale, throwable);
            hashMap.put(string, string2);
        }
        this.setValidationMap(hashMap);
        this.setErrorMap(map2);
    }

    public void encodeBegin(FacesContext facesContext) throws IOException {
    }

    public void encodeChildren(FacesContext facesContext) throws IOException {
    }

    public void encodeEnd(FacesContext facesContext) throws IOException {
        Object object;
        Object object2;
        ServletContext servletContext;
        Object[] objectArray;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        Object object3 = null;
        try {
            objectArray = (Object[])this.getParent();
            this.prepareRendering(facesContext, (MessageComponent)objectArray, objectArray.getMessageWrapper());
            servletContext = (ServletContext)facesContext.getExternalContext().getContext();
            object2 = (HttpServletRequest)facesContext.getExternalContext().getRequest();
            object = (HttpServletResponse)facesContext.getExternalContext().getResponse();
            if (this.getContext() != null) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Including " + this.getUrl() + " out of context " + this.getContext()));
                }
                servletContext = servletContext.getContext(this.getContext());
            }
            if (servletContext == null) {
                throw new CouldNotIncludeException(new Object[]{this.getUrl(), this.getContext()});
            }
            RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(this.getUrl());
            requestDispatcher.include((ServletRequest)object2, (ServletResponse)new FacesServletResponseWrapper((HttpServletResponse)object, facesContext));
        }
        catch (ServletException servletException) {
            object3 = servletException;
        }
        catch (IOException iOException) {
            object3 = iOException;
        }
        catch (ModelNotSpecifiedException modelNotSpecifiedException) {
            object3 = modelNotSpecifiedException;
        }
        catch (ModelNotAvailableException modelNotAvailableException) {
            object3 = modelNotAvailableException;
        }
        catch (CouldNotIncludeException couldNotIncludeException) {
            object3 = couldNotIncludeException;
        }
        this.setValidationMap(new HashMap());
        this.setErrorMap(new HashMap());
        if (object3 != null) {
            objectArray = new Object[]{this.getUrl(), this.getContext()};
            servletContext = MessageLogger.newMessageLogger((String)BPCClientTrace.class.getName());
            object2 = object3 instanceof CouldNotIncludeException ? (CouldNotIncludeException)((Object)object3) : new CouldNotIncludeException(new Object[]{this.getUrl(), this.getContext()}, (Throwable)object3);
            servletContext.text(MessageLogger.TYPE_ERROR, object2.getMessage());
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_EVENT, (Throwable)object2);
            }
            object = new IOException();
            ((Throwable)object).initCause((Throwable)object2);
            throw object;
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    public String getFamily() {
        return null;
    }

    static class FacesServletResponseWrapper
    extends HttpServletResponseWrapper {
        public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005.\n\n";
        ResponseWriter writer = null;

        public FacesServletResponseWrapper(HttpServletResponse httpServletResponse, FacesContext facesContext) {
            super(httpServletResponse);
            this.writer = facesContext.getResponseWriter();
        }

        public ServletOutputStream getOutputStream() throws IOException {
            throw new IllegalStateException();
        }

        public PrintWriter getWriter() throws IOException {
            return new PrintWriter((Writer)this.writer);
        }
    }
}

