/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.jsf.component.impl;

import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.jsf.component.impl.LiteralActionMethod;
import com.ibm.bpe.util.Assert;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.ActionEvent;
import javax.faces.event.ValueChangeEvent;

public class AssemblyUtils {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";

    public static ValueBinding createValueBinding(String string, String string2) {
        String string3 = AssemblyUtils.extendExpression(string, string2);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Transforming Value Binding from \"" + string + "\" to \"" + string3 + "\""));
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Application application = facesContext.getApplication();
        ValueBinding valueBinding = application.createValueBinding(string3);
        return valueBinding;
    }

    static MethodBinding createActionMethodBinding(String string, String string2) {
        if (string2 == null || string2.equals("")) {
            return AssemblyUtils.createActionMethodBinding(string);
        }
        String string3 = AssemblyUtils.extendExpression(string, string2);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Transforming \"" + string + "\" to Action Method Binding \"" + string3 + "\""));
        }
        return AssemblyUtils.createActionMethodBinding(string3);
    }

    public static MethodBinding createActionMethodBinding(String string) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Creating Action Method Binding for expression \"" + string + "\""));
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Application application = facesContext.getApplication();
        return application.createMethodBinding(string, new Class[0]);
    }

    public static MethodBinding createLiteralActionMethodBinding(String string) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Creating a Action Method Binding that just returns the literal \"" + string + "\""));
        }
        return new LiteralActionMethod(string);
    }

    public static MethodBinding createActionListenerMethodBinding(String string, String string2) {
        if (string2 == null || string2.equals("")) {
            return AssemblyUtils.createActionListenerMethodBinding(string);
        }
        String string3 = AssemblyUtils.extendExpression(string, string2);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Transforming \"" + string + "\" to Action Listener Method Binding \"" + string3 + "\""));
        }
        return AssemblyUtils.createActionListenerMethodBinding(string3);
    }

    public static MethodBinding createActionListenerMethodBinding(String string) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Creating Action Listener Method Binding for expression \"" + string + "\""));
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Application application = facesContext.getApplication();
        return application.createMethodBinding(string, new Class[]{ActionEvent.class});
    }

    static MethodBinding createValueChangedListenerMethodBinding(String string, String string2) {
        if (string2 == null || string2.equals("")) {
            return AssemblyUtils.createActionListenerMethodBinding(string);
        }
        String string3 = AssemblyUtils.extendExpression(string, string2);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Transforming \"" + string + "\" to Value Changed Method Binding \"" + string3 + "\""));
        }
        return AssemblyUtils.createValueChangedListenerMethodBinding(string3);
    }

    static MethodBinding createValueChangedListenerMethodBinding(String string) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Creating Value Changed Method Binding for expression \"" + string + "\""));
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Application application = facesContext.getApplication();
        return application.createMethodBinding(string, new Class[]{ValueChangeEvent.class});
    }

    public static UIComponent createUIComponent(Application application, UIViewRoot uIViewRoot, String string, String string2) {
        if (string2 == null) {
            string2 = uIViewRoot.createUniqueId();
        }
        UIComponent uIComponent = application.createComponent(string);
        uIComponent.setId(string2);
        if (BPCClientTrace.isTracing) {
            if (uIComponent != null) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Creating component " + uIComponent + " with id " + string2));
            } else {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Creating component (" + string + ") failed"));
            }
        }
        return uIComponent;
    }

    static String extendExpression(String string, String string2) {
        Assert.assertion((string != null ? 1 : 0) != 0, (String)"Expression must not be null");
        if (string2 == null) {
            return string;
        }
        int n = string.indexOf("#{");
        int n2 = string.indexOf("}");
        Assert.assertion((n != -1 && n2 != -1 ? 1 : 0) != 0, (String)("The expression (" + string + ") must be synatically correct"));
        return string.substring(0, n2) + "." + string2 + "}";
    }

    public static boolean isExpression(String string) {
        if (string == null) {
            return false;
        }
        int n = string.indexOf("#{");
        int n2 = string.indexOf("}");
        return n != -1 && n2 != -1;
    }

    static String getFirstPart(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(".");
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    static String getSecondPart(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(".");
        if (n == -1) {
            return null;
        }
        return string.substring(n + 1);
    }
}

