/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.jsf.component.impl;

import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.jsf.component.impl.AssemblyEntity;
import com.ibm.bpe.jsf.component.impl.AssemblyUtils;
import com.ibm.bpe.util.Assert;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.component.ActionSource;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.ValueHolder;
import javax.faces.convert.Converter;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;

public class AssemblyHelper {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2008.\n\n";
    protected static final int ATTRIBUTE = 0;
    protected static final int VALUE_BINDING = 1;
    protected static final int METHOD_BINDING = 2;
    protected static final int CONVERTER = 3;
    public static final int ATTRIBUTE_RULE = 0;
    public static final int ACTION_RULE = 1;
    public static final int ACTION_LISTENER_RULE = 2;
    public static final int VALUE_CHANGE_LISTENER_RULE = 3;
    public static final int CONVERTER_RULE = 4;

    static void register(AssemblyData assemblyData, String string, Object object) {
        assemblyData.getTargetMap().put("CURRENT" + string, object);
        ArrayList<Object> arrayList = (ArrayList<Object>)assemblyData.getTargetMap().get("ALL" + string);
        if (arrayList == null) {
            arrayList = new ArrayList<Object>();
        }
        if (object != null) {
            arrayList.add(object);
        }
        assemblyData.getTargetMap().put("ALL" + string, arrayList);
        Object v = assemblyData.getTargetMap().get(string);
        if (v != null) {
            if (v instanceof List) {
                ((List)v).add(object);
            } else {
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                arrayList2.add(v);
                if (object != null) {
                    arrayList2.add(object);
                }
                assemblyData.getTargetMap().put(string, arrayList2);
            }
        } else {
            assemblyData.getTargetMap().put(string, object);
        }
    }

    static Object getRegisteredObject(AssemblyData assemblyData, String string) {
        return assemblyData.getTargetMap().get(string);
    }

    static Object getCurrentRegisteredComponent(AssemblyData assemblyData, String string) {
        return assemblyData.getTargetMap().get("CURRENT" + string);
    }

    static List getAllRegisteredComponents(AssemblyData assemblyData, String string) {
        return (List)assemblyData.getTargetMap().get("ALL" + string);
    }

    static void finishComponentTree(AssemblyData assemblyData) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        AssemblyHelper.postProcess(assemblyData);
        for (Map.Entry entry : assemblyData.getTargetMap().entrySet()) {
            Object v = entry.getValue();
            String string = (String)entry.getKey();
            if (string.equals("THIS")) continue;
            if (v instanceof List) {
                for (Object e : (List)v) {
                    if (!(e instanceof AssemblyEntity)) continue;
                    ((AssemblyEntity)e).finishComponentTree();
                }
                continue;
            }
            if (!(v instanceof AssemblyEntity)) continue;
            ((AssemblyEntity)v).finishComponentTree();
        }
        assemblyData = null;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    private static void handleAddAttribute(Object object, DispatchRule dispatchRule, Object object2) {
        String string = dispatchRule.getTargetAttribute();
        if (object instanceof AssemblyEntity) {
            ((AssemblyEntity)object).addAttribute(string, object2);
        } else if (object instanceof UIComponent) {
            if (object instanceof ActionSource && dispatchRule.getType() == 1 && object2 instanceof String) {
                MethodBinding methodBinding = AssemblyUtils.createLiteralActionMethodBinding((String)object2);
                Assert.assertion((dispatchRule.getType() == 1 ? 1 : 0) != 0, (String)(dispatchRule + " must be an ActionMethodDispatchRule"));
                AssemblyHelper.handleAddActionMethodBinding(object, dispatchRule, methodBinding);
            } else {
                ((UIComponent)object).getAttributes().put(string, object2);
            }
        }
    }

    private static void handleAddValueBinding(Object object, DispatchRule dispatchRule, ValueBinding valueBinding) {
        String string = dispatchRule.getTargetAttribute();
        if (object instanceof UIComponent) {
            ((UIComponent)object).setValueBinding(string, valueBinding);
        } else if (object instanceof AssemblyEntity) {
            ((AssemblyEntity)object).addValueBinding(string, valueBinding);
        }
    }

    private static void handleAddMethodBinding(Object object, DispatchRule dispatchRule, MethodBinding methodBinding) {
        String string = dispatchRule.getTargetAttribute();
        if (object instanceof AssemblyEntity) {
            ((AssemblyEntity)object).addMethodBinding(string, methodBinding);
            return;
        }
        Assert.assertion((boolean)(object instanceof UIComponent), (String)(object.getClass().getName() + " must be of type UIComponent"));
        Assert.assertion((boolean)dispatchRule.isMethodDispatchRule(), (String)(dispatchRule.getClass().getName() + " must be a MethodDispatchRule"));
        switch (dispatchRule.getType()) {
            case 1: {
                AssemblyHelper.handleAddActionMethodBinding(object, dispatchRule, methodBinding);
                break;
            }
            case 2: {
                AssemblyHelper.handleAddActionListenerMethodBinding(object, dispatchRule, methodBinding);
                break;
            }
            case 3: {
                AssemblyHelper.handleAddValueChangedListenerMethodBinding(object, dispatchRule, methodBinding);
                break;
            }
            default: {
                if (!BPCClientTrace.isTracing) break;
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"ERROR: wrong path");
            }
        }
    }

    private static void handleAddActionMethodBinding(Object object, DispatchRule dispatchRule, MethodBinding methodBinding) {
        if (object instanceof ActionSource) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Setting Action to " + methodBinding.getExpressionString() + " for target " + object + " (" + object.getClass().getName() + ")"));
            }
            ((ActionSource)object).setAction(methodBinding);
        } else if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)(object.getClass().getName() + " does not implement ActionSource Interface"));
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)(methodBinding.getExpressionString() + "could not be added"));
        }
    }

    private static void handleAddActionListenerMethodBinding(Object object, DispatchRule dispatchRule, MethodBinding methodBinding) {
        if (object instanceof ActionSource) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Setting ActionListener to " + methodBinding.getExpressionString() + " for target " + object + " (" + object.getClass().getName() + ")"));
            }
            ((ActionSource)object).setActionListener(methodBinding);
        } else if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)(object.getClass().getName() + " does not implement ActionSource Interface"));
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)(methodBinding.getExpressionString() + "could not be added"));
        }
    }

    private static void handleAddValueChangedListenerMethodBinding(Object object, DispatchRule dispatchRule, MethodBinding methodBinding) {
        if (object instanceof UIInput) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Setting ValueChangedListener to " + methodBinding.getExpressionString() + " for target " + object + " (" + object.getClass().getName() + ")"));
            }
            ((UIInput)object).setValueChangeListener(methodBinding);
        } else if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)(object.getClass().getName() + " does not implement UIInput Interface"));
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)(methodBinding.getExpressionString() + "could not be added"));
        }
    }

    private static void handleAddConverter(Object object, DispatchRule dispatchRule, Converter converter) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("handleAddConverter(" + object + "," + dispatchRule + "," + converter));
        }
        String string = dispatchRule.getTargetAttribute();
        if (object instanceof AssemblyEntity) {
            ((AssemblyEntity)object).addAttribute(string, converter);
        } else if (object instanceof ValueHolder) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Setting converter " + converter + " on " + object));
            }
            ((ValueHolder)object).setConverter(converter);
        } else {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"I was here");
            }
            Assert.assertion((boolean)false, (String)("Converter cannot be set on target (" + object + ")"));
        }
    }

    static void addAttribute(AssemblyData assemblyData, String string, Object object) {
        Set set = (Set)assemblyData.getDispatchTable().get(string);
        Assert.assertion((set != null ? 1 : 0) != 0, (String)("Component (" + assemblyData.getDelegatingComponentName() + ") must feature an attribute " + string));
        for (DispatchRule dispatchRule : set) {
            boolean bl = AssemblyHelper.addValue(0, assemblyData, dispatchRule, object);
            if (!bl) continue;
            assemblyData.getAttributeCache().add(new DeferredDispatchRule(dispatchRule, object));
        }
    }

    static void addConverter(AssemblyData assemblyData, String string, Converter converter) {
        Set set = (Set)assemblyData.getDispatchTable().get(string);
        Assert.assertion((set != null ? 1 : 0) != 0, (String)("Component (" + assemblyData.getDelegatingComponentName() + ") must feature an attribute " + string));
        for (DispatchRule dispatchRule : set) {
            boolean bl = AssemblyHelper.addValue(3, assemblyData, dispatchRule, converter);
            if (!bl) continue;
            assemblyData.getConverterCache().add(new DeferredDispatchRule(dispatchRule, converter));
        }
    }

    static void addValueBinding(AssemblyData assemblyData, String string, ValueBinding valueBinding) {
        Set set = (Set)assemblyData.getDispatchTable().get(string);
        Assert.assertion((set != null ? 1 : 0) != 0, (String)("Component (" + assemblyData.getDelegatingComponentName() + ") must feature an attribute " + string));
        for (DispatchRule dispatchRule : set) {
            boolean bl = AssemblyHelper.addValue(1, assemblyData, dispatchRule, valueBinding);
            if (!bl) continue;
            assemblyData.getValueBindingCache().add(new DeferredDispatchRule(dispatchRule, valueBinding));
        }
    }

    static void addMethodBinding(AssemblyData assemblyData, String string, MethodBinding methodBinding) {
        Set set = (Set)assemblyData.getDispatchTable().get(string);
        Assert.assertion((set != null ? 1 : 0) != 0, (String)("Component (" + assemblyData.getDelegatingComponentName() + ") must feature an attribute " + string));
        for (DispatchRule dispatchRule : set) {
            boolean bl = AssemblyHelper.addValue(2, assemblyData, dispatchRule, methodBinding);
            if (!bl) continue;
            assemblyData.getMethodBindingCache().add(new DeferredDispatchRule(dispatchRule, methodBinding));
        }
    }

    protected static boolean addValue(int n, AssemblyData assemblyData, DispatchRule dispatchRule, Object object) {
        boolean bl = false;
        Object v = assemblyData.getTargetMap().get(dispatchRule.getTargetComponentID());
        Assert.assertion((dispatchRule.isLateBound() || v != null ? 1 : 0) != 0, (String)("The target of rule (" + dispatchRule + ") must exist in " + assemblyData.getTargetMap()));
        String string = null;
        String string2 = null;
        switch (n) {
            case 0: {
                string2 = "Object";
                string = object != null ? object.toString() : "null";
                break;
            }
            case 1: {
                string2 = "ValueBinding";
                string = object != null ? ((ValueBinding)object).getExpressionString() : "null";
                break;
            }
            case 2: {
                string2 = "MethodBinding";
                string = object != null ? ((MethodBinding)object).getExpressionString() : "null";
                break;
            }
            case 3: {
                string2 = "Converter";
                String string3 = string = object != null ? object.getClass().getName() : "null";
            }
        }
        if (v != null) {
            switch (n) {
                case 0: {
                    object = dispatchRule.alterExpression(object);
                    if (!(object instanceof MethodBinding)) break;
                    n = 2;
                    break;
                }
                case 1: {
                    Assert.assertion((boolean)(object instanceof ValueBinding), (String)("Binding (" + object + ") must be a ValueBinding"));
                    object = dispatchRule.alterExpression(object);
                    if (!(object instanceof MethodBinding)) break;
                    n = 2;
                    break;
                }
                case 2: {
                    Assert.assertion((boolean)(object instanceof MethodBinding), (String)("Binding (" + object + ") must be a MethodBinding"));
                    if (!dispatchRule.isMethodDispatchRule()) break;
                    object = dispatchRule.alterExpression(object);
                    break;
                }
            }
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Processing " + dispatchRule + " for " + string));
            }
            switch (n) {
                case 0: {
                    break;
                }
                case 1: {
                    Assert.assertion((boolean)(object instanceof ValueBinding), (String)("Binding (" + object + ") is not a ValueBinding"));
                    break;
                }
                case 2: {
                    Assert.assertion((boolean)(object instanceof MethodBinding), (String)("Binding (" + object + ") is not a MethodBinding"));
                    break;
                }
                case 3: {
                    Assert.assertion((boolean)(object instanceof Converter), (String)("Binding (" + object + ") is not a Converter"));
                }
            }
            if (dispatchRule.getType() == 4) {
                Assert.assertion((boolean)(object instanceof Converter), (String)("Binding (" + object + ") must be of type javax.faces.Converter"));
            }
            if (v instanceof List) {
                for (Object e : (List)v) {
                    switch (n) {
                        case 0: {
                            AssemblyHelper.handleAddAttribute(e, dispatchRule, object);
                            break;
                        }
                        case 1: {
                            AssemblyHelper.handleAddValueBinding(e, dispatchRule, (ValueBinding)object);
                            break;
                        }
                        case 2: {
                            AssemblyHelper.handleAddMethodBinding(e, dispatchRule, (MethodBinding)object);
                            break;
                        }
                        case 3: {
                            AssemblyHelper.handleAddConverter(e, dispatchRule, (Converter)object);
                        }
                    }
                }
            } else {
                Object v2 = v;
                switch (n) {
                    case 0: {
                        AssemblyHelper.handleAddAttribute(v2, dispatchRule, object);
                        break;
                    }
                    case 1: {
                        AssemblyHelper.handleAddValueBinding(v2, dispatchRule, (ValueBinding)object);
                        break;
                    }
                    case 2: {
                        AssemblyHelper.handleAddMethodBinding(v2, dispatchRule, (MethodBinding)object);
                        break;
                    }
                    case 3: {
                        AssemblyHelper.handleAddConverter(v2, dispatchRule, (Converter)object);
                    }
                }
            }
            if (assemblyData.getDelegatingComponent() != null) {
                assemblyData.getDelegatingComponent().getAttributes().put(dispatchRule.getAttribute(), string);
            }
        } else {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Postphoning " + dispatchRule + " for " + string));
            }
            bl = true;
        }
        return bl;
    }

    static boolean postProcess(AssemblyData assemblyData) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object52;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        boolean bl = false;
        Set set = assemblyData.getAttributeCache();
        HashSet<DeferredDispatchRule> hashSet = new HashSet<DeferredDispatchRule>();
        for (Object object52 : set) {
            object4 = ((DeferredDispatchRule)object52).getRule();
            boolean bl2 = AssemblyHelper.addValue(0, assemblyData, (DispatchRule)object4, object3 = ((DeferredDispatchRule)object52).getValue());
            if (!bl2) continue;
            hashSet.add(new DeferredDispatchRule((DispatchRule)object4, object3));
            bl = true;
        }
        object52 = assemblyData.getValueBindingCache();
        object4 = new HashSet();
        Iterator iterator = object52.iterator();
        while (iterator.hasNext()) {
            object3 = (DeferredDispatchRule)iterator.next();
            DispatchRule dispatchRule = ((DeferredDispatchRule)object3).getRule();
            boolean bl3 = AssemblyHelper.addValue(1, assemblyData, dispatchRule, object2 = (ValueBinding)((DeferredDispatchRule)object3).getValue());
            if (!bl3) continue;
            object4.add(new DeferredDispatchRule(dispatchRule, object2));
            bl = true;
        }
        object3 = assemblyData.getMethodBindingCache();
        HashSet<DeferredDispatchRule> hashSet2 = new HashSet<DeferredDispatchRule>();
        iterator = object3.iterator();
        while (iterator.hasNext()) {
            object2 = (DeferredDispatchRule)iterator.next();
            DispatchRule dispatchRule = ((DeferredDispatchRule)object2).getRule();
            boolean bl4 = AssemblyHelper.addValue(2, assemblyData, dispatchRule, object = (MethodBinding)((DeferredDispatchRule)object2).getValue());
            if (!bl4) continue;
            hashSet2.add(new DeferredDispatchRule(dispatchRule, object));
            bl = true;
        }
        object2 = assemblyData.getConverterCache();
        HashSet hashSet3 = new HashSet();
        iterator = object2.iterator();
        while (iterator.hasNext()) {
            Converter converter;
            object = (DeferredDispatchRule)iterator.next();
            DispatchRule dispatchRule = ((DeferredDispatchRule)object).getRule();
            boolean bl5 = AssemblyHelper.addValue(3, assemblyData, dispatchRule, converter = (Converter)((DeferredDispatchRule)object).getValue());
            if (!bl5) continue;
            hashSet2.add(new DeferredDispatchRule(dispatchRule, converter));
            bl = true;
        }
        if (bl) {
            assemblyData.setAttributeCache(hashSet);
            assemblyData.setValueBindingCache((Set)object4);
            assemblyData.setMethodBindingCache(hashSet2);
            assemblyData.setConverterCache(hashSet3);
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
        return bl;
    }

    public static void addDispatchRule(Map map, String string, String string2, boolean bl, int n) {
        block5: {
            String string3 = AssemblyUtils.getFirstPart(string);
            String string4 = AssemblyUtils.getSecondPart(string);
            String string5 = AssemblyUtils.getFirstPart(string2);
            String string6 = AssemblyUtils.getSecondPart(string2);
            Assert.assertion((string3 != null ? 1 : 0) != 0, (String)("The attribute of the sourceExpression " + string + " must not be null"));
            HashSet<DispatchRule> hashSet = (HashSet<DispatchRule>)map.get(string3);
            if (hashSet == null) {
                hashSet = new HashSet<DispatchRule>();
                map.put(string3, hashSet);
            }
            try {
                DispatchRule dispatchRule = new DispatchRule(string3, string4, string5, string6, bl, n);
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Adding dispatchRule " + dispatchRule));
                }
                hashSet.add(dispatchRule);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_EVENT, (Throwable)illegalArgumentException);
                }
                if (!BPCClientTrace.isTracing) break block5;
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Could not add dispatchRule for (" + string + "," + string2 + "," + bl + "," + n + ")"));
            }
        }
    }

    static class DeferredDispatchRule {
        public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2008.\n\n";
        private DispatchRule _rule;
        private Object _value;

        public DeferredDispatchRule(DispatchRule dispatchRule, Object object) {
            this._rule = dispatchRule;
            this._value = object;
        }

        public DispatchRule getRule() {
            return this._rule;
        }

        public Object getValue() {
            return this._value;
        }

        public void setRule(DispatchRule dispatchRule) {
            this._rule = dispatchRule;
        }

        public void setValue(Object object) {
            this._value = object;
        }
    }

    static class DispatchRule {
        public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";
        private String _attribute = null;
        private String _extension = null;
        private String _targetComponentID = null;
        private String _targetAttribute = null;
        private boolean _lateBound = false;
        private int _type = 0;

        public DispatchRule(String string, String string2, String string3, String string4, boolean bl, int n) throws IllegalArgumentException {
            this._attribute = string;
            this._extension = string2;
            this._targetComponentID = string3;
            this._targetAttribute = string4;
            this._lateBound = bl;
            this._type = n;
            switch (this._type) {
                case 0: {
                    break;
                }
                case 1: {
                    this._targetAttribute = "<action>]";
                    break;
                }
                case 2: {
                    this._targetAttribute = "<actionListener>";
                    break;
                }
                case 3: {
                    this._targetAttribute = "<valueChangedListener>";
                    break;
                }
                case 4: {
                    this._targetAttribute = "<converter>";
                    break;
                }
                default: {
                    if (BPCClientTrace.isTracing) {
                        BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"THIS KIND OF DISPATCH RULE DOES NOT YET EXIST");
                    }
                    throw new IllegalArgumentException("THIS KIND OF DISPATCH RULE DOES NOT YET EXIST: " + this.toString());
                }
            }
        }

        public boolean isMethodDispatchRule() {
            return this._type == 1 || this._type == 2 || this._type == 3;
        }

        public Object alterExpression(Object object) {
            block25: {
                Object object2;
                String string;
                block24: {
                    string = null;
                    object2 = null;
                    if (this._extension != null) break block24;
                    switch (this._type) {
                        case 1: {
                            if (object != null && object instanceof String) {
                                return AssemblyUtils.createLiteralActionMethodBinding((String)object);
                            }
                        }
                        case 2: 
                        case 3: {
                            if (object != null && object instanceof ValueBinding) {
                                String string2 = ((ValueBinding)object).getExpressionString();
                                if (this._type == 1) {
                                    object = AssemblyUtils.createActionMethodBinding(string2);
                                } else if (this._type == 2) {
                                    object = AssemblyUtils.createActionListenerMethodBinding(string2);
                                } else if (this._type == 3) {
                                    object = AssemblyUtils.createValueChangedListenerMethodBinding(string2);
                                }
                                if (BPCClientTrace.isTracing) {
                                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Converting ValueBinding " + string2 + " to MethodBinding of type " + this._type));
                                }
                                return object;
                            }
                            break block25;
                        }
                        default: {
                            return object;
                        }
                    }
                }
                if (object instanceof ValueBinding) {
                    string = ((ValueBinding)object).getExpressionString();
                } else if (object instanceof MethodBinding) {
                    string = ((MethodBinding)object).getExpressionString();
                } else if (object instanceof String) {
                    string = (String)object;
                }
                switch (this._type) {
                    case 0: {
                        object2 = AssemblyUtils.createValueBinding(string, this._extension);
                        break;
                    }
                    case 1: {
                        object2 = AssemblyUtils.createActionMethodBinding(string, this._extension);
                        break;
                    }
                    case 2: {
                        object2 = AssemblyUtils.createActionListenerMethodBinding(string, this._extension);
                        break;
                    }
                    case 3: {
                        object2 = AssemblyUtils.createValueChangedListenerMethodBinding(string, this._extension);
                        break;
                    }
                    case 4: {
                        object2 = object;
                    }
                }
                return object2;
            }
            return object;
        }

        public String getAttribute() {
            return this._attribute;
        }

        public String getTargetComponentID() {
            return this._targetComponentID;
        }

        public String getTargetAttribute() {
            return this._targetAttribute;
        }

        public boolean isLateBound() {
            return this._lateBound;
        }

        public int getType() {
            return this._type;
        }

        public String toString() {
            String string = this._extension != null ? this._attribute + "." + this._extension : this._attribute;
            String string2 = this._targetAttribute != null ? this._targetComponentID + "." + this._targetAttribute : this._targetComponentID;
            return this._lateBound ? string + "-->" + string2 + " (lateBound==true)" : string + "-->" + string2 + " (lateBound==false)";
        }
    }

    static class AssemblyData {
        public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2008.\n\n";
        protected Map _dispatchTable = new HashMap();
        protected Set _attributeCache = new HashSet();
        protected Set _valueBindingCache = new HashSet();
        protected Set _methodBindingCache = new HashSet();
        protected Set _converterCache = new HashSet();
        protected Map _targetMap = null;
        protected UIComponent _delegatingComponent = null;

        public AssemblyData(Map map, UIComponent uIComponent, Map map2) {
            this._targetMap = map;
            this._delegatingComponent = uIComponent;
            this._dispatchTable = map2;
        }

        public Set getAttributeCache() {
            return this._attributeCache;
        }

        public Set getValueBindingCache() {
            return this._valueBindingCache;
        }

        public Set getMethodBindingCache() {
            return this._methodBindingCache;
        }

        public Set getConverterCache() {
            return this._converterCache;
        }

        public UIComponent getDelegatingComponent() {
            return this._delegatingComponent;
        }

        public Map getTargetMap() {
            return this._targetMap;
        }

        public Map getDispatchTable() {
            return this._dispatchTable;
        }

        public void setAttributeCache(Set set) {
            this._attributeCache = set;
        }

        public void setValueBindingCache(Set set) {
            this._valueBindingCache = set;
        }

        public void setMethodBindingCache(Set set) {
            this._methodBindingCache = set;
        }

        public void setConverterCache(Set set) {
            this._converterCache = set;
        }

        public void setDelegatingComponent(UIComponent uIComponent) {
            this._delegatingComponent = uIComponent;
        }

        public void setTargetMap(Map map) {
            this._targetMap = map;
        }

        public void setDispatchTable(Map map) {
            this._dispatchTable = map;
        }

        public String getDelegatingComponentName() {
            if (this._delegatingComponent != null) {
                return this._delegatingComponent.getClass().getName();
            }
            return "";
        }
    }
}

