/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.jsf.component;

import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.jsf.component.ContextHelp;
import com.ibm.bpe.jsf.component.TabbedPaneComponent;
import com.ibm.bpe.util.Assert;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIPanel;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import javax.faces.render.Renderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabbedPaneRenderer
extends Renderer {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";

    public boolean getRendersChildren() {
        return true;
    }

    public void decode(FacesContext facesContext, UIComponent uIComponent) {
        Map map = facesContext.getExternalContext().getRequestParameterMap();
        String string = uIComponent.getClientId(facesContext);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)(string + " - requestParams: '" + map));
        }
        String string2 = (String)map.get(TabbedPaneRenderer.getHiddenFieldId(string));
        String string3 = (String)map.get(TabbedPaneRenderer.getHiddenField2Id(string));
        if (string2 != null && !string2.equals("")) {
            TabbedPaneComponent tabbedPaneComponent = (TabbedPaneComponent)uIComponent;
            tabbedPaneComponent.setSelectedPaneId(string2);
        }
        if ("true".equals(string3)) {
            uIComponent.queueEvent((FacesEvent)new ActionEvent(uIComponent));
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)(string + " - selected pane id: " + string2));
        }
        if (facesContext.getViewRoot() != null) {
            facesContext.getViewRoot().setTransient(false);
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        responseWriter.startElement("div", uIComponent);
        responseWriter.writeAttribute("id", (Object)uIComponent.getClientId(facesContext), null);
        String string = (String)uIComponent.getAttributes().get("styleClass");
        if (string != null) {
            responseWriter.writeAttribute("class", (Object)string, null);
        }
        responseWriter.write("\n");
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        if (uIComponent.getChildCount() == 0) {
            return;
        }
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        responseWriter.startElement("div", uIComponent);
        String string = (String)uIComponent.getAttributes().get("tabHeaderClass");
        if (string != null) {
            responseWriter.writeAttribute("class", (Object)string, null);
        }
        responseWriter.startElement("table", uIComponent);
        String string2 = uIComponent.getClientId(facesContext);
        responseWriter.writeAttribute("id", (Object)TabbedPaneRenderer.getTabHeaderId(string2), null);
        if (string != null) {
            responseWriter.writeAttribute("class", (Object)string, null);
        }
        responseWriter.startElement("tr", uIComponent);
        TabbedPaneComponent tabbedPaneComponent = (TabbedPaneComponent)uIComponent;
        String string3 = tabbedPaneComponent.getSelectedPaneId();
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)(string2 + " - selected pane id: " + string3));
        }
        List<UIPanel> list = TabbedPaneRenderer.getPanels(uIComponent);
        List<String> list2 = this.getClientIDs(facesContext, list);
        for (UIPanel uIPanel : list) {
            boolean bl = this.getRenderPane((UIComponent)uIPanel);
            if (BPCClientTrace.isTracing) {
                String string4 = (String)uIPanel.getAttributes().get("label");
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)(string2 + " - encode tabs, renderPane for label '" + string4 + "': " + bl));
            }
            if (!bl) continue;
            if (string3 == null) {
                string3 = uIPanel.getId();
                tabbedPaneComponent.setSelectedPaneId(string3);
            }
            this.encodeTab(facesContext, responseWriter, uIComponent, (UIComponent)uIPanel, list2);
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)(string2 + " - selected pane id: " + tabbedPaneComponent.getSelectedPaneId()));
        }
        responseWriter.endElement("tr");
        responseWriter.endElement("table");
        responseWriter.endElement("div");
        responseWriter.write("\n");
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        TabbedPaneComponent tabbedPaneComponent = (TabbedPaneComponent)uIComponent;
        String string = tabbedPaneComponent.getSelectedPaneId();
        List<UIPanel> list = TabbedPaneRenderer.getPanels(uIComponent);
        for (int i = 0; i < list.size(); ++i) {
            UIComponent uIComponent2 = (UIComponent)list.get(i);
            boolean bl = uIComponent2.getId().equals(string);
            boolean bl2 = Boolean.valueOf((String)uIComponent2.getAttributes().get("cached"));
            boolean bl3 = this.getRenderPane(uIComponent2);
            if (BPCClientTrace.isTracing) {
                String string2 = (String)uIComponent2.getAttributes().get("label");
                String string3 = uIComponent.getClientId(facesContext);
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)(string3 + " - encode pane, rendePane for label '" + string2 + "': " + bl3));
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("cached = " + bl2 + "; selected = " + bl));
            }
            if (bl) {
                this.encodeChild(uIComponent, uIComponent2, facesContext, true);
                continue;
            }
            if (bl2 && bl3) {
                this.encodeChild(uIComponent, uIComponent2, facesContext, false);
                continue;
            }
            uIComponent2.setRendered(false);
        }
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        responseWriter.endElement("div");
        this.encodeHiddenField(facesContext, responseWriter, uIComponent);
    }

    private void encodeHiddenField(FacesContext facesContext, ResponseWriter responseWriter, UIComponent uIComponent) throws IOException {
        responseWriter.startElement("input", uIComponent);
        responseWriter.writeAttribute("type", (Object)"hidden", null);
        String string = TabbedPaneRenderer.getHiddenFieldId(uIComponent.getClientId(facesContext));
        responseWriter.writeAttribute("id", (Object)string, null);
        responseWriter.writeAttribute("name", (Object)string, null);
        TabbedPaneComponent tabbedPaneComponent = (TabbedPaneComponent)uIComponent;
        String string2 = tabbedPaneComponent.getSelectedPaneId();
        if (string2 != null) {
            responseWriter.writeAttribute("value", (Object)string2, null);
        }
        responseWriter.endElement("input");
        responseWriter.startElement("input", uIComponent);
        responseWriter.writeAttribute("type", (Object)"hidden", null);
        string = TabbedPaneRenderer.getHiddenField2Id(uIComponent.getClientId(facesContext));
        responseWriter.writeAttribute("id", (Object)string, null);
        responseWriter.writeAttribute("name", (Object)string, null);
        responseWriter.writeAttribute("value", (Object)"false", null);
        responseWriter.endElement("input");
    }

    private void encodeTab(FacesContext facesContext, ResponseWriter responseWriter, UIComponent uIComponent, UIComponent uIComponent2, List<String> list) throws IOException {
        block14: {
            Object object;
            String string9;
            String string2 = uIComponent2.getId();
            String string3 = uIComponent2.getClientId(facesContext);
            String string4 = (String)uIComponent.getAttributes().get("tabClass");
            String string5 = (String)uIComponent.getAttributes().get("selectedTabClass");
            responseWriter.startElement("td", uIComponent);
            responseWriter.writeAttribute("id", (Object)TabbedPaneRenderer.getTabHeaderId(string3), null);
            String string6 = ((TabbedPaneComponent)uIComponent).getSelectedPaneId();
            if (string6 != null && string6.equals(string2)) {
                if (string5 != null) {
                    responseWriter.writeAttribute("class", (Object)string5, null);
                }
            } else if (string4 != null) {
                responseWriter.writeAttribute("class", (Object)string4, null);
            }
            String string7 = uIComponent.getClientId(facesContext);
            String string8 = TabbedPaneRenderer.getFormId(facesContext, uIComponent);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("var hidden = document.getElementById('" + TabbedPaneRenderer.getHiddenFieldId(string7) + "');");
            stringBuffer.append("var newPaneField = document.getElementById('" + TabbedPaneRenderer.getHiddenField2Id(string7) + "');");
            stringBuffer.append("var newPane = (hidden.value != '" + string2 + "');" + "if (newPane) {" + "hidden.value='" + string2 + "'; " + "newPaneField.value='true'; " + "}");
            boolean bl = Boolean.valueOf((String)uIComponent2.getAttributes().get("cached"));
            if (bl) {
                stringBuffer.append("var changed = true; " + (string5 != null ? "if (this.className=='" + string5 + "') changed = false; " : "") + "if (changed) {" + "var header; var helpLink; var pane;");
                for (String string9 : list) {
                    if (!string3.equals(string9)) {
                        if (string4 != null) {
                            stringBuffer.append("header = document.getElementById('" + TabbedPaneRenderer.getTabHeaderId(string9) + "');" + " if (header!=undefined) header.className='" + string4 + "';");
                        }
                        stringBuffer.append("pane = document.getElementById('" + TabbedPaneRenderer.getPaneId(string9) + "');" + " if (pane!=undefined) pane.style.display='none';");
                        continue;
                    }
                    if (string5 != null) {
                        stringBuffer.append("header = document.getElementById('" + TabbedPaneRenderer.getTabHeaderId(string9) + "');" + " if (header!=undefined) header.className='" + string5 + "';");
                    }
                    stringBuffer.append("pane = document.getElementById('" + TabbedPaneRenderer.getPaneId(string9) + "');" + " if (pane!=undefined) pane.style.display='block';");
                }
                stringBuffer.append("this.firstChild.focus(); }if (changed) return false;");
            } else {
                object = (String)uIComponent2.getAttributes().get("formSubmit");
                if (object == null) {
                    object = "document.forms['" + string8 + "'].submit(); ";
                }
                stringBuffer.append("var changed = true; " + (string5 != null ? "if (this.className=='" + string5 + "') changed = false; " : "") + "if (changed) {" + "document.cursor='wait' ;" + (String)object + "return false;" + "}");
            }
            responseWriter.writeAttribute("onclick", (Object)stringBuffer.toString(), null);
            object = facesContext.getExternalContext().getRequestLocale();
            string9 = (String)uIComponent2.getAttributes().get("contextId");
            String string10 = (String)uIComponent2.getAttributes().get("label");
            responseWriter.startElement("a", uIComponent);
            responseWriter.writeAttribute("href", (Object)"#", "href");
            responseWriter.writeAttribute("title", (Object)(string10 != null ? string10 : ""), null);
            responseWriter.write(string10 != null ? string10 : "");
            responseWriter.endElement("a");
            if (string9 != null) {
                try {
                    String string11 = ContextHelp.determineHelpUrl(facesContext, string9, (Locale)object);
                    responseWriter.write("&nbsp;");
                    String string12 = ContextHelp.getConfigurationString(ContextHelp.ICON_SRC);
                    ContextHelp.encodeLink(responseWriter, uIComponent, TabbedPaneRenderer.getTabHeaderHelpLinkId(string3), string11, string12, null, "helpLink");
                    ContextHelp.encodeIcon(responseWriter, uIComponent, string12, null, "inactiveHelpLink");
                }
                catch (Exception exception) {
                    if (!BPCClientTrace.isTracing) break block14;
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("No help for contextId " + string9 + " - " + exception.getMessage()));
                }
            }
        }
        responseWriter.endElement("td");
        responseWriter.write("\n");
    }

    private void encodeChild(UIComponent uIComponent, UIComponent uIComponent2, FacesContext facesContext, boolean bl) throws IOException {
        Assert.assertion((uIComponent2 != null ? 1 : 0) != 0, (String)"child != null");
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        responseWriter.startElement("div", uIComponent);
        responseWriter.writeAttribute("id", (Object)TabbedPaneRenderer.getPaneId(uIComponent2.getClientId(facesContext)), null);
        String string = (String)uIComponent.getAttributes().get("tabPaneClass");
        if (string != null) {
            responseWriter.writeAttribute("class", (Object)string, null);
        }
        if (!bl) {
            responseWriter.writeAttribute("style", (Object)"display:none", null);
        }
        uIComponent2.setRendered(true);
        uIComponent2.encodeBegin(facesContext);
        if (uIComponent2.getRendersChildren()) {
            uIComponent2.encodeChildren(facesContext);
        }
        uIComponent2.encodeEnd(facesContext);
        responseWriter.endElement("div");
    }

    private static List<UIPanel> getPanels(UIComponent uIComponent) {
        ArrayList<UIPanel> arrayList = new ArrayList<UIPanel>();
        for (UIComponent uIComponent2 : uIComponent.getChildren()) {
            if (!(uIComponent2 instanceof UIPanel)) continue;
            arrayList.add((UIPanel)uIComponent2);
        }
        return arrayList;
    }

    private static String getFormId(FacesContext facesContext, UIComponent uIComponent) {
        UIComponent uIComponent2 = uIComponent;
        while (!(uIComponent2 instanceof UIForm)) {
            uIComponent2 = uIComponent2.getParent();
        }
        return uIComponent2.getClientId(facesContext);
    }

    private static String getPaneId(String string) {
        return string + ":pane";
    }

    private static String getTabHeaderId(String string) {
        return string + ":tabHeader";
    }

    private static String getTabHeaderHelpLinkId(String string) {
        return TabbedPaneRenderer.getTabHeaderId(string) + ":helpLink";
    }

    private static String getHiddenFieldId(String string) {
        return string + ":selectedPaneId";
    }

    private static String getHiddenField2Id(String string) {
        return string + ":newPane";
    }

    private List<String> getClientIDs(FacesContext facesContext, List<UIPanel> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (UIPanel uIPanel : list) {
            arrayList.add(uIPanel.getClientId(facesContext));
        }
        return arrayList;
    }

    private boolean getRenderPane(UIComponent uIComponent) {
        boolean bl = true;
        Object v = uIComponent.getAttributes().get("renderPane");
        if (v != null && v instanceof Boolean) {
            bl = (Boolean)v;
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("renderPaneAttribute = " + v + "; renderPane = " + bl));
        }
        return bl;
    }
}

