/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.jsf.component;

import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.jsf.util.FacesUtils;
import com.ibm.bpe.jsf.util.LocaleUtils;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import java.io.IOException;
import java.util.Map;
import java.util.StringTokenizer;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import javax.servlet.http.HttpServletRequest;

public class NavigatorComponent
extends UICommand {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";
    static final String SEARCH_ACTION = "search";
    private String label;
    private String titleStyleClass;
    private String embeddedStyleClass;
    private String userRoles;

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public String getTitleStyleClass() {
        return this.titleStyleClass;
    }

    public void setTitleStyleClass(String string) {
        this.titleStyleClass = string;
    }

    public String getEmbeddedStyleClass() {
        return this.embeddedStyleClass;
    }

    public void setEmbeddedStyleClass(String string) {
        this.embeddedStyleClass = string;
    }

    public String getUserRoles() {
        return this.userRoles;
    }

    public void setUserRoles(String string) {
        this.userRoles = string;
    }

    public void decode(FacesContext facesContext) {
        String string;
        Map map;
        String string2;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        if ((string2 = (String)(map = facesContext.getExternalContext().getRequestParameterMap()).get((string = this.getClientId(facesContext)) + ":action")) != null && !string2.equals("")) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Navigator linkAction: " + string2));
            }
            ActionEvent actionEvent = new ActionEvent((UIComponent)this);
            this.queueEvent((FacesEvent)actionEvent);
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
        super.decode(facesContext);
    }

    public void encodeBegin(FacesContext facesContext) throws IOException {
        if (!this.isUserInRole(this.userRoles)) {
            return;
        }
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        responseWriter.startElement("div", (UIComponent)this);
        responseWriter.writeAttribute("id", (Object)this.getClientId(facesContext), "clientId");
        String string = (String)this.getAttributes().get("styleClass");
        if (string != null) {
            responseWriter.writeAttribute("class", (Object)string, "styleClass");
        }
        this.encodeTitle(facesContext);
        responseWriter.startElement("div", (UIComponent)this);
        responseWriter.writeAttribute("id", (Object)NavigatorComponent.getEmbeddedSectionId(this.getClientId(facesContext)), "id");
        String string2 = "expanded";
        if (this.getCollapsed(facesContext)) {
            string2 = "collapsed";
        }
        responseWriter.writeAttribute("class", (Object)string2, "styleClass");
    }

    public void encodeChildren(FacesContext facesContext) throws IOException {
        if (this.getChildCount() == 0) {
            return;
        }
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        for (UIComponent uIComponent : this.getChildren()) {
            if (!this.isUserInRole(this.userRoles) || !uIComponent.isRendered()) continue;
            responseWriter.startElement("div", (UIComponent)this);
            uIComponent.encodeBegin(facesContext);
            if (uIComponent.getRendersChildren()) {
                uIComponent.encodeChildren(facesContext);
            }
            uIComponent.encodeEnd(facesContext);
            responseWriter.endElement("div");
        }
    }

    public void encodeEnd(FacesContext facesContext) throws IOException {
        if (!this.isUserInRole(this.userRoles)) {
            return;
        }
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        responseWriter.endElement("div");
        responseWriter.endElement("div");
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void encodeTitle(FacesContext facesContext) throws IOException {
        ValueBinding valueBinding;
        if (this.label == null && (valueBinding = this.getValueBinding("label")) != null) {
            this.label = (String)valueBinding.getValue(facesContext);
        }
        if (this.label != null) {
            valueBinding = facesContext.getResponseWriter();
            valueBinding.startElement("div", (UIComponent)this);
            if (this.getAttributes().get("titleStyleClass") != null) {
                valueBinding.writeAttribute("class", this.getAttributes().get("titleStyleClass"), "styleClass");
            }
            valueBinding.startElement("table", (UIComponent)this);
            valueBinding.writeAttribute("style", (Object)"table-layout:fixed;width:100%;", "style");
            valueBinding.startElement("tr", (UIComponent)this);
            String string = "toggleExpanded";
            if (this.getCollapsed(facesContext)) {
                string = "toggleCollapsed";
            }
            valueBinding.startElement("td", (UIComponent)this);
            valueBinding.writeAttribute("id", (Object)NavigatorComponent.getToggleSectionId(this.getClientId(facesContext)), "id");
            valueBinding.writeAttribute("style", (Object)"padding:0px;width:10px;height:100%;cursor:pointer", "style");
            valueBinding.writeAttribute("class", (Object)string, "styleClass");
            valueBinding.writeAttribute("onClick", (Object)("toggle('" + NavigatorComponent.getEmbeddedSectionId(this.getClientId(facesContext)) + "', this)"), "onClick");
            valueBinding.endElement("td");
            valueBinding.startElement("td", (UIComponent)this);
            valueBinding.writeAttribute("title", (Object)this.label, "title");
            valueBinding.writeAttribute("style", (Object)"padding:4px;overflow:hidden;white-space:nowrap;", "style");
            valueBinding.write(this.label);
            valueBinding.endElement("td");
            if (this.getAction() != null) {
                String string2 = NavigatorComponent.getActionId(this.getClientId(facesContext));
                valueBinding.startElement("td", (UIComponent)this);
                valueBinding.writeAttribute("style", (Object)"padding:0px;width:18px;text-align:center;vertical-align:middle;", "style");
                valueBinding.startElement("input", (UIComponent)this);
                valueBinding.writeAttribute("type", (Object)"hidden", null);
                valueBinding.writeAttribute("id", (Object)string2, null);
                valueBinding.writeAttribute("name", (Object)string2, null);
                valueBinding.writeAttribute("value", (Object)"", null);
                valueBinding.endElement("input");
                valueBinding.startElement("a", (UIComponent)this);
                String string3 = "javascript:var naviAction = document.getElementById('" + string2 + "');" + "naviAction.value='" + SEARCH_ACTION + "';" + "if (naviAction.form.onsubmit) {" + "if (naviAction.form.onsubmit()) naviAction.form.submit();" + "} else {" + "naviAction.form.submit();" + "};";
                valueBinding.writeAttribute("href", (Object)string3, "href");
                valueBinding.startElement("img", (UIComponent)this);
                valueBinding.writeAttribute("style", (Object)"width:18px;height:18px;cursor:pointer", "style");
                valueBinding.writeAttribute("src", (Object)FacesUtils.getImageUrl("newQuery.gif"), "src");
                valueBinding.writeAttribute("alt", (Object)"New search", "alt");
                valueBinding.writeAttribute("title", (Object)"New search", "title");
                valueBinding.writeAttribute("border", (Object)"0", "border");
                valueBinding.writeAttribute("onLoad", (Object)"this.alt=SEARCH_TEXT;this.title=SEARCH_TEXT;", "onLoad");
                valueBinding.endElement("img");
                valueBinding.endElement("a");
                valueBinding.endElement("td");
            }
            valueBinding.endElement("tr");
            valueBinding.endElement("table");
            valueBinding.endElement("div");
        }
    }

    private boolean isUserInRole(String string) {
        if (string == null) {
            return true;
        }
        ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
        Object object = externalContext.getRequest();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            HttpServletRequest httpServletRequest;
            String string2 = stringTokenizer.nextToken();
            if (!(object instanceof HttpServletRequest) || !(httpServletRequest = (HttpServletRequest)object).isUserInRole(string2)) continue;
            return true;
        }
        return false;
    }

    private boolean getCollapsed(FacesContext facesContext) {
        ValueBinding valueBinding;
        Boolean bl = null;
        if (bl == null && this.getAttributes().get("collapsed") != null && (valueBinding = this.getValueBinding("collapsed")) != null) {
            bl = (Boolean)valueBinding.getValue(facesContext);
        }
        return bl != null ? bl : false;
    }

    private static String getEmbeddedSectionId(String string) {
        return string + ":embedded";
    }

    private static String getToggleSectionId(String string) {
        return string + ":toggle";
    }

    private static String getActionId(String string) {
        return string + ":action";
    }

    public static String getJavaScriptConstants(String string) {
        String string2 = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("var DELETE_TEXT = \"" + LocaleUtils.getLocalizedString("NAVIGATION.MENU.DELETE", string) + "\";" + string2);
        stringBuffer.append("var MODIFY_TEXT = \"" + LocaleUtils.getLocalizedString("NAVIGATION.MENU.MODIFY", string) + "\";" + string2);
        stringBuffer.append("var COPY_TEXT = \"" + LocaleUtils.getLocalizedString("NAVIGATION.MENU.COPY", string) + "\";" + string2);
        stringBuffer.append("var EXPORT_TEXT = \"" + LocaleUtils.getLocalizedString("NAVIGATION.MENU.EXPORT", string) + "\";" + string2);
        stringBuffer.append("var MOVEUP_TEXT = \"" + LocaleUtils.getLocalizedString("NAVIGATION.MENU.MOVEUP", string) + "\";" + string2);
        stringBuffer.append("var MOVEDOWN_TEXT = \"" + LocaleUtils.getLocalizedString("NAVIGATION.MENU.MOVEDOWN", string) + "\";" + string2);
        stringBuffer.append("var SEARCH_TEXT = \"" + LocaleUtils.getLocalizedString("NAVIGATION.MENU.SEARCH", string) + "\";" + string2);
        stringBuffer.append("var SHOW_POPUP_TEXT = \"" + LocaleUtils.getLocalizedString("NAVIGATION.MENU.SHOWPOPUP", string) + "\";" + string2);
        stringBuffer.append("var CLOSE_POPUP_TEXT = \"" + LocaleUtils.getLocalizedString("NAVIGATION.MENU.CLOSEPOPUP", string) + "\";" + string2);
        stringBuffer.append("var ASYNC_TEXT = \"" + LocaleUtils.getLocalizedString("NAVIGATION.MENU.ASYNC", string) + "\";" + string2);
        stringBuffer.append("var ASYNC_PROGRESS_TEXT = \"" + LocaleUtils.getLocalizedString("NAVIGATION.MENU.ASYNCPROGRESS", string) + "\";" + string2);
        stringBuffer.append("var ASYNC_OK_TEXT = \"" + LocaleUtils.getLocalizedString("NAVIGATION.MENU.ASYNCOK", string) + "\";" + string2);
        return stringBuffer.toString();
    }
}

