/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.jsf.component;

import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.jsf.component.MessageComponent;
import com.ibm.bpe.jsf.component.MessageViewRenderer;
import com.ibm.bpe.jsf.component.ResponseWriterWrapper;
import com.ibm.bpe.jsf.component.SDOViewRenderer;
import com.ibm.bpe.jsf.component.SourceViewRenderer;
import com.ibm.bpe.jsf.exception.CircularReferenceInMessageException;
import com.ibm.bpe.jsf.exception.NodesLimitExceededException;
import com.ibm.bpe.jsf.message.sdo.MessageItem;
import com.ibm.bpe.jsf.util.FacesUtils;
import com.ibm.bpe.jsf.util.LocaleUtils;
import com.ibm.bpe.util.Assert;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.PhaseId;
import javax.faces.render.Renderer;

public class MessageRenderer
extends Renderer {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2008.\n\n";
    public static final String SDO_TAB = "SDO_VIEW";
    public static final String XML_TAB = "SOURCE_VIEW";
    private static final String NO_DATA = "MESSAGE_COMPONENT.RENDERING.NO_DATA";
    private MessageViewRenderer sdoTab = new SDOViewRenderer("SDO_VIEW");
    private MessageViewRenderer xmlTab = new SourceViewRenderer("SOURCE_VIEW");

    public boolean getRendersChildren() {
        return true;
    }

    public void decode(FacesContext facesContext, UIComponent uIComponent) {
        MessageComponent messageComponent;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        if ((messageComponent = (MessageComponent)uIComponent).getBooleanAttribute("xmlViewUsed")) {
            Map map = facesContext.getExternalContext().getRequestParameterMap();
            String string = messageComponent.getUniqueId(facesContext, messageComponent, "TAB");
            if (map.keySet().contains(string)) {
                messageComponent.setAttribute("selectedTab", (String)map.get(string));
            }
            if (this.isSDOViewShown(messageComponent)) {
                this.sdoTab.decode(facesContext, messageComponent);
            } else {
                this.xmlTab.decode(facesContext, messageComponent);
            }
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        Assert.assertion((boolean)(uIComponent instanceof MessageComponent), (String)(uIComponent.getClass().getName() + " must be of type MessageComponent"));
        MessageComponent messageComponent = (MessageComponent)uIComponent;
        ResponseWriterWrapper responseWriterWrapper = new ResponseWriterWrapper(facesContext.getResponseWriter());
        try {
            MessageItem messageItem = (MessageItem)messageComponent.getRootTreeNode();
            if (messageItem == null) {
                responseWriterWrapper.startElement("div", uIComponent);
                responseWriterWrapper.writeText(FacesUtils.lookupNonPIIMessage(NO_DATA), null);
                responseWriterWrapper.endElement("div");
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.exit();
                }
                return;
            }
            messageComponent.setMessageNode(null);
            if (messageComponent.getBooleanAttribute("xmlViewUsed")) {
                boolean bl = this.isSDOViewShown(messageComponent);
                responseWriterWrapper.startElement("div", uIComponent);
                if (bl) {
                    messageComponent.setAttribute("selectedTab", this.sdoTab.getTabName());
                    this.sdoTab.render(facesContext, responseWriterWrapper, messageComponent);
                } else {
                    messageComponent.setAttribute("selectedTab", this.xmlTab.getTabName());
                    this.xmlTab.render(facesContext, responseWriterWrapper, messageComponent);
                }
                responseWriterWrapper.startElement("input", uIComponent);
                responseWriterWrapper.writeAttribute("type", "hidden", null);
                responseWriterWrapper.writeAttribute("name", messageComponent.getUniqueId(facesContext, messageComponent, "TAB"), null);
                responseWriterWrapper.writeAttribute("value", messageComponent.getAttribute("selectedTab"), null);
                responseWriterWrapper.endElement("input");
                responseWriterWrapper.endElement("div");
            } else {
                this.sdoTab.renderContent(facesContext, responseWriterWrapper, messageComponent);
            }
            messageComponent.setValidationMessage(null);
            messageComponent.setRootValidationMessage(null);
            messageComponent.setAttribute("selectedTab", SDO_TAB);
        }
        catch (NodesLimitExceededException nodesLimitExceededException) {
            if (messageComponent.getBooleanAttribute("readOnly")) {
                responseWriterWrapper.startElement("div", (UIComponent)messageComponent);
                responseWriterWrapper.writeText(nodesLimitExceededException.getMessage(LocaleUtils.getFacesLocale(facesContext)), null);
                responseWriterWrapper.endElement("div");
                responseWriterWrapper.closeAllElements();
            }
            responseWriterWrapper.closeAllElements();
            throw nodesLimitExceededException;
        }
        catch (CircularReferenceInMessageException circularReferenceInMessageException) {
            responseWriterWrapper.startElement("div", (UIComponent)messageComponent);
            responseWriterWrapper.writeText(circularReferenceInMessageException.getMessage(LocaleUtils.getFacesLocale(facesContext)), null);
            responseWriterWrapper.endElement("div");
            responseWriterWrapper.closeAllElements();
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    private boolean isSDOViewShown(MessageComponent messageComponent) {
        return !this.xmlTab.getTabName().equals(messageComponent.getAttribute("selectedTab"));
    }

    public static class TabbedPaneEvent
    extends FacesEvent {
        private static final long serialVersionUID = 1L;
        private String commandName;
        private String nextTab;
        private PhaseId phase = PhaseId.INVOKE_APPLICATION;

        public TabbedPaneEvent(UIComponent uIComponent, String string) {
            super(uIComponent);
            this.commandName = string;
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Creating Event for command " + string));
            }
        }

        public TabbedPaneEvent(UIComponent uIComponent, String string, PhaseId phaseId) {
            this(uIComponent, string);
            this.phase = phaseId;
        }

        public String getCommandName() {
            return this.commandName;
        }

        public boolean isAppropriateListener(FacesListener facesListener) {
            return false;
        }

        public void processListener(FacesListener facesListener) {
            throw new IllegalStateException();
        }

        public PhaseId getPhaseId() {
            return this.phase;
        }
    }
}

