/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.jsf.component;

import com.ibm.bpc.clientcore.MessageWrapper;
import com.ibm.bpc.clientcore.util.ApplicationNameProvider;
import com.ibm.bpe.api.ProcessException;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.jsf.component.MessageRenderer;
import com.ibm.bpe.jsf.component.impl.AssemblyUtils;
import com.ibm.bpe.jsf.component.impl.ImportHelperComponent;
import com.ibm.bpe.jsf.component.impl.WidgetComponentBase;
import com.ibm.bpe.jsf.exception.InvalidMessageException;
import com.ibm.bpe.jsf.exception.InvalidXMLDocumentException;
import com.ibm.bpe.jsf.exception.ModelNotAvailableException;
import com.ibm.bpe.jsf.exception.ModelNotSpecifiedException;
import com.ibm.bpe.jsf.message.sdo.MessageContext;
import com.ibm.bpe.jsf.message.sdo.MessageItem;
import com.ibm.bpe.jsf.message.sdo.MessageNode;
import com.ibm.bpe.jsf.message.sdo.MessageNodeUtils;
import com.ibm.bpe.jsf.message.sdo.SDOViewer;
import com.ibm.bpe.jsf.util.FacesUtils;
import com.ibm.bpe.jsf.util.InvalidPropertyMessage;
import com.ibm.bpe.jsf.util.LocaleUtils;
import com.ibm.bpe.util.Assert;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.websphere.bo.BOInstanceValidator;
import com.ibm.websphere.bo.BOXMLDocument;
import com.ibm.websphere.bo.BOXMLSerializer;
import com.ibm.websphere.sca.ServiceManager;
import com.ibm.wsspi.al.InvalidConfigException;
import com.ibm.wsspi.sca.scdl.wsdl.util.WSDLTypeHelper;
import commonj.sdo.DataObject;
import commonj.sdo.Type;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.application.Application;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.PhaseId;
import javax.servlet.ServletContext;

public class MessageComponent
extends UIInput
implements NamingContainer {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";
    public static final String FAULT_KEY_ATTRIBUTE = "faultKey";
    public static final String MESSAGE_KEY_ATTRIBUTE = "messageKey";
    public static final String PREFIX_KEY_ATTRIBUTE = "prefixKey";
    public static final String READONLY_ATTRIBUTE = "readOnly";
    public static final String RENDER_CUSTOM_JSP_ATTRIBUTE = "renderCustomJSP";
    public static final String SIMPLIFICATION_MODE_ATTRIBUTE = "simplificationMode";
    public static final String VAR_ATTRIBUTE = "var";
    public static final String DIALOG_FACET_MAP = "dialogFacetMap";
    public static final String MESSAGE_URI = "messageURI";
    public static final String MESSAGE_TYPE = "messageType";
    public static final String SELECTED_TAB = "selectedTab";
    public static final String XML_VIEW_USED = "xmlViewUsed";
    public static final String BUTTON_STYLE = "styleClass4Button";
    public static final String INVALID_INPUT_STYLE = "style4invalidInput";
    public static final String INVALID_INPUT_CLASS = "styleClass4invalidInput";
    private HashMap<String, SavedState> savedState = new HashMap();
    private MessageNode currentNode = null;
    private boolean webContainer = true;
    private String xml = null;
    private String pendingXml = null;
    private String validationMessage = null;
    private String rootValidationMessage = null;
    private Object cachedModel = null;
    private boolean boxedPrimitive = false;
    private String applicationName = null;
    private String immediateCommand = null;
    private FacesEvent immediateAction = null;
    private List validationDiagnostics;

    public MessageComponent() {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        this.setAttribute(DIALOG_FACET_MAP, new HashMap());
        this.setAttribute(SELECTED_TAB, "SDO_VIEW");
        this.webContainer = facesContext.getExternalContext().getContext() instanceof ServletContext;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    public void createSubTree() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Application application = facesContext.getApplication();
        UIViewRoot uIViewRoot = facesContext.getViewRoot();
        ImportHelperComponent importHelperComponent = (ImportHelperComponent)AssemblyUtils.createUIComponent(application, uIViewRoot, "impl.include", "importHelper");
        this.getChildren().add(importHelperComponent);
        importHelperComponent.setRendered(false);
    }

    private ImportHelperComponent getImportHelperComponent() {
        int n = this.getChildCount();
        Assert.assertion((n == 0 || n == 1 ? 1 : 0) != 0, (String)"The component must have at most 1 child");
        if (n == 0) {
            return null;
        }
        UIComponent uIComponent = (UIComponent)this.getChildren().get(0);
        Assert.assertion((boolean)(uIComponent instanceof ImportHelperComponent), (String)(uIComponent.getClass().getName() + " must be of type ImportHelperComponent"));
        return (ImportHelperComponent)uIComponent;
    }

    public String getFamily() {
        return "javax.faces.Data";
    }

    public Object getMessage() throws ModelNotSpecifiedException, ModelNotAvailableException {
        Object object = null;
        ValueBinding valueBinding = this.getValueBinding("value");
        if (valueBinding == null) {
            throw new ModelNotSpecifiedException(new Object[0]);
        }
        object = valueBinding.getValue(this.getFacesContext());
        if (object == null) {
            throw new ModelNotAvailableException(new Object[]{valueBinding.getExpressionString()});
        }
        return object;
    }

    public MessageWrapper getMessageWrapper() throws ModelNotSpecifiedException, ModelNotAvailableException {
        Object object = this.getMessage();
        return object instanceof MessageWrapper ? (MessageWrapper)object : null;
    }

    public Object getCachedMessage() {
        Object object;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        if (this.cachedModel != null) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Using cache");
                BPCClientTrace.exit();
            }
            return this.cachedModel;
        }
        this.applicationName = null;
        Object object2 = null;
        Object object3 = null;
        try {
            object2 = this.getMessage();
        }
        catch (ModelNotSpecifiedException modelNotSpecifiedException) {
            WidgetComponentBase.renderMessageBox((UIComponent)this, modelNotSpecifiedException);
        }
        catch (ModelNotAvailableException modelNotAvailableException) {
            WidgetComponentBase.renderMessageBox((UIComponent)this, modelNotAvailableException);
        }
        if (object2 != null && object2 instanceof MessageWrapper) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"MessageWrapper encountered");
            }
            if (object2 instanceof ApplicationNameProvider) {
                this.applicationName = ((ApplicationNameProvider)object2).getApplicationName();
            }
            if ((object = ((MessageWrapper)object2).getMessage()) == null) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"MessageWrapper does not contain a message");
                }
                object3 = null;
            } else {
                object3 = object instanceof DataObject ? object : object2;
            }
        } else {
            Assert.assertion((object2 == null || object2 instanceof DataObject ? 1 : 0) != 0, (String)(object2 + " should be either null or a DataObject"));
            object3 = object2;
        }
        if (object3 == null) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Could not retrieve a message");
                BPCClientTrace.exit();
            }
            return null;
        }
        if (object3 instanceof DataObject) {
            this.boxedPrimitive = false;
            object = (DataObject)object3;
            String string = object.getType().getURI();
            String string2 = object.getType().getName();
            if (!string.equals(this.getAttribute(MESSAGE_URI)) || !string2.equals(this.getAttribute(MESSAGE_TYPE))) {
                ((Map)this.getAttribute(DIALOG_FACET_MAP)).clear();
                this.setAttribute(MESSAGE_URI, string);
                this.setAttribute(MESSAGE_TYPE, string2);
            }
        } else {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Boxed Primitive");
            }
            this.boxedPrimitive = true;
        }
        SDOViewer.displayMessage(object3);
        this.cachedModel = object3;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
        return object3;
    }

    public void setCachedModel(Object object) throws ModelNotSpecifiedException, ModelNotAvailableException {
        if (object == null) {
            this.cachedModel = null;
            this.applicationName = null;
        } else if (object instanceof MessageWrapper) {
            this.cachedModel = object;
            if (object instanceof ApplicationNameProvider) {
                this.applicationName = ((ApplicationNameProvider)object).getApplicationName();
            }
        } else if (object instanceof DataObject) {
            Object object2 = this.getMessage();
            Assert.assertion((boolean)(object2 instanceof MessageWrapper), (String)"The Message Component requires a MessageWrapper as model");
            MessageWrapper messageWrapper = (MessageWrapper)object2;
            messageWrapper.setMessage(object);
            this.cachedModel = object;
            this.applicationName = null;
        }
    }

    public void setValueBinding(String string, ValueBinding valueBinding) {
        if ("value".equals(string)) {
            try {
                this.setCachedModel(null);
            }
            catch (ModelNotSpecifiedException modelNotSpecifiedException) {
            }
            catch (ModelNotAvailableException modelNotAvailableException) {}
        } else {
            this.setAttribute(string, null);
        }
        super.setValueBinding(string, valueBinding);
    }

    private void setALContext(String string) {
        try {
            if (!this.getBooleanAttribute(READONLY_ATTRIBUTE)) {
                FacesUtils.unsetRALContext(string);
                FacesUtils.setRALContext(string);
            }
        }
        catch (InvalidConfigException invalidConfigException) {
            throw new RuntimeException(invalidConfigException);
        }
    }

    private void unsetALContext(String string) {
        if (!this.getBooleanAttribute(READONLY_ATTRIBUTE)) {
            FacesUtils.unsetRALContext(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDecodes(FacesContext facesContext) {
        Boolean bl;
        Boolean bl2 = bl = this.getBooleanAttribute(READONLY_ATTRIBUTE) ? Boolean.FALSE : Boolean.TRUE;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)bl);
        }
        this.currentNode = null;
        this.savedState = new HashMap();
        if (!this.isRendered()) {
            return;
        }
        this.setMessageNode(null);
        if (this.getBooleanAttribute(RENDER_CUSTOM_JSP_ATTRIBUTE)) {
            ImportHelperComponent importHelperComponent = this.getImportHelperComponent();
            importHelperComponent.processDecodes(facesContext);
        } else {
            if (bl.booleanValue()) {
                this.process(facesContext, PhaseId.APPLY_REQUEST_VALUES);
            }
            this.decode(facesContext);
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processValidators(FacesContext facesContext) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        if (this.isRendered() && !this.getBooleanAttribute(READONLY_ATTRIBUTE) && !this.getBooleanAttribute(RENDER_CUSTOM_JSP_ATTRIBUTE) && "SDO_VIEW".equals(this.getAttribute(SELECTED_TAB))) {
            Object object;
            this.process(facesContext, PhaseId.PROCESS_VALIDATIONS);
            this.process(facesContext, PhaseId.UPDATE_MODEL_VALUES);
            if (BPCClientTrace.isTracing) {
                if (facesContext.getRenderResponse()) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"FacesContext.renderResponse has been called");
                } else {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"FacesContext.renderResponse has not been called");
                }
            }
            if ((object = this.getCachedMessage()) instanceof DataObject) {
                ArrayList arrayList;
                DataObject dataObject = (DataObject)object;
                BOInstanceValidator bOInstanceValidator = (BOInstanceValidator)new ServiceManager().locateService("com/ibm/websphere/bo/BOInstanceValidator");
                if (bOInstanceValidator.validate(dataObject, arrayList = new ArrayList(), LocaleUtils.getFacesLocale())) {
                    if (BPCClientTrace.isTracing) {
                        BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"BOInstanceValidator: Message is valid");
                    }
                } else {
                    Object object2;
                    if (BPCClientTrace.isTracing) {
                        BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"BOInstanceValidator: Message is not valid");
                    }
                    if (BPCClientTrace.isTracing) {
                        BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Setting valid to false");
                    }
                    this.setValid(false);
                    if (this.immediateCommand == null) {
                        object2 = new InvalidMessageException(new Object[0]);
                        this.setValidationMessage(object2.getMessage(LocaleUtils.getFacesLocale(facesContext)));
                    }
                    object2 = arrayList.iterator();
                    DataObject dataObject2 = null;
                    String string = super.getClientId(facesContext);
                    ArrayList<DataObject> arrayList2 = new ArrayList<DataObject>();
                    while (object2.hasNext()) {
                        dataObject2 = (DataObject)object2.next();
                        String string2 = dataObject2.getString("property");
                        if (this.immediateCommand != null) continue;
                        if ("/".equals(string2)) {
                            arrayList2.add(dataObject2);
                            continue;
                        }
                        String string3 = MessageNodeUtils.createCanonicalXPath(string2);
                        String string4 = dataObject2.getString("message");
                        String string5 = "T." + MessageNodeUtils.calculateMessageId(string3);
                        String string6 = MessageNodeUtils.getValidationClientId(string, string5) + ":error";
                        string5 = string + ":" + string5 + ":IDS";
                        if (BPCClientTrace.isTracing) {
                            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("xpath: " + string3 + " messageId: " + string5));
                            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("message: " + string4));
                        }
                        InvalidPropertyMessage invalidPropertyMessage = new InvalidPropertyMessage(string3, string4);
                        FacesUtils.queueValidationMessage(string5, invalidPropertyMessage);
                        FacesUtils.queueValidationMessage(string6, invalidPropertyMessage);
                    }
                    this.setValidationDiagnostics(arrayList2);
                    facesContext.renderResponse();
                }
            }
        }
        if (this.immediateCommand != null) {
            this.processCommand(facesContext, this.immediateCommand);
        } else if (this.immediateAction != null && facesContext.getRenderResponse()) {
            this.broadcast(this.immediateAction);
            this.immediateAction = null;
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    public void processUpdates(FacesContext facesContext) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    public void encodeBegin(FacesContext facesContext) throws IOException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        this.cachedModel = null;
        this.applicationName = null;
        if (this.isRendered()) {
            MessageWrapper messageWrapper = null;
            ImportHelperComponent importHelperComponent = this.getImportHelperComponent();
            try {
                messageWrapper = this.getMessageWrapper();
                if (messageWrapper != null) {
                    MessageNode messageNode = this.getRootTreeNode();
                    if (this.webContainer && messageWrapper.getUrl() != null && messageNode != null) {
                        this.setBooleanAttribute(RENDER_CUSTOM_JSP_ATTRIBUTE, true);
                        importHelperComponent.setRendered(true);
                        importHelperComponent.setContext(messageWrapper.getContextRoot());
                        importHelperComponent.setUrl(messageWrapper.getUrl());
                        importHelperComponent.prepareRendering(facesContext, this, messageWrapper);
                    } else {
                        importHelperComponent.setRendered(false);
                        this.setBooleanAttribute(RENDER_CUSTOM_JSP_ATTRIBUTE, false);
                    }
                } else {
                    importHelperComponent.setRendered(false);
                    this.setBooleanAttribute(RENDER_CUSTOM_JSP_ATTRIBUTE, false);
                }
            }
            catch (ModelNotSpecifiedException modelNotSpecifiedException) {
                WidgetComponentBase.renderMessageBox((UIComponent)this, modelNotSpecifiedException);
            }
            catch (ModelNotAvailableException modelNotAvailableException) {
                WidgetComponentBase.renderMessageBox((UIComponent)this, modelNotAvailableException);
            }
            if (!this.getBooleanAttribute(RENDER_CUSTOM_JSP_ATTRIBUTE)) {
                super.encodeBegin(facesContext);
            }
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext facesContext) throws IOException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        if (this.isRendered() && !this.getBooleanAttribute(RENDER_CUSTOM_JSP_ATTRIBUTE)) {
            super.encodeChildren(facesContext);
        } else {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Including Custom Java Server Faces Component");
            }
            ImportHelperComponent importHelperComponent = this.getImportHelperComponent();
            this.encodeRecursive(facesContext, (UIComponent)importHelperComponent);
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    public void encodeEnd(FacesContext facesContext) throws IOException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        this.savedState = new HashMap();
        this.setValidationMessage(null);
        this.setRootValidationMessage(null);
        this.setValidationDiagnostics(new ArrayList());
        this.immediateCommand = null;
        this.immediateAction = null;
        this.setAttribute(SELECTED_TAB, "SDO_VIEW");
        if (this.isRendered() && !this.getBooleanAttribute(RENDER_CUSTOM_JSP_ATTRIBUTE)) {
            super.encodeEnd(facesContext);
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    public boolean isValid() {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        boolean bl = super.isValid();
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)Boolean.toString(bl));
        }
        return bl;
    }

    public String getRendererType() {
        return "MessageRenderer";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcast(FacesEvent facesEvent) throws AbortProcessingException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        this.setMessageNode(null);
        if (facesEvent instanceof MessageRenderer.TabbedPaneEvent) {
            this.processCommand(facesContext, ((MessageRenderer.TabbedPaneEvent)facesEvent).getCommandName());
        } else if (facesEvent instanceof WrappedEvent) {
            WrappedEvent wrappedEvent = (WrappedEvent)facesEvent;
            String string = wrappedEvent.getNodeId();
            MessageNode messageNode = this.retrieveTreeNode(string);
            if (messageNode == null) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("ATTENTION: Could not retrieve a item for " + string));
                }
            } else {
                FacesEvent facesEvent2 = wrappedEvent.getSourceEvent();
                this.setMessageNode(messageNode);
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Broadcast for " + facesEvent2.getClass().getName() + " to component " + facesEvent2.getComponent().getClientId(facesContext)));
                }
                facesEvent2.getComponent().broadcast(facesEvent2);
                this.setMessageNode(null);
            }
        } else {
            super.broadcast(facesEvent);
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    public void queueEvent(FacesEvent facesEvent) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        if (facesEvent instanceof MessageRenderer.TabbedPaneEvent) {
            super.queueEvent(facesEvent);
        } else {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Wrapping " + facesEvent.getClass().getName() + " for " + facesEvent.getComponent().getClientId(FacesContext.getCurrentInstance())));
            }
            WrappedEvent wrappedEvent = new WrappedEvent((UIComponent)this, facesEvent, this.getCurrentNodeId());
            super.queueEvent((FacesEvent)wrappedEvent);
            if (facesEvent instanceof ActionEvent) {
                if (this.immediateAction != null && BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Attention: Overwritting immediateAction");
                }
                this.immediateAction = wrappedEvent;
            }
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    public void processCommand(FacesContext facesContext, String string) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)string);
        }
        try {
            this.savedState = new HashMap();
            if ("CANCEL".equals(string)) {
                this.processCancel(facesContext);
            } else if ("RESET".equals(string)) {
                this.processReset(facesContext);
            } else if ("CONFIRM".equals(string)) {
                this.processConfirmation(facesContext);
            } else if ("VALIDATE".equals(string)) {
                this.processValidation(facesContext);
            } else if ("VIEW_XML".equals(string)) {
                this.processViewSource(facesContext);
            } else if ("VIEW_SDO".equals(string)) {
                this.setAttribute(SELECTED_TAB, "SDO_VIEW");
            }
        }
        catch (Exception exception) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_EVENT, (Throwable)exception);
            }
            if (exception instanceof ProcessException) {
                String string2 = ((ProcessException)exception).getMessage(LocaleUtils.getFacesLocale());
                if (exception.getCause() != null) {
                    string2 = string2 + ". " + exception.getCause().getLocalizedMessage();
                    this.setRootValidationMessage(exception.getCause().getLocalizedMessage());
                }
                this.setValidationMessage(string2);
            } else if (exception.getCause() != null) {
                this.setValidationMessage(exception.getCause().getLocalizedMessage());
            } else {
                this.setValidationMessage(exception.getLocalizedMessage());
            }
            facesContext.renderResponse();
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)string);
        }
    }

    public void processViewSource(FacesContext facesContext) throws IOException {
        Object object;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        if ((object = this.getCachedMessage()) instanceof DataObject) {
            DataObject dataObject = (DataObject)object;
            BOXMLSerializer bOXMLSerializer = (BOXMLSerializer)new ServiceManager().locateService("com/ibm/websphere/bo/BOXMLSerializer");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            String string = dataObject.getType().getURI();
            String string2 = dataObject.getType().getName();
            if (string2 != null && string2.endsWith("_._type")) {
                String string3 = string2.substring(0, string2.length() - 7);
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Trimming type \"" + string2 + "\" to \"" + string3 + "\""));
                }
                string2 = string3;
            }
            if (WSDLTypeHelper.isSCAType((Type)dataObject.getType())) {
                dataObject = WSDLTypeHelper.convertToWSDLType((DataObject)dataObject, (boolean)true);
            }
            bOXMLSerializer.writeDataObject(dataObject, string, string2, (OutputStream)byteArrayOutputStream);
            this.setXml(byteArrayOutputStream.toString("utf8"));
            this.setPendingXml(this.getXml());
            this.setAttribute(SELECTED_TAB, "SOURCE_VIEW");
        } else if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Element is a boxed primitive");
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    public void processConfirmation(FacesContext facesContext) throws ModelNotSpecifiedException, ModelNotAvailableException, InvalidXMLDocumentException, IOException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        if (this.getPendingXml() != null) {
            DataObject dataObject = this.processValidation(facesContext);
            this.setCachedModel(dataObject);
            SDOViewer.displayMessage((Object)dataObject);
            this.setAttribute(SELECTED_TAB, "SDO_VIEW");
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataObject processValidation(FacesContext facesContext) throws IOException, InvalidXMLDocumentException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        if (this.getPendingXml() != null) {
            BOXMLSerializer bOXMLSerializer = (BOXMLSerializer)new ServiceManager().locateService("com/ibm/websphere/bo/BOXMLSerializer");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.getPendingXml().getBytes("utf8"));
            BOXMLDocument bOXMLDocument = null;
            DataObject dataObject = null;
            String string = this.getApplicationName();
            this.setALContext(string);
            try {
                bOXMLDocument = bOXMLSerializer.readXMLDocument((InputStream)byteArrayInputStream);
                dataObject = bOXMLDocument.getDataObject();
            }
            finally {
                this.unsetALContext(string);
            }
            ArrayList arrayList = new ArrayList();
            InvalidXMLDocumentException invalidXMLDocumentException = null;
            BOInstanceValidator bOInstanceValidator = (BOInstanceValidator)new ServiceManager().locateService("com/ibm/websphere/bo/BOInstanceValidator");
            try {
                if (bOInstanceValidator.validate(dataObject, arrayList, LocaleUtils.getFacesLocale())) {
                    if (!arrayList.isEmpty() && BPCClientTrace.isTracing) {
                        BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"DataObject is valid, but diagnostics is not empty...");
                    }
                } else {
                    SDOViewer.displayMessage((Object)dataObject);
                    this.setValidationDiagnostics(arrayList);
                    if (BPCClientTrace.isTracing) {
                        BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("DataObject " + dataObject.getType().getName() + " is not valid. Messages are: " + arrayList));
                    }
                    invalidXMLDocumentException = new InvalidXMLDocumentException(new Object[0]);
                }
            }
            catch (RuntimeException runtimeException) {
                SDOViewer.displayMessage((Object)dataObject);
                throw runtimeException;
            }
            if (invalidXMLDocumentException != null) {
                throw invalidXMLDocumentException;
            }
            this.setXml(this.getPendingXml());
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.exit();
            }
            return dataObject;
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
        return null;
    }

    public void processCancel(FacesContext facesContext) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        this.setAttribute(SELECTED_TAB, "SDO_VIEW");
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    public void processReset(FacesContext facesContext) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        this.setPendingXml(this.getXml());
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    public String getClientId(FacesContext facesContext) {
        String string = super.getClientId(facesContext);
        if (this.currentNode != null) {
            return string + ':' + this.currentNode.getIdentifier();
        }
        return string;
    }

    public String getUniqueId(FacesContext facesContext, MessageComponent messageComponent, String string) {
        return super.getClientId(facesContext) + ":" + string;
    }

    private String getCurrentNodeId() {
        return this.currentNode != null ? this.currentNode.getIdentifier() : null;
    }

    private void processNode(FacesContext facesContext, PhaseId phaseId, MessageNode messageNode) {
        UIComponent uIComponent;
        MessageContext messageContext = this.setMessageNode(messageNode);
        UIComponent uIComponent2 = messageNode.isBooleanField() ? this.getFacet("boolean") : this.getFacet("default");
        UIComponent uIComponent3 = this.getFacet("actions");
        String string = messageContext.getDialogFacet();
        UIComponent uIComponent4 = uIComponent = string != null ? this.getFacet(string) : null;
        if (uIComponent2 == null || uIComponent3 == null) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Facet \"default\" and \"actions\" are mandatory");
            }
            return;
        }
        if (phaseId != PhaseId.RESTORE_VIEW) {
            if (phaseId == PhaseId.APPLY_REQUEST_VALUES) {
                if (messageNode instanceof MessageItem) {
                    uIComponent2.processDecodes(facesContext);
                }
                uIComponent3.processDecodes(facesContext);
                if (uIComponent != null) {
                    uIComponent.processDecodes(facesContext);
                }
            } else if (phaseId == PhaseId.PROCESS_VALIDATIONS) {
                if (messageNode instanceof MessageItem) {
                    uIComponent2.processValidators(facesContext);
                }
                uIComponent3.processValidators(facesContext);
                if (uIComponent != null) {
                    uIComponent.processValidators(facesContext);
                }
            } else if (phaseId == PhaseId.UPDATE_MODEL_VALUES) {
                if (messageNode instanceof MessageItem) {
                    uIComponent2.processUpdates(facesContext);
                }
                uIComponent3.processUpdates(facesContext);
                if (uIComponent != null) {
                    uIComponent.processUpdates(facesContext);
                }
            } else if (phaseId == PhaseId.RENDER_RESPONSE) {
                // empty if block
            }
        }
        for (MessageNode messageNode2 = messageNode.getFirstChild(); messageNode2 != null; messageNode2 = messageNode2.getNextSibling()) {
            this.processNode(facesContext, phaseId, messageNode2);
        }
    }

    public MessageNode getRootTreeNode() {
        return MessageNodeUtils.createMessageItem(this.getCachedMessage(), this.getBooleanAttribute(SIMPLIFICATION_MODE_ATTRIBUTE) && !this.getBooleanAttribute(READONLY_ATTRIBUTE));
    }

    protected void process(FacesContext facesContext, PhaseId phaseId) {
        MessageNode messageNode;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)("(" + phaseId.toString() + "," + this.getClientId(facesContext) + ")"));
        }
        if ((messageNode = this.getRootTreeNode()) != null) {
            this.processNode(facesContext, phaseId, messageNode);
            this.setMessageNode(null);
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)("(" + phaseId.toString() + "," + this.getClientId(facesContext) + ")"));
        }
    }

    private MessageNode retrieveTreeNode(String string) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("retrieveNode for " + string));
        }
        Object object = this.getCachedMessage();
        MessageNode messageNode = null;
        if (object != null) {
            if (object instanceof DataObject) {
                messageNode = MessageNodeUtils.getMessageNode((DataObject)object, string, this.getBooleanAttribute(SIMPLIFICATION_MODE_ATTRIBUTE) && !this.getBooleanAttribute(READONLY_ATTRIBUTE));
            } else if (object instanceof MessageWrapper) {
                messageNode = this.getRootTreeNode();
            } else {
                Assert.assertion((boolean)false, (String)"MessageComponent only supports DOs and MessageWrapper which wrap a DO or a boxed primitive");
            }
        }
        if (messageNode != null) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("retrieveNode with uniqueNodeId: " + messageNode.getIdentifier()));
            }
        } else if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"retrieveNode null");
        }
        return messageNode;
    }

    public MessageContext setMessageNode(MessageNode messageNode) {
        String string;
        String string2 = string = messageNode != null ? messageNode.getIdentifier() : null;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)string);
        }
        this.saveDescendantState();
        this.currentNode = messageNode;
        this.restoreDescendantState();
        MessageContext messageContext = null;
        Map map = this.getFacesContext().getExternalContext().getRequestMap();
        Assert.assertion((this.getAttribute(VAR_ATTRIBUTE) != null ? 1 : 0) != 0, (String)"The var attribute is mandatory");
        if (this.currentNode == null) {
            map.remove(this.getAttribute(VAR_ATTRIBUTE));
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"No node provided");
                BPCClientTrace.exit();
            }
            return null;
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        String string3 = this.currentNode.getIdentifier();
        String string4 = super.getClientId(FacesContext.getCurrentInstance());
        String string5 = MessageNodeUtils.getValidationClientId(string4, string3);
        messageContext = MessageNodeUtils.createContext(this, this.currentNode, this.getClientId(facesContext), string5, this.getBooleanAttribute(READONLY_ATTRIBUTE));
        map.put((String)this.getAttribute(VAR_ATTRIBUTE), messageContext);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)string);
        }
        return messageContext;
    }

    private void restoreDescendantState() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)this.getClientId(facesContext));
        }
        for (UIComponent uIComponent : this.getFacets().values()) {
            this.restoreDescendantState(uIComponent, facesContext);
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)this.getClientId(facesContext));
        }
    }

    private void saveDescendantState() {
        FacesContext facesContext = this.getFacesContext();
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)this.getClientId(facesContext));
        }
        for (UIComponent uIComponent : this.getFacets().values()) {
            this.saveDescendantState(uIComponent, facesContext);
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)this.getClientId(facesContext));
        }
    }

    private void restoreDescendantState(UIComponent uIComponent, FacesContext facesContext) {
        String string = uIComponent.getId();
        uIComponent.setId(string);
        if (this.currentNode != null && uIComponent instanceof EditableValueHolder) {
            EditableValueHolder editableValueHolder = (EditableValueHolder)uIComponent;
            String string2 = uIComponent.getClientId(facesContext);
            SavedState savedState = this.savedState.get(string2);
            if (savedState == null) {
                savedState = new SavedState();
            }
            editableValueHolder.setValue(savedState.getValue());
            editableValueHolder.setValid(savedState.isValid());
            editableValueHolder.setSubmittedValue(savedState.getSubmittedValue());
            editableValueHolder.setLocalValueSet(savedState.isLocalValueSet());
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Restored state for " + uIComponent.getClientId(facesContext)));
            }
        }
        for (String string2 : uIComponent.getChildren()) {
            this.restoreDescendantState((UIComponent)string2, facesContext);
        }
    }

    private void saveDescendantState(UIComponent uIComponent, FacesContext facesContext) {
        if (uIComponent instanceof EditableValueHolder) {
            EditableValueHolder editableValueHolder = (EditableValueHolder)uIComponent;
            String string = uIComponent.getClientId(facesContext);
            SavedState savedState = this.savedState.get(string);
            if (savedState == null) {
                savedState = new SavedState();
                this.savedState.put(string, savedState);
            }
            savedState.setValue(editableValueHolder.getLocalValue());
            savedState.setValid(editableValueHolder.isValid());
            savedState.setSubmittedValue(editableValueHolder.getSubmittedValue());
            savedState.setLocalValueSet(editableValueHolder.isLocalValueSet());
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Saved state for " + uIComponent.getClientId(facesContext)));
            }
        }
        for (String string : uIComponent.getChildren()) {
            this.saveDescendantState((UIComponent)string, facesContext);
        }
    }

    private void encodeRecursive(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)uIComponent);
        }
        if (!this.isRendered()) {
            return;
        }
        uIComponent.encodeBegin(facesContext);
        if (uIComponent.getRendersChildren()) {
            uIComponent.encodeChildren(facesContext);
        } else {
            for (UIComponent uIComponent2 : uIComponent.getChildren()) {
                this.encodeRecursive(facesContext, uIComponent2);
            }
        }
        uIComponent.encodeEnd(facesContext);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)uIComponent);
        }
    }

    public Object getAttribute(String string) {
        ValueBinding valueBinding;
        Object v = this.getAttributes().get(string);
        if (v == null && (valueBinding = this.getValueBinding(string)) != null) {
            return valueBinding.getValue(FacesContext.getCurrentInstance());
        }
        return v;
    }

    public void setAttribute(String string, Object object) {
        if (object != null) {
            this.getAttributes().put(string, object);
        } else {
            this.getAttributes().remove(string);
        }
    }

    public boolean getBooleanAttribute(String string) {
        ValueBinding valueBinding;
        Boolean bl = (Boolean)this.getAttributes().get(string);
        if (bl == null && (valueBinding = this.getValueBinding(string)) != null) {
            bl = (Boolean)valueBinding.getValue(FacesContext.getCurrentInstance());
        }
        return bl != null ? bl : false;
    }

    public void setBooleanAttribute(String string, boolean bl) {
        this.getAttributes().put(string, bl);
    }

    public boolean isBoxedPrimitive() {
        this.getCachedMessage();
        return this.boxedPrimitive;
    }

    public void setBoxedPrimitive(boolean bl) {
        this.boxedPrimitive = bl;
    }

    public String getValidationMessage() {
        return this.validationMessage;
    }

    public void setValidationMessage(String string) {
        this.validationMessage = string;
    }

    public String getRootValidationMessage() {
        return this.rootValidationMessage;
    }

    public void setRootValidationMessage(String string) {
        this.rootValidationMessage = string;
    }

    public String getPendingXml() {
        return this.pendingXml;
    }

    public void setPendingXml(String string) {
        this.pendingXml = string;
    }

    public String getXml() {
        return this.xml;
    }

    public void setXml(String string) {
        this.xml = string;
    }

    public List getValidationDiagnostics() {
        return this.validationDiagnostics;
    }

    public void setValidationDiagnostics(List list) {
        this.validationDiagnostics = list;
    }

    public String getApplicationName() {
        if (this.applicationName == null) {
            Object object = this.getCachedMessage();
        }
        return this.applicationName;
    }

    public String getImmdiateCommand() {
        return this.immediateCommand;
    }

    public void setImmediateCommand(String string) {
        this.immediateCommand = string;
    }

    public Object saveState(FacesContext facesContext) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        Object[] objectArray = new Object[]{super.saveState(facesContext), this.savedState, this.currentNode, this.xml, this.pendingXml, this.validationMessage, this.rootValidationMessage, this.cachedModel, this.boxedPrimitive, this.applicationName, this.immediateCommand, this.validationDiagnostics};
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
        return objectArray;
    }

    public void restoreState(FacesContext facesContext, Object object) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        Object[] objectArray = (Object[])object;
        super.restoreState(facesContext, objectArray[0]);
        this.savedState = (HashMap)objectArray[1];
        this.currentNode = (MessageNode)objectArray[2];
        this.xml = (String)objectArray[3];
        this.pendingXml = (String)objectArray[4];
        this.validationMessage = (String)objectArray[5];
        this.rootValidationMessage = (String)objectArray[6];
        this.cachedModel = objectArray[7];
        this.boxedPrimitive = (Boolean)objectArray[8];
        this.applicationName = (String)objectArray[9];
        this.immediateCommand = (String)objectArray[10];
        this.validationDiagnostics = (List)objectArray[11];
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    public static class WrappedEvent
    extends FacesEvent {
        public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";
        private static final long serialVersionUID = 1L;
        private FacesEvent _event;
        private String _nodeId;

        public WrappedEvent(UIComponent uIComponent, FacesEvent facesEvent, String string) {
            super(uIComponent);
            this._event = facesEvent;
            this._nodeId = string;
        }

        public FacesEvent getSourceEvent() {
            return this._event;
        }

        public String getNodeId() {
            return this._nodeId;
        }

        public PhaseId getPhaseId() {
            return this._event.getPhaseId();
        }

        public void setPhaseId(PhaseId phaseId) {
            this._event.setPhaseId(phaseId);
        }

        public boolean isAppropriateListener(FacesListener facesListener) {
            return false;
        }

        public void processListener(FacesListener facesListener) {
            throw new IllegalStateException();
        }
    }

    public static class SavedState
    implements Serializable {
        public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";
        private static final long serialVersionUID = 1L;
        private Object _submittedValue = null;
        private boolean _valid = true;
        private Object _value = null;
        private boolean _localValueSet = false;

        public boolean isLocalValueSet() {
            return this._localValueSet;
        }

        public Object getSubmittedValue() {
            return this._submittedValue;
        }

        public boolean isValid() {
            return this._valid;
        }

        public Object getValue() {
            return this._value;
        }

        public void setLocalValueSet(boolean bl) {
            this._localValueSet = bl;
        }

        public void setSubmittedValue(Object object) {
            this._submittedValue = object;
        }

        public void setValid(boolean bl) {
            this._valid = bl;
        }

        public void setValue(Object object) {
            this._value = object;
        }
    }
}

