/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.jsf.component;

import com.ibm.bpc.clientcore.ColumnInfo;
import com.ibm.bpc.clientcore.DynamicalQuery;
import com.ibm.bpc.clientcore.Query;
import com.ibm.bpc.clientcore.converter.SimpleConverter;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.jsf.component.ListComponent;
import com.ibm.bpe.jsf.component.impl.AssemblyHelper;
import com.ibm.bpe.jsf.component.impl.AssemblyUtils;
import com.ibm.bpe.jsf.component.impl.ColumnHeaderComponent;
import com.ibm.bpe.jsf.component.impl.ListErrorIndicationComponent;
import com.ibm.bpe.jsf.component.impl.WidgetComponentBase;
import com.ibm.bpe.jsf.converter.FacesSimpleConverter;
import com.ibm.bpe.jsf.exception.ConfigurationException;
import com.ibm.bpe.jsf.handler.BPCListHandler;
import com.ibm.bpe.jsf.util.LocaleUtils;
import com.ibm.bpe.jsf.util.Message;
import com.ibm.bpe.util.Assert;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.faces.application.Application;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UIViewRoot;
import javax.faces.component.html.HtmlCommandLink;
import javax.faces.component.html.HtmlOutputText;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;

public class DynamicListComponent
extends ListComponent {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2008.\n\n";
    public static final String MAX_COLUMNS = "50";
    private String _columns;
    public static final String TABLE_ID = "_bpc_table";

    public DynamicListComponent() {
        this.showMessageBoxAndChild = true;
    }

    public String getColumns() {
        if (null != this._columns) {
            return this._columns;
        }
        ValueBinding valueBinding = this.getValueBinding("columns");
        if (valueBinding != null) {
            return (String)valueBinding.getValue(this.getFacesContext());
        }
        return MAX_COLUMNS;
    }

    private int getNumberOfColumns() {
        return Integer.parseInt(this.getColumns());
    }

    public void setColumns(String string) {
        this._columns = string;
    }

    public void addErrorIndicationColumn() {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Application application = facesContext.getApplication();
        UIViewRoot uIViewRoot = facesContext.getViewRoot();
        UIColumn uIColumn = (UIColumn)AssemblyUtils.createUIComponent(application, uIViewRoot, "javax.faces.Column", "CE");
        ListErrorIndicationComponent listErrorIndicationComponent = (ListErrorIndicationComponent)AssemblyUtils.createUIComponent(application, uIViewRoot, "impl.ErrorIndication", "EI");
        listErrorIndicationComponent.setValueBinding("item", application.createValueBinding("#{item.object}"));
        uIColumn.getChildren().add(listErrorIndicationComponent);
        ((UIComponent)this.getCurrentRegisteredComponent("TABLE")).getChildren().add(uIColumn);
        this.register("ERRORINDICATION", (Object)listErrorIndicationComponent);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    public void encodeChildren(FacesContext facesContext) throws IOException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        ValueBinding valueBinding = this.getRoot().getValueBinding("bpcModel");
        BPCListHandler bPCListHandler = (BPCListHandler)valueBinding.getValue(facesContext);
        bPCListHandler.getItems();
        Query query = bPCListHandler.getQuery();
        if (!(query instanceof DynamicalQuery)) {
            return;
        }
        DynamicalQuery dynamicalQuery = (DynamicalQuery)query;
        List list = dynamicalQuery.getColumnInfoList();
        Message message = bPCListHandler.getQueryMessage();
        if (message != null) {
            if (message instanceof WidgetComponentBase.InternalMessage && "EMPTY_LIST".equals(((WidgetComponentBase.InternalMessage)message).getKey())) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Ignoring empty list message");
                }
            } else {
                this.setMessage(message);
            }
        }
        Iterator iterator = this.getChildren().iterator();
        boolean bl = false;
        while (iterator.hasNext() && !bl) {
            UIComponent uIComponent = (UIComponent)iterator.next();
            if (!(uIComponent instanceof UIData)) continue;
            this.initializeColumns(facesContext, uIComponent, dynamicalQuery.getBundleName(), list, !bPCListHandler.getErrors().isEmpty());
            bl = true;
        }
        super.encodeChildren(facesContext);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    private void initializeColumns(FacesContext facesContext, UIComponent uIComponent, String string, List list, boolean bl) throws IOException {
        if (BPCClientTrace.isTracing) {
            if (list != null) {
                BPCClientTrace.entry((Object)("column info size: " + list.size()));
            } else {
                BPCClientTrace.entry((Object)"column info size: 0");
            }
        }
        Application application = facesContext.getApplication();
        if (list != null) {
            Iterator iterator = list.iterator();
            UIColumn uIColumn = (UIColumn)uIComponent.findComponent("CE");
            if (bl) {
                uIColumn.setRendered(true);
            } else {
                uIColumn.setRendered(false);
            }
            for (int i = 0; i < this.getNumberOfColumns(); ++i) {
                UIColumn uIColumn2 = (UIColumn)uIComponent.findComponent("C" + i);
                if (iterator.hasNext()) {
                    Object object;
                    ColumnInfo columnInfo = (ColumnInfo)iterator.next();
                    String string2 = columnInfo.getPropertyName();
                    if (string2 == null) continue;
                    if (BPCClientTrace.isTracing) {
                        BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Render column: " + uIColumn2.getId()));
                        BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Column name: " + uIColumn2.getId()));
                        BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Column info label: " + columnInfo.getLabel()));
                        BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Column info labelKey: " + columnInfo.getLabelKey()));
                    }
                    uIColumn2.setRendered(true);
                    String string3 = columnInfo.getLabel();
                    if (string3 == null) {
                        object = columnInfo.getLabelKey();
                        string3 = object != null ? com.ibm.bpc.clientcore.util.LocaleUtils.getLocalizedString((String)string, (Locale)LocaleUtils.getLocale(), (String)object) : "n/a";
                    }
                    object = columnInfo.getPropertyConverter();
                    MethodBinding methodBinding = null;
                    if (columnInfo.getAction() != null) {
                        if (BPCClientTrace.isTracing) {
                            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Column info action: " + columnInfo.getAction()));
                        }
                        methodBinding = application.createMethodBinding(columnInfo.getAction(), new Class[0]);
                    }
                    ColumnHeaderComponent columnHeaderComponent = (ColumnHeaderComponent)uIColumn2.findComponent("CH" + i);
                    HtmlOutputText htmlOutputText = (HtmlOutputText)uIColumn2.findComponent("HOTb" + i);
                    HtmlCommandLink htmlCommandLink = (HtmlCommandLink)uIColumn2.findComponent("HCLb" + i);
                    htmlCommandLink.setAction(methodBinding);
                    HtmlOutputText htmlOutputText2 = (HtmlOutputText)htmlCommandLink.findComponent("HOTCLb" + i);
                    htmlOutputText.setValueBinding("value", application.createValueBinding("#{item.object." + string2 + "}"));
                    htmlOutputText2.setValueBinding("value", application.createValueBinding("#{item.object." + string2 + "}"));
                    if (methodBinding != null) {
                        htmlOutputText.setRendered(false);
                        htmlCommandLink.setRendered(true);
                    } else {
                        htmlCommandLink.setRendered(false);
                        htmlOutputText.setRendered(true);
                    }
                    if (object != null) {
                        if (BPCClientTrace.isTracing) {
                            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Column info converter: " + object.getClass().getName()));
                        }
                        if (object instanceof SimpleConverter) {
                            FacesSimpleConverter facesSimpleConverter = new FacesSimpleConverter();
                            facesSimpleConverter.setSimpleConverter((SimpleConverter)object);
                            htmlOutputText.setConverter((Converter)facesSimpleConverter);
                            htmlOutputText2.setConverter((Converter)facesSimpleConverter);
                        } else {
                            htmlOutputText.setConverter((Converter)object);
                            htmlOutputText2.setConverter((Converter)object);
                        }
                    } else {
                        htmlOutputText.setConverter(null);
                        htmlOutputText2.setConverter(null);
                    }
                    columnHeaderComponent.getAttributes().put("property", string2);
                    columnHeaderComponent.getAttributes().put("columnInfo", columnInfo);
                    columnHeaderComponent.getAttributes().put("label", string3);
                    continue;
                }
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Don't render column: " + uIColumn2.getId()));
                }
                uIColumn2.setRendered(false);
            }
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    public void addColumn(int n) throws ConfigurationException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        if (this.getAllRegisteredComponents("COLUMN") == null) {
            this.addCheckboxColumn();
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Application application = facesContext.getApplication();
        UIViewRoot uIViewRoot = facesContext.getViewRoot();
        UIColumn uIColumn = (UIColumn)AssemblyUtils.createUIComponent(application, uIViewRoot, "javax.faces.Column", "C" + Integer.toString(n));
        HtmlOutputText htmlOutputText = (HtmlOutputText)AssemblyUtils.createUIComponent(application, uIViewRoot, "javax.faces.HtmlOutputText", "HOTb" + Integer.toString(n));
        htmlOutputText.setEscape(false);
        ColumnHeaderComponent columnHeaderComponent = (ColumnHeaderComponent)AssemblyUtils.createUIComponent(application, uIViewRoot, "impl.columnHeader", "CH" + Integer.toString(n));
        uIColumn.getFacets().put("header", columnHeaderComponent);
        HtmlCommandLink htmlCommandLink = (HtmlCommandLink)AssemblyUtils.createUIComponent(application, uIViewRoot, "javax.faces.HtmlCommandLink", "HCLb" + Integer.toString(n));
        HtmlOutputText htmlOutputText2 = (HtmlOutputText)AssemblyUtils.createUIComponent(application, uIViewRoot, "javax.faces.HtmlOutputText", "HOTCLb" + Integer.toString(n));
        uIColumn.getChildren().add(htmlCommandLink);
        htmlCommandLink.getChildren().add(htmlOutputText2);
        uIColumn.getChildren().add(htmlOutputText);
        this.register("HEADER", (Object)columnHeaderComponent);
        this.register("COLUMN", uIColumn);
        this.register("CONTENTTEXT", htmlOutputText);
        this.register("CONTENTLINK", htmlCommandLink);
        UIData uIData = (UIData)this.getCurrentRegisteredComponent("TABLE");
        Assert.assertion((uIData != null ? 1 : 0) != 0, (String)"Column cannot be added since no UIData sub component exists");
        uIData.getChildren().add(uIColumn);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    static {
        AssemblyHelper.addDispatchRule(dispatchTable, "MODEL.errors", "CURRENTERRORINDICATION.errorMap", true, 0);
    }
}

