/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.jsf.component;

import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.jsf.util.FacesUtils;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import java.io.IOException;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class ContextHelp
extends UICommand {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";
    private static ResourceBundle configuration = null;
    private static String CONFIGURATION_BUNDLE = "IHelpConfiguration";
    private static ResourceBundle mapping = null;
    private static String MAPPING_BUNDLE = "IHelpMapping";
    private static ResourceBundle messages = null;
    private static String MESSAGE_BUNDLE = "help.messages";
    private static String HELP_NOTFOUND = "help.notFound";
    private static String HELP_URL = "help.url";
    private static String HELP_LOCALE = "help.locale";
    private static String HELP_TARGET = "help.target";
    private static String HELP_STYLE = "help.style";
    private static String HELP_HOVERTEXT = "help.hovertext";
    public static String ICON_SRC = "icon.src";
    private static String ICON_STYLE = "icon.style";

    public ContextHelp() {
        block7: {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.entry();
            }
            try {
                String string;
                this.setRendererType(null);
                String string2 = ContextHelp.getConfigurationString(MAPPING_BUNDLE);
                if (string2 != null) {
                    MAPPING_BUNDLE = string2;
                }
                if ((string = ContextHelp.getConfigurationString(MESSAGE_BUNDLE)) != null) {
                    MESSAGE_BUNDLE = string;
                }
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.exit();
                }
            }
            catch (Exception exception) {
                if (!BPCClientTrace.isTracing) break block7;
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Exception is:" + exception.getMessage()));
            }
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    public void encodeBegin(FacesContext facesContext) throws IOException {
        block7: {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.entry();
            }
            ResponseWriter responseWriter = facesContext.getResponseWriter();
            try {
                Object object;
                Object object2;
                responseWriter.write("\n<!-- Context help -->\n");
                String string = (String)this.getAttributes().get("label");
                if (string == null && (object2 = this.getValueBinding("label")) != null) {
                    string = (String)object2.getValue(facesContext);
                }
                if ((object2 = (String)this.getAttributes().get("contextId")) == null && (object = this.getValueBinding("contextId")) != null) {
                    object2 = (String)object.getValue(facesContext);
                }
                if (object2 != null) {
                    object = facesContext.getExternalContext().getRequestLocale();
                    String string2 = ContextHelp.determineHelpUrl(facesContext, (String)object2, (Locale)object);
                    String string3 = ContextHelp.getConfigurationString(ICON_SRC);
                    ContextHelp.encodeLink(responseWriter, (UIComponent)this, null, string2, string3, string, null);
                }
            }
            catch (Exception exception) {
                this.encodeWarning(responseWriter, "exception " + exception.getClass().getName() + " caught: " + exception.getMessage());
                if (!BPCClientTrace.isTracing) break block7;
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)exception);
            }
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    public static void encodeLink(ResponseWriter responseWriter, UIComponent uIComponent, String string, String string2, String string3, String string4, String string5) throws IOException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)("helpUrl:" + string2 + " (optional) label: " + string4));
        }
        responseWriter.startElement("a", uIComponent);
        if (string != null) {
            responseWriter.writeAttribute("id", (Object)string, "id");
        }
        responseWriter.writeAttribute("href", (Object)string2, "href");
        String string6 = ContextHelp.getConfigurationString(HELP_TARGET);
        if (string6 != null) {
            responseWriter.writeAttribute("target", (Object)string6, "target");
        }
        if (string5 == null) {
            String string7 = ContextHelp.getConfigurationString(HELP_STYLE);
            if (string7 != null) {
                responseWriter.writeAttribute("class", (Object)string7, "class");
            }
        } else {
            responseWriter.writeAttribute("class", (Object)string5, "class");
        }
        if (string4 != null) {
            responseWriter.write(string4);
        } else {
            ContextHelp.encodeIcon(responseWriter, uIComponent, string3, ContextHelp.getMessageString(ContextHelp.getConfigurationString(HELP_HOVERTEXT)), ContextHelp.getConfigurationString(ICON_STYLE));
        }
        responseWriter.endElement("a");
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    public static void encodeIcon(ResponseWriter responseWriter, UIComponent uIComponent, String string, String string2, String string3) throws IOException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)("src:" + string));
        }
        responseWriter.startElement("img", uIComponent);
        responseWriter.writeAttribute("src", (Object)FacesUtils.getImageUrl(string), "src");
        if (string2 != null) {
            responseWriter.writeAttribute("alt", (Object)string2, "alt");
            responseWriter.writeAttribute("title", (Object)string2, "title");
        }
        if (string3 != null) {
            responseWriter.writeAttribute("class", (Object)string3, "class");
        }
        responseWriter.endElement("img");
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    private void encodeWarning(ResponseWriter responseWriter, String string) throws IOException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)("warning:" + string));
        }
        responseWriter.write("\n<!-- CONTEXT HELP WARNING: " + string + "-->\n");
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    public static String determineHelpUrl(FacesContext facesContext, String string, Locale locale) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)("contextId:" + string));
        }
        try {
            String string2 = ContextHelp.getConfigurationString(HELP_URL);
            if (string2 == null) {
                string2 = facesContext.getExternalContext().getRequestContextPath() + "/doc/";
            }
            String string3 = ContextHelp.getLocaleDirectory(locale);
            String string4 = ContextHelp.getMappingString(string);
            if (string4 == null) {
                string4 = ContextHelp.getConfigurationString(HELP_NOTFOUND);
            }
            String string5 = string2 + string3 + "/" + string4;
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Help URL is:" + string5));
            }
            return string5;
        }
        catch (MissingResourceException missingResourceException) {
            String string6 = ContextHelp.getConfigurationString(HELP_NOTFOUND);
            return string6;
        }
    }

    public static String getConfigurationString(String string) {
        return ContextHelp.getString(ContextHelp.getConfigurationBundle(), string);
    }

    public static String getMappingString(String string) {
        return ContextHelp.getString(ContextHelp.getMappingBundle(), string);
    }

    public static String getMessageString(String string) {
        return ContextHelp.getString(ContextHelp.getMessageBundle(), string);
    }

    private static String getString(ResourceBundle resourceBundle, String string) {
        try {
            return resourceBundle.getString(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static ResourceBundle getMappingBundle() {
        if (mapping == null) {
            mapping = ContextHelp.getResourceBundle(MAPPING_BUNDLE);
        }
        return mapping;
    }

    public static ResourceBundle getConfigurationBundle() {
        if (configuration == null) {
            configuration = ContextHelp.getResourceBundle(CONFIGURATION_BUNDLE);
        }
        return configuration;
    }

    public static ResourceBundle getMessageBundle() {
        if (messages == null) {
            messages = ContextHelp.getResourceBundle(MESSAGE_BUNDLE);
        }
        return messages;
    }

    private static ResourceBundle getResourceBundle(String string) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)("load bundle name: " + string));
        }
        return ResourceBundle.getBundle(string);
    }

    public static String getLocaleDirectory(Locale locale) {
        String string = "en";
        String[] stringArray = new String[]{locale.toString(), locale.getLanguage() + "_" + locale.getCountry(), locale.getLanguage()};
        ResourceBundle resourceBundle = ContextHelp.getConfigurationBundle();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                String string2 = HELP_LOCALE + "." + stringArray[i];
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Trying to map directory for key: " + string2 + " and locale: " + locale));
                }
                string = resourceBundle.getString(string2);
                break;
            }
            catch (MissingResourceException missingResourceException) {
                if (!BPCClientTrace.isTracing) continue;
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Falling back to default language directory: " + string));
                continue;
            }
        }
        return string;
    }

    public void decode(FacesContext facesContext) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        super.decode(facesContext);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }
}

