/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.jsf.component;

import com.ibm.bpc.clientcore.Command;
import com.ibm.bpc.clientcore.ConnectionFactory;
import com.ibm.bpc.clientcore.ServerCommand;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.jsf.exception.CommandInstanceNotAvailableException;
import com.ibm.bpe.jsf.exception.CommandNotAvailableException;
import com.ibm.bpe.jsf.util.FacesUtils;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import java.io.Serializable;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;

public class CommandInfo
implements Serializable {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";
    private static final long serialVersionUID = 1L;
    private String commandClazz = null;
    private String action = null;
    private String existingCommandExpressionString = null;
    private String contextExpressionString = null;
    private String errorTargetExpressionString = null;
    private String commandID = null;
    private String actionListener = null;
    transient Command command = null;
    transient MethodExpression actionMethodExpression = null;
    transient MethodExpression actionListenerMethodExpression = null;
    transient Command existingCommand = null;
    transient Object context = null;
    transient String errorTarget = null;

    public CommandInfo(String string, String string2, String string3, String string4, String string5, String string6) {
        this.commandID = string;
        this.commandClazz = string2;
        this.action = string3;
        this.existingCommandExpressionString = null;
        this.contextExpressionString = string4;
        this.errorTargetExpressionString = string5;
        this.actionListener = string6;
    }

    public void init(FacesContext facesContext, ConnectionFactory connectionFactory) throws CommandNotAvailableException, CommandInstanceNotAvailableException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)this.toString());
        }
        this.command = CommandInfo.createCommand(connectionFactory, this.commandClazz);
        this.context = CommandInfo.createContext(facesContext, this.contextExpressionString);
        if (this.command != null && this.context != null) {
            this.command.setContext(this.context);
        }
        this.existingCommand = CommandInfo.getExistingCommand(facesContext, this.existingCommandExpressionString);
        this.actionMethodExpression = CommandInfo.getActionMethodExpression(facesContext, this.action);
        this.actionListenerMethodExpression = CommandInfo.getActionListenerMethodExpression(facesContext, this.actionListener);
        this.errorTarget = CommandInfo.getErrorTargetBinding(facesContext, this.errorTargetExpressionString);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    public String toString() {
        return "commandClazz: " + this.commandClazz + "\n" + "action: " + this.action + "\n" + "actionListener: " + this.actionListener + "\n" + "existingCommandExpressionString: " + this.existingCommandExpressionString + "\n" + "errorTargetExpressionString: " + this.errorTargetExpressionString + "\n" + "contextExpressionString: " + this.contextExpressionString;
    }

    public String getCommandClazz() {
        return this.commandClazz;
    }

    public String getExistingCommandExpression() {
        return this.existingCommandExpressionString;
    }

    public MethodExpression getActionMethodExpression() {
        return this.actionMethodExpression;
    }

    public MethodExpression getActionListenerMethodExpression() {
        return this.actionListenerMethodExpression;
    }

    public Command getCommand() {
        return this.command;
    }

    public Command getExistingCommand() {
        return this.existingCommand;
    }

    public String getCommandID() {
        return this.commandID;
    }

    private static Command getExistingCommand(FacesContext facesContext, String string) throws CommandInstanceNotAvailableException {
        Command command = null;
        try {
            if (string != null) {
                Application application = facesContext.getApplication();
                ValueExpression valueExpression = application.getExpressionFactory().createValueExpression(facesContext.getELContext(), string, Command.class);
                command = (Command)valueExpression.getValue(facesContext.getELContext());
            }
        }
        catch (Exception exception) {
            throw new CommandInstanceNotAvailableException(new Object[]{string}, exception);
        }
        return command;
    }

    private static MethodExpression getActionMethodExpression(FacesContext facesContext, String string) {
        Application application = facesContext.getApplication();
        if (string != null) {
            return application.getExpressionFactory().createMethodExpression(facesContext.getELContext(), string, String.class, new Class[0]);
        }
        return null;
    }

    private static MethodExpression getActionListenerMethodExpression(FacesContext facesContext, String string) {
        Application application = facesContext.getApplication();
        if (string != null) {
            return application.getExpressionFactory().createMethodExpression(facesContext.getELContext(), string, null, new Class[]{ActionEvent.class});
        }
        return null;
    }

    private static String getErrorTargetBinding(FacesContext facesContext, String string) {
        String string2 = null;
        string2 = string;
        return string2;
    }

    private static Command createCommand(ConnectionFactory connectionFactory, String string) throws CommandNotAvailableException {
        Command command = null;
        try {
            if (string != null) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Creating a " + string + " command instance"));
                }
                if ((command = (Command)FacesUtils.getApplicationClazzInstance(string)) instanceof ServerCommand) {
                    ((ServerCommand)command).setConnectionFactory(connectionFactory);
                }
            }
        }
        catch (Exception exception) {
            throw new CommandNotAvailableException(new Object[]{string}, exception);
        }
        return command;
    }

    private static Object createContext(FacesContext facesContext, String string) {
        Object object = null;
        if (string != null) {
            ValueExpression valueExpression = null;
            if (string != null) {
                Application application = facesContext.getApplication();
                valueExpression = application.getExpressionFactory().createValueExpression(facesContext.getELContext(), string, Object.class);
            }
            object = null;
            if (valueExpression != null) {
                object = valueExpression.getValue(facesContext.getELContext());
            }
        }
        return object;
    }
}

