/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.jsf.component;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.Command;
import com.ibm.bpc.clientcore.StickySelection;
import com.ibm.bpc.clientcore.exception.CommandBarMessage;
import com.ibm.bpc.clientcore.exception.ErrorsInCommandException;
import com.ibm.bpe.api.FaultReplyException;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.jsf.component.CommandBarComponent;
import com.ibm.bpe.jsf.component.CommandInfo;
import com.ibm.bpe.jsf.component.impl.WidgetComponentBase;
import com.ibm.bpe.jsf.exception.ModelNotAvailableException;
import com.ibm.bpe.jsf.exception.ModelNotSpecifiedException;
import com.ibm.bpe.jsf.handler.BPCListHandler;
import com.ibm.bpe.jsf.handler.ErrorHandler;
import com.ibm.bpe.jsf.util.FacesUtils;
import com.ibm.bpe.jsf.util.Message;
import com.ibm.bpe.util.Assert;
import com.ibm.bpe.util.MessageLogger;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.el.ELException;
import javax.el.MethodExpression;
import javax.faces.component.StateHolder;
import javax.faces.component.UICommand;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;

public class CommandHandler
implements ActionListener,
StateHolder {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";
    private CommandBarComponent component = null;
    private String clientID = null;

    public CommandHandler() {
    }

    public CommandHandler(CommandBarComponent commandBarComponent) {
        this.component = commandBarComponent;
    }

    public void setCommandBar(CommandBarComponent commandBarComponent) {
        this.component = commandBarComponent;
    }

    public void processAction(ActionEvent actionEvent) throws AbortProcessingException {
        String string;
        UICommand uICommand = (UICommand)actionEvent.getComponent();
        FacesContext facesContext = FacesContext.getCurrentInstance();
        String string2 = string = uICommand != null ? uICommand.getClientId(facesContext) : "unkown";
        if (this.component == null) {
            this.component = (CommandBarComponent)FacesUtils.findComponent(this.clientID);
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)(string + " - " + uICommand.getActionExpression() + " - " + facesContext.toString()));
        }
        String string3 = null;
        Integer n = (Integer)uICommand.getAttributes().get("NUMBER");
        Assert.assertion((n != null ? 1 : 0) != 0, (String)"numberOfButton != null");
        CommandInfo commandInfo = this.component.getCommandInfo(n);
        Object object = null;
        string3 = commandInfo.errorTarget;
        boolean bl = true;
        MethodExpression methodExpression = commandInfo.getActionListenerMethodExpression();
        if (methodExpression != null) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Running actionListener " + methodExpression.getExpressionString()));
            }
            try {
                methodExpression.invoke(facesContext.getELContext(), new Object[]{actionEvent});
            }
            catch (Exception exception) {
                Throwable throwable;
                object = exception;
                if (exception instanceof ELException && (throwable = exception.getCause()) instanceof ClientException) {
                    try {
                        string3 = this.handleErrors((ClientException)throwable, string3);
                        object = null;
                    }
                    catch (ModelNotSpecifiedException modelNotSpecifiedException) {
                        object = modelNotSpecifiedException;
                    }
                }
                bl = false;
            }
        }
        if (bl) {
            try {
                string3 = this.executeCommand(facesContext, commandInfo);
            }
            catch (ModelNotAvailableException modelNotAvailableException) {
                object = modelNotAvailableException;
            }
            catch (ModelNotSpecifiedException modelNotSpecifiedException) {
                object = modelNotSpecifiedException;
            }
        }
        if (object != null) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_EVENT, (Throwable)object);
            MessageLogger messageLogger = MessageLogger.newMessageLogger((String)BPCClientTrace.class.getName());
            messageLogger.message(MessageLogger.TYPE_ERROR, object.getLocalizedMessage());
            string3 = commandInfo.errorTarget;
            FacesUtils.showErrorPage(facesContext, object, true);
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.exit((Object)string);
            }
            return;
        }
        if (string3 != null) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Processing navigation target \"" + string3 + "\""));
            }
            FacesUtils.navigate(facesContext, string3);
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)string);
        }
    }

    public String executeCommand(FacesContext facesContext, CommandInfo commandInfo) throws ModelNotAvailableException, ModelNotSpecifiedException {
        Object object;
        Command command;
        boolean bl;
        boolean bl2;
        ClientException clientException;
        boolean bl3;
        Object object2;
        block26: {
            this.clearErrorMap();
            object2 = commandInfo.errorTarget;
            bl3 = true;
            if (this.component == null) {
                this.component = (CommandBarComponent)FacesUtils.findComponent(this.clientID);
            }
            clientException = null;
            bl2 = true;
            bl = false;
            try {
                if (commandInfo.getExistingCommand() != null) {
                    if (BPCClientTrace.isTracing) {
                        BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Running existing command (" + commandInfo.getExistingCommandExpression() + ")"));
                    }
                    boolean bl4 = bl2 = !((command = commandInfo.getExistingCommand()) instanceof StickySelection);
                    if (BPCClientTrace.isTracing) {
                        BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("unselectAfterExecution set to: " + bl2));
                    }
                    object2 = command.execute(this.component.getSelectedItems());
                    FacesUtils.addCommandTrace(commandInfo.getCommandID(), this.component.getSelectedItems());
                    bl = true;
                } else if (commandInfo.getCommand() != null) {
                    if (BPCClientTrace.isTracing) {
                        BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Running command (" + commandInfo.getCommandClazz() + ")"));
                    }
                    boolean bl5 = bl2 = !((command = commandInfo.getCommand()) instanceof StickySelection);
                    if (BPCClientTrace.isTracing) {
                        BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("unselectAfterExecution set to: " + bl2));
                    }
                    object2 = command.execute(this.component.getSelectedItems());
                    FacesUtils.addCommandTrace(commandInfo.getCommandID(), this.component.getSelectedItems());
                    bl = true;
                }
            }
            catch (ClientException clientException2) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)clientException2);
                }
                clientException = clientException2;
                bl3 = clientException2 instanceof ErrorsInCommandException;
                bl2 = clientException2 instanceof ErrorsInCommandException;
                if (!BPCClientTrace.isTracing) break block26;
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("unselectAfterExecution set to: " + bl2));
            }
        }
        command = commandInfo.getActionMethodExpression();
        if (command != null) {
            if (bl3) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Running ActionBinding (" + command.getExpressionString() + ")"));
                }
                if (!command.isLiteralText()) {
                    object = null;
                    try {
                        object = (String)command.invoke(facesContext.getELContext(), new Object[0]);
                        if (!bl) {
                            FacesUtils.addCommandTrace(commandInfo.getCommandID(), this.component.getSelectedItems());
                            bl = true;
                        }
                    }
                    catch (Exception exception) {
                        Throwable throwable;
                        if (BPCClientTrace.isTracing) {
                            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("The action method " + command.getExpressionString() + " did throw an exception"));
                            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)exception);
                        }
                        if ((throwable = exception.getCause()) instanceof ClientException) {
                            clientException = (ClientException)throwable;
                        }
                        throw new AbortProcessingException((Throwable)exception);
                    }
                    if (object instanceof String) {
                        object2 = object;
                    }
                } else {
                    object2 = command.getExpressionString();
                }
            } else if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Running ActionBinding (" + command.getExpressionString() + ") is suppressed due to exception"));
            }
        }
        if (bl2 && (object = this.component.getAssociatedModel()) instanceof BPCListHandler) {
            ((BPCListHandler)object).clearSelection();
        }
        if (clientException != null) {
            object2 = this.handleErrors(clientException, commandInfo.errorTarget);
        }
        return object2;
    }

    private void clearErrorMap() throws ModelNotSpecifiedException {
        Object object;
        if (this.component == null) {
            this.component = (CommandBarComponent)FacesUtils.findComponent(this.clientID);
        }
        if ((object = this.component.getAssociatedModel()) instanceof ErrorHandler) {
            ((ErrorHandler)object).setErrors(new HashMap());
        }
    }

    private void showErrorPage(Exception exception) {
        FacesUtils.showErrorPage(FacesContext.getCurrentInstance(), exception, true);
    }

    private String handleErrors(ClientException clientException, String string) throws ModelNotSpecifiedException {
        if (clientException != null) {
            if (this.component == null) {
                this.component = (CommandBarComponent)FacesUtils.findComponent(this.clientID);
            }
            if (clientException instanceof ErrorsInCommandException) {
                clientException = this.handleErrorsInCommandException((ErrorsInCommandException)clientException);
            }
            if (clientException != null) {
                if (clientException instanceof CommandBarMessage) {
                    this.component.setMessage(new WidgetComponentBase.ExceptionMessage(clientException));
                    string = null;
                } else if (clientException.getCause() instanceof FaultReplyException) {
                    string = "processFaultMessage";
                } else if (clientException instanceof ClientException) {
                    this.showErrorPage((Exception)((Object)clientException));
                }
            }
        }
        return string;
    }

    private ClientException handleErrorsInCommandException(ErrorsInCommandException errorsInCommandException) throws ModelNotSpecifiedException {
        if (this.component == null) {
            this.component = (CommandBarComponent)FacesUtils.findComponent(this.clientID);
        }
        Object object = errorsInCommandException;
        Object object2 = this.component.getAssociatedModel();
        if (object2 instanceof ErrorHandler) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Setting ErrorMap on " + object2.getClass().getName()));
            }
            Map map = errorsInCommandException.getErrors();
            ((ErrorHandler)object2).setErrors(map);
            this.component.setMessage(new ProblemEncounteredMessage(map.size()));
            object = null;
        } else {
            Collection collection = errorsInCommandException.getErrors().values();
            if (collection.size() == 1) {
                Iterator iterator;
                Exception exception;
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"ErrorsInCommandException with single entry encountered");
                }
                if ((exception = (Exception)(iterator = collection.iterator()).next()) instanceof ClientException) {
                    object = (ClientException)((Object)exception);
                } else {
                    this.showErrorPage(exception);
                }
            }
        }
        return object;
    }

    public void restoreState(FacesContext facesContext, Object object) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        this.clientID = (String)((Object[])object)[0];
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)this.clientID);
        }
    }

    public Object saveState(FacesContext facesContext) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        if (this.component == null) {
            this.component = (CommandBarComponent)FacesUtils.findComponent(this.clientID);
        }
        Object[] objectArray = new Object[]{this.component.getClientId(facesContext)};
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)this.component.getClientId(facesContext));
        }
        return objectArray;
    }

    public boolean isTransient() {
        return false;
    }

    public void setTransient(boolean bl) {
        throw new UnsupportedOperationException();
    }

    static class ProblemEncounteredMessage
    implements Message {
        public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2006.\n\n";
        private static final long serialVersionUID = 1L;
        Integer numberOfProblems = null;

        ProblemEncounteredMessage(int n) {
            this.numberOfProblems = new Integer(n);
        }

        public String getMessage() {
            return FacesUtils.lookupNonPIIMessage("LISTCOMPONENT.ERROR.MESSAGE", new Object[]{this.numberOfProblems});
        }

        public int getType() {
            return 0;
        }
    }
}

