/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.jsf.component;

import com.ibm.bpc.clientcore.ConnectionFactory;
import com.ibm.bpc.clientcore.DynamicalCommandQuery;
import com.ibm.bpc.clientcore.Query;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.jsf.component.CommandHandler;
import com.ibm.bpe.jsf.component.CommandInfo;
import com.ibm.bpe.jsf.component.impl.AssemblyHelper;
import com.ibm.bpe.jsf.component.impl.AssemblyUtils;
import com.ibm.bpe.jsf.component.impl.MessageBoxComponent;
import com.ibm.bpe.jsf.component.impl.WidgetComponentBase;
import com.ibm.bpe.jsf.exception.CommandInstanceNotAvailableException;
import com.ibm.bpe.jsf.exception.CommandNotAvailableException;
import com.ibm.bpe.jsf.exception.ModelNotAvailableException;
import com.ibm.bpe.jsf.exception.ModelNotSpecifiedException;
import com.ibm.bpe.jsf.handler.BPCListHandler;
import com.ibm.bpe.jsf.handler.ItemProvider;
import com.ibm.bpe.util.Assert;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.html.HtmlCommandButton;
import javax.faces.component.html.HtmlPanelGroup;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionListener;

public class CommandBarComponent
extends WidgetComponentBase {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";
    private static Map dispatchTable = new HashMap();
    private List commandInfoList = new ArrayList();
    private static ConnectionFactory connectionFactory = null;
    private CommandHandler commandHandler = null;
    static final String COMMAND_NUMBER = "NUMBER";

    public CommandBarComponent() {
        this.init(dispatchTable);
        if (connectionFactory == null) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            if (facesContext != null) {
                Application application = facesContext.getApplication();
                ELContext eLContext = facesContext.getELContext();
                ValueExpression valueExpression = application.getExpressionFactory().createValueExpression(eLContext, "#{ConnectionFactory}", ConnectionFactory.class);
                connectionFactory = (ConnectionFactory)valueExpression.getValue(eLContext);
            } else if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_EVENT, (String)"No Faces Context available. There seems to be no JSF container");
            }
        }
        this.commandHandler = new CommandHandler(this);
    }

    public String getFamily() {
        return "javax.faces.Panel";
    }

    public void encodeBegin(FacesContext facesContext) throws IOException {
        try {
            Map map;
            Object object;
            if (this.getPendingMessage() == null && (object = this.getAssociatedModel()) instanceof BPCListHandler && (map = ((BPCListHandler)object).getErrors()) != null && map.size() > 0) {
                this.setMessage(new CommandHandler.ProblemEncounteredMessage(map.size()));
            }
        }
        catch (ModelNotSpecifiedException modelNotSpecifiedException) {
            // empty catch block
        }
        super.encodeBegin(facesContext);
    }

    public void encodeChildren(FacesContext facesContext) throws IOException {
        Iterator iterator;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        Query query = null;
        try {
            iterator = this.getAssociatedModel();
            if (iterator instanceof BPCListHandler) {
                query = ((BPCListHandler)((Object)iterator)).getQuery();
            }
        }
        catch (ModelNotSpecifiedException modelNotSpecifiedException) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_EVENT, (String)"No model has been specified for the commandBar");
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_EVENT, (Throwable)((Object)modelNotSpecifiedException));
            }
            throw new RuntimeException((Throwable)((Object)modelNotSpecifiedException));
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Query=" + (query != null ? query.getClass().getName() : "null")));
        }
        if (query != null && query instanceof DynamicalCommandQuery && !((DynamicalCommandQuery)query).isDefaultCommandSetUsed()) {
            iterator = this.getChildren().iterator();
            UIComponent uIComponent = null;
            while (iterator.hasNext()) {
                UIComponent uIComponent2 = (UIComponent)iterator.next();
                if (uIComponent2 instanceof MessageBoxComponent) {
                    this.encodeRecursive(facesContext, uIComponent2);
                }
                if (!(uIComponent2 instanceof HtmlPanelGroup)) continue;
                uIComponent = uIComponent2;
            }
            Assert.assertion((uIComponent != null ? 1 : 0) != 0, (String)"panelGroup not set");
            boolean bl = uIComponent.isRendered();
            if (bl) {
                String string;
                Object object2;
                List list = uIComponent.getChildren();
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                for (Object object2 : list) {
                    string = (String)object2.getAttributes().get("COMMANDID");
                    if (string != null) {
                        if (BPCClientTrace.isTracing) {
                            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Adding command for id " + string));
                        }
                        hashMap.put(string, object2);
                        continue;
                    }
                    if (!BPCClientTrace.isTracing) continue;
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Child is not a command and will be ignored! " + object2.toString()));
                }
                object2 = ((DynamicalCommandQuery)query).getCommandInfoList();
                iterator = object2.iterator();
                while (iterator.hasNext()) {
                    UIComponent uIComponent3;
                    string = (com.ibm.bpc.clientcore.CommandInfo)iterator.next();
                    if (BPCClientTrace.isTracing) {
                        BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Processing commandID " + string.getCommandID()));
                    }
                    if ((uIComponent3 = (UIComponent)hashMap.get(string.getCommandID())) == null) continue;
                    this.encodeRecursive(facesContext, uIComponent3);
                }
                string = (UIComponent)hashMap.get("EditList");
                if (string != null) {
                    this.encodeRecursive(facesContext, (UIComponent)string);
                }
            }
        } else {
            super.encodeChildren(facesContext);
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    public void restoreState(FacesContext facesContext, Object object) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)this);
        }
        Object object2 = ((Object[])object)[0];
        this.commandInfoList = (List)((Object[])object)[1];
        super.restoreState(facesContext, object2);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)this.commandInfoList);
        }
    }

    public Object saveState(FacesContext facesContext) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)this);
        }
        Object object = super.saveState(facesContext);
        Object[] objectArray = new Object[]{object, this.commandInfoList};
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)this.commandInfoList);
        }
        return objectArray;
    }

    protected UIComponent createComponentTree() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Application application = facesContext.getApplication();
        UIViewRoot uIViewRoot = facesContext.getViewRoot();
        HtmlPanelGroup htmlPanelGroup = (HtmlPanelGroup)AssemblyUtils.createUIComponent(application, uIViewRoot, "javax.faces.HtmlPanelGroup", "HPG");
        this.register("PANELGROUP", htmlPanelGroup);
        this.setShowMessageBoxAndDefaultRendering(true);
        return htmlPanelGroup;
    }

    public void addCommandButton(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws CommandNotAvailableException, CommandInstanceNotAvailableException {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Application application = facesContext.getApplication();
        UIViewRoot uIViewRoot = facesContext.getViewRoot();
        int n = this.commandInfoList.size();
        HtmlCommandButton htmlCommandButton = (HtmlCommandButton)AssemblyUtils.createUIComponent(application, uIViewRoot, "javax.faces.HtmlCommandButton", "Button" + Integer.toString(n));
        htmlCommandButton.getAttributes().put("COMMANDID", string2);
        if (string5 != null) {
            htmlCommandButton.setId(string5);
        }
        ((UIComponent)this.getCurrentRegisteredComponent("PANELGROUP")).getChildren().add(htmlCommandButton);
        this.register("COMMANDBUTTON", htmlCommandButton);
        if (this.commandHandler == null) {
            this.commandHandler = new CommandHandler(this);
        }
        htmlCommandButton.addActionListener((ActionListener)this.commandHandler);
        htmlCommandButton.getAttributes().put(COMMAND_NUMBER, new Integer(n));
        CommandInfo commandInfo = new CommandInfo(string2, string, string3, string4, string6, string7);
        commandInfo.init(facesContext, connectionFactory);
        this.commandInfoList.add(commandInfo);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Adding command button \n" + commandInfo.toString()));
        }
    }

    List getSelectedItems() throws ModelNotAvailableException, ModelNotSpecifiedException {
        Object object = this.getAssociatedModel();
        if (object instanceof ItemProvider) {
            ItemProvider itemProvider = (ItemProvider)object;
            return itemProvider.getSelectedItems();
        }
        if (object == null) {
            String string = (String)this.getAttributes().get("MODEL");
            throw new ModelNotAvailableException(new Object[]{string});
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_EVENT, (String)("The model " + object.getClass().getName() + " does not implement CommandBarContext"));
        }
        return null;
    }

    Object getAssociatedModel() throws ModelNotSpecifiedException {
        ValueExpression valueExpression = this.getValueExpression("bpcModel");
        if (valueExpression == null) {
            throw new ModelNotSpecifiedException(new Object[0]);
        }
        Object object = valueExpression.getValue(FacesContext.getCurrentInstance().getELContext());
        return object;
    }

    CommandInfo getCommandInfo(int n) {
        return (CommandInfo)this.commandInfoList.get(n);
    }

    public void setCommandHandler(CommandHandler commandHandler) {
        this.commandHandler = commandHandler;
    }

    static {
        AssemblyHelper.addDispatchRule(dispatchTable, "MODEL", "THIS.bpcModel", false, 0);
        AssemblyHelper.addDispatchRule(dispatchTable, "STYLECLASS", "PANELGROUP.styleClass", false, 0);
        AssemblyHelper.addDispatchRule(dispatchTable, "CURRENT_LABEL", "CURRENTCOMMANDBUTTON.value", false, 0);
        AssemblyHelper.addDispatchRule(dispatchTable, "CURRENT_ACTIONPATH.disabled", "CURRENTCOMMANDBUTTON.disabled", false, 0);
        AssemblyHelper.addDispatchRule(dispatchTable, "CURRENT_ACTIONID", "CURRENTCOMMANDBUTTON.actionID", false, 0);
        AssemblyHelper.addDispatchRule(dispatchTable, "BUTTONSTYLECLASS", "CURRENTCOMMANDBUTTON.styleClass", false, 0);
        AssemblyHelper.addDispatchRule(dispatchTable, "ACTION", "CURRENTCOMMANDBUTTON", false, 1);
        AssemblyHelper.addDispatchRule(dispatchTable, "CURRENT_RENDERED", "CURRENTCOMMANDBUTTON.rendered", false, 0);
        AssemblyHelper.addDispatchRule(dispatchTable, "CURRENT_IMMEDIATE", "CURRENTCOMMANDBUTTON.immediate", false, 0);
    }
}

