/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpc.clientcore;

import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.jsf.exception.PropertyNotFoundException;
import com.ibm.bpe.jsf.exception.PropertyPopulationException;
import com.ibm.bpe.jsf.message.sdo.PopulationHelper;
import com.ibm.bpe.jsf.util.LocaleUtils;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import commonj.sdo.DataObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.faces.context.FacesContext;

class DataObjectWrapper {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2008.\n\n";
    private DataObject message = null;
    private Map messageMap = null;

    public DataObjectWrapper(DataObject dataObject) {
        this.message = dataObject;
        if (dataObject != null) {
            Locale locale = LocaleUtils.getFacesLocale(FacesContext.getCurrentInstance());
            this.messageMap = PopulationHelper.createMessageMap(dataObject, locale);
            this.messageMap = new InternalMap(this.messageMap);
        } else {
            this.messageMap = new HashMap();
        }
    }

    public Map getValueMap() {
        return this.messageMap;
    }

    public DataObject createDataObject() {
        block6: {
            try {
                if (this.messageMap instanceof InternalMap) {
                    PopulationHelper.populateMessage(this.message, this.messageMap, ((InternalMap)this.messageMap).getRemovals());
                } else {
                    PopulationHelper.populateMessage(this.message, this.messageMap, new HashSet<String>());
                }
            }
            catch (PropertyNotFoundException propertyNotFoundException) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_EVENT, (Throwable)((Object)propertyNotFoundException));
                }
            }
            catch (PropertyPopulationException propertyPopulationException) {
                if (!BPCClientTrace.isTracing) break block6;
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_EVENT, (Throwable)((Object)propertyPopulationException));
            }
        }
        return this.message;
    }

    private static class InternalMap
    implements Map {
        private Map map;
        private Set removals = new HashSet();

        public InternalMap(Map map) {
            this.map = map;
        }

        private Set getRemovals() {
            return this.removals;
        }

        public int size() {
            return this.map.size();
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        public boolean containsKey(Object object) {
            return this.map.containsKey(object);
        }

        public boolean containsValue(Object object) {
            return this.map.containsValue(object);
        }

        public Object get(Object object) {
            return this.map.get(object);
        }

        public Object put(Object object, Object object2) {
            return this.map.put(object, object2);
        }

        public Object remove(Object object) {
            this.removals.add(object);
            return this.map.remove(object);
        }

        public void putAll(Map map) {
            this.map.putAll(map);
        }

        public void clear() {
            this.map.clear();
        }

        public Set keySet() {
            return this.map.keySet();
        }

        public Collection values() {
            return this.map.values();
        }

        public Set entrySet() {
            return this.map.entrySet();
        }
    }
}

