/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpc.clientcore;

import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.jsf.exception.PropertyNotFoundException;
import com.ibm.bpe.jsf.exception.PropertyPopulationException;
import com.ibm.bpe.jsf.message.sdo.PopulationHelper;
import com.ibm.bpe.jsf.util.LocaleUtils;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import commonj.sdo.DataObject;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import javax.faces.context.FacesContext;

public class DataObjectUtils {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2008.\n\n";

    public static Map getValueMap(DataObject dataObject) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        Locale locale = LocaleUtils.getFacesLocale(FacesContext.getCurrentInstance());
        Map<String, Object> map = PopulationHelper.createMessageMap(dataObject, locale);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit(map);
        }
        return map;
    }

    public static DataObject putAll(DataObject dataObject, Map map) {
        return DataObjectUtils.putAll(dataObject, map, true);
    }

    public static DataObject putAll(DataObject dataObject, Map map, boolean bl) {
        block8: {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.entry((Object)map);
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("setDefaultsForMandatoryFields = " + bl));
            }
            try {
                PopulationHelper.populateMessage(dataObject, map, new HashSet<String>());
                if (bl) {
                    if (BPCClientTrace.isTracing) {
                        BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Adding mandatory elements");
                    }
                    PopulationHelper.createMessageMap(dataObject, Locale.ENGLISH);
                }
            }
            catch (PropertyNotFoundException propertyNotFoundException) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_EVENT, (Throwable)((Object)propertyNotFoundException));
                }
            }
            catch (PropertyPopulationException propertyPopulationException) {
                if (!BPCClientTrace.isTracing) break block8;
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_EVENT, (Throwable)((Object)propertyPopulationException));
            }
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
        return dataObject;
    }

    public static DataObject populateAll(DataObject dataObject, Map map) throws PropertyNotFoundException, PropertyPopulationException {
        return DataObjectUtils.populateAll(dataObject, map, true);
    }

    public static DataObject populateAll(DataObject dataObject, Map map, boolean bl) throws PropertyNotFoundException, PropertyPopulationException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)map);
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("setDefaultsForMandatoryFields = " + bl));
        }
        PopulationHelper.populateMessage(dataObject, map, new HashSet<String>());
        if (bl) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Adding mandatory elements");
            }
            PopulationHelper.createMessageMap(dataObject, Locale.ENGLISH);
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
        return dataObject;
    }
}

