/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.clientmodel.util;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.exception.CommunicationException;
import com.ibm.bpe.api.AIID;
import com.ibm.bpe.api.ActivityInstanceData;
import com.ibm.bpe.api.BusinessFlowManagerService;
import com.ibm.bpe.api.EngineNotAuthorizedException;
import com.ibm.bpe.api.IdWrongFormatException;
import com.ibm.bpe.api.InvalidLengthException;
import com.ibm.bpe.api.OID;
import com.ibm.bpe.api.ObjectDoesNotExistException;
import com.ibm.bpe.api.PIID;
import com.ibm.bpe.api.PTID;
import com.ibm.bpe.api.ProcessInstanceData;
import com.ibm.bpe.api.ProcessTemplateData;
import com.ibm.bpe.api.UnexpectedFailureException;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.clientmodel.BFMConnection;
import com.ibm.bpe.clientmodel.query.BFMQueryConstants;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import java.rmi.RemoteException;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.naming.NamingException;

public class BFMUtils {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2006, 2009.\n\n";

    public static BusinessFlowManagerService getBusinessFlowManagerService(BFMConnection bFMConnection) throws ClientException {
        BusinessFlowManagerService businessFlowManagerService = null;
        try {
            businessFlowManagerService = bFMConnection.getBusinessFlowManagerService();
        }
        catch (CreateException createException) {
            throw new CommunicationException(new Object[]{"BFMConnection.getBusinessFlowManagerService"}, (Throwable)createException);
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(new Object[]{"BFMConnection.getBusinessFlowManagerService"}, (Throwable)remoteException);
        }
        catch (NamingException namingException) {
            throw new CommunicationException(new Object[]{"BFMConnection.getBusinessFlowManagerService"}, (Throwable)namingException);
        }
        return businessFlowManagerService;
    }

    public static boolean isBFMSystemAdministrator(BFMConnection bFMConnection) {
        boolean bl;
        block2: {
            bl = false;
            try {
                bl = BFMUtils.getBusinessFlowManagerService(bFMConnection).isBusinessProcessAdministrator();
            }
            catch (Exception exception) {
                if (!BPCClientTrace.isTracing) break block2;
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)exception);
            }
        }
        return bl;
    }

    public static boolean isBFMSystemMonitor(BFMConnection bFMConnection) {
        boolean bl;
        block2: {
            bl = false;
            try {
                bl = BFMUtils.getBusinessFlowManagerService(bFMConnection).isBusinessProcessMonitor();
            }
            catch (Exception exception) {
                if (!BPCClientTrace.isTracing) break block2;
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)exception);
            }
        }
        return bl;
    }

    public static String lookupApplicationName(BusinessFlowManagerService businessFlowManagerService, ActivityInstanceData activityInstanceData) {
        return activityInstanceData.getApplicationName();
    }

    public static String lookupApplicationName(BusinessFlowManagerService businessFlowManagerService, ProcessInstanceData processInstanceData) throws EngineNotAuthorizedException, IdWrongFormatException, InvalidLengthException, ObjectDoesNotExistException, UnexpectedFailureException, RemoteException, EJBException {
        ProcessTemplateData processTemplateData = businessFlowManagerService.getProcessTemplate(processInstanceData.getProcessTemplateID());
        return processTemplateData != null ? processTemplateData.getApplicationName() : null;
    }

    static String getEntityType(OID oID) {
        if (oID instanceof PTID) {
            return BFMQueryConstants.PROCESSTEMPLATE_ENITITYTYPE;
        }
        if (oID instanceof PIID) {
            return BFMQueryConstants.PROCESSINSTANCE_ENITITYTYPE;
        }
        if (oID instanceof AIID) {
            return BFMQueryConstants.ACTIVITYINSTANCE_ENITITYTYPE;
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_EVENT, (String)("No entity type for " + oID.getClass().getName()));
        }
        return null;
    }
}

