/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.clientmodel.util;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.bean.QueryPropertyBean;
import com.ibm.bpc.clientcore.exception.CommunicationException;
import com.ibm.bpc.clientcore.util.QueryProperties;
import com.ibm.bpe.api.AIID;
import com.ibm.bpe.api.BusinessFlowManagerService;
import com.ibm.bpe.api.OID;
import com.ibm.bpe.api.PIID;
import com.ibm.bpe.api.PTID;
import com.ibm.bpe.api.ProcessException;
import com.ibm.bpe.api.QueryProperty;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.clientmodel.BFMConnection;
import com.ibm.bpe.clientmodel.exception.BFMCommandException;
import com.ibm.bpe.clientmodel.query.QueryPropertyBFMQuery;
import com.ibm.bpe.clientmodel.util.BFMUtils;
import com.ibm.bpe.util.Assert;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.task.api.TKIID;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BFMQueryProperties
extends QueryProperties {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2008.\n\n";
    private BFMConnection connection = null;

    public BFMQueryProperties(OID oID, BFMConnection bFMConnection) {
        super(oID);
        this.connection = bFMConnection;
    }

    protected Map retrieveBeanQueryProperties() throws ClientException {
        return BFMQueryProperties.getQueryPropertiesMap(this.getOid(), this.connection);
    }

    public static List getProcessTemplateQueryProperties(PTID pTID, BFMConnection bFMConnection) throws ClientException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)pTID);
        }
        ArrayList<QueryPropertyBean> arrayList = new ArrayList<QueryPropertyBean>();
        List list = null;
        BusinessFlowManagerService businessFlowManagerService = BFMUtils.getBusinessFlowManagerService(bFMConnection);
        try {
            list = businessFlowManagerService.getQueryProperties(pTID);
        }
        catch (ProcessException processException) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)processException);
            }
            throw new BFMCommandException(new Object[]{"BusinessFlowManager.getQueryProperties"}, processException);
        }
        catch (RemoteException remoteException) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)remoteException);
            }
            throw new CommunicationException(new Object[]{"BusinessFlowManagerService.getQueryProperties"}, (Throwable)remoteException);
        }
        if (list != null && list.size() > 0) {
            arrayList = new ArrayList(list.size());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                QueryPropertyBean queryPropertyBean = new QueryPropertyBean((QueryProperty)iterator.next());
                arrayList.add(queryPropertyBean);
                if (!BPCClientTrace.isTracing) continue;
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Added query property for PTID " + pTID + ": " + queryPropertyBean));
            }
        }
        if (BPCClientTrace.isTracing) {
            int n = 0;
            if (arrayList != null) {
                n = arrayList.size();
            }
            BPCClientTrace.exit((Object)("returning " + n + " properties"));
        }
        return arrayList;
    }

    public static List getQueryPropertyBeans(OID oID, BFMConnection bFMConnection) throws ClientException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)oID);
        }
        Assert.assertion((oID instanceof PTID || oID instanceof PIID || oID instanceof AIID || oID instanceof TKIID ? 1 : 0) != 0, (String)"OID must be PTID, PIID, AIID or TKIID!");
        List list = null;
        if (oID != null) {
            if (oID instanceof PTID) {
                list = BFMQueryProperties.getProcessTemplateQueryProperties((PTID)oID, bFMConnection);
            } else {
                QueryPropertyBFMQuery queryPropertyBFMQuery = new QueryPropertyBFMQuery();
                queryPropertyBFMQuery.setConnection(bFMConnection);
                queryPropertyBFMQuery.getQueryPropertyFilterAttributes().setOid(oID);
                list = queryPropertyBFMQuery.execute();
            }
        }
        if (BPCClientTrace.isTracing) {
            int n = 0;
            if (list != null) {
                n = list.size();
            }
            BPCClientTrace.exit((Object)("returning " + n + " properties"));
        }
        return list;
    }

    public static Map getQueryPropertiesMap(OID oID, BFMConnection bFMConnection) throws ClientException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)oID);
        }
        List list = BFMQueryProperties.getQueryPropertyBeans(oID, bFMConnection);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (list != null && list.size() > 0) {
            for (QueryPropertyBean queryPropertyBean : list) {
                hashMap.put(queryPropertyBean.getKey(), queryPropertyBean.getValue());
                if (!BPCClientTrace.isTracing) continue;
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Added query property " + queryPropertyBean.toString()));
            }
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)("returning " + hashMap.size() + " properties"));
        }
        return hashMap;
    }
}

