/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.clientmodel.util;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.bean.CustomPropertyBean;
import com.ibm.bpc.clientcore.exception.CommunicationException;
import com.ibm.bpc.clientcore.util.CustomProperties;
import com.ibm.bpe.api.BusinessFlowManagerService;
import com.ibm.bpe.api.CustomProperty;
import com.ibm.bpe.api.OID;
import com.ibm.bpe.api.ProcessException;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.clientmodel.BFMConnection;
import com.ibm.bpe.clientmodel.exception.BFMCommandException;
import com.ibm.bpe.clientmodel.util.BFMUtils;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BFMCustomProperties
extends CustomProperties {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2008.\n\n";
    private BFMConnection connection = null;

    public BFMCustomProperties(OID oID, BFMConnection bFMConnection) {
        super(oID);
        this.connection = bFMConnection;
    }

    protected Map retrieveAllCustomProperties() throws ClientException {
        return BFMCustomProperties.getCustomPropertiesMap(this.getOid(), this.connection);
    }

    public static List getCustomPropertyBeans(OID oID, BFMConnection bFMConnection) throws ClientException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)oID);
        }
        ArrayList<CustomPropertyBean> arrayList = new ArrayList<CustomPropertyBean>();
        List list = BFMCustomProperties.getCustomProperties(oID, bFMConnection);
        if (list != null && list.size() > 0) {
            arrayList = new ArrayList(list.size());
            for (CustomProperty customProperty : list) {
                arrayList.add(new CustomPropertyBean(BFMUtils.getEntityType(oID), customProperty.getName(), customProperty.getValue()));
            }
        }
        if (BPCClientTrace.isTracing) {
            int n = 0;
            if (arrayList != null) {
                n = arrayList.size();
            }
            BPCClientTrace.exit((Object)("returning " + n + " properties"));
        }
        return arrayList;
    }

    private static List getCustomProperties(OID oID, BFMConnection bFMConnection) throws ClientException {
        List list = null;
        BusinessFlowManagerService businessFlowManagerService = BFMUtils.getBusinessFlowManagerService(bFMConnection);
        try {
            list = businessFlowManagerService.getCustomProperties(oID.toString());
        }
        catch (ProcessException processException) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)processException);
            }
            throw new BFMCommandException(new Object[]{"BusinessFlowManagerService.getCustomProperties"}, processException);
        }
        catch (RemoteException remoteException) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)remoteException);
            }
            throw new CommunicationException(new Object[]{"BusinessFlowManagerService.getCustomProperties"}, (Throwable)remoteException);
        }
        return list;
    }

    public static Map getCustomPropertiesMap(OID oID, BFMConnection bFMConnection) throws ClientException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)oID);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        List list = BFMCustomProperties.getCustomProperties(oID, bFMConnection);
        if (list != null && list.size() > 0) {
            String string = BFMUtils.getEntityType(oID);
            for (CustomProperty customProperty : list) {
                String string2 = customProperty.getValue();
                CustomPropertyBean customPropertyBean = new CustomPropertyBean(string, customProperty.getName(), string2);
                hashMap.put(customPropertyBean.getKey(), string2);
                if (!BPCClientTrace.isTracing) continue;
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Added custom property " + customPropertyBean.toString()));
            }
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)("returning " + hashMap.size() + " properties"));
        }
        return hashMap;
    }
}

