/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.clientmodel.util;

import com.ibm.bpc.clientcore.util.LocaleUtils;
import com.ibm.bpc.clientcore.util.Timer;
import com.ibm.bpe.api.EngineParameterNullException;
import com.ibm.bpe.api.TimerSpecification;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.clientmodel.bean.ActivityInstanceBean;
import com.ibm.bpe.clientmodel.bean.ActivityInstanceBeanExt;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.icu.util.TimeZone;
import java.util.Calendar;
import java.util.Locale;

public class ActivityTimer
extends Timer {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2009.\n\n";
    protected ActivityInstanceBean activityInstanceBean = null;

    public ActivityTimer(ActivityInstanceBean activityInstanceBean, String string, String string2, Locale locale, TimeZone timeZone) {
        super(string, string2, locale, timeZone);
        this.activityInstanceBean = activityInstanceBean;
        this.initializeAvailableActions();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof ActivityTimer) {
            ActivityTimer activityTimer = (ActivityTimer)((Object)object);
            if (this.getLabel().equals(activityTimer.getLabel()) && this.getId().equals(activityTimer.getId())) {
                bl = true;
            }
        }
        return bl;
    }

    public String getTimestamp() {
        Calendar calendar = this.activityInstanceBean.getExpirationTime();
        if (calendar != null) {
            this.timestamp = LocaleUtils.getISODate((Calendar)calendar, (Locale)this.getLocale(), (TimeZone)this.getTimeZone());
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.entry((Object)this.timestamp);
            }
        } else {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.entry((Object)"Timer not set, set timestamp to DURATION_INFINITE to indicate this to the GUI");
            }
            this.timestamp = "DURATION_INFINITE";
        }
        return this.timestamp;
    }

    protected boolean isTimerDurationUpdateable() {
        boolean bl = ((ActivityInstanceBeanExt)this.activityInstanceBean).isActionAvailable(3044);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Timer duration updateable: " + bl));
        }
        return bl;
    }

    protected boolean isTimerTimestampUpdateable() {
        boolean bl = ((ActivityInstanceBeanExt)this.activityInstanceBean).isActionAvailable(3044);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Timer timestamp updateable: " + bl));
        }
        return bl;
    }

    public TimerSpecification getTimerSpecification() throws EngineParameterNullException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        TimerSpecification timerSpecification = null;
        if (this.timestamp.equals("DURATION_ZERO")) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Fire timer now");
            }
            timerSpecification = TimerSpecification.TIMER_SPECIFICATION_IMMEDIATE;
        } else if (this.timestamp.equals("DURATION_INFINITE")) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Set time to infinite");
            }
            timerSpecification = TimerSpecification.TIMER_SPECIFICATION_INFINITE;
        } else {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Set timer to new timestamp:" + this.timestamp));
            }
            Calendar calendar = LocaleUtils.parseDateTime((String)this.timestamp, (int)1, (int)1, (Locale)this.getLocale(), (TimeZone)this.getTimeZone());
            timerSpecification = new TimerSpecification(calendar);
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"New due was set");
            }
        }
        return timerSpecification;
    }
}

