/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.clientmodel.query;

import com.ibm.bpc.clientcore.BPCQueryAttributes;
import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.bean.QueryPropertyBean;
import com.ibm.bpc.clientcore.query.QueryPropertyFilterAttributes;
import com.ibm.bpc.clientcore.query.QueryPropertyQueryAttributes;
import com.ibm.bpe.api.QueryResultSet;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.clientmodel.query.BFMQuery;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import java.util.ArrayList;
import java.util.List;

public class QueryPropertyBFMQuery
extends BFMQuery {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2006, 2009.\n\n";
    private static final String TYPE = QueryPropertyBean.class.getName();

    public QueryPropertyBFMQuery() {
        super((BPCQueryAttributes)new QueryPropertyQueryAttributes());
        this.setType(TYPE);
    }

    public QueryPropertyFilterAttributes getQueryPropertyFilterAttributes() {
        return (QueryPropertyFilterAttributes)this.getQueryAttributes().getFilterAttributes(QueryPropertyFilterAttributes.TYPE);
    }

    protected List executeBFMQuery() throws ClientException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        QueryResultSet queryResultSet = this.executeGenericBFMQuery();
        List list = this.transform(queryResultSet);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
        return list;
    }

    public List transform(QueryResultSet queryResultSet) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Result rows " + (queryResultSet != null ? queryResultSet.size() : 0)));
        }
        String string = this.getQueryAttributes().getTableName();
        ArrayList<QueryPropertyBean> arrayList = null;
        if (queryResultSet != null && queryResultSet.size() > 0) {
            arrayList = new ArrayList(queryResultSet.size());
            for (int i = 0; i < queryResultSet.size(); ++i) {
                queryResultSet.next();
                QueryPropertyBean queryPropertyBean = new QueryPropertyBean();
                for (int j = 1; j <= queryResultSet.numberColumns(); ++j) {
                    String string2 = queryResultSet.getTableDisplayName(j);
                    String string3 = queryResultSet.getColumnDisplayName(j);
                    if (BPCClientTrace.isTracing) {
                        BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Table: " + string2 + " Column: " + string3));
                    }
                    if (!string.equalsIgnoreCase(string2)) continue;
                    Object object = null;
                    object = "STRING_VALUE".equals(string3) ? queryResultSet.getString(j) : ("GENERIC_VALUE".equals(string3) ? queryResultSet.getString(j) : ("NUMBER_VALUE".equals(string3) ? queryResultSet.getLong(j) : ("DECIMAL_VALUE".equals(string3) ? queryResultSet.getDouble(j) : ("TIMESTAMP_VALUE".equals(string3) ? queryResultSet.getTimestamp(j) : ("NAME".equals(string3) ? queryResultSet.getString(j) : ("VARIABLE_NAME".equals(string3) ? queryResultSet.getString(j) : ("NAMESPACE".equals(string3) ? queryResultSet.getString(j) : queryResultSet.getObject(j))))))));
                    queryPropertyBean.setValueFromResultSet(string3, object);
                }
                if (queryPropertyBean.getName() == null) continue;
                arrayList.add(queryPropertyBean);
                if (!BPCClientTrace.isTracing) continue;
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Added query property: " + queryPropertyBean.toString()));
            }
        } else {
            arrayList = new ArrayList<QueryPropertyBean>(0);
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
        return arrayList;
    }
}

