/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.clientmodel.query;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.exception.CommunicationException;
import com.ibm.bpc.clientcore.exception.NotAuthorizedException;
import com.ibm.bpe.api.BusinessFlowManagerService;
import com.ibm.bpe.api.EngineNotAuthorizedException;
import com.ibm.bpe.api.EngineProcessDoesNotExistException;
import com.ibm.bpe.api.PIID;
import com.ibm.bpe.api.ProcessException;
import com.ibm.bpe.api.WorkItemData;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.clientmodel.BFMConnection;
import com.ibm.bpe.clientmodel.bean.ProcessInstanceBeanExt;
import com.ibm.bpe.clientmodel.exception.BFMCommandException;
import com.ibm.bpe.clientmodel.exception.ProcessDoesNotExistException;
import com.ibm.bpe.clientmodel.util.BFMUtils;
import com.ibm.bpe.util.Assert;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.task.clientmodel.bean.WorkItemBeanExt;
import com.ibm.task.clientmodel.query.WorkItemQuery;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.EJBException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessWorkItemQuery
extends WorkItemQuery {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2009.\n\n";
    private BFMConnection bfmConnection = null;

    public BFMConnection getBfmConnection() {
        return this.bfmConnection;
    }

    public void setBfmConnection(BFMConnection bFMConnection) {
        this.bfmConnection = bFMConnection;
    }

    public List executeBPCQuery() throws ClientException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)"getAllWorkItems");
        }
        List<WorkItemBeanExt> list = null;
        if (this.isSystemAdmin()) {
            Assert.postcondition((this.getConnection() != null ? 1 : 0) != 0, (String)"HTMConnection must be set!");
            List list2 = super.executeHTMQuery();
            list = new ArrayList<WorkItemBeanExt>();
            for (WorkItemBeanExt workItemBeanExt : list2) {
                if (workItemBeanExt.getReason() == 6) continue;
                list.add(workItemBeanExt);
            }
        } else {
            Assert.postcondition((this.getBfmConnection() != null ? 1 : 0) != 0, (String)"BFMConnection must be set!");
            Map map = this.getProcessInstanceBeans();
            Assert.postcondition((map != null && map.size() > 0 ? 1 : 0) != 0, (String)"Process instance beans required as parameter! Use method 'setProcessInstanceBeans()'.");
            PIID pIID2 = null;
            try {
                BusinessFlowManagerService businessFlowManagerService = BFMUtils.getBusinessFlowManagerService(this.getBfmConnection());
                list = new ArrayList();
                WorkItemData[] workItemDataArray = null;
                Set set = map.keySet();
                for (PIID pIID2 : set) {
                    if (BPCClientTrace.isTracing) {
                        BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("getAllWorkItems for PIID " + pIID2.toString()));
                    }
                    workItemDataArray = businessFlowManagerService.getAllWorkItems(pIID2);
                    if (BPCClientTrace.isTracing) {
                        BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("getAllWorkItems returned: " + workItemDataArray.length + " items for piid " + pIID2));
                    }
                    list = this.transformAndAddWorkitems(list, (ProcessInstanceBeanExt)map.get(pIID2), workItemDataArray);
                }
            }
            catch (EngineNotAuthorizedException engineNotAuthorizedException) {
                throw new NotAuthorizedException(new Object[0], (Throwable)engineNotAuthorizedException);
            }
            catch (EngineProcessDoesNotExistException engineProcessDoesNotExistException) {
                throw new ProcessDoesNotExistException(new Object[]{((ProcessInstanceBeanExt)map.get(pIID2)).getName()}, engineProcessDoesNotExistException);
            }
            catch (ProcessException processException) {
                throw new BFMCommandException(new Object[]{"BusinessFlowManagerService.getAllWorkItems"}, processException);
            }
            catch (RemoteException remoteException) {
                throw new CommunicationException(new Object[]{((Object)((Object)this)).getClass()});
            }
            catch (EJBException eJBException) {
                throw new CommunicationException(new Object[]{((Object)((Object)this)).getClass()});
            }
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)("returning " + list.size() + " instances"));
        }
        return list;
    }

    private List<WorkItemBeanExt> transformAndAddWorkitems(List<WorkItemBeanExt> list, ProcessInstanceBeanExt processInstanceBeanExt, WorkItemData[] workItemDataArray) {
        if (list == null) {
            list = new ArrayList<WorkItemBeanExt>();
        }
        for (int i = 0; i < workItemDataArray.length; ++i) {
            if (workItemDataArray[i].getAssignmentReason() == 6) continue;
            WorkItemBeanExt workItemBeanExt = new WorkItemBeanExt(workItemDataArray[i], processInstanceBeanExt, this.getLocale());
            list.add(workItemBeanExt);
        }
        return list;
    }
}

